/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    static SimpleLookupTable PackageCache = new SimpleLookupTable();
    String zipFilename;
    IFile resource;
    ZipFile zipFile;
    long lastModified;
    boolean closeZipFileAtEnd;
    SimpleSet knownPackageNames;
    AccessRuleSet accessRuleSet;

    static SimpleSet findPackageSet(ClasspathJar classpathJar) {
        String string = classpathJar.zipFilename;
        long l = classpathJar.lastModified();
        long l2 = new File(string).length();
        PackageCacheEntry packageCacheEntry = (PackageCacheEntry)PackageCache.get(string);
        if (packageCacheEntry != null && packageCacheEntry.lastModified == l && packageCacheEntry.fileSize == l2) {
            return packageCacheEntry.packageSet;
        }
        SimpleSet simpleSet = new SimpleSet(41);
        simpleSet.add("");
        Enumeration<? extends ZipEntry> enumeration = classpathJar.zipFile.entries();
        block0: while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            int n = string2.lastIndexOf(47);
            while (n > 0) {
                String string3 = string2.substring(0, n);
                if (simpleSet.addIfNotIncluded(string3) == null) continue block0;
                n = string3.lastIndexOf(47);
            }
        }
        PackageCache.put(string, new PackageCacheEntry(l, l2, simpleSet));
        return simpleSet;
    }

    ClasspathJar(IFile iFile, AccessRuleSet accessRuleSet) {
        this.resource = iFile;
        try {
            URI uRI = iFile.getLocationURI();
            if (uRI == null) {
                this.zipFilename = "";
            } else {
                File file = Util.toLocalFile(uRI, null);
                this.zipFilename = file.getPath();
            }
        }
        catch (CoreException coreException) {}
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    ClasspathJar(String string, long l, AccessRuleSet accessRuleSet) {
        this.zipFilename = string;
        this.lastModified = l;
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    public ClasspathJar(ZipFile zipFile, AccessRuleSet accessRuleSet) {
        this.zipFilename = zipFile.getName();
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = false;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    public void cleanup() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {}
            this.zipFile = null;
        }
        this.knownPackageNames = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClasspathJar)) {
            return false;
        }
        ClasspathJar classpathJar = (ClasspathJar)object;
        if (!(this.accessRuleSet == classpathJar.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(classpathJar.accessRuleSet))) {
            return false;
        }
        return this.zipFilename.equals(classpathJar.zipFilename) && this.lastModified() == classpathJar.lastModified();
    }

    public NameEnvironmentAnswer findClass(String string, String string2, String string3) {
        if (!this.isPackage(string2)) {
            return null;
        }
        try {
            ClassFileReader classFileReader = ClassFileReader.read(this.zipFile, string3);
            if (classFileReader != null) {
                if (this.accessRuleSet == null) {
                    return new NameEnvironmentAnswer(classFileReader, null);
                }
                String string4 = string3.substring(0, string3.length() - SuffixConstants.SUFFIX_CLASS.length);
                return new NameEnvironmentAnswer(classFileReader, this.accessRuleSet.getViolatedRestriction(string4.toCharArray()));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public boolean isPackage(String string) {
        if (this.knownPackageNames != null) {
            return this.knownPackageNames.includes(string);
        }
        try {
            if (this.zipFile == null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [ClasspathJar.isPackage(String)] Creating ZipFile on " + this.zipFilename);
                }
                this.zipFile = new ZipFile(this.zipFilename);
                this.closeZipFileAtEnd = true;
            }
            this.knownPackageNames = ClasspathJar.findPackageSet(this);
        }
        catch (Exception exception) {
            this.knownPackageNames = new SimpleSet();
        }
        return this.knownPackageNames.includes(string);
    }

    public long lastModified() {
        if (this.lastModified == 0L) {
            this.lastModified = new File(this.zipFilename).lastModified();
        }
        return this.lastModified;
    }

    public String toString() {
        String string = "Classpath jar file " + this.zipFilename;
        if (this.accessRuleSet == null) {
            return string;
        }
        return String.valueOf(string) + " with " + this.accessRuleSet;
    }

    public String debugPathString() {
        long l = this.lastModified();
        if (l == 0L) {
            return this.zipFilename;
        }
        return String.valueOf(this.zipFilename) + '(' + new Date(l) + " : " + l + ')';
    }

    static class PackageCacheEntry {
        long lastModified;
        long fileSize;
        SimpleSet packageSet;

        PackageCacheEntry(long l, long l2, SimpleSet simpleSet) {
            this.lastModified = l;
            this.fileSize = l2;
            this.packageSet = simpleSet;
        }
    }
}

