/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.wst.jsdt.internal.core.builder.BuildNotifier;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;

public class NameEnvironment
implements INameEnvironment,
SuffixConstants {
    boolean isIncrementalBuild = false;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    BuildNotifier notifier;
    SimpleSet initialTypeNames;
    SimpleLookupTable additionalUnits;
    SearchableEnvironment searchableEnvironment;

    NameEnvironment(IWorkspaceRoot iWorkspaceRoot, JavaProject javaProject, SimpleLookupTable simpleLookupTable, BuildNotifier buildNotifier) throws CoreException {
        this.notifier = buildNotifier;
        this.computeClasspathLocations(iWorkspaceRoot, javaProject, simpleLookupTable);
        this.searchableEnvironment = javaProject.newSearchableNameEnvironment(new ICompilationUnit[0]);
    }

    public NameEnvironment(IJavaProject iJavaProject) {
        try {
            this.computeClasspathLocations(iJavaProject.getProject().getWorkspace().getRoot(), (JavaProject)iJavaProject, null);
        }
        catch (CoreException coreException) {
            this.sourceLocations = new ClasspathMultiDirectory[0];
            this.binaryLocations = new ClasspathLocation[0];
        }
        try {
            this.searchableEnvironment = iJavaProject.newSearchableNameEnvironment(new ICompilationUnit[0]);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    private void computeClasspathLocations(IWorkspaceRoot iWorkspaceRoot, JavaProject javaProject, SimpleLookupTable simpleLookupTable) throws CoreException {
        Object object;
        Object object2;
        IMarker iMarker = javaProject.getCycleMarker();
        if (iMarker != null) {
            int n;
            int n2 = n = "error".equals(javaProject.getOption("org.eclipse.wst.jsdt.core.circularClasspath", true)) ? 2 : 1;
            if (n != iMarker.getAttribute("severity", n)) {
                iMarker.setAttribute("severity", n);
            }
        }
        IClasspathEntry[] iClasspathEntryArray = javaProject.getExpandedClasspath();
        ArrayList<ClasspathLocation> arrayList = new ArrayList<ClasspathLocation>(iClasspathEntryArray.length);
        ArrayList<ClasspathLocation> arrayList2 = new ArrayList<ClasspathLocation>(iClasspathEntryArray.length);
        int n = 0;
        int n3 = iClasspathEntryArray.length;
        while (n < n3) {
            block27: {
                ClasspathEntry classpathEntry = (ClasspathEntry)iClasspathEntryArray[n];
                object2 = classpathEntry.getPath();
                object = JavaModel.getTarget((IContainer)iWorkspaceRoot, object2, true);
                if (object != null) {
                    IClasspathAttribute[] iClasspathAttributeArray = classpathEntry.getExtraAttributes();
                    int n4 = 0;
                    while (iClasspathAttributeArray != null && n4 < iClasspathAttributeArray.length) {
                        if (!iClasspathAttributeArray[n4].getName().equalsIgnoreCase("validate") || !iClasspathAttributeArray[n4].getValue().equalsIgnoreCase("false")) {
                            ++n4;
                            continue;
                        }
                        break block27;
                    }
                    switch (classpathEntry.getEntryKind()) {
                        case 3: {
                            IProject iProject;
                            IPath iPath;
                            if (!(object instanceof IContainer)) break;
                            IPath iPath2 = iPath = classpathEntry.getOutputLocation() != null ? classpathEntry.getOutputLocation() : javaProject.getOutputLocation();
                            if (iPath.segmentCount() == 1) {
                                iProject = javaProject.getProject();
                            } else {
                                iProject = iWorkspaceRoot.getFolder(iPath);
                                if (!iProject.exists()) {
                                    this.createOutputFolder((IContainer)iProject);
                                }
                            }
                            arrayList.add(ClasspathLocation.forSourceFolder((IContainer)object, (IContainer)iProject, classpathEntry.fullInclusionPatternChars(), classpathEntry.fullExclusionPatternChars()));
                            break;
                        }
                        case 2: {
                            IProject iProject;
                            if (!(object instanceof IProject) || !JavaProject.hasJavaNature(iProject = (IProject)object)) break;
                            JavaProject javaProject2 = (JavaProject)JavaCore.create(iProject);
                            IClasspathEntry[] iClasspathEntryArray2 = javaProject2.getRawClasspath();
                            ArrayList<IProject> arrayList3 = new ArrayList<IProject>();
                            int n5 = 0;
                            int n6 = iClasspathEntryArray2.length;
                            while (n5 < n6) {
                                Object object3;
                                IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n5];
                                if (iClasspathEntry.getEntryKind() == 3 && (object3 = JavaModel.getTarget((IContainer)iWorkspaceRoot, iClasspathEntry.getPath(), true)) instanceof IContainer) {
                                    IProject iProject2;
                                    IPath iPath = iClasspathEntry.getOutputLocation() != null ? iClasspathEntry.getOutputLocation() : javaProject2.getOutputLocation();
                                    Object object4 = iProject2 = iPath.segmentCount() == 1 ? iProject : iWorkspaceRoot.getFolder(iPath);
                                    if (iProject2.exists() && !arrayList3.contains(iProject2)) {
                                        arrayList3.add(iProject2);
                                        ClasspathLocation classpathLocation = ClasspathLocation.forBinaryFolder((IContainer)iProject2, true, classpathEntry.getAccessRuleSet());
                                        arrayList2.add(classpathLocation);
                                        if (simpleLookupTable != null) {
                                            ClasspathLocation[] classpathLocationArray = (ClasspathLocation[])simpleLookupTable.get(iProject);
                                            if (classpathLocationArray == null) {
                                                classpathLocationArray = new ClasspathLocation[]{classpathLocation};
                                            } else {
                                                int n7 = classpathLocationArray.length;
                                                ClasspathLocation[] classpathLocationArray2 = classpathLocationArray;
                                                classpathLocationArray = new ClasspathLocation[n7 + 1];
                                                System.arraycopy(classpathLocationArray2, 0, classpathLocationArray, 0, n7);
                                                classpathLocationArray[n7] = classpathLocation;
                                            }
                                            simpleLookupTable.put(iProject, classpathLocationArray);
                                        }
                                    }
                                }
                                ++n5;
                            }
                            break;
                        }
                    }
                }
            }
            ++n;
        }
        ArrayList<IPath> arrayList4 = new ArrayList<IPath>(1);
        this.sourceLocations = new ClasspathMultiDirectory[arrayList.size()];
        if (!arrayList.isEmpty()) {
            arrayList.toArray(this.sourceLocations);
            n3 = 0;
            int n8 = this.sourceLocations.length;
            while (n3 < n8) {
                block28: {
                    object2 = this.sourceLocations[n3];
                    object = object2.binaryFolder.getFullPath();
                    int n9 = 0;
                    while (n9 < n3) {
                        if (object.equals((Object)this.sourceLocations[n9].binaryFolder.getFullPath())) {
                            object2.hasIndependentOutputFolder = this.sourceLocations[n9].hasIndependentOutputFolder;
                            break block28;
                        }
                        ++n9;
                    }
                    arrayList4.add((IPath)object2);
                    n9 = 0;
                    int n10 = this.sourceLocations.length;
                    while (n9 < n10) {
                        if (!object.equals((Object)this.sourceLocations[n9].sourceFolder.getFullPath())) {
                            ++n9;
                            continue;
                        }
                        break block28;
                    }
                    object2.hasIndependentOutputFolder = true;
                }
                ++n3;
            }
        }
        this.binaryLocations = new ClasspathLocation[arrayList4.size() + arrayList2.size()];
        n3 = 0;
        int n11 = 0;
        int n12 = arrayList4.size();
        while (n11 < n12) {
            this.binaryLocations[n3++] = (ClasspathLocation)arrayList4.get(n11);
            ++n11;
        }
        n11 = 0;
        n12 = arrayList2.size();
        while (n11 < n12) {
            this.binaryLocations[n3++] = (ClasspathLocation)arrayList2.get(n11);
            ++n11;
        }
    }

    public void cleanup() {
        this.searchableEnvironment = null;
    }

    private void createOutputFolder(IContainer iContainer) throws CoreException {
        this.createParentFolder(iContainer.getParent());
        ((IFolder)iContainer).create(1025, true, null);
    }

    private void createParentFolder(IContainer iContainer) throws CoreException {
        if (!iContainer.exists()) {
            this.createParentFolder(iContainer.getParent());
            ((IFolder)iContainer).create(true, true, null);
        }
    }

    private NameEnvironmentAnswer findClass(String string, char[] cArray) {
        Object object;
        if (this.notifier != null) {
            this.notifier.checkCancelWithinCompiler();
        }
        if (this.initialTypeNames != null && this.initialTypeNames.includes(string)) {
            if (this.isIncrementalBuild) {
                throw new AbortCompilation(true, new AbortIncrementalBuildException(string));
            }
            return null;
        }
        if (this.additionalUnits != null && this.sourceLocations.length > 0 && (object = (SourceFile)this.additionalUnits.get(string)) != null) {
            return new NameEnvironmentAnswer((org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)object, null);
        }
        Object object2 = object = String.valueOf(string) + ".js";
        String string2 = "";
        if (string.length() > cArray.length) {
            int n = ((String)object).length() - cArray.length - 6;
            string2 = ((String)object).substring(0, n - 1);
            object2 = ((String)object).substring(n);
        }
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        int n = 0;
        int n2 = this.binaryLocations.length;
        while (n < n2) {
            NameEnvironmentAnswer nameEnvironmentAnswer2 = this.binaryLocations[n].findClass((String)object2, string2, (String)object);
            if (nameEnvironmentAnswer2 != null) {
                if (!nameEnvironmentAnswer2.ignoreIfBetter()) {
                    if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                        return nameEnvironmentAnswer2;
                    }
                } else if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                    nameEnvironmentAnswer = nameEnvironmentAnswer2;
                }
            }
            ++n;
        }
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] cArray, ITypeRequestor iTypeRequestor) {
        return this.searchableEnvironment.findType(cArray, iTypeRequestor);
    }

    private SourceFile convertToSourceFile(CompilationUnit compilationUnit) {
        IPath iPath = compilationUnit.getPath();
        int n = 0;
        while (n < this.sourceLocations.length) {
            IContainer iContainer = this.sourceLocations[n].sourceFolder;
            if (iContainer.getFullPath().isPrefixOf(iPath)) {
                SourceFile sourceFile = new SourceFile((IFile)compilationUnit.getResource(), this.sourceLocations[n]);
                return sourceFile;
            }
            ++n;
        }
        return null;
    }

    private NameEnvironmentAnswer convertToSourceFile(NameEnvironmentAnswer nameEnvironmentAnswer) {
        if (nameEnvironmentAnswer == null) {
            return nameEnvironmentAnswer;
        }
        if (nameEnvironmentAnswer.getCompilationUnit() instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)nameEnvironmentAnswer.getCompilationUnit();
            SourceFile sourceFile = this.convertToSourceFile(compilationUnit);
            if (sourceFile != null) {
                return new NameEnvironmentAnswer(sourceFile, nameEnvironmentAnswer.getAccessRestriction());
            }
        } else if (nameEnvironmentAnswer.getCompilationUnits() != null) {
            org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit[] iCompilationUnitArray = nameEnvironmentAnswer.getCompilationUnits();
            org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit[] iCompilationUnitArray2 = new org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit[iCompilationUnitArray.length];
            boolean bl = false;
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                SourceFile sourceFile;
                iCompilationUnitArray2[n] = iCompilationUnitArray[n];
                if (iCompilationUnitArray[n] instanceof CompilationUnit && (sourceFile = this.convertToSourceFile((CompilationUnit)iCompilationUnitArray[n])) != null) {
                    iCompilationUnitArray2[n] = sourceFile;
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                return new NameEnvironmentAnswer(iCompilationUnitArray2, nameEnvironmentAnswer.getAccessRestriction());
            }
        }
        return nameEnvironmentAnswer;
    }

    public NameEnvironmentAnswer findBinding(char[] cArray, char[][] cArray2, int n, ITypeRequestor iTypeRequestor, boolean bl, String string) {
        if (this.notifier != null) {
            this.notifier.checkCancelWithinCompiler();
        }
        NameEnvironmentAnswer nameEnvironmentAnswer = this.searchableEnvironment.findBinding(cArray, cArray2, n, iTypeRequestor, bl, string);
        nameEnvironmentAnswer = this.convertToSourceFile(nameEnvironmentAnswer);
        return nameEnvironmentAnswer;
    }

    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2, ITypeRequestor iTypeRequestor) {
        return this.searchableEnvironment.findType(cArray, cArray2, iTypeRequestor);
    }

    public boolean isPackage(char[][] cArray, char[] cArray2) {
        return this.searchableEnvironment.isPackage(cArray, cArray2);
    }

    public boolean isPackage(String string) {
        int n = 0;
        int n2 = this.binaryLocations.length;
        while (n < n2) {
            if (this.binaryLocations[n].isPackage(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setNames(String[] stringArray, SourceFile[] sourceFileArray) {
        int n;
        int n2;
        if (stringArray == null) {
            this.initialTypeNames = null;
        } else {
            this.initialTypeNames = new SimpleSet(stringArray.length);
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                this.initialTypeNames.add(stringArray[n2]);
                ++n2;
            }
        }
        if (sourceFileArray == null) {
            this.additionalUnits = null;
        } else {
            this.additionalUnits = new SimpleLookupTable(sourceFileArray.length);
            n2 = 0;
            n = sourceFileArray.length;
            while (n2 < n) {
                SourceFile sourceFile = sourceFileArray[n2];
                if (sourceFile != null) {
                    this.additionalUnits.put(sourceFile.initialTypeName, sourceFileArray[n2]);
                }
                ++n2;
            }
        }
        n2 = 0;
        n = this.sourceLocations.length;
        while (n2 < n) {
            this.sourceLocations[n2].reset();
            ++n2;
        }
        n2 = 0;
        n = this.binaryLocations.length;
        while (n2 < n) {
            this.binaryLocations[n2].reset();
            ++n2;
        }
    }
}

