/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.Arrays;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class LineCommentEndOffsets {
    private int[] offsets;
    private final List commentList;

    public LineCommentEndOffsets(List list) {
        this.commentList = list;
        this.offsets = null;
    }

    private int[] getOffsets() {
        if (this.offsets == null) {
            if (this.commentList != null) {
                int n = this.commentList.size();
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    Object e = this.commentList.get(n3);
                    if (e instanceof LineComment) {
                        ++n2;
                    }
                    ++n3;
                }
                this.offsets = new int[n2];
                n3 = 0;
                int n4 = 0;
                while (n3 < n) {
                    Object e = this.commentList.get(n3);
                    if (e instanceof LineComment) {
                        LineComment lineComment = (LineComment)e;
                        this.offsets[n4++] = lineComment.getStartPosition() + lineComment.getLength();
                    }
                    ++n3;
                }
            } else {
                this.offsets = Util.EMPTY_INT_ARRAY;
            }
        }
        return this.offsets;
    }

    public boolean isEndOfLineComment(int n) {
        return n >= 0 && Arrays.binarySearch(this.getOffsets(), n) >= 0;
    }

    public boolean isEndOfLineComment(int n, char[] cArray) {
        if (n < 0 || n < cArray.length && !IndentManipulation.isLineDelimiterChar(cArray[n])) {
            return false;
        }
        return Arrays.binarySearch(this.getOffsets(), n) >= 0;
    }

    public boolean remove(int n) {
        int[] nArray = this.getOffsets();
        int n2 = Arrays.binarySearch(nArray, n);
        if (n2 >= 0) {
            if (n2 > 0) {
                System.arraycopy(nArray, 0, nArray, 1, n2);
            }
            nArray[0] = -1;
            return true;
        }
        return false;
    }
}

