/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import java.util.Stack;
import org.eclipse.wst.jsdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.wst.jsdt.core.jdom.IDOMNode;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.jdom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMNode;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMType;
import org.eclipse.wst.jsdt.internal.core.jdom.ILineStartFinder;
import org.eclipse.wst.jsdt.internal.core.util.ReferenceInfoAdapter;

public class AbstractDOMBuilder
extends ReferenceInfoAdapter
implements ILineStartFinder {
    protected boolean fAbort;
    protected boolean fBuildingCU = false;
    protected boolean fBuildingType = false;
    protected char[] fDocument = null;
    protected int[] fLineStartPositions = new int[1];
    protected Stack fStack = null;
    protected int fFieldCount;
    protected DOMNode fNode;

    public void acceptLineSeparatorPositions(int[] nArray) {
        int n;
        if (nArray != null && (n = nArray.length) > 0) {
            this.fLineStartPositions = new int[n + 1];
            this.fLineStartPositions[0] = 0;
            int n2 = this.fDocument.length;
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3 + 1;
                int n5 = nArray[n3] + 1;
                this.fLineStartPositions[n4] = n5 < n2 ? (n4 < n ? n5 : (this.fDocument[n5] == '\n' ? n5 + 1 : n5)) : n5;
                ++n3;
            }
        }
    }

    protected void addChild(IDOMNode iDOMNode) {
        if (this.fStack.size() > 0) {
            DOMNode dOMNode = (DOMNode)this.fStack.peek();
            if (this.fBuildingCU || this.fBuildingType) {
                dOMNode.basicAddChild(iDOMNode);
            }
        }
    }

    public IDOMCompilationUnit createCompilationUnit(char[] cArray, char[] cArray2) {
        return this.createCompilationUnit(new CompilationUnit(cArray, cArray2));
    }

    public IDOMCompilationUnit createCompilationUnit(ICompilationUnit iCompilationUnit) {
        if (this.fAbort) {
            return null;
        }
        this.fNode.normalize(this);
        return (IDOMCompilationUnit)((Object)this.fNode);
    }

    public void enterCompilationUnit() {
        if (this.fBuildingCU) {
            int[] nArray = new int[2];
            nArray[1] = this.fDocument.length - 1;
            DOMCompilationUnit dOMCompilationUnit = new DOMCompilationUnit(this.fDocument, nArray);
            this.fStack.push(dOMCompilationUnit);
        }
    }

    public void exitCompilationUnit(int n) {
        DOMCompilationUnit dOMCompilationUnit = (DOMCompilationUnit)this.fStack.pop();
        dOMCompilationUnit.setSourceRangeEnd(n);
        this.fNode = dOMCompilationUnit;
    }

    protected void exitType(int n, int n2) {
        DOMType dOMType = (DOMType)this.fStack.pop();
        dOMType.setSourceRangeEnd(n2);
        dOMType.setCloseBodyRangeStart(n);
        dOMType.setCloseBodyRangeEnd(n);
        this.fNode = dOMType;
    }

    public int getLineStart(int n) {
        int n2 = this.fLineStartPositions.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (this.fLineStartPositions[n3] <= n) {
                return this.fLineStartPositions[n3];
            }
            --n3;
        }
        return 0;
    }

    protected void initializeBuild(char[] cArray, boolean bl, boolean bl2) {
        this.fBuildingCU = bl;
        this.fBuildingType = bl2;
        this.fStack = new Stack();
        this.fDocument = cArray;
        this.fFieldCount = 0;
        this.fAbort = false;
    }
}

