/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.jdom.IDOMMember;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMNode;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;

abstract class DOMMember
extends DOMNode
implements IDOMMember {
    protected int fFlags = 0;
    protected String fComment = null;
    protected int[] fCommentRange;
    protected char[] fModifiers = null;
    protected int[] fModifierRange;

    DOMMember() {
    }

    DOMMember(char[] cArray, int[] nArray, String string, int[] nArray2, int[] nArray3, int n, int[] nArray4) {
        super(cArray, nArray, string, nArray2);
        this.fFlags = n;
        this.fComment = null;
        this.fCommentRange = nArray3;
        this.fModifierRange = nArray4;
        this.setHasComment(nArray3[0] >= 0);
    }

    protected void appendFragmentedContents(CharArrayBuffer charArrayBuffer) {
        if (this.isDetailed()) {
            this.appendMemberHeaderFragment(charArrayBuffer);
            this.appendMemberDeclarationContents(charArrayBuffer);
            this.appendMemberBodyContents(charArrayBuffer);
        } else {
            this.appendSimpleContents(charArrayBuffer);
        }
    }

    protected abstract void appendMemberBodyContents(CharArrayBuffer var1);

    protected abstract void appendMemberDeclarationContents(CharArrayBuffer var1);

    protected void appendMemberHeaderFragment(CharArrayBuffer charArrayBuffer) {
        String string;
        int n;
        int n2;
        if (this.hasComment()) {
            n2 = this.fSourceRange[0];
            n = this.fCommentRange[0];
            if (n > 0) {
                charArrayBuffer.append(this.fDocument, n2, n - n2);
            }
        }
        if ((string = this.getComment()) != null) {
            charArrayBuffer.append(string);
        }
        if ((n = this.fModifierRange[0] >= 0 ? this.fModifierRange[0] - 1 : this.getMemberDeclarationStartPosition() - 1) >= (n2 = this.fCommentRange[1] >= 0 ? this.fCommentRange[1] + 1 : this.fSourceRange[0])) {
            charArrayBuffer.append(this.fDocument, n2, n + 1 - n2);
        }
        charArrayBuffer.append(this.getModifiersText());
    }

    protected abstract void appendSimpleContents(CharArrayBuffer var1);

    protected String[] appendString(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    protected char[] generateFlags() {
        char[] cArray = Flags.toString(this.getFlags()).toCharArray();
        if (cArray.length == 0) {
            return cArray;
        }
        return CharOperation.concat(cArray, new char[]{' '});
    }

    public String getComment() {
        this.becomeDetailed();
        if (this.hasComment()) {
            if (this.fComment != null) {
                return this.fComment;
            }
            return new String(this.fDocument, this.fCommentRange[0], this.fCommentRange[1] + 1 - this.fCommentRange[0]);
        }
        return null;
    }

    public int getFlags() {
        return this.fFlags;
    }

    protected abstract int getMemberDeclarationStartPosition();

    protected char[] getModifiersText() {
        if (this.fModifiers == null) {
            if (this.fModifierRange[0] < 0) {
                return null;
            }
            return CharOperation.subarray(this.fDocument, this.fModifierRange[0], this.fModifierRange[1] + 1);
        }
        return this.fModifiers;
    }

    protected boolean hasBody() {
        return this.getMask(16);
    }

    protected boolean hasComment() {
        return this.getMask(32);
    }

    protected void offset(int n) {
        super.offset(n);
        this.offsetRange(this.fCommentRange, n);
        this.offsetRange(this.fModifierRange, n);
    }

    public void setComment(String string) {
        this.becomeDetailed();
        this.fComment = string;
        this.fragment();
        this.setHasComment(string != null);
        if (string != null && string.indexOf("@deprecated") >= 0) {
            this.fFlags |= 0x100000;
            return;
        }
        this.fFlags &= 0xFFEFFFFF;
    }

    public void setFlags(int n) {
        this.becomeDetailed();
        this.fFlags = Flags.isDeprecated(this.fFlags) ? n | 0x100000 : n & 0xFFEFFFFF;
        this.fragment();
        this.fModifiers = this.generateFlags();
    }

    protected void setHasBody(boolean bl) {
        this.setMask(16, bl);
    }

    protected void setHasComment(boolean bl) {
        this.setMask(32, bl);
    }

    protected void setStartPosition(int n) {
        if (this.fCommentRange[0] >= 0) {
            this.fCommentRange[0] = n;
        }
        super.setStartPosition(n);
    }

    protected void shareContents(DOMNode dOMNode) {
        super.shareContents(dOMNode);
        DOMMember dOMMember = (DOMMember)dOMNode;
        this.fComment = dOMMember.fComment;
        this.fCommentRange = this.rangeCopy(dOMMember.fCommentRange);
        this.fFlags = dOMMember.fFlags;
        this.fModifiers = dOMMember.fModifiers;
        this.fModifierRange = this.rangeCopy(dOMMember.fModifierRange);
    }
}

