/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.search.AbstractSearchScope;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaSearchScope
extends AbstractSearchScope {
    private ArrayList elements;
    private ArrayList projectPaths = new ArrayList();
    private int[] projectIndexes;
    private String[] containerPaths;
    private String[] relativePaths;
    private boolean[] isPkgPath;
    protected AccessRuleSet[] pathRestrictions;
    private int pathsCount;
    private int threshold;
    private IPath[] enclosingProjectsAndJars;
    private Hashtable exclusionPathList = new Hashtable();
    public static final AccessRuleSet NOT_ENCLOSED = new AccessRuleSet(null, null);

    public JavaSearchScope() {
        this(5);
    }

    private JavaSearchScope(int n) {
        this.initialize(n);
    }

    private void addEnclosingProjectOrJar(IPath iPath) {
        int n = this.enclosingProjectsAndJars.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.enclosingProjectsAndJars[n2].equals((Object)iPath)) {
                return;
            }
            ++n2;
        }
        this.enclosingProjectsAndJars = new IPath[n + 1];
        System.arraycopy(this.enclosingProjectsAndJars, 0, this.enclosingProjectsAndJars, 0, n);
        this.enclosingProjectsAndJars[n] = iPath;
    }

    public void add(JavaProject javaProject, int n, HashSet hashSet) throws JavaModelException {
        this.add(javaProject, null, n, hashSet, null);
    }

    void add(JavaProject javaProject, IPath iPath, int n, HashSet hashSet, IClasspathEntry iClasspathEntry) throws JavaModelException {
        IProject iProject = javaProject.getProject();
        if (!iProject.isAccessible() || !hashSet.add(iProject)) {
            return;
        }
        IPath iPath2 = iProject.getFullPath();
        String string = iPath2.toString();
        this.addEnclosingProjectOrJar(iPath2);
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath();
        IJavaModel iJavaModel = javaProject.getJavaModel();
        JavaModelManager.PerProjectInfo perProjectInfo = javaProject.getPerProjectInfo();
        int n2 = 0;
        int n3 = iClasspathEntryArray.length;
        while (n2 < n3) {
            block16: {
                ClasspathEntry classpathEntry;
                AccessRuleSet accessRuleSet;
                IClasspathEntry iClasspathEntry2;
                block15: {
                    iClasspathEntry2 = iClasspathEntryArray[n2];
                    accessRuleSet = null;
                    classpathEntry = (ClasspathEntry)iClasspathEntry2;
                    if (iClasspathEntry == null) break block15;
                    if (!iClasspathEntry2.isExported() && iClasspathEntry2.getEntryKind() != 3) break block16;
                    classpathEntry = classpathEntry.combineWith((ClasspathEntry)iClasspathEntry);
                }
                accessRuleSet = classpathEntry.getAccessRuleSet();
                block0 : switch (iClasspathEntry2.getEntryKind()) {
                    case 1: {
                        Object object;
                        IClasspathEntry iClasspathEntry3 = null;
                        Map map = perProjectInfo.rootPathToRawEntries;
                        if (map != null) {
                            iClasspathEntry3 = (IClasspathEntry)map.get(iClasspathEntry2.getPath());
                        }
                        if (iClasspathEntry3 == null) break;
                        switch (iClasspathEntry3.getEntryKind()) {
                            case 1: 
                            case 4: {
                                if ((n & 2) == 0) break;
                                object = iClasspathEntry2.getPath();
                                if (iPath != null && !iPath.equals(object)) break block0;
                                String string2 = object.getDevice() == null ? object.toString() : object.toOSString();
                                this.add(iPath2.toString(), "", string2, false, accessRuleSet);
                                this.addEnclosingProjectOrJar((IPath)object);
                                break;
                            }
                            case 5: {
                                object = JavaCore.getClasspathContainer(iClasspathEntry3.getPath(), javaProject);
                                if (object == null || (object.getKind() != 1 || (n & 2) == 0) && (n & 4) == 0) break block0;
                                String string2 = iClasspathEntry2.getPath();
                                if (iPath != null && !iPath.equals((Object)string2)) break block0;
                                String string3 = string2.getDevice() == null ? string2.toString() : string2.toOSString();
                                this.add(iPath2.toString(), "", string3, false, accessRuleSet);
                                this.addEnclosingProjectOrJar((IPath)string2);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if ((n & 8) == 0) break;
                        Object object = iClasspathEntry2.getPath();
                        if (iPath != null && !iPath.equals(object)) break;
                        this.add((JavaProject)iJavaModel.getJavaProject(iClasspathEntry2.getPath().lastSegment()), null, n, hashSet, classpathEntry);
                        break;
                    }
                    case 3: {
                        if ((n & 1) == 0) break;
                        Object object = iClasspathEntry2.getPath();
                        if (iPath != null && !iPath.equals(object)) break;
                        this.add(iPath2.toString(), Util.relativePath((IPath)object, 1), string, false, accessRuleSet);
                    }
                }
            }
            ++n2;
        }
    }

    public void add(IJavaElement iJavaElement) throws JavaModelException {
        IPath iPath = null;
        String string = null;
        int n = 7;
        switch (iJavaElement.getElementType()) {
            case 1: {
                break;
            }
            case 2: {
                this.add((JavaProject)iJavaElement, null, n, new HashSet(2), null);
                break;
            }
            case 3: {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                IPath iPath2 = iPackageFragmentRoot.getPath();
                IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getResolvedClasspathEntry();
                IPath[] iPathArray = iClasspathEntry.getExclusionPatterns();
                if (iPathArray != null && iPathArray.length > 0) {
                    this.addExclusions(iPath2, iPathArray);
                }
                iPath = iPackageFragmentRoot.getKind() == 1 ? iPackageFragmentRoot.getParent().getPath() : iPath2;
                string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
                IResource iResource = iPackageFragmentRoot.getResource();
                String string2 = iPackageFragmentRoot.getJavaProject().getPath().toString();
                if (iResource != null && iResource.isAccessible()) {
                    String string3 = Util.relativePath(iResource.getFullPath(), iPath.segmentCount());
                    this.add(string2, string3, string, false, null);
                    break;
                }
                this.add(string2, "", string, false, null);
                break;
            }
            case 4: {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getParent();
                String string4 = iPackageFragmentRoot.getJavaProject().getPath().toString();
                if (iPackageFragmentRoot.isArchive()) {
                    String string5 = Util.concatWith(((PackageFragment)iJavaElement).names, '/');
                    iPath = iPackageFragmentRoot.getPath();
                    string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
                    this.add(string4, string5, string, true, null);
                    break;
                }
                IResource iResource = iJavaElement.getResource();
                if (iResource == null) break;
                iPath = iResource.isAccessible() ? (iPackageFragmentRoot.getKind() == 1 ? iPackageFragmentRoot.getParent().getPath() : iPackageFragmentRoot.getPath()) : iResource.getParent().getFullPath();
                string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
                String string6 = Util.relativePath(iResource.getFullPath(), iPath.segmentCount());
                this.add(string4, string6, string, true, null);
                break;
            }
            default: {
                String string7;
                if (iJavaElement instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(iJavaElement);
                }
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                String string8 = iPackageFragmentRoot.getJavaProject().getPath().toString();
                if (iPackageFragmentRoot.getKind() == 1) {
                    iPath = iPackageFragmentRoot.getParent().getPath();
                    string7 = Util.relativePath(this.getPath(iJavaElement, false), 1);
                } else {
                    iPath = iPackageFragmentRoot.getPath();
                    string7 = this.getPath(iJavaElement, true).toString();
                }
                string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
                this.add(string8, string7, string, false, null);
            }
        }
        if (iPath != null) {
            this.addEnclosingProjectOrJar(iPath);
        }
    }

    private void addExclusions(IPath iPath, IPath[] iPathArray) {
        this.exclusionPathList.put(iPath.toString(), iPathArray);
    }

    public boolean shouldExclude(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null || this.exclusionPathList.size() == 0) {
            return false;
        }
        IPath[] iPathArray = (IPath[])this.exclusionPathList.get(string);
        if (iPathArray == null) {
            return false;
        }
        Path path = new Path(String.valueOf(string) + "/" + string2);
        int n = 0;
        while (!bl && n < iPathArray.length) {
            bl = Util.isExcluded((IPath)path, (char[][])new char[0][], (char[][])new char[][]{iPathArray[n].toString().toCharArray()});
            ++n;
        }
        return bl;
    }

    private void add(String string, String string2, String string3, boolean bl, AccessRuleSet accessRuleSet) {
        String string4;
        String string5;
        string3 = this.normalize(string3);
        string2 = this.normalize(string2);
        int n = this.containerPaths.length;
        int n2 = (string3.hashCode() & Integer.MAX_VALUE) % n;
        while ((string5 = this.relativePaths[n2]) != null && (string4 = this.containerPaths[n2]) != null) {
            if (string5.equals(string2) && string4.equals(string3)) {
                return;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        int n3 = this.projectPaths.indexOf(string);
        if (n3 == -1) {
            this.projectPaths.add(string);
            n3 = this.projectPaths.indexOf(string);
        }
        this.projectIndexes[n2] = n3;
        this.relativePaths[n2] = string2;
        this.containerPaths[n2] = string3;
        this.isPkgPath[n2] = bl;
        if (this.pathRestrictions != null) {
            this.pathRestrictions[n2] = accessRuleSet;
        } else if (accessRuleSet != null) {
            this.pathRestrictions = new AccessRuleSet[this.relativePaths.length];
            this.pathRestrictions[n2] = accessRuleSet;
        }
        if (++this.pathsCount > this.threshold) {
            this.rehash();
        }
    }

    public boolean encloses(String string) {
        int n = string.indexOf("|");
        if (n != -1) {
            String string2;
            String string3 = string.substring(0, n);
            return this.indexOf(string3, string2 = string.substring(n + 1)) >= 0;
        }
        return this.indexOf(string) >= 0;
    }

    private int indexOf(String string) {
        int n = 0;
        int n2 = this.relativePaths.length;
        while (n < n2) {
            String string2 = this.relativePaths[n];
            if (string2 != null) {
                String string3;
                String string4 = this.containerPaths[n];
                String string5 = string3 = string2.length() == 0 ? string4 : String.valueOf(string4) + '/' + string2;
                if (this.encloses(string3, string, n)) {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    private int indexOf(String string, String string2) {
        String string3;
        int n = this.containerPaths.length;
        int n2 = (string.hashCode() & Integer.MAX_VALUE) % n;
        while ((string3 = this.containerPaths[n2]) != null) {
            String string4;
            if (string3.equals(string) && this.encloses(string4 = this.relativePaths[n2], string2, n2)) {
                return n2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return -1;
    }

    private boolean encloses(String string, String string2, int n) {
        int n2;
        int n3 = (string2 = this.normalize(string2)).length();
        if (n3 < (n2 = string.length())) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n3 == n2) {
            Path path = new Path(string2);
            Path path2 = new Path(string);
            return path.equals((Object)path2);
        }
        if (!this.isPkgPath[n]) {
            return string2.startsWith(string) && string2.charAt(n2) == '/';
        }
        return string2.startsWith(string) && (string.length() == string2.lastIndexOf(47) || string.length() == string2.length());
    }

    public boolean encloses(IJavaElement iJavaElement) {
        if (this.elements != null) {
            int n = 0;
            int n2 = this.elements.size();
            while (n < n2) {
                IJavaElement iJavaElement2 = (IJavaElement)this.elements.get(n);
                IJavaElement iJavaElement3 = iJavaElement;
                while (iJavaElement3 != null) {
                    if (iJavaElement3.equals(iJavaElement2)) {
                        return true;
                    }
                    iJavaElement3 = iJavaElement3.getParent();
                }
                ++n;
            }
            return false;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
        if (iPackageFragmentRoot != null && iPackageFragmentRoot.isArchive()) {
            IPath iPath;
            IPath iPath2 = iPackageFragmentRoot.getPath();
            String string = iPath2.getDevice() == null ? iPath2.toString() : iPath2.toOSString();
            return this.indexOf(string, (iPath = this.getPath(iJavaElement, true)).toString()) >= 0;
        }
        String string = this.getPath(iJavaElement, false).toString();
        return this.indexOf(string) >= 0;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingProjectsAndJars;
    }

    private IPath getPath(IJavaElement iJavaElement, boolean bl) {
        switch (iJavaElement.getElementType()) {
            case 1: {
                return Path.EMPTY;
            }
            case 2: {
                return iJavaElement.getPath();
            }
            case 3: {
                if (bl) {
                    return Path.EMPTY;
                }
                return iJavaElement.getPath();
            }
            case 4: {
                String string = Util.concatWith(((PackageFragment)iJavaElement).names, '/');
                return this.getPath(iJavaElement.getParent(), bl).append((IPath)new Path(string));
            }
            case 5: 
            case 6: {
                return this.getPath(iJavaElement.getParent(), bl).append((IPath)new Path(iJavaElement.getElementName()));
            }
        }
        return this.getPath(iJavaElement.getParent(), bl);
    }

    public AccessRuleSet getAccessRuleSet(String string, String string2) {
        int n = this.indexOf(string2, string);
        if (n == -1) {
            return NOT_ENCLOSED;
        }
        if (this.pathRestrictions == null) {
            return null;
        }
        return this.pathRestrictions[n];
    }

    protected void initialize(int n) {
        this.pathsCount = 0;
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.relativePaths = new String[n2];
        this.containerPaths = new String[n2];
        this.projectPaths = new ArrayList();
        this.projectIndexes = new int[n2];
        this.isPkgPath = new boolean[n2];
        this.pathRestrictions = null;
        this.enclosingProjectsAndJars = new IPath[0];
    }

    private String normalize(String string) {
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0 && string.charAt(n2) == '/') {
            --n2;
        }
        if (n2 != n - 1) {
            return string.substring(0, n2 + 1);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDelta(IJavaElementDelta iJavaElementDelta) {
        switch (iJavaElementDelta.getKind()) {
            case 4: {
                IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
                int n = 0;
                int n2 = iJavaElementDeltaArray.length;
                while (n < n2) {
                    IJavaElementDelta iJavaElementDelta2 = iJavaElementDeltaArray[n];
                    this.processDelta(iJavaElementDelta2);
                    ++n;
                }
                return;
            }
            case 2: {
                IJavaElement iJavaElement = iJavaElementDelta.getElement();
                if (!this.encloses(iJavaElement)) return;
                if (this.elements != null) {
                    this.elements.remove(iJavaElement);
                }
                IPath iPath = null;
                switch (iJavaElement.getElementType()) {
                    case 2: {
                        iPath = ((IJavaProject)iJavaElement).getProject().getFullPath();
                    }
                    case 3: {
                        if (iPath == null) {
                            iPath = ((IPackageFragmentRoot)iJavaElement).getPath();
                        }
                        int n = -1;
                        int n3 = 0;
                        while (n3 < this.pathsCount) {
                            if (this.relativePaths[n3].equals(iPath)) {
                                n = n3;
                                break;
                            }
                            ++n3;
                        }
                        if (n == -1) return;
                        this.relativePaths[n] = null;
                        this.rehash();
                    }
                }
            }
        }
    }

    public IPackageFragmentRoot packageFragmentRoot(String string) {
        String string2;
        boolean bl;
        int n = -1;
        int n2 = string.indexOf("|");
        boolean bl2 = bl = n2 != -1;
        if (bl) {
            String string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
            n = this.indexOf(string3, string2);
        } else {
            n = this.indexOf(string);
        }
        if (n >= 0) {
            int n3 = this.projectIndexes[n];
            String string4 = string2 = n3 == -1 ? null : (String)this.projectPaths.get(n3);
            if (string2 != null) {
                IJavaProject iJavaProject = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot().getProject(string2));
                if (bl) {
                    return iJavaProject.getPackageFragmentRoot(this.containerPaths[n]);
                }
                Object object = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)new Path(String.valueOf(this.containerPaths[n]) + '/' + this.relativePaths[n]), false);
                if (object instanceof IProject) {
                    return iJavaProject.getPackageFragmentRoot((IResource)((IProject)object));
                }
                if (object instanceof IResource) {
                    IJavaElement iJavaElement = JavaCore.create((IResource)object);
                    return (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                }
                if (object instanceof File) {
                    return iJavaProject.getPackageFragmentRoot(this.containerPaths[n]);
                }
            }
        }
        return null;
    }

    private void rehash() {
        JavaSearchScope javaSearchScope = new JavaSearchScope(this.pathsCount * 2);
        javaSearchScope.projectPaths.ensureCapacity(this.projectPaths.size());
        int n = this.relativePaths.length;
        while (--n >= 0) {
            String string = this.relativePaths[n];
            if (string == null) continue;
            int n2 = this.projectIndexes[n];
            String string2 = n2 == -1 ? null : (String)this.projectPaths.get(n2);
            javaSearchScope.add(string2, string, this.containerPaths[n], this.isPkgPath[n], this.pathRestrictions == null ? null : this.pathRestrictions[n]);
        }
        this.relativePaths = javaSearchScope.relativePaths;
        this.containerPaths = javaSearchScope.containerPaths;
        this.projectPaths = javaSearchScope.projectPaths;
        this.projectIndexes = javaSearchScope.projectIndexes;
        this.isPkgPath = javaSearchScope.isPkgPath;
        this.pathRestrictions = javaSearchScope.pathRestrictions;
        this.threshold = javaSearchScope.threshold;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("JavaSearchScope on ");
        if (this.elements != null) {
            stringBuffer.append("[");
            int n = 0;
            int n2 = this.elements.size();
            while (n < n2) {
                JavaElement javaElement = (JavaElement)this.elements.get(n);
                stringBuffer.append("\n\t");
                stringBuffer.append(javaElement.toStringWithAncestors());
                ++n;
            }
            stringBuffer.append("\n]");
        } else if (this.pathsCount == 0) {
            stringBuffer.append("[empty scope]");
        } else {
            stringBuffer.append("[");
            int n = 0;
            while (n < this.relativePaths.length) {
                String string = this.relativePaths[n];
                if (string != null) {
                    stringBuffer.append("\n\t");
                    stringBuffer.append(this.containerPaths[n]);
                    if (string.length() > 0) {
                        stringBuffer.append('/');
                        stringBuffer.append(string);
                    }
                }
                ++n;
            }
            stringBuffer.append("\n]");
        }
        return stringBuffer.toString();
    }
}

