/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ConstructorPattern
extends JavaSearchPattern {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    public boolean varargs = false;
    char[][][] parametersTypeSignatures;
    char[][][][] parametersTypeArguments;
    boolean constructorParameters = false;
    char[][] constructorArguments;
    protected static char[][] REF_CATEGORIES = new char[][]{CONSTRUCTOR_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{CONSTRUCTOR_REF, CONSTRUCTOR_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{CONSTRUCTOR_DECL};

    public static char[] createIndexKey(char[] cArray, int n) {
        char[] cArray2 = n < 10 ? COUNTS[n] : ("/" + String.valueOf(n)).toCharArray();
        return CharOperation.concat(cArray, cArray2);
    }

    ConstructorPattern(int n) {
        super(32, n);
    }

    public ConstructorPattern(boolean bl, boolean bl2, char[] cArray, char[] cArray2, char[][] cArray3, char[][] cArray4, int n) {
        this(n);
        this.findDeclarations = bl;
        this.findReferences = bl2;
        this.declaringQualification = this.isCaseSensitive() ? cArray2 : CharOperation.toLowerCase(cArray2);
        char[] cArray5 = this.declaringSimpleName = this.isCaseSensitive() || this.isCamelCase() ? cArray : CharOperation.toLowerCase(cArray);
        if (cArray4 != null) {
            this.parameterCount = cArray4.length;
            boolean bl3 = this.parameterCount > 0 && cArray2 != null && CharOperation.equals(CharOperation.concat(cArray3[0], cArray4[0], '.'), cArray2);
            int n2 = 0;
            if (bl3) {
                --this.parameterCount;
                ++n2;
            }
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            int n3 = 0;
            while (n3 < this.parameterCount) {
                this.parameterQualifications[n3] = this.isCaseSensitive() ? cArray3[n3 + n2] : CharOperation.toLowerCase(cArray3[n3 + n2]);
                this.parameterSimpleNames[n3] = this.isCaseSensitive() ? cArray4[n3 + n2] : CharOperation.toLowerCase(cArray4[n3 + n2]);
                ++n3;
            }
        } else {
            this.parameterCount = -1;
        }
        this.mustResolve = this.mustResolve();
    }

    public ConstructorPattern(boolean bl, boolean bl2, char[] cArray, char[] cArray2, char[][] cArray3, char[][] cArray4, String[] stringArray, IMethod iMethod, int n) {
        this(bl, bl2, cArray, cArray2, cArray3, cArray4, n);
        int n2;
        String string;
        try {
            this.varargs = (iMethod.getFlags() & 0x80) != 0;
        }
        catch (JavaModelException javaModelException) {}
        String string2 = null;
        if (iMethod.isResolved() && new BindingKey(string = iMethod.getKey()).isParameterizedType()) {
            string2 = Util.getDeclaringTypeSignature(string);
        } else {
            this.constructorParameters = true;
        }
        if (string2 != null) {
            this.typeSignatures = Util.splitTypeLevelsSignature(string2);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
        } else {
            this.storeTypeSignaturesAndArguments(iMethod.getDeclaringType());
        }
        if (stringArray != null && (n2 = stringArray.length) > 0) {
            this.parametersTypeSignatures = new char[n2][][];
            this.parametersTypeArguments = new char[n2][][][];
            int n3 = 0;
            while (n3 < n2) {
                this.parametersTypeSignatures[n3] = Util.splitTypeLevelsSignature(stringArray[n3]);
                this.parametersTypeArguments[n3] = Util.getAllTypeArguments(this.parametersTypeSignatures[n3]);
                ++n3;
            }
        }
        this.constructorArguments = this.extractMethodArguments(iMethod);
        if (this.hasConstructorArguments()) {
            this.mustResolve = true;
        }
    }

    public ConstructorPattern(boolean bl, boolean bl2, char[] cArray, char[] cArray2, String string, char[][] cArray3, char[][] cArray4, String[] stringArray, char[][] cArray5, int n) {
        this(bl, bl2, cArray, cArray2, cArray3, cArray4, n);
        int n2;
        if (string != null) {
            this.typeSignatures = Util.splitTypeLevelsSignature(string);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
        }
        if (stringArray != null && (n2 = stringArray.length) > 0) {
            this.parametersTypeSignatures = new char[n2][][];
            this.parametersTypeArguments = new char[n2][][][];
            int n3 = 0;
            while (n3 < n2) {
                this.parametersTypeSignatures[n3] = Util.splitTypeLevelsSignature(stringArray[n3]);
                this.parametersTypeArguments[n3] = Util.getAllTypeArguments(this.parametersTypeSignatures[n3]);
                ++n3;
            }
        }
        this.constructorArguments = cArray5;
        if ((cArray5 == null || cArray5.length == 0) && this.getTypeArguments() != null && this.getTypeArguments().length > 0) {
            this.constructorArguments = this.getTypeArguments()[0];
        }
        if (this.hasConstructorArguments()) {
            this.mustResolve = true;
        }
    }

    public void decodeIndexKey(char[] cArray) {
        int n = cArray.length - 1;
        this.parameterCount = 0;
        this.declaringSimpleName = null;
        int n2 = 1;
        int n3 = n;
        while (n3 >= 0) {
            if (cArray[n3] == '/') {
                this.declaringSimpleName = new char[n3];
                System.arraycopy(cArray, 0, this.declaringSimpleName, 0, n3);
                break;
            }
            this.parameterCount = n3 == n ? cArray[n3] - 48 : (this.parameterCount += (n2 *= 10) * (cArray[n3] - 48));
            --n3;
        }
    }

    public SearchPattern getBlankPattern() {
        return new ConstructorPattern(8);
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    boolean hasConstructorArguments() {
        return this.constructorArguments != null && this.constructorArguments.length > 0;
    }

    boolean hasConstructorParameters() {
        return this.constructorParameters;
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        ConstructorPattern constructorPattern = (ConstructorPattern)searchPattern;
        return (this.parameterCount == constructorPattern.parameterCount || this.parameterCount == -1 || this.varargs) && this.matchesName(this.declaringSimpleName, constructorPattern.declaringSimpleName);
    }

    protected boolean mustResolve() {
        if (this.declaringQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int n = 0;
            int n2 = this.parameterSimpleNames.length;
            while (n < n2) {
                if (this.parameterQualifications[n] != null) {
                    return true;
                }
                ++n;
            }
        }
        return this.findReferences;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] cArray = this.declaringSimpleName;
        int n = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                if (this.declaringSimpleName != null && this.parameterCount >= 0 && !this.varargs) {
                    cArray = ConstructorPattern.createIndexKey(this.declaringSimpleName, this.parameterCount);
                    break;
                }
                n &= 0xFFFFFFFF;
                n |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0 && !this.varargs) {
                    cArray = ConstructorPattern.createIndexKey(this.declaringSimpleName == null ? ONE_STAR : this.declaringSimpleName, this.parameterCount);
                    break;
                }
                if (this.declaringSimpleName == null || this.declaringSimpleName[this.declaringSimpleName.length - 1] == '*') break;
                cArray = CharOperation.concat(this.declaringSimpleName, ONE_STAR, '/');
                break;
            }
        }
        return index.query(this.getIndexCategories(), cArray, n);
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        if (this.findDeclarations) {
            stringBuffer.append(this.findReferences ? "ConstructorCombinedPattern: " : "ConstructorDeclarationPattern: ");
        } else {
            stringBuffer.append("ConstructorReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            stringBuffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            stringBuffer.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            stringBuffer.append("*");
        }
        stringBuffer.append('(');
        if (this.parameterSimpleNames == null) {
            stringBuffer.append("...");
        } else {
            int n = 0;
            int n2 = this.parameterSimpleNames.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                if (this.parameterQualifications[n] != null) {
                    stringBuffer.append(this.parameterQualifications[n]).append('.');
                }
                if (this.parameterSimpleNames[n] == null) {
                    stringBuffer.append('*');
                } else {
                    stringBuffer.append(this.parameterSimpleNames[n]);
                }
                ++n;
            }
        }
        stringBuffer.append(')');
        return super.print(stringBuffer);
    }
}

