/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class PackageReferenceLocator
extends PatternLocator {
    protected PackageReferencePattern pattern;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDeclaringPackageFragment(IPackageFragment iPackageFragment, ReferenceBinding referenceBinding) {
        char[] cArray = referenceBinding.getFileName();
        if (cArray == null) return true;
        cArray = CharOperation.replaceOnCopy(cArray, '/', '\\');
        cArray = CharOperation.lastSegment(cArray, '\\');
        try {
            switch (iPackageFragment.getKind()) {
                case 1: {
                    if (!Util.isJavaLikeFileName(cArray)) return false;
                    if (iPackageFragment.getCompilationUnit(new String(cArray)).exists()) return true;
                    return false;
                }
                case 2: {
                    if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(cArray)) return false;
                    if (iPackageFragment.getClassFile(new String(cArray)).exists()) return true;
                    return false;
                }
            }
            return true;
        }
        catch (JavaModelException javaModelException) {}
        return true;
    }

    public PackageReferenceLocator(PackageReferencePattern packageReferencePattern) {
        super(packageReferencePattern);
        this.pattern = packageReferencePattern;
    }

    public int match(ASTNode aSTNode, MatchingNodeSet matchingNodeSet) {
        if (!(aSTNode instanceof ImportReference)) {
            return 0;
        }
        return matchingNodeSet.addMatch(aSTNode, this.matchLevel((ImportReference)aSTNode));
    }

    public int match(Reference reference, MatchingNodeSet matchingNodeSet) {
        if (!(reference instanceof QualifiedNameReference)) {
            return 0;
        }
        return matchingNodeSet.addMatch(reference, this.matchLevelForTokens(((QualifiedNameReference)reference).tokens));
    }

    public int match(TypeReference typeReference, MatchingNodeSet matchingNodeSet) {
        if (typeReference instanceof JavadocSingleTypeReference) {
            char[][] cArrayArray = new char[][]{((JavadocSingleTypeReference)typeReference).token};
            return matchingNodeSet.addMatch(typeReference, this.matchLevelForTokens(cArrayArray));
        }
        if (!(typeReference instanceof QualifiedTypeReference)) {
            return 0;
        }
        return matchingNodeSet.addMatch(typeReference, this.matchLevelForTokens(((QualifiedTypeReference)typeReference).tokens));
    }

    protected int matchLevel(ImportReference importReference) {
        return this.matchLevelForTokens(importReference.tokens);
    }

    protected int matchLevelForTokens(char[][] cArray) {
        if (this.pattern.pkgName == null) {
            return 3;
        }
        char[] cArray2 = null;
        if (this.isCamelCase && CharOperation.camelCaseMatch(this.pattern.pkgName, cArray2 = CharOperation.concatWith(cArray, '.'))) {
            return 2;
        }
        switch (this.matchMode) {
            case 0: 
            case 1: {
                if (cArray2 == null) {
                    cArray2 = CharOperation.concatWith(cArray, '.');
                }
                if (!CharOperation.prefixEquals(this.pattern.pkgName, cArray2, this.isCaseSensitive)) break;
                return 2;
            }
            case 2: {
                char[] cArray3;
                char[] cArray4 = cArray3 = this.pattern.pkgName[this.pattern.pkgName.length - 1] == '*' ? this.pattern.pkgName : CharOperation.concat(this.pattern.pkgName, ".*".toCharArray());
                if (cArray2 == null) {
                    cArray2 = CharOperation.concatWith(cArray, '.');
                }
                if (!CharOperation.match(cArray3, cArray2, this.isCaseSensitive)) break;
                return 2;
            }
        }
        return 0;
    }

    protected void matchLevelAndReportImportRef(ImportReference importReference, Binding binding, MatchLocator matchLocator) throws CoreException {
        Binding binding2 = binding;
        if (importReference.isStatic()) {
            MemberTypeBinding memberTypeBinding;
            if (binding instanceof FieldBinding) {
                FieldBinding fieldBinding = (FieldBinding)binding;
                if (!fieldBinding.isStatic()) {
                    return;
                }
                binding2 = fieldBinding.declaringClass;
            } else if (binding instanceof MethodBinding) {
                MethodBinding methodBinding = (MethodBinding)binding;
                if (!methodBinding.isStatic()) {
                    return;
                }
                binding2 = methodBinding.declaringClass;
            } else if (binding instanceof MemberTypeBinding && !(memberTypeBinding = (MemberTypeBinding)binding).isStatic()) {
                return;
            }
        }
        super.matchLevelAndReportImportRef(importReference, binding2, matchLocator);
    }

    protected void matchReportImportRef(ImportReference importReference, Binding binding, IJavaElement iJavaElement, int n, MatchLocator matchLocator) throws CoreException {
        if (binding == null) {
            this.matchReportReference(importReference, iJavaElement, null, n, matchLocator);
        } else if (matchLocator.encloses(iJavaElement)) {
            PackageBinding packageBinding;
            long[] lArray = importReference.sourcePositions;
            int n2 = lArray.length - 1;
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).closestMatch();
            }
            if (binding instanceof ReferenceBinding && (packageBinding = ((ReferenceBinding)binding).fPackage) != null) {
                n2 = packageBinding.compoundName.length;
            }
            if (binding instanceof PackageBinding) {
                n2 = ((PackageBinding)binding).compoundName.length;
            }
            int n3 = (int)(lArray[0] >>> 32);
            int n4 = (int)lArray[n2 - 1];
            this.match = matchLocator.newPackageReferenceMatch(iJavaElement, n, n3, n4 - n3 + 1, importReference);
            matchLocator.report(this.match);
        }
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        int n2;
        long[] lArray;
        block25: {
            Object object;
            Object object2;
            block27: {
                block26: {
                    block24: {
                        lArray = null;
                        n2 = -1;
                        if (!(aSTNode instanceof ImportReference)) break block24;
                        object2 = (ImportReference)aSTNode;
                        lArray = ((ImportReference)object2).sourcePositions;
                        n2 = (((ImportReference)object2).bits & 0x20000) != 0 ? lArray.length : lArray.length - 1;
                        break block25;
                    }
                    object2 = null;
                    if (!(aSTNode instanceof QualifiedNameReference)) break block26;
                    object = (QualifiedNameReference)aSTNode;
                    lArray = ((QualifiedNameReference)object).sourcePositions;
                    switch (((QualifiedNameReference)object).bits & 0xF) {
                        case 1: {
                            object2 = ((QualifiedNameReference)object).actualReceiverType;
                            break;
                        }
                        case 4: {
                            if (((QualifiedNameReference)object).binding instanceof TypeBinding) {
                                object2 = (TypeBinding)((QualifiedNameReference)object).binding;
                                break;
                            }
                            break block27;
                        }
                        case 3: 
                        case 7: {
                            Binding binding2 = ((QualifiedNameReference)object).binding;
                            if (binding2 instanceof TypeBinding) {
                                object2 = (TypeBinding)binding2;
                                break;
                            }
                            if (binding2 instanceof ProblemFieldBinding) {
                                object2 = ((QualifiedNameReference)object).actualReceiverType;
                                n2 = ((QualifiedNameReference)object).tokens.length - (((QualifiedNameReference)object).otherBindings == null ? 2 : ((QualifiedNameReference)object).otherBindings.length + 2);
                                break;
                            }
                            if (!(binding2 instanceof ProblemBinding)) break block27;
                            ProblemBinding problemBinding = (ProblemBinding)binding2;
                            object2 = problemBinding.searchType;
                            n2 = CharOperation.occurencesOf('.', problemBinding.name);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block27;
                }
                if (aSTNode instanceof QualifiedTypeReference) {
                    object = (QualifiedTypeReference)aSTNode;
                    lArray = ((QualifiedTypeReference)object).sourcePositions;
                    object2 = ((QualifiedTypeReference)object).resolvedType;
                } else if (aSTNode instanceof JavadocSingleTypeReference) {
                    object = (JavadocSingleTypeReference)aSTNode;
                    lArray = new long[]{((long)((JavadocSingleTypeReference)object).sourceStart << 32) + (long)((JavadocSingleTypeReference)object).sourceEnd};
                    object2 = ((JavadocSingleTypeReference)object).resolvedType;
                }
            }
            if (lArray == null) {
                return;
            }
            if (object2 instanceof ArrayBinding) {
                object2 = ((ArrayBinding)object2).leafComponentType;
            }
            if (object2 instanceof ProblemReferenceBinding) {
                object2 = ((ProblemReferenceBinding)object2).closestMatch();
            }
            if (object2 instanceof ReferenceBinding && (object = ((ReferenceBinding)object2).fPackage) != null) {
                n2 = ((PackageBinding)object).compoundName.length;
            }
            Object object3 = object = object2 == null ? null : ((TypeBinding)object2).enclosingType();
            if (object != null) {
                int n3 = lArray.length;
                while (object != null && n3 > 0) {
                    --n3;
                    object = ((TypeBinding)object).enclosingType();
                }
                if (n3 <= 1) {
                    return;
                }
            }
        }
        if (n2 == -1) {
            n2 = this.pattern.segments.length;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 > lArray.length) {
            n2 = lArray.length;
        }
        int n4 = (int)(lArray[0] >>> 32);
        int n5 = (int)lArray[n2 - 1];
        this.match = matchLocator.newPackageReferenceMatch(iJavaElement, n, n4, n5 - n4 + 1, aSTNode);
        matchLocator.report(this.match);
    }

    protected int referenceType() {
        return 4;
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (aSTNode instanceof JavadocQualifiedTypeReference) {
            JavadocQualifiedTypeReference javadocQualifiedTypeReference = (JavadocQualifiedTypeReference)aSTNode;
            if (javadocQualifiedTypeReference.packageBinding != null) {
                return this.resolveLevel(javadocQualifiedTypeReference.packageBinding);
            }
            return this.resolveLevel(javadocQualifiedTypeReference.resolvedType);
        }
        if (aSTNode instanceof JavadocSingleTypeReference) {
            JavadocSingleTypeReference javadocSingleTypeReference = (JavadocSingleTypeReference)aSTNode;
            if (javadocSingleTypeReference.packageBinding != null) {
                return this.resolveLevel(javadocSingleTypeReference.packageBinding);
            }
            return 0;
        }
        if (aSTNode instanceof QualifiedTypeReference) {
            return this.resolveLevel(((QualifiedTypeReference)aSTNode).resolvedType);
        }
        if (aSTNode instanceof QualifiedNameReference) {
            return this.resolveLevel((QualifiedNameReference)aSTNode);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        char[][] cArray = null;
        if (binding instanceof ImportBinding) {
            cArray = ((ImportBinding)binding).compoundName;
        } else if (binding instanceof PackageBinding) {
            cArray = ((PackageBinding)binding).compoundName;
        } else {
            if (binding instanceof ArrayBinding) {
                binding = ((ArrayBinding)binding).leafComponentType;
            }
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).closestMatch();
            }
            if (binding == null) {
                return 1;
            }
            if (binding instanceof ReferenceBinding) {
                PackageBinding packageBinding = ((ReferenceBinding)binding).fPackage;
                if (packageBinding == null) {
                    return 1;
                }
                cArray = packageBinding.compoundName;
            }
        }
        if (cArray != null && this.matchesName(this.pattern.pkgName, CharOperation.concatWith(cArray, '.'))) {
            if (this.pattern.focus instanceof IPackageFragment && binding instanceof ReferenceBinding && !PackageReferenceLocator.isDeclaringPackageFragment((IPackageFragment)this.pattern.focus, (ReferenceBinding)binding)) {
                return 0;
            }
            return 3;
        }
        return 0;
    }

    protected int resolveLevel(QualifiedNameReference qualifiedNameReference) {
        TypeBinding typeBinding = null;
        switch (qualifiedNameReference.bits & 0xF) {
            case 1: {
                if (qualifiedNameReference.tokens.length < (qualifiedNameReference.otherBindings == null ? 3 : qualifiedNameReference.otherBindings.length + 3)) {
                    return 0;
                }
                typeBinding = qualifiedNameReference.actualReceiverType;
                break;
            }
            case 2: {
                return 0;
            }
            case 4: {
                if (!(qualifiedNameReference.binding instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)qualifiedNameReference.binding;
                break;
            }
            case 3: 
            case 7: {
                Binding binding = qualifiedNameReference.binding;
                if (binding instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                if (binding instanceof ProblemFieldBinding) {
                    if (qualifiedNameReference.tokens.length < (qualifiedNameReference.otherBindings == null ? 3 : qualifiedNameReference.otherBindings.length + 3)) {
                        return 0;
                    }
                    typeBinding = qualifiedNameReference.actualReceiverType;
                    break;
                }
                if (!(binding instanceof ProblemBinding)) break;
                ProblemBinding problemBinding = (ProblemBinding)binding;
                if (CharOperation.occurencesOf('.', problemBinding.name) <= 0) {
                    return 1;
                }
                typeBinding = problemBinding.searchType;
            }
        }
        return this.resolveLevel(typeBinding);
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

