/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;

public class TypeDeclarationPattern
extends JavaSearchPattern {
    public char[] simpleName;
    public char[] pkg;
    public char[][] enclosingTypeNames;
    public char typeSuffix;
    public int modifiers;
    public boolean secondary = false;
    protected static char[][] CATEGORIES = new char[][]{TYPE_DECL};
    static PackageNameSet internedPackageNames = new PackageNameSet(1001);

    public static char[] createIndexKey(int n, char[] cArray, char[] cArray2, char[][] cArray3, boolean bl) {
        int n2;
        int n3 = cArray == null ? 0 : cArray.length;
        int n4 = cArray2 == null ? 0 : cArray2.length;
        int n5 = 0;
        if (cArray3 != null) {
            n2 = 0;
            int n6 = cArray3.length;
            while (n2 < n6) {
                n5 += cArray3[n2].length;
                if (++n2 >= n6) continue;
                ++n5;
            }
        }
        n2 = n3 + n4 + n5 + 5;
        if (bl) {
            n2 += 2;
        }
        char[] cArray4 = new char[n2];
        int n7 = 0;
        if (n3 > 0) {
            System.arraycopy(cArray, 0, cArray4, n7, n3);
            n7 += n3;
        }
        cArray4[n7++] = 47;
        if (n4 > 0) {
            System.arraycopy(cArray2, 0, cArray4, n7, n4);
            n7 += n4;
        }
        cArray4[n7++] = 47;
        if (cArray3 != null && n5 > 0) {
            int n8 = 0;
            int n9 = cArray3.length;
            while (n8 < n9) {
                char[] cArray5 = cArray3[n8];
                int n10 = cArray5.length;
                System.arraycopy(cArray5, 0, cArray4, n7, n10);
                n7 += n10;
                if (++n8 >= n9) continue;
                cArray4[n7++] = 46;
            }
        }
        cArray4[n7++] = 47;
        cArray4[n7++] = (char)n;
        cArray4[n7] = (char)(n >> 16);
        if (bl) {
            cArray4[++n7] = 47;
            cArray4[++n7] = 83;
        }
        return cArray4;
    }

    public TypeDeclarationPattern(char[] cArray, char[][] cArray2, char[] cArray3, char c, int n) {
        this(n);
        char[] cArray4 = this.pkg = this.isCaseSensitive() ? cArray : CharOperation.toLowerCase(cArray);
        if (this.isCaseSensitive() || cArray2 == null) {
            this.enclosingTypeNames = cArray2;
        } else {
            int n2 = cArray2.length;
            this.enclosingTypeNames = new char[n2][];
            int n3 = 0;
            while (n3 < n2) {
                this.enclosingTypeNames[n3] = CharOperation.toLowerCase(cArray2[n3]);
                ++n3;
            }
        }
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? cArray3 : CharOperation.toLowerCase(cArray3);
        this.typeSuffix = c;
        this.mustResolve = this.pkg != null && this.enclosingTypeNames != null || c != '\u0000';
    }

    TypeDeclarationPattern(int n) {
        super(8, n);
    }

    public void decodeIndexKey(char[] cArray) {
        int n;
        int n2 = CharOperation.indexOf('/', cArray, 0);
        this.simpleName = CharOperation.subarray(cArray, 0, n2);
        if (cArray[n = ++n2] == '/') {
            this.pkg = CharOperation.NO_CHAR;
        } else {
            n2 = CharOperation.indexOf('/', cArray, n);
            this.pkg = internedPackageNames.add(CharOperation.subarray(cArray, n, n2));
        }
        int n3 = cArray.length - 1;
        boolean bl = this.secondary = cArray[n3] == 'S';
        if (this.secondary) {
            n3 -= 2;
        }
        this.modifiers = cArray[n3 - 1] + (cArray[n3] << 16);
        this.decodeModifiers();
        n = n2 + 1;
        this.enclosingTypeNames = n == (n3 -= 2) ? CharOperation.NO_CHAR_CHAR : (n3 == n + 1 && cArray[n] == '0' ? ONE_ZERO_CHAR : CharOperation.splitOn('.', cArray, n, n3));
    }

    protected void decodeModifiers() {
        switch (this.modifiers & 0x6200) {
            case 8192: 
            case 8704: {
                this.typeSuffix = (char)65;
                break;
            }
            case 16384: {
                this.typeSuffix = (char)69;
                break;
            }
            case 512: {
                this.typeSuffix = (char)73;
                break;
            }
            default: {
                this.typeSuffix = (char)67;
            }
        }
    }

    public SearchPattern getBlankPattern() {
        return new TypeDeclarationPattern(8);
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        TypeDeclarationPattern typeDeclarationPattern = (TypeDeclarationPattern)searchPattern;
        if (this.typeSuffix != typeDeclarationPattern.typeSuffix && this.typeSuffix != '\u0000' && !this.matchDifferentTypeSuffixes(this.typeSuffix, typeDeclarationPattern.typeSuffix)) {
            return false;
        }
        if (!this.matchesName(this.simpleName, typeDeclarationPattern.simpleName)) {
            return false;
        }
        if (this.pkg != null && !CharOperation.equals(this.pkg, typeDeclarationPattern.pkg, this.isCaseSensitive())) {
            return false;
        }
        if (this.enclosingTypeNames != null) {
            if (this.enclosingTypeNames.length == 0) {
                return typeDeclarationPattern.enclosingTypeNames.length == 0;
            }
            if (this.enclosingTypeNames.length == 1 && typeDeclarationPattern.enclosingTypeNames.length == 1) {
                return CharOperation.equals(this.enclosingTypeNames[0], typeDeclarationPattern.enclosingTypeNames[0], this.isCaseSensitive());
            }
            if (typeDeclarationPattern.enclosingTypeNames == ONE_ZERO_CHAR) {
                return true;
            }
            return CharOperation.equals(this.enclosingTypeNames, typeDeclarationPattern.enclosingTypeNames, this.isCaseSensitive());
        }
        return true;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] cArray = this.simpleName;
        int n = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 1: {
                break;
            }
            case 0: {
                if (this.isCamelCase) break;
                n &= 0xFFFFFFFF;
                if (this.simpleName != null) {
                    n |= 1;
                    cArray = this.pkg == null ? CharOperation.append(this.simpleName, '/') : CharOperation.concat(this.simpleName, '/', this.pkg, '/', CharOperation.NO_CHAR);
                    break;
                }
                n |= 2;
            }
            case 2: {
                if (this.pkg == null) {
                    if (this.simpleName == null) {
                        switch (this.typeSuffix) {
                            default: 
                        }
                        break;
                    }
                    if (this.simpleName[this.simpleName.length - 1] == '*') break;
                    cArray = CharOperation.concat(this.simpleName, ONE_STAR, '/');
                    break;
                }
                cArray = CharOperation.concat(this.simpleName == null ? ONE_STAR : this.simpleName, '/', this.pkg, '/', ONE_STAR);
                break;
            }
        }
        return index.query(this.getIndexCategories(), cArray, n);
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        switch (this.typeSuffix) {
            case 'C': {
                stringBuffer.append("ClassDeclarationPattern: pkg<");
                break;
            }
            case '\n': {
                stringBuffer.append("ClassAndInterfaceDeclarationPattern: pkg<");
                break;
            }
            case '\t': {
                stringBuffer.append("ClassAndEnumDeclarationPattern: pkg<");
                break;
            }
            case 'I': {
                stringBuffer.append("InterfaceDeclarationPattern: pkg<");
                break;
            }
            case '\u000b': {
                stringBuffer.append("InterfaceAndAnnotationDeclarationPattern: pkg<");
                break;
            }
            case 'E': {
                stringBuffer.append("EnumDeclarationPattern: pkg<");
                break;
            }
            case 'A': {
                stringBuffer.append("AnnotationTypeDeclarationPattern: pkg<");
                break;
            }
            default: {
                stringBuffer.append("TypeDeclarationPattern: pkg<");
            }
        }
        if (this.pkg != null) {
            stringBuffer.append(this.pkg);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(">, enclosing<");
        if (this.enclosingTypeNames != null) {
            int n = 0;
            while (n < this.enclosingTypeNames.length) {
                stringBuffer.append(this.enclosingTypeNames[n]);
                if (n < this.enclosingTypeNames.length - 1) {
                    stringBuffer.append('.');
                }
                ++n;
            }
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(">, type<");
        if (this.simpleName != null) {
            stringBuffer.append(this.simpleName);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(">");
        return super.print(stringBuffer);
    }

    static class PackageNameSet {
        public char[][] names;
        public int elementSize = 0;
        public int threshold;

        PackageNameSet(int n) {
            this.threshold = n;
            int n2 = (int)((float)n * 1.5f);
            if (this.threshold == n2) {
                ++n2;
            }
            this.names = new char[n2][];
        }

        char[] add(char[] cArray) {
            char[] cArray2;
            int n = this.names.length;
            int n2 = CharOperation.hashCode(cArray) % n;
            while ((cArray2 = this.names[n2]) != null) {
                if (CharOperation.equals(cArray2, cArray)) {
                    return cArray2;
                }
                if (++n2 != n) continue;
                n2 = 0;
            }
            this.names[n2] = cArray;
            if (++this.elementSize > this.threshold) {
                this.rehash();
            }
            return cArray;
        }

        void rehash() {
            PackageNameSet packageNameSet = new PackageNameSet(this.elementSize * 2);
            int n = this.names.length;
            while (--n >= 0) {
                char[] cArray = this.names[n];
                if (cArray == null) continue;
                packageNameSet.add(cArray);
            }
            this.names = packageNameSet.names;
            this.elementSize = packageNameSet.elementSize;
            this.threshold = packageNameSet.threshold;
        }
    }
}

