/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;

public class InnerClassesAttributeEntry
extends ClassFileStruct
implements IInnerClassesAttributeEntry {
    private int innerClassNameIndex;
    private int outerClassNameIndex;
    private int innerNameIndex;
    private char[] innerClassName;
    private char[] outerClassName;
    private char[] innerName;
    private int accessFlags;

    public InnerClassesAttributeEntry(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        IConstantPoolEntry iConstantPoolEntry;
        this.innerClassNameIndex = this.u2At(byArray, 0, n);
        this.outerClassNameIndex = this.u2At(byArray, 2, n);
        this.innerNameIndex = this.u2At(byArray, 4, n);
        this.accessFlags = this.u2At(byArray, 6, n);
        if (this.innerClassNameIndex != 0) {
            iConstantPoolEntry = iConstantPool.decodeEntry(this.innerClassNameIndex);
            if (iConstantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.innerClassName = iConstantPoolEntry.getClassInfoName();
        }
        if (this.outerClassNameIndex != 0) {
            iConstantPoolEntry = iConstantPool.decodeEntry(this.outerClassNameIndex);
            if (iConstantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.outerClassName = iConstantPoolEntry.getClassInfoName();
        }
        if (this.innerNameIndex != 0) {
            iConstantPoolEntry = iConstantPool.decodeEntry(this.innerNameIndex);
            if (iConstantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.innerName = iConstantPoolEntry.getUtf8Value();
        }
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public char[] getInnerClassName() {
        return this.innerClassName;
    }

    public int getInnerClassNameIndex() {
        return this.innerClassNameIndex;
    }

    public char[] getInnerName() {
        return this.innerName;
    }

    public int getInnerNameIndex() {
        return this.innerNameIndex;
    }

    public char[] getOuterClassName() {
        return this.outerClassName;
    }

    public int getOuterClassNameIndex() {
        return this.outerClassNameIndex;
    }
}

