/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.eval;

import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.eval.EvaluationConstants;
import org.eclipse.wst.jsdt.internal.eval.EvaluationContext;
import org.eclipse.wst.jsdt.internal.eval.VariablesInfo;

public class CodeSnippetEnvironment
implements INameEnvironment,
EvaluationConstants {
    INameEnvironment env;
    EvaluationContext context;

    public CodeSnippetEnvironment(INameEnvironment iNameEnvironment, EvaluationContext evaluationContext) {
        this.env = iNameEnvironment;
        this.context = evaluationContext;
    }

    public NameEnvironmentAnswer findType(char[][] cArray, ITypeRequestor iTypeRequestor) {
        NameEnvironmentAnswer nameEnvironmentAnswer = this.env.findType(cArray, iTypeRequestor);
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        if (CharOperation.equals(cArray, ROOT_COMPOUND_NAME)) {
            IBinaryType iBinaryType = this.context.getRootCodeSnippetBinary();
            if (iBinaryType == null) {
                return null;
            }
            return new NameEnvironmentAnswer(iBinaryType, null);
        }
        VariablesInfo variablesInfo = this.context.installedVars;
        ClassFile[] classFileArray = variablesInfo.classFiles;
        int n = 0;
        while (n < classFileArray.length) {
            ClassFile classFile = classFileArray[n];
            if (CharOperation.equals(cArray, classFile.getCompoundName())) {
                ClassFileReader classFileReader = null;
                try {
                    classFileReader = new ClassFileReader(classFile.getBytes(), null);
                }
                catch (ClassFormatException classFormatException) {
                    classFormatException.printStackTrace();
                    return null;
                }
                return new NameEnvironmentAnswer(classFileReader, null);
            }
            ++n;
        }
        return null;
    }

    public NameEnvironmentAnswer findBinding(char[] cArray, char[][] cArray2, int n, ITypeRequestor iTypeRequestor, boolean bl, String string) {
        throw new UnimplementedException();
    }

    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2, ITypeRequestor iTypeRequestor) {
        NameEnvironmentAnswer nameEnvironmentAnswer = this.env.findType(cArray, cArray2, iTypeRequestor);
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        return this.findType(CharOperation.arrayConcat(cArray2, cArray), iTypeRequestor);
    }

    public boolean isPackage(char[][] cArray, char[] cArray2) {
        return this.env.isPackage(cArray, cArray2);
    }

    public void cleanup() {
        this.env.cleanup();
    }
}

