/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.eval;

import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.wst.jsdt.internal.eval.EvaluationConstants;

class CodeSnippetToCuMapper
implements EvaluationConstants {
    public char[] cuSource;
    public int lineNumberOffset = 0;
    public int startPosOffset = 0;
    char[] codeSnippet;
    char[] snippetPackageName;
    char[][] snippetImports;
    char[] snippetClassName;
    char[] snippetVarClassName;
    char[] snippetDeclaringTypeName;
    char[][] localVarNames;
    char[][] localVarTypeNames;
    int[] localVarModifiers;

    public CodeSnippetToCuMapper(char[] cArray, char[] cArray2, char[][] cArray3, char[] cArray4, char[] cArray5, char[][] cArray6, char[][] cArray7, int[] nArray, char[] cArray8, String string) {
        this.codeSnippet = cArray;
        this.snippetPackageName = cArray2;
        this.snippetImports = cArray3;
        this.snippetClassName = cArray4;
        this.snippetVarClassName = cArray5;
        this.localVarNames = cArray6;
        this.localVarTypeNames = cArray7;
        this.localVarModifiers = nArray;
        this.snippetDeclaringTypeName = cArray8;
        this.buildCUSource(string);
    }

    private void buildCUSource(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.snippetPackageName != null && this.snippetPackageName.length != 0) {
            stringBuffer.append("package ");
            stringBuffer.append(this.snippetPackageName);
            stringBuffer.append(";").append(string);
            ++this.lineNumberOffset;
        }
        char[][] cArray = this.snippetImports;
        int n = 0;
        while (n < cArray.length) {
            stringBuffer.append("import ");
            stringBuffer.append(cArray[n]);
            stringBuffer.append(';').append(string);
            ++this.lineNumberOffset;
            ++n;
        }
        stringBuffer.append("public class ");
        stringBuffer.append(this.snippetClassName);
        if (this.snippetVarClassName != null) {
            stringBuffer.append(" extends ");
            stringBuffer.append(this.snippetVarClassName);
        } else {
            stringBuffer.append(" extends ");
            stringBuffer.append(PACKAGE_NAME);
            stringBuffer.append(".");
            stringBuffer.append(ROOT_CLASS_NAME);
        }
        stringBuffer.append(" {").append(string);
        ++this.lineNumberOffset;
        if (this.snippetDeclaringTypeName != null) {
            stringBuffer.append("  ");
            stringBuffer.append(this.snippetDeclaringTypeName);
            stringBuffer.append(" ");
            stringBuffer.append(DELEGATE_THIS);
            stringBuffer.append(';').append(string);
            ++this.lineNumberOffset;
        }
        if (this.localVarNames != null) {
            n = 0;
            int n2 = this.localVarNames.length;
            while (n < n2) {
                stringBuffer.append("    ");
                stringBuffer.append(this.localVarTypeNames[n]);
                stringBuffer.append(" ");
                stringBuffer.append(LOCAL_VAR_PREFIX);
                stringBuffer.append(this.localVarNames[n]);
                stringBuffer.append(';').append(string);
                ++this.lineNumberOffset;
                ++n;
            }
        }
        stringBuffer.append("public void run() throws Throwable {").append(string);
        ++this.lineNumberOffset;
        this.startPosOffset = stringBuffer.length();
        stringBuffer.append(this.codeSnippet);
        stringBuffer.append(string).append('}').append(string);
        stringBuffer.append('}').append(string);
        n = stringBuffer.length();
        this.cuSource = new char[n];
        stringBuffer.getChars(0, n, this.cuSource, 0);
    }

    public CompletionRequestor getCompletionRequestor(final CompletionRequestor completionRequestor) {
        return new CompletionRequestor(){

            public void accept(CompletionProposal completionProposal) {
                switch (completionProposal.getKind()) {
                    case 9: {
                        int n = completionProposal.getFlags();
                        if ((n & 0x4000) != 0 || (n & 0x200) != 0) break;
                        char[] cArray = completionProposal.getDeclarationSignature();
                        char[] cArray2 = Signature.getSignatureSimpleName(completionProposal.getSignature());
                        if (CharOperation.equals(cArray, CodeSnippetToCuMapper.this.snippetPackageName) && (CharOperation.equals(cArray2, CodeSnippetToCuMapper.this.snippetClassName) || CharOperation.equals(cArray2, CodeSnippetToCuMapper.this.snippetVarClassName))) {
                            return;
                        }
                        if (!CharOperation.equals(cArray, PACKAGE_NAME) || !CharOperation.equals(cArray2, ROOT_CLASS_NAME)) break;
                        return;
                    }
                    case 6: 
                    case 7: {
                        char[] cArray = Signature.getSignatureQualifier(completionProposal.getDeclarationSignature());
                        char[] cArray3 = Signature.getSignatureSimpleName(completionProposal.getDeclarationSignature());
                        if (CharOperation.equals(cArray, CodeSnippetToCuMapper.this.snippetPackageName) && CharOperation.equals(cArray3, CodeSnippetToCuMapper.this.snippetClassName)) {
                            return;
                        }
                        if (!CharOperation.equals(cArray, PACKAGE_NAME) || !CharOperation.equals(cArray3, ROOT_CLASS_NAME)) break;
                        return;
                    }
                }
                completionRequestor.accept(completionProposal);
            }

            public void completionFailure(IProblem iProblem) {
                iProblem.setSourceStart(iProblem.getSourceStart() - CodeSnippetToCuMapper.this.startPosOffset);
                iProblem.setSourceEnd(iProblem.getSourceEnd() - CodeSnippetToCuMapper.this.startPosOffset);
                iProblem.setSourceLineNumber(iProblem.getSourceLineNumber() - CodeSnippetToCuMapper.this.lineNumberOffset);
                completionRequestor.completionFailure(iProblem);
            }

            public void acceptContext(CompletionContext completionContext) {
                completionRequestor.acceptContext(completionContext);
            }

            public void beginReporting() {
                completionRequestor.beginReporting();
            }

            public void endReporting() {
                completionRequestor.endReporting();
            }

            public boolean isIgnored(int n) {
                return completionRequestor.isIgnored(n);
            }

            public void setIgnored(int n, boolean bl) {
                completionRequestor.setIgnored(n, bl);
            }

            public boolean isAllowingRequiredProposals(int n, int n2) {
                return completionRequestor.isAllowingRequiredProposals(n, n2);
            }

            public void setAllowsRequiredProposals(int n, int n2, boolean bl) {
                completionRequestor.setAllowsRequiredProposals(n, n2, bl);
            }
        };
    }

    public char[] getCUSource(String string) {
        if (this.cuSource == null) {
            this.buildCUSource(string);
        }
        return this.cuSource;
    }

    public int getEvaluationType(int n) {
        int n2 = 1;
        if (this.snippetPackageName != null && this.snippetPackageName.length != 0) {
            if (n == 1) {
                return 4;
            }
            ++n2;
        }
        char[][] cArray = this.snippetImports;
        if (n2 <= n && n < n2 + cArray.length) {
            return 3;
        }
        n2 += cArray.length + 1;
        if ((n2 += (this.snippetDeclaringTypeName == null ? 0 : 1) + (this.localVarNames == null ? 0 : this.localVarNames.length)) > n) {
            return 5;
        }
        if (++n2 >= this.lineNumberOffset) {
            return 2;
        }
        return 5;
    }

    public char[] getImport(int n) {
        int n2 = this.lineNumberOffset - 1 - this.snippetImports.length;
        return this.snippetImports[n - n2];
    }

    public ISelectionRequestor getSelectionRequestor(final ISelectionRequestor iSelectionRequestor) {
        return new ISelectionRequestor(){

            public void acceptType(char[] cArray, char[] cArray2, int n, boolean bl, char[] cArray3, int n2, int n3) {
                iSelectionRequestor.acceptType(cArray, cArray2, n, bl, cArray3, n2, n3);
            }

            public void acceptError(CategorizedProblem categorizedProblem) {
                categorizedProblem.setSourceLineNumber(categorizedProblem.getSourceLineNumber() - CodeSnippetToCuMapper.this.lineNumberOffset);
                categorizedProblem.setSourceStart(categorizedProblem.getSourceStart() - CodeSnippetToCuMapper.this.startPosOffset);
                categorizedProblem.setSourceEnd(categorizedProblem.getSourceEnd() - CodeSnippetToCuMapper.this.startPosOffset);
                iSelectionRequestor.acceptError(categorizedProblem);
            }

            public void acceptField(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, char[] cArray4, int n, int n2) {
                iSelectionRequestor.acceptField(cArray, cArray2, cArray3, bl, cArray4, n, n2);
            }

            public void acceptMethod(char[] cArray, char[] cArray2, String string, char[] cArray3, char[][] cArray4, char[][] cArray5, String[] stringArray, char[][] cArray6, char[][][] cArray7, boolean bl, boolean bl2, char[] cArray8, int n, int n2) {
                iSelectionRequestor.acceptMethod(cArray, cArray2, string, cArray3, cArray4, cArray5, stringArray, cArray6, cArray7, bl, bl2, cArray8, n, n2);
            }

            public void acceptPackage(char[] cArray) {
                iSelectionRequestor.acceptPackage(cArray);
            }

            public void acceptTypeParameter(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, int n, int n2) {
                iSelectionRequestor.acceptTypeParameter(cArray, cArray2, cArray3, bl, n, n2);
            }

            public void acceptMethodTypeParameter(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, char[] cArray4, boolean bl, int n3, int n4) {
                iSelectionRequestor.acceptMethodTypeParameter(cArray, cArray2, cArray3, n, n2, cArray4, bl, n3, n4);
            }
        };
    }
}

