/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.eval.EvaluationContext;
import org.eclipse.wst.jsdt.internal.eval.EvaluationResult;
import org.eclipse.wst.jsdt.internal.eval.Evaluator;
import org.eclipse.wst.jsdt.internal.eval.IRequestor;

public abstract class Evaluator {
    EvaluationContext context;
    INameEnvironment environment;
    Map options;
    IRequestor requestor;
    IProblemFactory problemFactory;

    Evaluator(EvaluationContext evaluationContext, INameEnvironment iNameEnvironment, Map map, IRequestor iRequestor, IProblemFactory iProblemFactory) {
        this.context = evaluationContext;
        this.environment = iNameEnvironment;
        this.options = map;
        this.requestor = iRequestor;
        this.problemFactory = iProblemFactory;
    }

    protected abstract void addEvaluationResultForCompilationProblem(Map var1, CategorizedProblem var2, char[] var3);

    protected EvaluationResult[] evaluationResultsForCompilationProblems(CompilationResult compilationResult, char[] cArray) {
        CategorizedProblem[] categorizedProblemArray = compilationResult.getAllProblems();
        HashMap hashMap = new HashMap(5);
        int n = 0;
        while (n < categorizedProblemArray.length) {
            this.addEvaluationResultForCompilationProblem(hashMap, categorizedProblemArray[n], cArray);
            ++n;
        }
        n = hashMap.size();
        EvaluationResult[] evaluationResultArray = new EvaluationResult[n];
        Iterator iterator = hashMap.values().iterator();
        int n2 = 0;
        while (n2 < n) {
            evaluationResultArray[n2] = (EvaluationResult)iterator.next();
            ++n2;
        }
        return evaluationResultArray;
    }

    ClassFile[] getClasses() {
        final char[] cArray = this.getSource();
        ArrayList arrayList = new ArrayList();
        class CompilerRequestor
        implements ICompilerRequestor {
            boolean hasErrors;
            final /* synthetic */ Evaluator this$0;
            private final /* synthetic */ char[] val$source;
            private final /* synthetic */ ArrayList val$classDefinitions;

            CompilerRequestor(Evaluator evaluator, char[] cArray, ArrayList arrayList) {
                this.this$0 = evaluator;
                this.val$source = cArray;
                this.val$classDefinitions = arrayList;
                this.hasErrors = false;
            }

            public void acceptResult(CompilationResult compilationResult) {
                Object object;
                int n;
                Object[] objectArray;
                if (compilationResult.hasProblems()) {
                    objectArray = this.this$0.evaluationResultsForCompilationProblems(compilationResult, this.val$source);
                    n = 0;
                    while (n < objectArray.length) {
                        object = objectArray[n];
                        CategorizedProblem[] categorizedProblemArray = ((EvaluationResult)object).getProblems();
                        int n2 = 0;
                        while (n2 < categorizedProblemArray.length) {
                            this.this$0.requestor.acceptProblem(categorizedProblemArray[n2], ((EvaluationResult)object).getEvaluationID(), ((EvaluationResult)object).getEvaluationType());
                            ++n2;
                        }
                        ++n;
                    }
                }
                if (compilationResult.hasErrors()) {
                    this.hasErrors = true;
                } else {
                    objectArray = compilationResult.getClassFiles();
                    n = 0;
                    while (n < objectArray.length) {
                        object = objectArray[n];
                        this.val$classDefinitions.add(object);
                        ++n;
                    }
                }
            }
        }
        CompilerRequestor compilerRequestor = new CompilerRequestor(this, cArray, arrayList);
        Compiler compiler = this.getCompiler(compilerRequestor);
        compiler.compile(new ICompilationUnit[]{new ICompilationUnit(){

            public char[] getFileName() {
                return CharOperation.concat(Evaluator.this.getClassName(), Util.defaultJavaExtension().toCharArray());
            }

            public char[] getContents() {
                return cArray;
            }

            public char[] getMainTypeName() {
                return Evaluator.this.getClassName();
            }

            public char[][] getPackageName() {
                return null;
            }

            public LibrarySuperType getCommonSuperType() {
                System.out.println("Unimplemented method:.getCommonSuperType");
                return null;
            }
        }});
        if (compilerRequestor.hasErrors) {
            return null;
        }
        ClassFile[] classFileArray = new ClassFile[arrayList.size()];
        arrayList.toArray(classFileArray);
        return classFileArray;
    }

    protected abstract char[] getClassName();

    Compiler getCompiler(ICompilerRequestor iCompilerRequestor) {
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        return new Compiler(this.environment, DefaultErrorHandlingPolicies.exitAfterAllProblems(), compilerOptions, iCompilerRequestor, this.problemFactory);
    }

    protected abstract char[] getSource();
}

