/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CharLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.infer.InferOptions;
import org.eclipse.wst.jsdt.internal.infer.InferredAttribute;
import org.eclipse.wst.jsdt.internal.infer.InferredMember;
import org.eclipse.wst.jsdt.internal.infer.InferredMethod;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class InferEngine
extends ASTVisitor {
    InferOptions inferOptions;
    CompilationUnitDeclaration compUnit;
    Context[] contexts = new Context[100];
    int contextPtr = -1;
    Context currentContext = new Context();
    int passNumber = 1;
    boolean isTopLevelAnonymousFunction;
    int anonymousCount = 0;
    public InferredType StringType = new InferredType(new char[]{'S', 't', 'r', 'i', 'n', 'g'});
    public InferredType NumberType = new InferredType(new char[]{'N', 'u', 'm', 'b', 'e', 'r'});
    public InferredType BooleanType = new InferredType(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'});
    public InferredType ArrayType = new InferredType(InferredType.ARRAY_NAME);
    public InferredType VoidType = new InferredType(new char[]{'v', 'o', 'i', 'd'});
    public InferredType ObjectType = new InferredType(InferredType.OBJECT_NAME);
    public InferredType GlobalType = new InferredType(InferredType.GLOBAL_NAME);
    static final char[] CONSTRUCTOR_ID = new char[]{'c', 'o', 'n', 's', 't', 'r', 'u', 'c', 't', 'o', 'r'};
    public static final char[] ANONYMOUS_PREFIX = new char[]{'_', '_', '_'};
    public static final char[] ANONYMOUS_CLASS_ID = new char[]{'a', 'n', 'o', 'n', 'y', 'm', 'o', 'u', 's'};

    public InferEngine(InferOptions inferOptions) {
        this.inferOptions = inferOptions;
    }

    public InferEngine() {
        this.inferOptions = new InferOptions();
    }

    public void initialize() {
        this.contextPtr = -1;
        this.currentContext = new Context();
        this.passNumber = 1;
        this.isTopLevelAnonymousFunction = false;
        this.anonymousCount = 0;
    }

    public void setCompilationUnit(CompilationUnitDeclaration compilationUnitDeclaration) {
        this.compUnit = compilationUnitDeclaration;
        this.buildDefinedMembers(compilationUnitDeclaration.statements, null);
    }

    public boolean visit(MessageSend messageSend, BlockScope blockScope) {
        boolean bl = this.handleFunctionCall(messageSend);
        if (bl && this.contextPtr == -1 && messageSend.receiver instanceof FunctionExpression) {
            this.isTopLevelAnonymousFunction = true;
        }
        return bl;
    }

    public boolean visit(LocalDeclaration localDeclaration, BlockScope blockScope) {
        this.currentContext.addMember(localDeclaration.name, localDeclaration);
        if (localDeclaration.javadoc != null) {
            InferredType inferredType;
            Javadoc javadoc = localDeclaration.javadoc;
            InferredAttribute inferredAttribute = null;
            if (javadoc.memberOf != null) {
                inferredType = this.addType(javadoc.memberOf.getSimpleTypeName());
                inferredAttribute = inferredType.addAttribute(localDeclaration.name, localDeclaration);
                if (localDeclaration.initialization != null) {
                    inferredAttribute.initializationStart = localDeclaration.initialization.sourceStart;
                }
                inferredAttribute.type = inferredType;
            }
            if (javadoc.returnType != null) {
                localDeclaration.inferredType = inferredType = this.addType(javadoc.returnType.getSimpleTypeName());
                if (inferredAttribute != null) {
                    inferredAttribute.type = inferredType;
                }
            }
        }
        if (localDeclaration.inferredType == null && localDeclaration.initialization != null) {
            localDeclaration.inferredType = this.getTypeOf(localDeclaration.initialization);
        }
        return true;
    }

    public boolean visit(Assignment assignment, BlockScope blockScope) {
        this.pushContext();
        if (!this.handlePrototype(assignment)) {
            if (assignment.expression instanceof FunctionExpression) {
                FunctionExpression functionExpression = (FunctionExpression)assignment.expression;
                char[] cArray = this.constructTypeName(assignment.lhs);
                InferredType inferredType = null;
                if (cArray != null) {
                    inferredType = this.compUnit.findInferredType(cArray);
                }
                if (inferredType != null) {
                    if (this.inferOptions.useInitMethod) {
                        this.currentContext.currentType = inferredType;
                        this.currentContext.currentType = inferredType;
                        inferredType.isDefinition = true;
                        InferredMethod inferredMethod = inferredType.addMethod(inferredType.name, functionExpression.methodDeclaration);
                        inferredMethod.isConstructor = true;
                        inferredMethod.nameStart = assignment.lhs.sourceStart;
                    }
                } else if (assignment.lhs instanceof FieldReference) {
                    AbstractVariableDeclaration abstractVariableDeclaration;
                    FieldReference fieldReference = (FieldReference)assignment.lhs;
                    int n = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType inferredType2 = this.getInferredType(fieldReference.receiver);
                    if (inferredType2 != null) {
                        InferredMethod inferredMethod = inferredType2.findMethod(fieldReference.token, functionExpression.methodDeclaration);
                        if (inferredMethod == null) {
                            inferredMethod = inferredType2.addMethod(fieldReference.token, functionExpression.methodDeclaration);
                            inferredType2.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                            inferredMethod.nameStart = n;
                            char[] cArray2 = this.constructTypeName(fieldReference.receiver);
                            inferredMethod.isStatic = cArray2 != null && this.compUnit.findInferredType(cArray2) != null;
                            return true;
                        }
                        return false;
                    }
                    if (this.passNumber == 2 && (abstractVariableDeclaration = this.getVariable(fieldReference.receiver)) != null) {
                        inferredType2 = this.createAnonymousType(abstractVariableDeclaration);
                        InferredMethod inferredMethod = inferredType2.addMethod(fieldReference.token, functionExpression.methodDeclaration);
                        inferredMethod.nameStart = n;
                        inferredType2.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                    }
                }
            } else if (assignment.expression instanceof SingleNameReference && this.currentContext.currentType != null && InferEngine.isThis(assignment.lhs)) {
                SingleNameReference singleNameReference = (SingleNameReference)assignment.expression;
                Object object = this.currentContext.getMember(singleNameReference.token);
                FieldReference fieldReference = (FieldReference)assignment.lhs;
                char[] cArray = fieldReference.token;
                InferredMember inferredMember = null;
                if (object instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)object;
                    inferredMember = this.currentContext.currentType.addMethod(cArray, methodDeclaration);
                } else {
                    inferredMember = this.currentContext.currentType.addAttribute(cArray, assignment);
                    inferredMember.type = this.getTypeOf(assignment.expression);
                }
                if (inferredMember != null) {
                    inferredMember.isStatic = false;
                    inferredMember.nameStart = fieldReference.sourceEnd - cArray.length + 1;
                }
            } else if (assignment.expression instanceof ObjectLiteral && assignment.lhs instanceof SingleNameReference) {
                AbstractVariableDeclaration abstractVariableDeclaration = this.getVariable((SingleNameReference)assignment.lhs);
                if (abstractVariableDeclaration != null) {
                    InferredType inferredType = abstractVariableDeclaration.inferredType;
                    if (inferredType == null) {
                        abstractVariableDeclaration.inferredType = inferredType = this.getTypeOf(assignment.expression);
                        return true;
                    }
                    return false;
                }
            } else if (assignment.expression instanceof ObjectLiteral && assignment.lhs instanceof FieldReference) {
                if (this.inferOptions.useAssignments && this.passNumber == 2) {
                    InferredAttribute inferredAttribute;
                    FieldReference fieldReference = (FieldReference)assignment.lhs;
                    InferredType inferredType = this.getInferredType(fieldReference.receiver);
                    if (inferredType != null && ((inferredAttribute = inferredType.findAttribute(fieldReference.token)) == null || inferredAttribute.type == null)) {
                        inferredAttribute = inferredType.addAttribute(fieldReference.token, assignment);
                        inferredAttribute.type = this.getTypeOf(assignment.expression);
                        char[] cArray = this.constructTypeName(fieldReference.receiver);
                        inferredAttribute.isStatic = cArray != null && this.compUnit.findInferredType(cArray) != null;
                        inferredAttribute.nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                        return false;
                    }
                }
            } else if (this.inferOptions.useAssignments && assignment.lhs instanceof FieldReference) {
                InferredAttribute inferredAttribute;
                FieldReference fieldReference = (FieldReference)assignment.lhs;
                InferredType inferredType = this.getInferredType(fieldReference.receiver);
                if (inferredType != null && ((inferredAttribute = inferredType.findAttribute(fieldReference.token)) == null || inferredAttribute.type == null)) {
                    inferredAttribute = inferredType.addAttribute(fieldReference.token, assignment);
                    inferredAttribute.type = this.getTypeOf(assignment.expression);
                    char[] cArray = this.constructTypeName(fieldReference.receiver);
                    inferredAttribute.isStatic = cArray != null && this.compUnit.findInferredType(cArray) != null;
                    inferredAttribute.nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    return false;
                }
            }
        }
        return true;
    }

    private InferredType createAnonymousType(AbstractVariableDeclaration abstractVariableDeclaration) {
        InferredType inferredType = abstractVariableDeclaration.inferredType;
        if (inferredType == null || !inferredType.isAnonymous) {
            char[] cArray = String.valueOf(this.anonymousCount++).toCharArray();
            char[] cArray2 = CharOperation.concat(ANONYMOUS_PREFIX, abstractVariableDeclaration.name, cArray);
            InferredType inferredType2 = this.addType(cArray2);
            inferredType2.isDefinition = true;
            inferredType2.isAnonymous = true;
            if (inferredType != null) {
                inferredType2.superClass = inferredType;
            }
            abstractVariableDeclaration.inferredType = inferredType2;
        }
        return abstractVariableDeclaration.inferredType;
    }

    private InferredType createAnonymousType(ObjectLiteral objectLiteral) {
        char[] cArray = (String.valueOf(String.valueOf(objectLiteral.sourceStart)) + '_' + String.valueOf(objectLiteral.sourceEnd)).toCharArray();
        char[] cArray2 = CharOperation.concat(ANONYMOUS_PREFIX, ANONYMOUS_CLASS_ID, cArray);
        InferredType inferredType = this.addType(cArray2);
        inferredType.isDefinition = true;
        inferredType.isAnonymous = true;
        inferredType.superClass = this.ObjectType;
        inferredType.sourceStart = objectLiteral.sourceStart;
        inferredType.sourceEnd = objectLiteral.sourceEnd;
        this.populateType(inferredType, objectLiteral);
        return inferredType;
    }

    protected boolean handlePrototype(Assignment assignment) {
        Expression expression = assignment.lhs;
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.isPrototype()) {
                InferredType inferredType = null;
                char[] cArray = this.constructTypeName(fieldReference.receiver);
                if (cArray == null) {
                    return true;
                }
                inferredType = this.compUnit.findInferredType(cArray);
                if (inferredType == null) {
                    inferredType = this.addType(cArray);
                    inferredType.isDefinition = true;
                }
                inferredType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                if (assignment.expression instanceof AllocationExpression) {
                    AllocationExpression allocationExpression = (AllocationExpression)assignment.expression;
                    InferredType inferredType2 = null;
                    char[] cArray2 = this.constructTypeName(allocationExpression.member);
                    if (cArray2 != null) {
                        inferredType2 = this.compUnit.findInferredType(cArray2);
                        if (inferredType2 == null) {
                            inferredType2 = this.addType(cArray2);
                        }
                        if (inferredType.superClass == null) {
                            inferredType.superClass = inferredType2;
                        }
                    }
                    return true;
                }
                if (assignment.expression instanceof ObjectLiteral) {
                    this.populateType(inferredType, (ObjectLiteral)assignment.expression);
                    if (inferredType.superClass == null) {
                        inferredType.superClass = this.ObjectType;
                    }
                    return true;
                }
            } else if (fieldReference.receiver.isPrototype()) {
                Object object;
                FieldReference fieldReference2 = (FieldReference)fieldReference.receiver;
                InferredType inferredType = null;
                char[] cArray = this.constructTypeName(fieldReference2.receiver);
                if (cArray == null) {
                    return true;
                }
                inferredType = this.compUnit.findInferredType(cArray);
                if (inferredType == null) {
                    inferredType = this.addType(cArray);
                    inferredType.isDefinition = true;
                }
                inferredType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                if (this.passNumber == 1 && assignment.expression instanceof ObjectLiteral) {
                    return false;
                }
                char[] cArray3 = fieldReference.token;
                int n = (int)(fieldReference.nameSourcePosition >>> 32);
                InferredType inferredType3 = this.getTypeOf(assignment.expression);
                MethodDeclaration methodDeclaration = null;
                if (inferredType3 == null && assignment.expression instanceof SingleNameReference) {
                    object = this.currentContext.getMember(((SingleNameReference)assignment.expression).token);
                    if (object instanceof AbstractMethodDeclaration) {
                        methodDeclaration = (MethodDeclaration)object;
                    }
                } else if (assignment.expression instanceof FunctionExpression) {
                    methodDeclaration = ((FunctionExpression)assignment.expression).methodDeclaration;
                }
                if (methodDeclaration != null) {
                    object = inferredType.addMethod(cArray3, methodDeclaration);
                    ((InferredMember)object).nameStart = n;
                } else if (!CharOperation.equals(CONSTRUCTOR_ID, cArray3)) {
                    object = inferredType.addAttribute(cArray3, assignment);
                    ((InferredAttribute)object).initializationStart = assignment.expression.sourceStart;
                    ((InferredAttribute)object).nameStart = n;
                    if (((InferredAttribute)object).type == null) {
                        ((InferredAttribute)object).type = inferredType3;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected InferredType getTypeOf(Expression expression) {
        if (expression instanceof StringLiteral || expression instanceof CharLiteral) {
            return this.StringType;
        }
        if (expression instanceof NumberLiteral) {
            return this.NumberType;
        }
        if (expression instanceof AllocationExpression) {
            AllocationExpression allocationExpression = (AllocationExpression)expression;
            InferredType inferredType = null;
            char[] cArray = this.constructTypeName(allocationExpression.member);
            if (cArray != null) {
                inferredType = this.compUnit.findInferredType(cArray);
                if (inferredType == null) {
                    inferredType = this.addType(cArray);
                }
                return inferredType;
            }
        } else if (expression instanceof SingleNameReference) {
            AbstractVariableDeclaration abstractVariableDeclaration = this.getVariable((SingleNameReference)expression);
            if (abstractVariableDeclaration != null) {
                return abstractVariableDeclaration.inferredType;
            }
        } else if (expression instanceof FieldReference) {
            InferredAttribute inferredAttribute;
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && this.currentContext.currentType != null && (inferredAttribute = this.currentContext.currentType.findAttribute(fieldReference.token)) != null) {
                return inferredAttribute.type;
            }
        } else {
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                boolean bl = false;
                InferredType inferredType = null;
                if (arrayInitializer.expressions != null) {
                    int n = 0;
                    while (n < arrayInitializer.expressions.length) {
                        InferredType inferredType2 = this.getTypeOf(arrayInitializer.expressions[n]);
                        if (inferredType2 != null) {
                            if (!inferredType2.equals(inferredType)) {
                                inferredType = !bl ? inferredType2 : null;
                            }
                            bl = true;
                        }
                        ++n;
                    }
                }
                if (inferredType != null) {
                    InferredType inferredType3 = new InferredType(InferredType.ARRAY_NAME);
                    inferredType3.referenceClass = inferredType;
                    return inferredType3;
                }
                return this.ArrayType;
            }
            if (expression instanceof TrueLiteral || expression instanceof FalseLiteral) {
                return this.BooleanType;
            }
            if (expression instanceof ObjectLiteral) {
                InferredType inferredType = this.createAnonymousType((ObjectLiteral)expression);
                inferredType.sourceStart = expression.sourceStart;
                inferredType.sourceEnd = expression.sourceEnd;
                return inferredType;
            }
        }
        return null;
    }

    private void populateType(InferredType inferredType, ObjectLiteral objectLiteral) {
        if (objectLiteral.fields != null) {
            int n = 0;
            while (n < objectLiteral.fields.length) {
                ObjectLiteralField objectLiteralField = objectLiteral.fields[n];
                char[] cArray = null;
                int n2 = -1;
                if (objectLiteralField.fieldName instanceof SingleNameReference) {
                    ASTNode aSTNode = (SingleNameReference)objectLiteralField.fieldName;
                    cArray = aSTNode.token;
                    n2 = aSTNode.sourceStart;
                    if (objectLiteralField.initializer instanceof FunctionExpression) {
                        aSTNode = (FunctionExpression)objectLiteralField.initializer;
                        InferredMethod inferredMethod = inferredType.addMethod(cArray, ((FunctionExpression)aSTNode).methodDeclaration);
                        inferredMethod.nameStart = n2;
                    } else {
                        aSTNode = inferredType.addAttribute(cArray, objectLiteralField.fieldName);
                        ((InferredAttribute)aSTNode).nameStart = n2;
                        ((InferredAttribute)aSTNode).type = this.getTypeOf(objectLiteralField.initializer);
                    }
                }
                ++n;
            }
        }
    }

    public void endVisit(Assignment assignment, BlockScope blockScope) {
        this.popContext();
    }

    protected boolean handleFunctionCall(MessageSend messageSend) {
        return true;
    }

    public void endVisit(ReturnStatement returnStatement, BlockScope blockScope) {
        if (this.currentContext.currentMethod != null && returnStatement.expression != null) {
            InferredType inferredType = this.getTypeOf(returnStatement.expression);
            if (this.currentContext.currentMethod.inferredType == this.VoidType) {
                this.currentContext.currentMethod.inferredType = inferredType;
            } else if (inferredType == null || !inferredType.equals(this.currentContext.currentMethod.inferredType)) {
                this.currentContext.currentMethod.inferredType = null;
            }
        }
    }

    public void endVisit(MethodDeclaration methodDeclaration, Scope scope) {
        this.popContext();
    }

    public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        this.pushContext();
        if (this.isTopLevelAnonymousFunction && this.currentContext.currentType == null) {
            this.currentContext.currentType = this.addType(InferredType.GLOBAL_NAME);
            this.currentContext.currentType.isDefinition = true;
        }
        this.isTopLevelAnonymousFunction = false;
        if (this.passNumber == 1) {
            this.buildDefinedMembers(methodDeclaration.statements, methodDeclaration.arguments);
            if (methodDeclaration.javadoc != null) {
                ASTNode aSTNode3;
                InferredType inferredType;
                aSTNode2 = null;
                aSTNode = methodDeclaration.javadoc;
                if (((Javadoc)aSTNode).isConstructor) {
                    inferredType = this.addType(methodDeclaration.selector);
                    inferredType.isDefinition = true;
                    aSTNode2 = inferredType.addMethod(methodDeclaration.selector, methodDeclaration);
                    ((InferredMethod)aSTNode2).nameStart = methodDeclaration.sourceStart;
                    ((InferredMethod)aSTNode2).isConstructor = true;
                    if (((Javadoc)aSTNode).extendsType != null) {
                        aSTNode3 = this.addType(((Javadoc)aSTNode).extendsType.getSimpleTypeName());
                        inferredType.superClass = aSTNode3;
                    }
                } else if (((Javadoc)aSTNode).memberOf != null) {
                    inferredType = this.addType(((Javadoc)aSTNode).memberOf.getSimpleTypeName());
                    aSTNode2 = inferredType.addMethod(methodDeclaration.selector, methodDeclaration);
                }
                if (((Javadoc)aSTNode).returnType != null) {
                    methodDeclaration.inferredType = inferredType = this.addType(((Javadoc)aSTNode).returnType.getSimpleTypeName());
                }
                if (methodDeclaration.arguments != null) {
                    int n = 0;
                    while (n < methodDeclaration.arguments.length) {
                        int n2;
                        aSTNode3 = ((Javadoc)aSTNode).findParam(methodDeclaration.arguments[n].name);
                        if (aSTNode3 != null && aSTNode3.types != null && (n2 = 0) < aSTNode3.types.length) {
                            InferredType inferredType2;
                            TypeReference typeReference = aSTNode3.types[n2];
                            methodDeclaration.arguments[n].inferredType = inferredType2 = this.addType(typeReference.getSimpleTypeName());
                        }
                        ++n;
                    }
                }
            }
        }
        if (this.passNumber == 2 && methodDeclaration.selector != null && (aSTNode2 = this.compUnit.findInferredType(methodDeclaration.selector)) != null) {
            this.currentContext.currentType = aSTNode2;
            aSTNode2.isDefinition = true;
            aSTNode = aSTNode2.addMethod(methodDeclaration.selector, methodDeclaration);
            ((InferredMethod)aSTNode).nameStart = methodDeclaration.sourceStart;
            ((InferredMethod)aSTNode).isConstructor = true;
            methodDeclaration.inferredType = aSTNode2;
        }
        this.currentContext.currentMethod = methodDeclaration;
        if (methodDeclaration.inferredMethod != null && methodDeclaration.inferredMethod.inType != null) {
            this.currentContext.currentType = methodDeclaration.inferredMethod.inType;
        }
        if (methodDeclaration.inferredType == null) {
            methodDeclaration.inferredType = this.VoidType;
        }
        return true;
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope blockScope) {
        InferredType inferredType = null;
        char[] cArray = this.constructTypeName(allocationExpression.member);
        if (cArray != null && (inferredType = this.compUnit.findInferredType(cArray)) == null) {
            inferredType = this.addType(cArray);
        }
        return true;
    }

    public void endVisit(ObjectLiteralField objectLiteralField, BlockScope blockScope) {
        if (objectLiteralField.javaDoc != null) {
            ASTNode aSTNode;
            Javadoc javadoc = objectLiteralField.javaDoc;
            InferredType inferredType = null;
            char[] cArray = null;
            int n = -1;
            InferredType inferredType2 = null;
            if (objectLiteralField.fieldName instanceof SingleNameReference) {
                aSTNode = (SingleNameReference)objectLiteralField.fieldName;
                cArray = aSTNode.token;
                n = aSTNode.sourceStart;
            }
            if (javadoc.memberOf != null) {
                inferredType = this.addType(javadoc.memberOf.getSimpleTypeName());
                inferredType.isDefinition = true;
            }
            if (javadoc.returnType != null) {
                inferredType2 = this.addType(javadoc.returnType.getSimpleTypeName());
            }
            if (inferredType != null) {
                if (objectLiteralField.initializer instanceof FunctionExpression) {
                    aSTNode = (FunctionExpression)objectLiteralField.initializer;
                    InferredMethod inferredMethod = inferredType.addMethod(cArray, ((FunctionExpression)aSTNode).methodDeclaration);
                    inferredMethod.nameStart = n;
                    ((FunctionExpression)aSTNode).methodDeclaration.modifiers = javadoc.modifiers;
                    if (inferredType2 != null) {
                        ((FunctionExpression)aSTNode).methodDeclaration.inferredType = inferredType2;
                    }
                } else {
                    aSTNode = inferredType.addAttribute(cArray, objectLiteralField.fieldName);
                    ((InferredAttribute)aSTNode).nameStart = objectLiteralField.fieldName.sourceStart;
                    if (inferredType2 != null) {
                        ((InferredAttribute)aSTNode).type = inferredType2;
                    }
                }
            }
        } else {
            boolean cfr_ignored_0 = objectLiteralField.initializer instanceof ObjectLiteral;
        }
    }

    protected boolean isMatch(Expression expression, String[] stringArray, int n) {
        char[] cArray = stringArray[n].toCharArray();
        if (expression instanceof SingleNameReference) {
            SingleNameReference singleNameReference = (SingleNameReference)expression;
            return CharOperation.equals(singleNameReference.token, cArray);
        }
        if (expression instanceof FieldReference && stringArray.length > 1) {
            FieldReference fieldReference = (FieldReference)expression;
            if (CharOperation.equals(fieldReference.token, cArray)) {
                return this.isMatch(fieldReference.receiver, stringArray, n - 1);
            }
        }
        return false;
    }

    protected boolean isFunction(MessageSend messageSend, String string) {
        String[] stringArray = string.split("\\.");
        char[] cArray = stringArray[stringArray.length - 1].toCharArray();
        if (!CharOperation.equals(cArray, messageSend.selector)) {
            return false;
        }
        if (stringArray.length > 1) {
            return this.isMatch(messageSend.receiver, stringArray, stringArray.length - 2);
        }
        return true;
    }

    public void doInfer() {
        this.compUnit.traverse(this, this.compUnit.scope, true);
        this.passNumber = 2;
        this.compUnit.traverse(this, this.compUnit.scope, true);
        this.compUnit = null;
    }

    protected InferredType addType(char[] cArray) {
        InferredType inferredType = this.compUnit.findInferredType(cArray);
        if (inferredType == null) {
            if (this.compUnit.numberInferredTypes == this.compUnit.inferredTypes.length) {
                this.compUnit.inferredTypes = new InferredType[this.compUnit.numberInferredTypes * 2];
                System.arraycopy(this.compUnit.inferredTypes, 0, this.compUnit.inferredTypes, 0, this.compUnit.numberInferredTypes);
            }
            InferredType inferredType2 = new InferredType(cArray);
            this.compUnit.inferredTypes[this.compUnit.numberInferredTypes++] = inferredType2;
            inferredType = inferredType2;
            this.compUnit.inferredTypesHash.put(cArray, inferredType);
        }
        return inferredType;
    }

    protected final void pushContext() {
        Context context = new Context(this.currentContext);
        this.contexts[++this.contextPtr] = this.currentContext;
        this.currentContext = context;
    }

    protected final void popContext() {
        this.currentContext = this.contexts[this.contextPtr];
        this.contexts[this.contextPtr--] = null;
    }

    protected final boolean isInNamedMethod() {
        return this.currentContext.currentMethod != null && this.currentContext.currentMethod.selector != null;
    }

    protected AbstractVariableDeclaration getVariable(Expression expression) {
        Object object;
        char[] cArray = null;
        if (expression instanceof SingleNameReference) {
            cArray = ((SingleNameReference)expression).token;
        }
        if (cArray != null && (object = this.currentContext.getMember(cArray)) instanceof AbstractVariableDeclaration) {
            return (AbstractVariableDeclaration)object;
        }
        return null;
    }

    private void buildDefinedMembers(ProgramElement[] programElementArray, Argument[] argumentArray) {
        int n;
        if (argumentArray != null) {
            n = 0;
            while (n < argumentArray.length) {
                this.currentContext.addMember(argumentArray[n].name, argumentArray[n]);
                ++n;
            }
        }
        if (programElementArray != null) {
            n = 0;
            while (n < programElementArray.length) {
                Statement statement;
                if (programElementArray[n] instanceof LocalDeclaration) {
                    statement = (LocalDeclaration)programElementArray[n];
                    this.currentContext.addMember(statement.name, statement);
                } else if (programElementArray[n] instanceof AbstractMethodDeclaration) {
                    statement = (AbstractMethodDeclaration)programElementArray[n];
                    if (((AbstractMethodDeclaration)statement).selector != null) {
                        this.currentContext.addMember(((AbstractMethodDeclaration)statement).selector, statement);
                    }
                }
                ++n;
            }
        }
    }

    private static boolean isThis(Expression expression) {
        return expression instanceof FieldReference && ((FieldReference)expression).receiver.isThis();
    }

    private InferredType getInferredType(Expression expression) {
        char[] cArray;
        InferredType inferredType = null;
        if (expression instanceof ThisReference) {
            inferredType = this.currentContext.currentType;
        } else if (expression instanceof SingleNameReference) {
            AbstractVariableDeclaration abstractVariableDeclaration;
            char[] cArray2 = this.constructTypeName(expression);
            if (cArray2 != null && (inferredType = this.compUnit.findInferredType(cArray2)) == null && (abstractVariableDeclaration = this.getVariable((SingleNameReference)expression)) != null) {
                inferredType = abstractVariableDeclaration.inferredType;
            }
        } else if (expression instanceof FieldReference && (cArray = this.constructTypeName(expression)) != null && (inferredType = this.compUnit.findInferredType(cArray)) == null) {
            InferredAttribute inferredAttribute;
            FieldReference fieldReference = (FieldReference)expression;
            InferredType inferredType2 = this.getInferredType(fieldReference.receiver);
            if (inferredType2 != null && (inferredAttribute = inferredType2.findAttribute(fieldReference.token)) != null) {
                inferredType = inferredAttribute.type;
            }
        }
        return inferredType;
    }

    protected final char[] constructTypeName(Expression expression) {
        return Util.getTypeName(expression);
    }

    static class Context {
        InferredType currentType;
        MethodDeclaration currentMethod;
        private HashtableOfObject definedMembers;
        private Context parent = null;

        Context() {
        }

        Context(Context context) {
            this.parent = context;
            this.currentType = context.currentType;
            this.currentMethod = context.currentMethod;
        }

        public Object getMember(char[] cArray) {
            Object object = null;
            if (this.definedMembers != null) {
                object = this.definedMembers.get(cArray);
            }
            if (object == null && this.parent != null) {
                object = this.parent.getMember(cArray);
            }
            return object;
        }

        public void addMember(char[] cArray, Object object) {
            if (this.definedMembers == null) {
                this.definedMembers = new HashtableOfObject();
            }
            this.definedMembers.put(cArray, object);
        }
    }
}

