/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;

public class SourceRange
implements ISourceRange {
    private final int fOffset;
    private final int fLength;

    public SourceRange(int n, int n2) {
        this.fLength = n2;
        this.fOffset = n;
    }

    public SourceRange(ASTNode aSTNode) {
        this(aSTNode.getStartPosition(), aSTNode.getLength());
    }

    public SourceRange(IProblem iProblem) {
        this(iProblem.getSourceStart(), iProblem.getSourceEnd() - iProblem.getSourceStart() + 1);
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getEndExclusive() {
        return this.getOffset() + this.getLength();
    }

    public int getEndInclusive() {
        return this.getEndExclusive() - 1;
    }

    public String toString() {
        return "<offset: " + this.fOffset + " length: " + this.fLength + "/>";
    }

    public static ISourceRange[] reverseSortByOffset(ISourceRange[] iSourceRangeArray) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ISourceRange)object2).getOffset() - ((ISourceRange)object).getOffset();
            }
        };
        Arrays.sort(iSourceRangeArray, comparator);
        return iSourceRangeArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ISourceRange)) {
            return false;
        }
        return ((ISourceRange)object).getOffset() == this.fOffset && ((ISourceRange)object).getLength() == this.fLength;
    }

    public int hashCode() {
        return this.fLength ^ this.fOffset;
    }

    public boolean covers(ASTNode aSTNode) {
        return this.covers(new SourceRange(aSTNode));
    }

    public boolean covers(SourceRange sourceRange) {
        return this.getOffset() <= sourceRange.getOffset() && this.getEndInclusive() >= sourceRange.getEndInclusive();
    }

    public static boolean isAvailable(ISourceRange iSourceRange) {
        return iSourceRange != null && iSourceRange.getOffset() != -1;
    }
}

