/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.buildpath;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class ClasspathModifier {
    private ClasspathModifier() {
    }

    public static BuildpathDelta setOutputLocation(CPListElement cPListElement, IPath iPath, boolean bl, CPJavaProject cPJavaProject) throws CoreException {
        Object object;
        BuildpathDelta buildpathDelta = new BuildpathDelta(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip);
        IJavaProject iJavaProject = cPJavaProject.getJavaProject();
        IProject iProject = iJavaProject.getProject();
        IWorkspace iWorkspace = iProject.getWorkspace();
        IPath iPath2 = iProject.getFullPath();
        if (!bl && cPJavaProject.getDefaultOutputLocation().segmentCount() == 1 && !iPath2.equals((Object)cPListElement.getPath())) {
            object = PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName");
            cPJavaProject.setDefaultOutputLocation(cPJavaProject.getDefaultOutputLocation().append((String)object));
            List list = cPJavaProject.getCPListElements();
            CPListElement cPListElement2 = ClasspathModifier.getListElement(iJavaProject.getPath(), list);
            if (cPListElement2 != null) {
                list.remove(cPListElement2);
                buildpathDelta.removeEntry(cPListElement2);
            }
        }
        if (iPath != null) {
            ClasspathModifier.exclude(iPath, cPJavaProject.getCPListElements(), new ArrayList(), cPJavaProject.getJavaProject(), null);
        }
        if ((object = (IPath)cPListElement.getAttribute("output")) != null && object.segmentCount() > 1 && !object.equals((Object)cPJavaProject.getDefaultOutputLocation())) {
            ClasspathModifier.include(cPJavaProject, object);
            buildpathDelta.addDeletedResource((IResource)iWorkspace.getRoot().getFolder(object));
        }
        cPListElement.setAttribute("output", iPath);
        buildpathDelta.setDefaultOutputLocation(cPJavaProject.getDefaultOutputLocation());
        buildpathDelta.setNewEntries(cPJavaProject.getCPListElements().toArray(new CPListElement[cPJavaProject.getCPListElements().size()]));
        if (iPath != null && iPath.segmentCount() > 1) {
            buildpathDelta.addCreatedResource((IResource)iWorkspace.getRoot().getFolder(iPath));
        }
        return buildpathDelta;
    }

    public static IStatus checkSetOutputLocationPrecondition(CPListElement cPListElement, IPath iPath, boolean bl, CPJavaProject cPJavaProject) throws CoreException {
        String string;
        IStatus iStatus;
        IJavaProject iJavaProject = cPJavaProject.getJavaProject();
        IProject iProject = iJavaProject.getProject();
        IWorkspace iWorkspace = iProject.getWorkspace();
        IPath iPath2 = iProject.getFullPath();
        if (iPath == null) {
            iPath = cPJavaProject.getDefaultOutputLocation();
        }
        if (!(iStatus = iWorkspace.validatePath(iPath.toString(), 6)).isOK()) {
            return new StatusInfo(4, Messages.format(NewWizardMessages.OutputLocationDialog_error_invalidpath, iStatus.getMessage()));
        }
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IResource iResource = iWorkspaceRoot.findMember(iPath);
        if (iResource != null && iResource.getType() == 1) {
            return new StatusInfo(4, NewWizardMessages.OutputLocationDialog_error_existingisfile);
        }
        IStatus iStatus2 = StatusInfo.OK_STATUS;
        int n = cPJavaProject.indexOf(cPListElement);
        cPJavaProject = cPJavaProject.createWorkingCopy();
        cPListElement = cPJavaProject.get(n);
        if (!bl && cPJavaProject.getDefaultOutputLocation().segmentCount() == 1 && !iPath2.equals((Object)cPListElement.getPath())) {
            string = PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName");
            cPJavaProject.setDefaultOutputLocation(cPJavaProject.getDefaultOutputLocation().append(string));
            ClasspathModifier.removeFromClasspath(iJavaProject, cPJavaProject.getCPListElements(), null);
            iStatus2 = new StatusInfo(1, Messages.format(NewWizardMessages.OutputLocationDialog_removeProjectFromBP, cPJavaProject.getDefaultOutputLocation()));
        }
        ClasspathModifier.exclude(iPath, cPJavaProject.getCPListElements(), new ArrayList(), cPJavaProject.getJavaProject(), null);
        string = (IPath)cPListElement.getAttribute("output");
        if (string != null && string.segmentCount() > 1 && !string.equals((Object)cPJavaProject.getDefaultOutputLocation())) {
            ClasspathModifier.include(cPJavaProject, (IPath)string);
        }
        cPListElement.setAttribute("output", iPath);
        IJavaModelStatus iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)iJavaProject, (IClasspathEntry[])cPJavaProject.getClasspathEntries(), (IPath)cPJavaProject.getDefaultOutputLocation());
        if (!iJavaModelStatus.isOK()) {
            if (bl) {
                return new StatusInfo(2, iJavaModelStatus.getMessage());
            }
            return new StatusInfo(4, iJavaModelStatus.getMessage());
        }
        if (iPath.segmentCount() - iPath2.segmentCount() < 1) {
            return iStatus2;
        }
        String string2 = iPath.lastSegment();
        if (string2 == null) {
            return iStatus2;
        }
        if (string2.equals(".settings") && iPath.segmentCount() - iPath2.segmentCount() == 1) {
            StatusInfo statusInfo = new StatusInfo(2, NewWizardMessages.OutputLocation_SettingsAsLocation);
            if (iStatus2.isOK()) {
                return statusInfo;
            }
            MultiStatus multiStatus = new MultiStatus(iStatus2.getPlugin(), iStatus2.getCode(), new IStatus[]{iStatus2, statusInfo}, statusInfo.getMessage(), null);
            return multiStatus;
        }
        if (string2.length() > 1 && string2.charAt(0) == '.') {
            StatusInfo statusInfo = new StatusInfo(2, Messages.format(NewWizardMessages.OutputLocation_DotAsLocation, iPath.toString()));
            if (iStatus2.isOK()) {
                return statusInfo;
            }
            MultiStatus multiStatus = new MultiStatus(iStatus2.getPlugin(), iStatus2.getCode(), new IStatus[]{iStatus2, statusInfo}, statusInfo.getMessage(), null);
            return multiStatus;
        }
        return iStatus2;
    }

    public static IStatus checkAddExternalJarsPrecondition(IPath[] iPathArray, CPJavaProject cPJavaProject) throws CoreException {
        Object object;
        IStatus iStatus = StatusInfo.OK_STATUS;
        IJavaProject iJavaProject = cPJavaProject.getJavaProject();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        List list = cPJavaProject.getCPListElements();
        int n = 0;
        while (n < iPathArray.length) {
            object = new CPListElement(iJavaProject, 1, iPathArray[n], null);
            if (list.contains(object)) {
                arrayList2.add(object);
            } else {
                arrayList.add(object);
            }
            ++n;
        }
        if (arrayList2.size() > 0) {
            String string;
            if (arrayList2.size() > 1) {
                object = new StringBuffer();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    CPListElement cPListElement = (CPListElement)iterator.next();
                    ((StringBuffer)object).append('\n').append(cPListElement.getPath().lastSegment());
                }
                string = Messages.format(NewWizardMessages.AddArchiveToBuildpathAction_DuplicateArchivesInfo_message, ((StringBuffer)object).toString());
            } else {
                string = Messages.format(NewWizardMessages.AddArchiveToBuildpathAction_DuplicateArchiveInfo_message, ((CPListElement)arrayList2.get(0)).getPath().lastSegment());
            }
            iStatus = new StatusInfo(1, string);
        }
        if (arrayList.size() == 0) {
            return iStatus;
        }
        cPJavaProject = cPJavaProject.createWorkingCopy();
        list = cPJavaProject.getCPListElements();
        IJavaModelStatus iJavaModelStatus = arrayList.iterator();
        while (iJavaModelStatus.hasNext()) {
            object = (CPListElement)iJavaModelStatus.next();
            ClasspathModifier.insertAtEndOfCategory((CPListElement)object, list);
        }
        iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)iJavaProject, (IClasspathEntry[])cPJavaProject.getClasspathEntries(), (IPath)cPJavaProject.getDefaultOutputLocation());
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        return iStatus;
    }

    public static BuildpathDelta addExternalJars(IPath[] iPathArray, CPJavaProject cPJavaProject) throws CoreException {
        BuildpathDelta buildpathDelta = new BuildpathDelta(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_tooltip);
        IJavaProject iJavaProject = cPJavaProject.getJavaProject();
        List list = cPJavaProject.getCPListElements();
        int n = 0;
        while (n < iPathArray.length) {
            CPListElement cPListElement = new CPListElement(iJavaProject, 1, iPathArray[n], null);
            if (!list.contains(cPListElement)) {
                ClasspathModifier.insertAtEndOfCategory(cPListElement, list);
                buildpathDelta.addEntry(cPListElement);
            }
            ++n;
        }
        buildpathDelta.setNewEntries(list.toArray(new CPListElement[list.size()]));
        buildpathDelta.setDefaultOutputLocation(cPJavaProject.getDefaultOutputLocation());
        return buildpathDelta;
    }

    public static BuildpathDelta removeFromBuildpath(CPListElement[] cPListElementArray, CPJavaProject cPJavaProject) {
        IJavaProject iJavaProject = cPJavaProject.getJavaProject();
        IPath iPath = iJavaProject.getPath();
        IWorkspaceRoot iWorkspaceRoot = iJavaProject.getProject().getWorkspace().getRoot();
        List list = cPJavaProject.getCPListElements();
        BuildpathDelta buildpathDelta = new BuildpathDelta(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
        int n = 0;
        while (n < cPListElementArray.length) {
            Object object;
            CPListElement cPListElement = cPListElementArray[n];
            list.remove(cPListElement);
            buildpathDelta.removeEntry(cPListElement);
            IPath iPath2 = cPListElement.getPath();
            ClasspathModifier.removeFilters(iPath2, iJavaProject, list);
            if (!iPath2.equals((Object)iPath)) {
                object = iWorkspaceRoot.findMember(iPath2);
                if (object != null) {
                    buildpathDelta.addDeletedResource((IResource)object);
                }
            } else if (cPJavaProject.getDefaultOutputLocation().equals((Object)iPath) && ClasspathModifier.containsSourceFolders(cPJavaProject)) {
                object = PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName");
                cPJavaProject.setDefaultOutputLocation(cPJavaProject.getDefaultOutputLocation().append((String)object));
            }
            ++n;
        }
        buildpathDelta.setDefaultOutputLocation(cPJavaProject.getDefaultOutputLocation());
        buildpathDelta.setNewEntries(list.toArray(new CPListElement[list.size()]));
        return buildpathDelta;
    }

    private static boolean containsSourceFolders(CPJavaProject cPJavaProject) {
        List list = cPJavaProject.getCPListElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CPListElement cPListElement = (CPListElement)iterator.next();
            if (cPListElement.getEntryKind() != 3) continue;
            return true;
        }
        return false;
    }

    private static void include(CPJavaProject cPJavaProject, IPath iPath) {
        List list = cPJavaProject.getCPListElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CPListElement cPListElement = (CPListElement)iterator.next();
            cPListElement.removeFromExclusions(iPath);
        }
    }

    public static List getExistingEntries(IJavaProject iJavaProject) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            arrayList.add(CPListElement.createFromExisting(iClasspathEntry, iJavaProject));
            ++n;
        }
        return arrayList;
    }

    public static CPListElement getClasspathEntry(List list, IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
        int n = 0;
        while (n < list.size()) {
            CPListElement cPListElement = (CPListElement)list.get(n);
            if (cPListElement.getPath().equals((Object)iPackageFragmentRoot.getPath()) && cPListElement.getEntryKind() == iClasspathEntry.getEntryKind()) {
                return (CPListElement)list.get(n);
            }
            ++n;
        }
        CPListElement cPListElement = CPListElement.createFromExisting(iClasspathEntry, iPackageFragmentRoot.getJavaProject());
        list.add(cPListElement);
        return cPListElement;
    }

    public static IPackageFragment getFragment(IResource iResource) {
        IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
        if (iJavaElement instanceof IPackageFragment) {
            return (IPackageFragment)iJavaElement;
        }
        return null;
    }

    public static IPackageFragmentRoot getFragmentRoot(IResource iResource, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IJavaElement iJavaElement = null;
        if (iResource.getFullPath().equals((Object)iJavaProject.getPath())) {
            return iJavaProject.getPackageFragmentRoot(iResource);
        }
        IContainer iContainer = iResource.getParent();
        do {
            if (iContainer instanceof IFolder) {
                iJavaElement = JavaCore.create((IFolder)((IFolder)iContainer));
            }
            if (iContainer.getFullPath().equals((Object)iJavaProject.getPath())) {
                iJavaElement = iJavaProject;
                break;
            }
            if ((iContainer = iContainer.getParent()) != null) continue;
            return null;
        } while (iJavaElement == null || !(iJavaElement instanceof IPackageFragmentRoot));
        if (iJavaElement instanceof IJavaProject) {
            if (!ClasspathModifier.isSourceFolder((IJavaProject)iJavaElement)) {
                return null;
            }
            iJavaElement = iJavaProject.getPackageFragmentRoot(iJavaProject.getResource());
        }
        return (IPackageFragmentRoot)iJavaElement;
    }

    public static IClasspathEntry getClasspathEntryFor(IPath iPath, IJavaProject iJavaProject, int n) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n2 = 0;
        while (n2 < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            if (iClasspathEntry.getPath().equals((Object)iPath) && ClasspathModifier.equalEntryKind(iClasspathEntry, n)) {
                return iClasspathEntry;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isDefaultOutputFolder(CPListElementAttribute cPListElementAttribute) {
        return cPListElementAttribute.getValue() == null;
    }

    public static boolean isIncluded(IJavaElement iJavaElement, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry iClasspathEntry;
        IPackageFragmentRoot iPackageFragmentRoot;
        block4: {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            try {
                iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ContainsPath, 4);
                iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                if (iClasspathEntry != null) break block4;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return false;
        }
        boolean bl = ClasspathModifier.contains(iJavaElement.getPath().removeFirstSegments(iPackageFragmentRoot.getPath().segmentCount()), iClasspathEntry.getInclusionPatterns(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
        Object var5_6 = null;
        iProgressMonitor.done();
        return bl;
    }

    public static boolean isExcluded(IResource iResource, IJavaProject iJavaProject) throws JavaModelException {
        IPackageFragmentRoot iPackageFragmentRoot = ClasspathModifier.getFragmentRoot(iResource, iJavaProject, null);
        if (iPackageFragmentRoot == null) {
            return false;
        }
        String string = ClasspathModifier.getName(iResource.getFullPath(), iPackageFragmentRoot.getPath());
        string = ClasspathModifier.completeName(string);
        IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
        return iClasspathEntry != null && ClasspathModifier.contains((IPath)new Path(string), iClasspathEntry.getExclusionPatterns(), null);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parentExcluded(IResource var0, IJavaProject var1_1) throws JavaModelException {
        if (var0.getFullPath().equals((Object)var1_1.getPath())) {
            return false;
        }
        var2_2 = ClasspathModifier.getFragmentRoot(var0, var1_1, null);
        if (var2_2 == null) {
            return true;
        }
        var3_3 = var0.getFullPath().removeFirstSegments(var2_2.getPath().segmentCount());
        var4_4 = var2_2.getRawClasspathEntry();
        if (var4_4 != null) ** GOTO lbl13
        return true;
lbl-1000:
        // 1 sources

        {
            if (ClasspathModifier.contains(var3_3, var4_4.getExclusionPatterns(), null)) {
                return true;
            }
            var3_3 = var3_3.removeLastSegments(1);
lbl13:
            // 2 sources

            ** while (var3_3.segmentCount() > 0)
        }
lbl14:
        // 1 sources

        return false;
    }

    public static boolean hasDefaultOutputFolder(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        return iPackageFragmentRoot.getRawClasspathEntry().getOutputLocation() == null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasOutputFolders(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        block7: {
            block6: {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                try {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                    iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_CheckOutputFolders, iPackageFragmentRootArray.length);
                    int n = 0;
                    while (n < iPackageFragmentRootArray.length) {
                        if (iPackageFragmentRootArray[n].getRawClasspathEntry().getOutputLocation() != null) {
                            Object var4_4 = null;
                            break block6;
                        }
                        iProgressMonitor.worked(1);
                        ++n;
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return true;
        }
        Object var4_6 = null;
        iProgressMonitor.done();
        return false;
    }

    public static String escapeSpecialChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    stringBuffer.append(" ");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isSourceFolder(IJavaProject iJavaProject) throws JavaModelException {
        return ClasspathModifier.getClasspathEntryFor(iJavaProject.getPath(), iJavaProject, 3) != null;
    }

    public static boolean isDefaultFragment(IPackageFragment iPackageFragment) {
        return iPackageFragment.getElementName().length() == 0;
    }

    public static boolean includeFiltersEmpty(IResource iResource, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        block4: {
            boolean bl;
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            try {
                iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ExamineInputFilters, 4);
                IPackageFragmentRoot iPackageFragmentRoot = ClasspathModifier.getFragmentRoot(iResource, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
                if (iPackageFragmentRoot == null) break block4;
                IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                bl = iClasspathEntry.getInclusionPatterns().length == 0;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return bl;
        }
        Object var5_7 = null;
        iProgressMonitor.done();
        return true;
    }

    public static boolean filtersSet(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        if (iPackageFragmentRoot == null) {
            return false;
        }
        IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
        IPath[] iPathArray = iClasspathEntry.getInclusionPatterns();
        IPath[] iPathArray2 = iClasspathEntry.getExclusionPatterns();
        if (iPathArray != null && iPathArray.length > 0) {
            return true;
        }
        return iPathArray2 != null && iPathArray2.length > 0;
    }

    public static CPListElement addToClasspath(IResource iResource, List list, List list2, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws OperationCanceledException, CoreException {
        CPListElement cPListElement;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            CPListElement cPListElement2;
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 2);
            ClasspathModifier.exclude(iResource.getFullPath(), list, list2, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            cPListElement = cPListElement2 = new CPListElement(iJavaProject, 3, iResource.getFullPath(), iResource);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return cPListElement;
    }

    public static boolean isArchive(IFile iFile, IJavaProject iJavaProject) throws JavaModelException {
        if (!ArchiveFileFilter.isArchivePath(iFile.getFullPath())) {
            return false;
        }
        return iJavaProject != null && iJavaProject.exists() && iJavaProject.findPackageFragmentRoot(iFile.getFullPath()) == null;
    }

    public static CPListElement addToClasspath(IJavaElement iJavaElement, List list, List list2, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws OperationCanceledException, CoreException {
        CPListElement cPListElement;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            CPListElement cPListElement2;
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 10);
            cPListElement = cPListElement2 = new CPListElement(iJavaProject, 3, iJavaElement.getPath(), iJavaElement.getResource());
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return cPListElement;
    }

    public static IJavaProject removeFromClasspath(IJavaProject iJavaProject, List list, IProgressMonitor iProgressMonitor) {
        CPListElement cPListElement = ClasspathModifier.getListElement(iJavaProject.getPath(), list);
        if (cPListElement != null) {
            list.remove(cPListElement);
        }
        return iJavaProject;
    }

    public static List removeFilters(IPath iPath, IJavaProject iJavaProject, List list) {
        if (iPath == null) {
            return Collections.EMPTY_LIST;
        }
        IPath iPath2 = iJavaProject.getPath();
        if (iPath2.isPrefixOf(iPath)) {
            iPath = iPath.removeFirstSegments(iPath2.segmentCount()).addTrailingSeparator();
        }
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            CPListElement cPListElement = (CPListElement)iterator.next();
            boolean bl = false;
            IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
            if (iPathArray != null) {
                object = new ArrayList(iPathArray.length);
                int n = 0;
                while (n < iPathArray.length) {
                    if (!iPathArray[n].equals((Object)iPath)) {
                        object.add(iPathArray[n]);
                    } else {
                        bl = true;
                    }
                    ++n;
                }
                cPListElement.setAttribute("exclusion", object.toArray(new IPath[object.size()]));
            }
            if ((object = (IPath[])cPListElement.getAttribute("inclusion")) != null) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(((IPath[])object).length);
                int n = 0;
                while (n < ((Object)object).length) {
                    if (!object[n].equals((Object)iPath)) {
                        arrayList2.add(object[n]);
                    } else {
                        bl = true;
                    }
                    ++n;
                }
                cPListElement.setAttribute("inclusion", arrayList2.toArray(new IPath[arrayList2.size()]));
            }
            if (!bl) continue;
            arrayList.add(cPListElement);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IResource exclude(String string, IPath iPath, CPListElement cPListElement, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IResource iResource;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 6);
            IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
            IPath[] iPathArray2 = new IPath[iPathArray.length + 1];
            string = ClasspathModifier.completeName(string);
            Path path = new Path(string);
            if (!ClasspathModifier.contains((IPath)path, iPathArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2))) {
                System.arraycopy(iPathArray, 0, iPathArray2, 0, iPathArray.length);
                iPathArray2[iPathArray.length] = path;
                cPListElement.setAttribute("exclusion", iPathArray2);
                cPListElement.setAttribute("inclusion", ClasspathModifier.remove((IPath)path, (IPath[])cPListElement.getAttribute("inclusion"), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4)));
            }
            iResource = iPath == null ? null : ClasspathModifier.getResource(iPath, iJavaProject);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        iProgressMonitor.done();
        return iResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void exclude(IPath iPath, List list, List list2, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        block8: {
            block7: {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                try {
                    IPath iPath2;
                    iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 1);
                    CPListElement cPListElement = null;
                    CPListElement cPListElement2 = null;
                    int n = 0;
                    do {
                        if ((iPath2 = iPath.removeLastSegments(++n)).segmentCount() == 0) {
                            Object var9_9 = null;
                            break block7;
                        }
                        cPListElement = ClasspathModifier.getListElement(iPath2, list2);
                    } while ((cPListElement2 = ClasspathModifier.getListElement(iPath2, list)) == null && cPListElement == null);
                    if (cPListElement == null) {
                        cPListElement = cPListElement2;
                    }
                    ClasspathModifier.exclude(iPath.removeFirstSegments(iPath.segmentCount() - n).toString(), null, cPListElement, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return;
        }
        Object var9_11 = null;
        iProgressMonitor.done();
    }

    public static IResource exclude(IJavaElement iJavaElement, CPListElement cPListElement, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IResource iResource;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            String string = ClasspathModifier.getName(iJavaElement.getPath(), cPListElement.getPath());
            iResource = ClasspathModifier.exclude(string, iJavaElement.getPath(), cPListElement, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return iResource;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unExclude(IResource iResource, CPListElement cPListElement, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveExclusion, 10);
            String string = ClasspathModifier.getName(iResource.getFullPath(), cPListElement.getPath());
            IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
            IPath[] iPathArray2 = ClasspathModifier.remove((IPath)new Path(ClasspathModifier.completeName(string)), iPathArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            cPListElement.setAttribute("exclusion", iPathArray2);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void resetFilters(IJavaElement iJavaElement, CPListElement cPListElement, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            IPath[] iPathArray;
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetFilters, 3);
            List list = ClasspathModifier.getFoldersOnCP(iJavaElement.getPath(), iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            IPath iPath = (IPath)cPListElement.getAttribute("output");
            if (iPath != null) {
                iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
                if (ClasspathModifier.contains((IPath)new Path(ClasspathModifier.completeName(iPath.lastSegment())), iPathArray, null)) {
                    list.add(new Path(ClasspathModifier.completeName(iPath.lastSegment())));
                }
            }
            iPathArray = list.toArray(new IPath[list.size()]);
            cPListElement.setAttribute("inclusion", new IPath[0]);
            cPListElement.setAttribute("exclusion", iPathArray);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        iProgressMonitor.done();
    }

    public static CPListElementAttribute resetOutputFolder(CPListElement cPListElement, IJavaProject iJavaProject) throws JavaModelException {
        cPListElement.setAttribute("output", null);
        CPListElementAttribute cPListElementAttribute = new CPListElementAttribute(cPListElement, "output", cPListElement.getAttribute("output"), true);
        return cPListElementAttribute;
    }

    public static CPListElement getClasspathEntry(List list, CPListElement cPListElement) {
        int n = 0;
        while (n < list.size()) {
            if (((CPListElement)list.get(n)).getPath().equals((Object)cPListElement.getPath())) {
                return (CPListElement)list.get(n);
            }
            ++n;
        }
        list.add(cPListElement);
        return cPListElement;
    }

    public static CPListElement getListElement(IPath iPath, List list) {
        int n = 0;
        while (n < list.size()) {
            CPListElement cPListElement = (CPListElement)list.get(n);
            if (cPListElement.getEntryKind() == 3 && cPListElement.getPath().equals((Object)iPath)) {
                return cPListElement;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commitClassPath(List list, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 2);
        try {
            IClasspathEntry[] iClasspathEntryArray = ClasspathModifier.convert(list);
            IPath iPath = iJavaProject.getOutputLocation();
            IJavaModelStatus iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)iJavaProject, (IClasspathEntry[])iClasspathEntryArray, (IPath)iPath);
            if (!iJavaModelStatus.isOK()) {
                throw new JavaModelException(iJavaModelStatus);
            }
            iJavaProject.setRawClasspath(iClasspathEntryArray, iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commitClassPath(CPJavaProject cPJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 2);
        try {
            IClasspathEntry[] iClasspathEntryArray = ClasspathModifier.convert(cPJavaProject.getCPListElements());
            IPath iPath = cPJavaProject.getDefaultOutputLocation();
            IJavaModelStatus iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)cPJavaProject.getJavaProject(), (IClasspathEntry[])iClasspathEntryArray, (IPath)iPath);
            if (!iJavaModelStatus.isOK()) {
                throw new JavaModelException(iJavaModelStatus);
            }
            cPJavaProject.getJavaProject().setRawClasspath(iClasspathEntryArray, iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        iProgressMonitor.done();
    }

    public static List getCorrespondingElements(List list, IJavaProject iJavaProject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            IPath iPath = e instanceof IResource ? ((IResource)e).getFullPath() : ((IJavaElement)e).getPath();
            IResource iResource = ClasspathModifier.getResource(iPath, iJavaProject);
            if (iResource != null) {
                IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
                if (iJavaElement != null && iJavaProject.isOnClasspath(iJavaElement)) {
                    arrayList.add(iJavaElement);
                } else {
                    arrayList.add(iResource);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private static IResource getResource(IPath iPath, IJavaProject iJavaProject) {
        return iJavaProject.getProject().getWorkspace().getRoot().findMember(iPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean contains(IPath iPath, IPath[] iPathArray, IProgressMonitor iProgressMonitor) {
        block9: {
            block8: {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                if (iPath == null) {
                    return false;
                }
                try {
                    iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ComparePaths, iPathArray.length);
                    if (iPath.getFileExtension() == null) {
                        iPath = new Path(ClasspathModifier.completeName(iPath.toString()));
                    }
                    int n = 0;
                    while (n < iPathArray.length) {
                        if (iPathArray[n].equals((Object)iPath)) {
                            Object var4_4 = null;
                            break block8;
                        }
                        iProgressMonitor.worked(1);
                        ++n;
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return true;
        }
        Object var4_6 = null;
        iProgressMonitor.done();
        return false;
    }

    private static String completeName(String string) {
        if (!JavaCore.isJavaLikeFileName((String)string)) {
            string = String.valueOf(string) + "/";
            string = string.replace('.', '/');
            return string;
        }
        return string;
    }

    private static IPath[] remove(IPath iPath, IPath[] iPathArray, IProgressMonitor iProgressMonitor) {
        IPath[] iPathArray2;
        block6: {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemovePath, iPathArray.length + 5);
            if (ClasspathModifier.contains(iPath, iPathArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 5))) break block6;
            IPath[] iPathArray3 = iPathArray;
            Object var5_5 = null;
            iProgressMonitor.done();
            return iPathArray3;
        }
        try {
            ArrayList<IPath> arrayList = new ArrayList<IPath>();
            int n = 0;
            while (n < iPathArray.length) {
                iProgressMonitor.worked(1);
                if (!iPathArray[n].equals((Object)iPath)) {
                    arrayList.add(iPathArray[n]);
                }
                ++n;
            }
            iPathArray2 = arrayList.toArray(new IPath[arrayList.size()]);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return iPathArray2;
    }

    private static List getFoldersOnCP(IPath iPath, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        ArrayList<Path> arrayList = new ArrayList<Path>();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IPath iPath2 = iClasspathEntryArray[n].getPath();
            if (iPath.isPrefixOf(iPath2) && iPath.segmentCount() + 1 == iPath2.segmentCount()) {
                arrayList.add(new Path(ClasspathModifier.completeName(iPath2.lastSegment())));
            }
            ++n;
        }
        return arrayList;
    }

    private static String getName(IPath iPath, IPath iPath2) {
        return iPath.removeFirstSegments(iPath2.segmentCount()).toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setNewEntry(List list, List list2, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_SetNewEntry, list.size());
            int n = 0;
            while (n < list2.size()) {
                CPListElement cPListElement = (CPListElement)list2.get(n);
                ClasspathModifier.validateAndAddEntry(cPListElement, list, iJavaProject);
                iProgressMonitor.worked(1);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        iProgressMonitor.done();
    }

    private static IClasspathEntry[] convert(List list) {
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[list.size()];
        int n = 0;
        while (n < list.size()) {
            CPListElement cPListElement = (CPListElement)list.get(n);
            iClasspathEntryArray[n] = cPListElement.getClasspathEntry();
            ++n;
        }
        return iClasspathEntryArray;
    }

    private static void validateAndAddEntry(CPListElement cPListElement, List list, IJavaProject iJavaProject) throws CoreException {
        IFileStore iFileStore;
        Object object;
        IPath iPath = cPListElement.getPath();
        IPath iPath2 = iJavaProject.getProject().getFullPath();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus iStatus = iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2);
        StatusInfo statusInfo = new StatusInfo();
        statusInfo.setOK();
        boolean bl = ClasspathModifier.isExternalArchiveOrLibrary(cPListElement, iJavaProject);
        if (!bl && iStatus.matches(4) && !iJavaProject.getPath().equals((Object)iPath)) {
            statusInfo.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, iStatus.getMessage()));
            throw new CoreException((IStatus)statusInfo);
        }
        if (!bl && !iJavaProject.getPath().equals((Object)iPath)) {
            IResource iResource = iWorkspaceRoot.findMember(iPath);
            if (iResource != null) {
                if (iResource.getType() != 2 && iResource.getType() != 1) {
                    statusInfo.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                    throw new CoreException((IStatus)statusInfo);
                }
            } else {
                object = iJavaProject.getProject().getLocationURI();
                if (object != null && (iFileStore = EFS.getStore((URI)object).getChild(iPath)).fetchInfo().exists()) {
                    statusInfo.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                    throw new CoreException((IStatus)statusInfo);
                }
            }
        }
        int n = 0;
        while (n < list.size()) {
            object = (CPListElement)list.get(n);
            if (object.getEntryKind() == 3 && iPath.equals((Object)object.getPath()) && !iJavaProject.getPath().equals((Object)iPath)) {
                statusInfo.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                throw new CoreException((IStatus)statusInfo);
            }
            ++n;
        }
        if (!bl && !cPListElement.getPath().equals((Object)iJavaProject.getPath())) {
            ClasspathModifier.exclude(cPListElement.getPath(), list, new ArrayList(), iJavaProject, null);
        }
        IPath iPath3 = iJavaProject.getOutputLocation();
        ClasspathModifier.insertAtEndOfCategory(cPListElement, list);
        object = ClasspathModifier.convert(list);
        iFileStore = JavaConventions.validateClasspath((IJavaProject)iJavaProject, (IClasspathEntry[])object, (IPath)iPath3);
        if (!iFileStore.isOK()) {
            IJavaModelStatus iJavaModelStatus;
            if (iPath3.equals((Object)iPath2) && (iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)iJavaProject, (IClasspathEntry[])object, (IPath)iPath3)).isOK()) {
                if (iJavaProject.isOnClasspath((IJavaElement)iJavaProject)) {
                    statusInfo.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSFandOL, iPath3.makeRelative().toString()));
                } else {
                    statusInfo.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceOL, iPath3.makeRelative().toString()));
                }
                return;
            }
            statusInfo.setError(iFileStore.getMessage());
            throw new CoreException((IStatus)statusInfo);
        }
        if (ClasspathModifier.isSourceFolder(iJavaProject) || iJavaProject.getPath().equals((Object)iPath)) {
            statusInfo.setWarning(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
            return;
        }
        statusInfo.setOK();
    }

    private static void insertAtEndOfCategory(CPListElement cPListElement, List list) {
        int n = list.size();
        CPListElement[] cPListElementArray = list.toArray(new CPListElement[n]);
        int n2 = 0;
        while (n2 < n && cPListElementArray[n2].getClasspathEntry().getEntryKind() != cPListElement.getClasspathEntry().getEntryKind()) {
            ++n2;
        }
        if (n2 < n) {
            ++n2;
            while (n2 < n && cPListElementArray[n2].getClasspathEntry().getEntryKind() == cPListElement.getClasspathEntry().getEntryKind()) {
                ++n2;
            }
            list.add(n2, cPListElement);
            return;
        }
        switch (cPListElement.getClasspathEntry().getEntryKind()) {
            case 3: {
                list.add(0, cPListElement);
                break;
            }
            default: {
                list.add(cPListElement);
            }
        }
    }

    private static boolean isExternalArchiveOrLibrary(CPListElement cPListElement, IJavaProject iJavaProject) {
        if (cPListElement.getEntryKind() == 1 || cPListElement.getEntryKind() == 5) {
            return !(cPListElement.getResource() instanceof IFolder);
        }
        return false;
    }

    private static boolean equalEntryKind(IClasspathEntry iClasspathEntry, int n) {
        return iClasspathEntry.getEntryKind() == n;
    }

    public static ClasspathModifierQueries.OutputFolderValidator getValidator(final List list, IJavaProject iJavaProject) throws JavaModelException {
        return new ClasspathModifierQueries.OutputFolderValidator(list, iJavaProject){

            public boolean validate(IPath iPath) {
                int n = 0;
                while (n < list.size()) {
                    if (this.isInvalid(list.get(n), iPath)) {
                        return false;
                    }
                    ++n;
                }
                n = 0;
                while (n < this.fEntries.length) {
                    if (this.isInvalid(this.fEntries[n], iPath)) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }

            private boolean isInvalid(Object object, IPath iPath) {
                IPath iPath2 = null;
                if (object instanceof IFolder) {
                    iPath2 = this.getFolderPath(object);
                } else if (object instanceof IJavaElement) {
                    iPath2 = this.getJavaElementPath(object);
                } else if (object instanceof IClasspathEntry) {
                    iPath2 = this.getCPEntryPath(object);
                }
                return this.isSubFolderOf(iPath2, iPath);
            }

            private IPath getFolderPath(Object object) {
                return ((IFolder)object).getFullPath();
            }

            private IPath getJavaElementPath(Object object) {
                return ((IJavaElement)object).getPath();
            }

            private IPath getCPEntryPath(Object object) {
                return ((IClasspathEntry)object).getPath();
            }

            private boolean isSubFolderOf(IPath iPath, IPath iPath2) {
                if (iPath == null || iPath2 == null) {
                    return iPath == null && iPath2 == null;
                }
                return iPath2.matchingFirstSegments(iPath) == iPath2.segmentCount();
            }
        };
    }
}

