/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CallLocation
implements IAdaptable {
    public static final int UNKNOWN_LINE_NUMBER = -1;
    private IMember fMember;
    private IMember fCalledMember;
    private int fStart;
    private int fEnd;
    private String fCallText;
    private int fLineNumber;
    static /* synthetic */ Class class$0;

    public CallLocation(IMember iMember, IMember iMember2, int n, int n2, int n3) {
        this.fMember = iMember;
        this.fCalledMember = iMember2;
        this.fStart = n;
        this.fEnd = n2;
        this.fLineNumber = n3;
    }

    public IMember getCalledMember() {
        return this.fCalledMember;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public IMember getMember() {
        return this.fMember;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getLineNumber() {
        this.initCallTextAndLineNumber();
        return this.fLineNumber;
    }

    public String getCallText() {
        this.initCallTextAndLineNumber();
        return this.fCallText;
    }

    private void initCallTextAndLineNumber() {
        if (this.fCallText != null) {
            return;
        }
        IBuffer iBuffer = this.getBufferForMember();
        if (iBuffer == null || iBuffer.getLength() < this.fEnd) {
            this.fCallText = "";
            this.fLineNumber = -1;
            return;
        }
        this.fCallText = iBuffer.getText(this.fStart, this.fEnd - this.fStart);
        if (this.fLineNumber == -1) {
            Document document = new Document(iBuffer.getContents());
            try {
                this.fLineNumber = document.getLineOfOffset(this.fStart) + 1;
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
        }
    }

    private IBuffer getBufferForMember() {
        IBuffer iBuffer = null;
        try {
            IOpenable iOpenable = this.fMember.getOpenable();
            if (iOpenable != null && this.fMember.exists()) {
                iBuffer = iOpenable.getBuffer();
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return iBuffer;
    }

    public String toString() {
        return this.getCallText();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return this.getMember();
        }
        return null;
    }
}

