/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class AddJavaDocStubOperation
implements IWorkspaceRunnable {
    private IMember[] fMembers;

    public AddJavaDocStubOperation(IMember[] iMemberArray) {
        this.fMembers = iMemberArray;
    }

    private String createTypeComment(IType iType, String string) throws CoreException {
        String[] stringArray = StubUtility.getTypeParameterNames(iType.getTypeParameters());
        return CodeGeneration.getTypeComment(iType.getCompilationUnit(), iType.getTypeQualifiedName('.'), stringArray, string);
    }

    private String createMethodComment(IMethod iMethod, String string) throws CoreException {
        IType iType = iMethod.getDeclaringType();
        IMethod iMethod2 = null;
        if (!iMethod.isConstructor() && iType != null) {
            ITypeHierarchy iTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy(iType);
            MethodOverrideTester methodOverrideTester = new MethodOverrideTester(iType, iTypeHierarchy);
            iMethod2 = methodOverrideTester.findOverriddenMethod(iMethod, true);
        }
        return CodeGeneration.getMethodComment(iMethod, iMethod2, string);
    }

    private String createFieldComment(IField iField, String string) throws JavaModelException, CoreException {
        String string2 = Signature.toString((String)iField.getTypeSignature());
        String string3 = iField.getElementName();
        return CodeGeneration.getFieldComment(iField.getCompilationUnit(), string2, string3, string);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (this.fMembers.length == 0) {
            return;
        }
        try {
            iProgressMonitor.beginTask(CodeGenerationMessages.AddJavaDocStubOperation_description, this.fMembers.length + 2);
            this.addJavadocComments(iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        iProgressMonitor.done();
    }

    protected IDocument getDocument(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws CoreException {
        IDocument iDocument;
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        IPath iPath = iCompilationUnit.getPath();
        try {
            iTextFileBufferManager.connect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iDocument = iTextFileBufferManager.getTextFileBuffer(iPath).getDocument();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            throw throwable;
        }
        iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        return iDocument;
    }

    private void addJavadocComments(IProgressMonitor iProgressMonitor) throws CoreException {
        ICompilationUnit iCompilationUnit = this.fMembers[0].getCompilationUnit();
        try {
            IDocument iDocument = this.getDocument(iCompilationUnit, iProgressMonitor);
            String string = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            int n = 0;
            while (n < this.fMembers.length) {
                StringBuffer stringBuffer;
                IMember iMember = this.fMembers[n];
                int n2 = this.getMemberStartOffset(iMember, iDocument);
                String string2 = null;
                switch (iMember.getElementType()) {
                    case 7: {
                        string2 = this.createTypeComment((IType)iMember, string);
                        break;
                    }
                    case 8: {
                        string2 = this.createFieldComment((IField)iMember, string);
                        break;
                    }
                    case 9: {
                        string2 = this.createMethodComment((IMethod)iMember, string);
                    }
                }
                if (string2 == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("/**").append(string);
                    stringBuffer.append(" *").append(string);
                    stringBuffer.append(" */").append(string);
                    string2 = stringBuffer.toString();
                } else if (!string2.endsWith(string)) {
                    string2 = String.valueOf(string2) + string;
                }
                stringBuffer = iCompilationUnit.getJavaProject();
                IRegion iRegion = iDocument.getLineInformationOfOffset(n2);
                String string3 = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                String string4 = Strings.getIndentString(string3, (IJavaProject)stringBuffer);
                String string5 = Strings.changeIndent(string2, 0, (IJavaProject)stringBuffer, string4, string);
                multiTextEdit.addChild((TextEdit)new InsertEdit(n2, string5));
                iProgressMonitor.worked(1);
                ++n;
            }
            multiTextEdit.apply(iDocument);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(JavaUIStatus.createError(4, badLocationException));
        }
    }

    private int getMemberStartOffset(IMember iMember, IDocument iDocument) throws JavaModelException {
        int n = iMember.getSourceRange().getOffset();
        TokenScanner tokenScanner = new TokenScanner(iDocument, iMember.getJavaProject());
        try {
            return tokenScanner.getNextStartOffset(n, true);
        }
        catch (CoreException coreException) {
            return n;
        }
    }
}

