/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;

public class ASTNodeFactory {
    private static final String STATEMENT_HEADER = "class __X__ { void __x__() { ";
    private static final String STATEMENT_FOOTER = "}}";
    private static final String TYPE_HEADER = "class __X__ { abstract ";
    private static final String TYPE_FOOTER = " __f__(); }}";
    private static final String TYPEPARAM_HEADER = "class __X__ { abstract <";
    private static final String TYPEPARAM_FOOTER = "> void __f__(); }}";

    private ASTNodeFactory() {
    }

    public static ASTNode newStatement(AST aST, String string) {
        StringBuffer stringBuffer = new StringBuffer(STATEMENT_HEADER);
        stringBuffer.append(string);
        stringBuffer.append(STATEMENT_FOOTER);
        ASTParser aSTParser = ASTParser.newParser((int)aST.apiLevel());
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        ASTNode aSTNode = ASTNode.copySubtree((AST)aST, (ASTNode)NodeFinder.perform((ASTNode)compilationUnit, STATEMENT_HEADER.length(), string.length()));
        aSTNode.accept((ASTVisitor)new PositionClearer());
        return aSTNode;
    }

    public static Name newName(AST aST, String string) {
        return aST.newName(string);
    }

    public static TypeParameter newTypeParameter(AST aST, String string) {
        StringBuffer stringBuffer = new StringBuffer(TYPEPARAM_HEADER);
        stringBuffer.append(string);
        stringBuffer.append(TYPEPARAM_FOOTER);
        ASTParser aSTParser = ASTParser.newParser((int)aST.apiLevel());
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        List list = compilationUnit.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        TypeParameter typeParameter = (TypeParameter)methodDeclaration.typeParameters().get(0);
        ASTNode aSTNode = ASTNode.copySubtree((AST)aST, (ASTNode)typeParameter);
        aSTNode.accept((ASTVisitor)new PositionClearer());
        return (TypeParameter)aSTNode;
    }

    public static Type newType(AST aST, String string) {
        StringBuffer stringBuffer = new StringBuffer(TYPE_HEADER);
        stringBuffer.append(string);
        stringBuffer.append(TYPE_FOOTER);
        ASTParser aSTParser = ASTParser.newParser((int)aST.apiLevel());
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        List list = compilationUnit.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Type type = methodDeclaration.getReturnType2();
        ASTNode aSTNode = ASTNode.copySubtree((AST)aST, (ASTNode)type);
        aSTNode.accept((ASTVisitor)new PositionClearer());
        return (Type)aSTNode;
    }

    public static Type newType(AST aST, VariableDeclaration variableDeclaration) {
        Type type = ASTNodes.getType(variableDeclaration);
        int n = variableDeclaration.getExtraDimensions();
        type = (Type)ASTNode.copySubtree((AST)aST, (ASTNode)type);
        int n2 = 0;
        while (n2 < n) {
            type = aST.newArrayType(type);
            ++n2;
        }
        return type;
    }

    public static Expression newDefaultExpression(AST aST, Type type, int n) {
        if (n == 0 && type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.BOOLEAN) {
                return aST.newBooleanLiteral(false);
            }
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID) {
                return null;
            }
            return aST.newNumberLiteral("0");
        }
        return aST.newNullLiteral();
    }

    public static Expression newDefaultExpression(AST aST, ITypeBinding iTypeBinding) {
        if (iTypeBinding.isPrimitive()) {
            String string = iTypeBinding.getName();
            if ("boolean".equals(string)) {
                return aST.newBooleanLiteral(false);
            }
            if ("void".equals(string)) {
                return null;
            }
            return aST.newNumberLiteral("0");
        }
        return aST.newNullLiteral();
    }

    public static List newModifiers(AST aST, int n) {
        return aST.newModifiers(n);
    }

    public static List newModifiers(AST aST, List list) {
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>(list.size());
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof Modifier) {
                arrayList.add(aST.newModifier(((Modifier)e).getKeyword()));
            }
            ++n;
        }
        return arrayList;
    }

    public static Expression newInfixExpression(AST aST, InfixExpression.Operator operator, ArrayList arrayList) {
        if (arrayList.size() == 1) {
            return (Expression)arrayList.get(0);
        }
        InfixExpression infixExpression = aST.newInfixExpression();
        infixExpression.setOperator(operator);
        infixExpression.setLeftOperand((Expression)arrayList.get(0));
        infixExpression.setRightOperand((Expression)arrayList.get(1));
        infixExpression.extendedOperands().addAll(arrayList.subList(2, arrayList.size()));
        return infixExpression;
    }

    private static class PositionClearer
    extends GenericVisitor {
        public PositionClearer() {
            super(true);
        }

        protected boolean visitNode(ASTNode aSTNode) {
            aSTNode.setSourceRange(-1, 0);
            return true;
        }
    }
}

