/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

public class CodeScopeBuilder
extends ASTVisitor {
    private IBinding fIgnoreBinding;
    private Selection fIgnoreRange;
    private Scope fScope;
    private List fScopes;

    public static Scope perform(BodyDeclaration bodyDeclaration, IBinding iBinding) {
        CodeScopeBuilder codeScopeBuilder = new CodeScopeBuilder((ASTNode)bodyDeclaration, iBinding);
        bodyDeclaration.accept((ASTVisitor)codeScopeBuilder);
        return codeScopeBuilder.fScope;
    }

    public static Scope perform(BodyDeclaration bodyDeclaration, Selection selection) {
        CodeScopeBuilder codeScopeBuilder = new CodeScopeBuilder((ASTNode)bodyDeclaration, selection);
        bodyDeclaration.accept((ASTVisitor)codeScopeBuilder);
        return codeScopeBuilder.fScope;
    }

    private CodeScopeBuilder(ASTNode aSTNode, IBinding iBinding) {
        this.fScope = new Scope(null, aSTNode.getStartPosition(), aSTNode.getLength());
        this.fScopes = new ArrayList();
        this.fIgnoreBinding = iBinding;
    }

    private CodeScopeBuilder(ASTNode aSTNode, Selection selection) {
        this.fScope = new Scope(null, aSTNode.getStartPosition(), aSTNode.getLength());
        this.fScopes = new ArrayList();
        this.fIgnoreRange = selection;
    }

    public boolean visit(CatchClause catchClause) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, catchClause.getStartPosition(), catchClause.getLength());
        return true;
    }

    public void endVisit(CatchClause catchClause) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    public boolean visit(SimpleName simpleName) {
        if (this.fIgnoreBinding != null && Bindings.equals(this.fIgnoreBinding, simpleName.resolveBinding())) {
            return false;
        }
        if (this.fIgnoreRange != null && this.fIgnoreRange.covers((ASTNode)simpleName)) {
            return false;
        }
        this.fScope.addName(simpleName.getIdentifier());
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        qualifiedName.getQualifier().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        Expression expression = methodInvocation.getExpression();
        if (expression == null) {
            SimpleName simpleName = methodInvocation.getName();
            if (this.fIgnoreBinding == null || simpleName != null && !Bindings.equals(this.fIgnoreBinding, simpleName.resolveBinding())) {
                methodInvocation.getName().accept((ASTVisitor)this);
            }
        } else {
            expression.accept((ASTVisitor)this);
        }
        this.accept(methodInvocation.arguments());
        return false;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        if (typeDeclarationStatement.getAST().apiLevel() == 2) {
            this.fScope.addName(typeDeclarationStatement.getTypeDeclaration().getName().getIdentifier());
        } else {
            this.fScope.addName(typeDeclarationStatement.getDeclaration().getName().getIdentifier());
        }
        return false;
    }

    public boolean visit(Block block) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, block.getStartPosition(), block.getLength());
        return true;
    }

    public void endVisit(Block block) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    public boolean visit(ForStatement forStatement) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, forStatement.getStartPosition(), forStatement.getLength());
        return true;
    }

    public void endVisit(ForStatement forStatement) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    private void accept(List list) {
        int n;
        if (list == null || (n = list.size()) == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ((ASTNode)list.get(n2)).accept((ASTVisitor)this);
            ++n2;
        }
    }

    public boolean visit(ForInStatement forInStatement) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, forInStatement.getStartPosition(), forInStatement.getLength());
        return true;
    }

    public void endVisit(ForInStatement forInStatement) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    public static class Scope {
        private Scope fParent;
        private int fStart;
        private int fLength;
        private List fNames;
        private List fChildren;
        private int fCursorOffset;

        Scope(Scope scope, int n, int n2) {
            this.fParent = scope;
            this.fStart = n;
            this.fLength = n2;
            if (this.fParent != null) {
                this.fParent.addChild(this);
            }
        }

        public void setCursor(int n) {
            this.fCursorOffset = n;
        }

        private void addChild(Scope scope) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList(2);
            }
            this.fChildren.add(scope);
        }

        private void addName(String string) {
            if (this.fNames == null) {
                this.fNames = new ArrayList(2);
            }
            this.fNames.add(string);
        }

        public Scope findScope(int n, int n2) {
            if (this.fStart <= n && n + n2 <= this.fStart + this.fLength) {
                if (this.fChildren == null) {
                    return this;
                }
                Iterator iterator = this.fChildren.iterator();
                while (iterator.hasNext()) {
                    Scope scope = ((Scope)iterator.next()).findScope(n, n2);
                    if (scope == null) continue;
                    return scope;
                }
                return this;
            }
            return null;
        }

        public String createName(String string, boolean bl) {
            int n = 1;
            String string2 = string;
            while (this.isInUse(string2)) {
                string2 = String.valueOf(string) + n++;
            }
            if (bl) {
                this.addName(string2);
            }
            return string2;
        }

        public boolean isInUse(String string) {
            if (this.internalIsInUse(string)) {
                return true;
            }
            if (this.fChildren != null) {
                Iterator iterator = this.fChildren.iterator();
                while (iterator.hasNext()) {
                    Scope scope = (Scope)iterator.next();
                    if (this.fCursorOffset >= scope.fStart || !scope.isInUseDown(string)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean internalIsInUse(String string) {
            if (this.fNames != null && this.fNames.contains(string)) {
                return true;
            }
            if (this.fParent != null) {
                return this.fParent.internalIsInUse(string);
            }
            return false;
        }

        private boolean isInUseDown(String string) {
            if (this.fNames != null && this.fNames.contains(string)) {
                return true;
            }
            if (this.fChildren == null) {
                return false;
            }
            Iterator iterator = this.fChildren.iterator();
            while (iterator.hasNext()) {
                Scope scope = (Scope)iterator.next();
                if (!scope.isInUseDown(string)) continue;
                return true;
            }
            return false;
        }
    }
}

