/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.core.dom.ASTNode;

public class Selection {
    public static final int INTERSECTS = 0;
    public static final int BEFORE = 1;
    public static final int SELECTED = 2;
    public static final int AFTER = 3;
    private int fStart;
    private int fLength;
    private int fExclusiveEnd;

    protected Selection() {
    }

    public static Selection createFromStartLength(int n, int n2) {
        Assert.isTrue((n >= 0 && n2 >= 0 ? 1 : 0) != 0);
        Selection selection = new Selection();
        selection.fStart = n;
        selection.fLength = n2;
        selection.fExclusiveEnd = n + n2;
        return selection;
    }

    public static Selection createFromStartEnd(int n, int n2) {
        Assert.isTrue((n >= 0 && n2 >= n ? 1 : 0) != 0);
        Selection selection = new Selection();
        selection.fStart = n;
        selection.fLength = n2 - n + 1;
        selection.fExclusiveEnd = selection.fStart + selection.fLength;
        return selection;
    }

    public int getOffset() {
        return this.fStart;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getInclusiveEnd() {
        return this.fExclusiveEnd - 1;
    }

    public int getExclusiveEnd() {
        return this.fExclusiveEnd;
    }

    public int getVisitSelectionMode(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        int n2 = n + aSTNode.getLength();
        if (n2 <= this.fStart) {
            return 1;
        }
        if (this.covers(aSTNode)) {
            return 2;
        }
        if (this.fExclusiveEnd <= n) {
            return 3;
        }
        return 0;
    }

    public int getEndVisitSelectionMode(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        int n2 = n + aSTNode.getLength();
        if (n2 <= this.fStart) {
            return 1;
        }
        if (this.covers(aSTNode)) {
            return 2;
        }
        if (n2 >= this.fExclusiveEnd) {
            return 3;
        }
        return 0;
    }

    public boolean covers(int n) {
        return this.fStart <= n && n < this.fStart + this.fLength;
    }

    public boolean covers(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        return this.fStart <= n && n + aSTNode.getLength() <= this.fExclusiveEnd;
    }

    public boolean coveredBy(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        return n <= this.fStart && this.fExclusiveEnd <= n + aSTNode.getLength();
    }

    public boolean coveredBy(IRegion iRegion) {
        int n = iRegion.getOffset();
        return n <= this.fStart && this.fExclusiveEnd <= n + iRegion.getLength();
    }

    public boolean endsIn(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        return n < this.fExclusiveEnd && this.fExclusiveEnd < n + aSTNode.getLength();
    }

    public boolean liesOutside(ASTNode aSTNode) {
        boolean bl;
        int n = aSTNode.getStartPosition();
        int n2 = n + aSTNode.getLength();
        boolean bl2 = n2 < this.fStart;
        boolean bl3 = bl = this.fExclusiveEnd < n;
        return bl2 || bl;
    }

    public String toString() {
        return "<start == " + this.fStart + ", length == " + this.fLength + "/>";
    }
}

