/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class ConvertForLoopOperation
extends ConvertLoopOperation {
    private static final String LENGTH_QUERY = "length";
    private static final String LITERAL_0 = "0";
    private static final String LITERAL_1 = "1";
    private IVariableBinding fIndexBinding;
    private IVariableBinding fLengthBinding;
    private IBinding fArrayBinding;
    private Expression fArrayAccess;
    private VariableDeclarationFragment fElementDeclaration;
    private final boolean fMakeFinal;

    public ConvertForLoopOperation(ForStatement forStatement) {
        this(forStatement, new String[0], false);
    }

    public ConvertForLoopOperation(ForStatement forStatement, String[] stringArray, boolean bl) {
        super(forStatement, stringArray);
        this.fMakeFinal = bl;
    }

    public IStatus satisfiesPreconditions() {
        ForStatement forStatement = this.getForStatement();
        CompilationUnit compilationUnit = (CompilationUnit)forStatement.getRoot();
        IJavaElement iJavaElement = compilationUnit.getJavaElement();
        if (iJavaElement == null) {
            return ERROR_STATUS;
        }
        if (!JavaModelUtil.is50OrHigher(iJavaElement.getJavaProject())) {
            return ERROR_STATUS;
        }
        if (!this.validateInitializers(forStatement)) {
            return ERROR_STATUS;
        }
        if (!this.validateExpression(forStatement)) {
            return ERROR_STATUS;
        }
        if (!this.validateUpdaters(forStatement)) {
            return ERROR_STATUS;
        }
        if (!this.validateBody(forStatement)) {
            return ERROR_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean validateInitializers(ForStatement forStatement) {
        List list = forStatement.initializers();
        if (list.size() != 1) {
            return false;
        }
        Expression expression = (Expression)list.get(0);
        if (!(expression instanceof VariableDeclarationExpression)) {
            return false;
        }
        VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)expression;
        ITypeBinding iTypeBinding = variableDeclarationExpression.resolveTypeBinding();
        if (iTypeBinding == null) {
            return false;
        }
        if (!iTypeBinding.isPrimitive()) {
            return false;
        }
        if (!PrimitiveType.INT.toString().equals(iTypeBinding.getQualifiedName())) {
            return false;
        }
        List list2 = variableDeclarationExpression.fragments();
        if (list2.size() == 1) {
            IVariableBinding iVariableBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)list2.get(0));
            if (iVariableBinding == null) {
                return false;
            }
            this.fIndexBinding = iVariableBinding;
            return true;
        }
        if (list2.size() == 2) {
            IVariableBinding iVariableBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)list2.get(0));
            if (iVariableBinding == null) {
                iVariableBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)list2.get(1));
                if (iVariableBinding == null) {
                    return false;
                }
                if (!this.validateLengthFragment((VariableDeclarationFragment)list2.get(0))) {
                    return false;
                }
            } else if (!this.validateLengthFragment((VariableDeclarationFragment)list2.get(1))) {
                return false;
            }
            this.fIndexBinding = iVariableBinding;
            return true;
        }
        return false;
    }

    private boolean validateLengthFragment(VariableDeclarationFragment variableDeclarationFragment) {
        Expression expression = variableDeclarationFragment.getInitializer();
        if (expression == null) {
            return false;
        }
        if (!this.validateLengthQuery(expression)) {
            return false;
        }
        IVariableBinding iVariableBinding = (IVariableBinding)variableDeclarationFragment.getName().resolveBinding();
        if (iVariableBinding == null) {
            return false;
        }
        this.fLengthBinding = iVariableBinding;
        return true;
    }

    private IVariableBinding getIndexBindingFromFragment(VariableDeclarationFragment variableDeclarationFragment) {
        Expression expression = variableDeclarationFragment.getInitializer();
        if (!(expression instanceof NumberLiteral)) {
            return null;
        }
        NumberLiteral numberLiteral = (NumberLiteral)expression;
        if (!LITERAL_0.equals(numberLiteral.getToken())) {
            return null;
        }
        return (IVariableBinding)variableDeclarationFragment.getName().resolveBinding();
    }

    private boolean validateExpression(ForStatement forStatement) {
        Expression expression = forStatement.getExpression();
        if (!(expression instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)expression;
        Expression expression2 = infixExpression.getLeftOperand();
        Expression expression3 = infixExpression.getRightOperand();
        if (expression2 instanceof SimpleName && expression3 instanceof SimpleName) {
            IVariableBinding iVariableBinding = this.fLengthBinding;
            if (iVariableBinding == null) {
                return false;
            }
            IBinding iBinding = ((SimpleName)expression2).resolveBinding();
            IBinding iBinding2 = ((SimpleName)expression3).resolveBinding();
            if (this.fIndexBinding.equals((Object)iBinding)) {
                return iVariableBinding.equals((Object)iBinding2);
            }
            if (this.fIndexBinding.equals((Object)iBinding2)) {
                return iVariableBinding.equals((Object)iBinding);
            }
            return false;
        }
        if (expression2 instanceof SimpleName) {
            if (!this.fIndexBinding.equals((Object)((SimpleName)expression2).resolveBinding())) {
                return false;
            }
            if (!InfixExpression.Operator.LESS.equals(infixExpression.getOperator())) {
                return false;
            }
            return this.validateLengthQuery(expression3);
        }
        if (expression3 instanceof SimpleName) {
            if (!this.fIndexBinding.equals((Object)((SimpleName)expression3).resolveBinding())) {
                return false;
            }
            if (!InfixExpression.Operator.GREATER.equals(infixExpression.getOperator())) {
                return false;
            }
            return this.validateLengthQuery(expression2);
        }
        return false;
    }

    private boolean validateLengthQuery(Expression expression) {
        if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            SimpleName simpleName = qualifiedName.getName();
            if (!LENGTH_QUERY.equals(simpleName.getIdentifier())) {
                return false;
            }
            Name name = qualifiedName.getQualifier();
            ITypeBinding iTypeBinding = name.resolveTypeBinding();
            if (iTypeBinding == null) {
                return false;
            }
            if (!iTypeBinding.isArray()) {
                return false;
            }
            IBinding iBinding = name.resolveBinding();
            if (iBinding == null) {
                return false;
            }
            this.fArrayBinding = iBinding;
            this.fArrayAccess = name;
            return true;
        }
        if (expression instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)expression;
            SimpleName simpleName = fieldAccess.getName();
            if (!LENGTH_QUERY.equals(simpleName.getIdentifier())) {
                return false;
            }
            Expression expression2 = fieldAccess.getExpression();
            ITypeBinding iTypeBinding = expression2.resolveTypeBinding();
            if (iTypeBinding == null) {
                return false;
            }
            if (!iTypeBinding.isArray()) {
                return false;
            }
            IBinding iBinding = ConvertForLoopOperation.getBinding(expression2);
            if (iBinding == null) {
                return false;
            }
            this.fArrayBinding = iBinding;
            this.fArrayAccess = expression2;
            return true;
        }
        return false;
    }

    private boolean validateUpdaters(ForStatement forStatement) {
        List list = forStatement.updaters();
        if (list.size() != 1) {
            return false;
        }
        Expression expression = (Expression)list.get(0);
        if (expression instanceof PostfixExpression) {
            PostfixExpression postfixExpression = (PostfixExpression)expression;
            if (!PostfixExpression.Operator.INCREMENT.equals(postfixExpression.getOperator())) {
                return false;
            }
            IBinding iBinding = ConvertForLoopOperation.getBinding(postfixExpression.getOperand());
            return this.fIndexBinding.equals((Object)iBinding);
        }
        if (expression instanceof Assignment) {
            Assignment assignment = (Assignment)expression;
            Expression expression2 = assignment.getLeftHandSide();
            IBinding iBinding = ConvertForLoopOperation.getBinding(expression2);
            if (!this.fIndexBinding.equals((Object)iBinding)) {
                return false;
            }
            if (Assignment.Operator.PLUS_ASSIGN.equals(assignment.getOperator())) {
                return this.isOneLiteral(assignment.getRightHandSide());
            }
            if (Assignment.Operator.ASSIGN.equals(assignment.getOperator())) {
                Expression expression3 = assignment.getRightHandSide();
                if (!(expression3 instanceof InfixExpression)) {
                    return false;
                }
                InfixExpression infixExpression = (InfixExpression)expression3;
                Expression expression4 = infixExpression.getLeftOperand();
                IBinding iBinding2 = ConvertForLoopOperation.getBinding(expression4);
                Expression expression5 = infixExpression.getRightOperand();
                IBinding iBinding3 = ConvertForLoopOperation.getBinding(expression5);
                if (this.fIndexBinding.equals((Object)iBinding2)) {
                    return this.isOneLiteral(expression5);
                }
                if (this.fIndexBinding.equals((Object)iBinding3)) {
                    return this.isOneLiteral(expression4);
                }
            }
        }
        return false;
    }

    private boolean isOneLiteral(Expression expression) {
        if (!(expression instanceof NumberLiteral)) {
            return false;
        }
        NumberLiteral numberLiteral = (NumberLiteral)expression;
        return LITERAL_1.equals(numberLiteral.getToken());
    }

    private boolean validateBody(ForStatement forStatement) {
        Statement statement = forStatement.getBody();
        try {
            statement.accept((ASTVisitor)new GenericVisitor(){

                protected boolean visitNode(ASTNode aSTNode) {
                    if (aSTNode instanceof Name) {
                        Name name = (Name)aSTNode;
                        IBinding iBinding = name.resolveBinding();
                        if (iBinding == null) {
                            throw new InvalidBodyError();
                        }
                        if (iBinding.equals((Object)ConvertForLoopOperation.this.fIndexBinding)) {
                            if (aSTNode.getLocationInParent() != ArrayAccess.INDEX_PROPERTY) {
                                throw new InvalidBodyError();
                            }
                            ArrayAccess arrayAccess = (ArrayAccess)aSTNode.getParent();
                            Expression expression = arrayAccess.getArray();
                            IBinding iBinding2 = ConvertForLoopOperation.getBinding(expression);
                            if (iBinding2 == null) {
                                throw new InvalidBodyError();
                            }
                            if (!ConvertForLoopOperation.this.fArrayBinding.equals((Object)iBinding2)) {
                                throw new InvalidBodyError();
                            }
                        } else if (iBinding.equals((Object)ConvertForLoopOperation.this.fArrayBinding)) {
                            ASTNode aSTNode2 = aSTNode;
                            while (aSTNode2 != null && !(aSTNode2 instanceof Statement)) {
                                if (aSTNode2.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                                    throw new InvalidBodyError();
                                }
                                if (aSTNode2 instanceof PrefixExpression) {
                                    throw new InvalidBodyError();
                                }
                                if (aSTNode2 instanceof PostfixExpression) {
                                    throw new InvalidBodyError();
                                }
                                aSTNode2 = aSTNode2.getParent();
                            }
                        } else if (iBinding.equals((Object)ConvertForLoopOperation.this.fLengthBinding)) {
                            throw new InvalidBodyError();
                        }
                    }
                    return true;
                }

                public boolean visit(ArrayAccess arrayAccess) {
                    if (ConvertForLoopOperation.this.fElementDeclaration != null) {
                        return super.visit(arrayAccess);
                    }
                    IBinding iBinding = ConvertForLoopOperation.getBinding(arrayAccess.getArray());
                    if (ConvertForLoopOperation.this.fArrayBinding.equals((Object)iBinding)) {
                        IBinding iBinding2 = ConvertForLoopOperation.getBinding(arrayAccess.getIndex());
                        if (ConvertForLoopOperation.this.fIndexBinding.equals((Object)iBinding2) && arrayAccess.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                            ConvertForLoopOperation.this.fElementDeclaration = (VariableDeclarationFragment)arrayAccess.getParent();
                        }
                    }
                    return super.visit(arrayAccess);
                }
            });
        }
        catch (InvalidBodyError invalidBodyError) {
            return false;
        }
        return true;
    }

    private static IBinding getBinding(Expression expression) {
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).resolveFieldBinding();
        }
        if (expression instanceof Name) {
            return ((Name)expression).resolveBinding();
        }
        return null;
    }

    public String getIntroducedVariableName() {
        if (this.fElementDeclaration != null) {
            return this.fElementDeclaration.getName().getIdentifier();
        }
        ForStatement forStatement = this.getForStatement();
        IJavaProject iJavaProject = ((CompilationUnit)forStatement.getRoot()).getJavaElement().getJavaProject();
        String[] stringArray = this.getVariableNameProposals(this.fArrayAccess.resolveTypeBinding(), iJavaProject);
        return stringArray[0];
    }

    public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list, LinkedProposalModel linkedProposalModel) throws CoreException {
        TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description);
        list.add(textEditGroup);
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        TightSourceRangeComputer tightSourceRangeComputer = aSTRewrite.getExtendedSourceRangeComputer() instanceof TightSourceRangeComputer ? (TightSourceRangeComputer)aSTRewrite.getExtendedSourceRangeComputer() : new TightSourceRangeComputer();
        tightSourceRangeComputer.addTightSourceNode((ASTNode)this.getForStatement());
        aSTRewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)tightSourceRangeComputer);
        Statement statement = this.convert(compilationUnitRewrite, textEditGroup, linkedProposalModel);
        aSTRewrite.replace((ASTNode)this.getForStatement(), (ASTNode)statement, textEditGroup);
    }

    protected Statement convert(CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup, LinkedProposalModel linkedProposalModel) throws CoreException {
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        ImportRewrite importRewrite = compilationUnitRewrite.getImportRewrite();
        ForStatement forStatement = this.getForStatement();
        IJavaProject iJavaProject = ((CompilationUnit)forStatement.getRoot()).getJavaElement().getJavaProject();
        String[] stringArray = this.getVariableNameProposals(this.fArrayAccess.resolveTypeBinding(), iJavaProject);
        String string = this.fElementDeclaration != null ? this.fElementDeclaration.getName().getIdentifier() : stringArray[0];
        LinkedProposalPositionGroup linkedProposalPositionGroup = linkedProposalModel.getPositionGroup(string, true);
        if (this.fElementDeclaration != null) {
            linkedProposalPositionGroup.addProposal(string, null, 10);
        }
        int n = 0;
        while (n < stringArray.length) {
            linkedProposalPositionGroup.addProposal(stringArray[n], null, 10);
            ++n;
        }
        AST aST = forStatement.getAST();
        EnhancedForStatement enhancedForStatement = aST.newEnhancedForStatement();
        SingleVariableDeclaration singleVariableDeclaration = this.createParameterDeclaration(string, this.fElementDeclaration, this.fArrayAccess, forStatement, importRewrite, aSTRewrite, textEditGroup, linkedProposalPositionGroup, this.fMakeFinal);
        enhancedForStatement.setParameter(singleVariableDeclaration);
        enhancedForStatement.setExpression((Expression)aSTRewrite.createCopyTarget((ASTNode)this.fArrayAccess));
        this.convertBody(forStatement.getBody(), (IBinding)this.fIndexBinding, this.fArrayBinding, string, aSTRewrite, textEditGroup, linkedProposalPositionGroup);
        enhancedForStatement.setBody(this.getBody(compilationUnitRewrite, textEditGroup, linkedProposalModel));
        linkedProposalModel.setEndPosition(aSTRewrite.track((ASTNode)enhancedForStatement));
        return enhancedForStatement;
    }

    private void convertBody(Statement statement, final IBinding iBinding, final IBinding iBinding2, final String string, final ASTRewrite aSTRewrite, final TextEditGroup textEditGroup, final LinkedProposalPositionGroup linkedProposalPositionGroup) {
        final AST aST = statement.getAST();
        final HashSet hashSet = new HashSet();
        statement.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(ArrayAccess arrayAccess) {
                IBinding iBinding3;
                IBinding iBinding22 = ConvertForLoopOperation.getBinding(arrayAccess.getArray());
                if (iBinding2.equals((Object)iBinding22) && iBinding.equals((Object)(iBinding3 = ConvertForLoopOperation.getBinding(arrayAccess.getIndex())))) {
                    this.replaceAccess((ASTNode)arrayAccess);
                }
                return super.visit(arrayAccess);
            }

            public boolean visit(SimpleName simpleName) {
                if (hashSet.contains(simpleName.resolveBinding())) {
                    this.replaceAccess((ASTNode)simpleName);
                }
                return super.visit(simpleName);
            }

            private void replaceAccess(ASTNode aSTNode) {
                if (aSTNode.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                    VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode.getParent();
                    IBinding iBinding3 = variableDeclarationFragment.getName().resolveBinding();
                    if (iBinding3 != null) {
                        hashSet.add(iBinding3);
                        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)variableDeclarationFragment.getParent();
                        if (variableDeclarationStatement.fragments().size() == 1) {
                            aSTRewrite.remove((ASTNode)variableDeclarationStatement, textEditGroup);
                        } else {
                            ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)variableDeclarationStatement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                            listRewrite.remove((ASTNode)variableDeclarationFragment, textEditGroup);
                        }
                    } else {
                        SimpleName simpleName = aST.newSimpleName(string);
                        aSTRewrite.replace(aSTNode, (ASTNode)simpleName, textEditGroup);
                        linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)simpleName), true);
                    }
                } else {
                    SimpleName simpleName = aST.newSimpleName(string);
                    aSTRewrite.replace(aSTNode, (ASTNode)simpleName, textEditGroup);
                    linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)simpleName), true);
                }
            }
        });
    }

    private SingleVariableDeclaration createParameterDeclaration(String string, VariableDeclarationFragment variableDeclarationFragment, Expression expression, ForStatement forStatement, ImportRewrite importRewrite, ASTRewrite aSTRewrite, TextEditGroup textEditGroup, LinkedProposalPositionGroup linkedProposalPositionGroup, boolean bl) {
        CompilationUnit compilationUnit = (CompilationUnit)expression.getRoot();
        AST aST = compilationUnit.getAST();
        SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
        SimpleName simpleName = aST.newSimpleName(string);
        linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)simpleName), true);
        singleVariableDeclaration.setName(simpleName);
        ITypeBinding iTypeBinding = expression.resolveTypeBinding();
        Type type = this.importType(iTypeBinding.getElementType(), (ASTNode)forStatement, importRewrite, compilationUnit);
        if (iTypeBinding.getDimensions() != 1) {
            type = aST.newArrayType(type, iTypeBinding.getDimensions() - 1);
        }
        singleVariableDeclaration.setType(type);
        if (variableDeclarationFragment != null) {
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)variableDeclarationFragment.getParent();
            ModifierRewrite.create(aSTRewrite, (ASTNode)singleVariableDeclaration).copyAllModifiers((ASTNode)variableDeclarationStatement, textEditGroup);
        }
        if (bl) {
            ModifierRewrite.create(aSTRewrite, (ASTNode)singleVariableDeclaration).setModifiers(16, 0, textEditGroup);
        }
        return singleVariableDeclaration;
    }

    private String[] getVariableNameProposals(ITypeBinding iTypeBinding, IJavaProject iJavaProject) {
        String[] stringArray = this.getUsedVariableNames();
        String[] stringArray2 = StubUtility.getLocalNameSuggestions(iJavaProject, "element", 0, stringArray);
        String string = iTypeBinding.getElementType().getName();
        String[] stringArray3 = StubUtility.getLocalNameSuggestions(iJavaProject, string, iTypeBinding.getDimensions() - 1, stringArray);
        String[] stringArray4 = new String[stringArray2.length + stringArray3.length];
        System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray2.length);
        System.arraycopy(stringArray3, 0, stringArray4, stringArray2.length, stringArray3.length);
        return stringArray4;
    }

    private static final class InvalidBodyError
    extends Error {
        private static final long serialVersionUID = 1L;

        private InvalidBodyError() {
        }
    }
}

