/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.javadoc;

import org.eclipse.jface.internal.text.html.SingleCharReader;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;

public class JavaDocCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(IBuffer iBuffer, int n, int n2) {
        this.fBuffer = iBuffer;
        this.fStartPos = n + 3;
        this.fEndPos = n2 - 2;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        char c;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                c = this.fBuffer.getChar(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(c));
            if (c == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((c = this.fBuffer.getChar(this.fCurrPos++)) == '*') {
                }
            }
        } else {
            c = this.fBuffer.getChar(this.fCurrPos++);
        }
        this.fWasNewLine = IndentManipulation.isLineDelimiterChar((char)c);
        return c;
    }

    public void close() {
        this.fBuffer = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

