/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;

public abstract class AbstractJavaElementRenameChange
extends JDTChange {
    private final String fNewName;
    private final String fOldName;
    private final IPath fResourcePath;
    private final long fStampToRestore;

    protected AbstractJavaElementRenameChange(IPath iPath, String string, String string2) {
        this(iPath, string, string2, -1L);
    }

    protected AbstractJavaElementRenameChange(IPath iPath, String string, String string2, long l) {
        Assert.isNotNull((Object)string2, (String)"new name");
        Assert.isNotNull((Object)string, (String)"old name");
        this.fResourcePath = iPath;
        this.fOldName = string;
        this.fNewName = string2;
        this.fStampToRestore = l;
    }

    protected abstract IPath createNewPath();

    protected abstract Change createUndoChange(long var1) throws CoreException;

    protected abstract void doRename(IProgressMonitor var1) throws CoreException;

    public Object getModifiedElement() {
        return JavaCore.create((IResource)this.getResource());
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getOldName() {
        return this.fOldName;
    }

    protected final IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    protected IPath getResourcePath() {
        return this.fResourcePath;
    }

    public final Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
        Change change;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.AbstractRenameChange_Renaming, 1);
            IResource iResource = this.getResource();
            IPath iPath = this.createNewPath();
            Change change2 = this.createUndoChange(iResource.getModificationStamp());
            this.doRename((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fStampToRestore != -1L) {
                IResource iResource2 = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
                iResource2.revertModificationStamp(this.fStampToRestore);
            }
            change = change2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return change;
    }
}

