/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.base;

import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

public abstract class JavaStatusContext
extends RefactoringStatusContext {
    public static RefactoringStatusContext create(IMember iMember) {
        if (iMember == null || !iMember.exists()) {
            return null;
        }
        return new MemberSourceContext(iMember);
    }

    public static RefactoringStatusContext create(IImportDeclaration iImportDeclaration) {
        if (iImportDeclaration == null || !iImportDeclaration.exists()) {
            return null;
        }
        return new ImportDeclarationSourceContext(iImportDeclaration);
    }

    public static RefactoringStatusContext create(IMethodBinding iMethodBinding) {
        return JavaStatusContext.create((IMember)((IMethod)iMethodBinding.getJavaElement()));
    }

    public static RefactoringStatusContext create(ITypeRoot iTypeRoot) {
        return JavaStatusContext.create(iTypeRoot, null);
    }

    public static RefactoringStatusContext create(ITypeRoot iTypeRoot, ISourceRange iSourceRange) {
        if (iTypeRoot instanceof ICompilationUnit) {
            return new CompilationUnitSourceContext((ICompilationUnit)iTypeRoot, iSourceRange);
        }
        if (iTypeRoot instanceof IClassFile) {
            return new ClassFileSourceContext((IClassFile)iTypeRoot, iSourceRange);
        }
        return null;
    }

    public static RefactoringStatusContext create(ITypeRoot iTypeRoot, ASTNode aSTNode) {
        SourceRange sourceRange = null;
        if (aSTNode != null) {
            sourceRange = new SourceRange(aSTNode.getStartPosition(), aSTNode.getLength());
        }
        return JavaStatusContext.create(iTypeRoot, sourceRange);
    }

    public static RefactoringStatusContext create(ITypeRoot iTypeRoot, Selection selection) {
        SourceRange sourceRange = null;
        if (selection != null) {
            sourceRange = new SourceRange(selection.getOffset(), selection.getLength());
        }
        return JavaStatusContext.create(iTypeRoot, sourceRange);
    }

    public abstract boolean isBinary();

    public abstract ICompilationUnit getCompilationUnit();

    public abstract IClassFile getClassFile();

    public abstract ISourceRange getSourceRange();

    public Object getCorrespondingElement() {
        if (this.isBinary()) {
            return this.getClassFile();
        }
        return this.getCompilationUnit();
    }

    private static class ClassFileSourceContext
    extends JavaStatusContext {
        private IClassFile fClassFile;
        private ISourceRange fSourceRange;

        private ClassFileSourceContext(IClassFile iClassFile, ISourceRange iSourceRange) {
            this.fClassFile = iClassFile;
            this.fSourceRange = iSourceRange;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        public boolean isBinary() {
            return true;
        }

        public ICompilationUnit getCompilationUnit() {
            return null;
        }

        public IClassFile getClassFile() {
            return this.fClassFile;
        }

        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return this.getSourceRange() + " in " + super.toString();
        }
    }

    private static class CompilationUnitSourceContext
    extends JavaStatusContext {
        private ICompilationUnit fCUnit;
        private ISourceRange fSourceRange;

        private CompilationUnitSourceContext(ICompilationUnit iCompilationUnit, ISourceRange iSourceRange) {
            this.fCUnit = iCompilationUnit;
            this.fSourceRange = iSourceRange;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        public boolean isBinary() {
            return false;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCUnit;
        }

        public IClassFile getClassFile() {
            return null;
        }

        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return this.getSourceRange() + " in " + super.toString();
        }
    }

    private static class ImportDeclarationSourceContext
    extends JavaStatusContext {
        private IImportDeclaration fImportDeclartion;

        private ImportDeclarationSourceContext(IImportDeclaration iImportDeclaration) {
            this.fImportDeclartion = iImportDeclaration;
        }

        public boolean isBinary() {
            return false;
        }

        public ICompilationUnit getCompilationUnit() {
            return (ICompilationUnit)this.fImportDeclartion.getParent().getParent();
        }

        public IClassFile getClassFile() {
            return null;
        }

        public ISourceRange getSourceRange() {
            try {
                return this.fImportDeclartion.getSourceRange();
            }
            catch (JavaModelException javaModelException) {
                return new SourceRange(0, 0);
            }
        }
    }

    private static class MemberSourceContext
    extends JavaStatusContext {
        private IMember fMember;

        private MemberSourceContext(IMember iMember) {
            this.fMember = iMember;
        }

        public boolean isBinary() {
            return this.fMember.isBinary();
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fMember.getCompilationUnit();
        }

        public IClassFile getClassFile() {
            return this.fMember.getClassFile();
        }

        public ISourceRange getSourceRange() {
            try {
                return this.fMember.getSourceRange();
            }
            catch (JavaModelException javaModelException) {
                return new SourceRange(0, 0);
            }
        }
    }
}

