/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

abstract class CompilationUnitReorgChange
extends JDTChange {
    private String fCuHandle;
    private String fOldPackageHandle;
    private String fNewPackageHandle;
    private INewNameQuery fNewNameQuery;
    static /* synthetic */ Class class$0;

    CompilationUnitReorgChange(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment, INewNameQuery iNewNameQuery) {
        this.fCuHandle = iCompilationUnit.getHandleIdentifier();
        this.fNewPackageHandle = iPackageFragment.getHandleIdentifier();
        this.fNewNameQuery = iNewNameQuery;
        this.fOldPackageHandle = iCompilationUnit.getParent().getHandleIdentifier();
    }

    CompilationUnitReorgChange(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment) {
        this(iCompilationUnit, iPackageFragment, null);
    }

    CompilationUnitReorgChange(String string, String string2, String string3) {
        this.fOldPackageHandle = string;
        this.fNewPackageHandle = string2;
        this.fCuHandle = string3;
    }

    public final Change perform(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        Change change;
        iProgressMonitor.beginTask(this.getName(), 1);
        try {
            ICompilationUnit iCompilationUnit = this.getCu();
            ResourceMapping resourceMapping = JavaElementResourceMapping.create(iCompilationUnit);
            Change change2 = this.doPerformReorg((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.markAsExecuted(iCompilationUnit, resourceMapping);
            change = change2;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return change;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public Object getModifiedElement() {
        return this.getCu();
    }

    ICompilationUnit getCu() {
        return (ICompilationUnit)JavaCore.create((String)this.fCuHandle);
    }

    IPackageFragment getOldPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fOldPackageHandle);
    }

    IPackageFragment getDestinationPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fNewPackageHandle);
    }

    String getNewName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return null;
        }
        return this.fNewNameQuery.getNewName();
    }

    static String getPackageName(IPackageFragment iPackageFragment) {
        if (iPackageFragment.isDefaultPackage()) {
            return RefactoringCoreMessages.MoveCompilationUnitChange_default_package;
        }
        return iPackageFragment.getElementName();
    }

    private void markAsExecuted(ICompilationUnit iCompilationUnit, ResourceMapping resourceMapping) {
        ReorgExecutionLog reorgExecutionLog;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reorgExecutionLog = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            reorgExecutionLog.markAsProcessed((Object)iCompilationUnit);
            reorgExecutionLog.markAsProcessed((Object)resourceMapping);
        }
    }
}

