/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenamePackageChange
extends AbstractJavaElementRenameChange {
    private Map fCompilationUnitStamps;
    private final boolean fRenameSubpackages;

    private static IPath createPath(String string) {
        return new Path(string.replace('.', '/'));
    }

    public RenamePackageChange(IPackageFragment iPackageFragment, String string, boolean bl) {
        this(iPackageFragment.getPath(), iPackageFragment.getElementName(), string, -1L, null, bl);
        Assert.isTrue((!iPackageFragment.isReadOnly() ? 1 : 0) != 0, (String)"package must not be read only");
    }

    private RenamePackageChange(IPath iPath, String string, String string2, long l, Map map, boolean bl) {
        super(iPath, string, string2, l);
        this.fCompilationUnitStamps = map;
        this.fRenameSubpackages = bl;
    }

    private void addStamps(Map map, ICompilationUnit[] iCompilationUnitArray) {
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            IResource iResource = iCompilationUnitArray[n].getResource();
            long l = -1L;
            if (iResource != null && (l = iResource.getModificationStamp()) != -1L) {
                map.put(iResource, new Long(l));
            }
            ++n;
        }
    }

    protected IPath createNewPath() {
        IPackageFragment iPackageFragment = this.getPackage();
        IPath iPath = RenamePackageChange.createPath(iPackageFragment.getElementName());
        IPath iPath2 = RenamePackageChange.createPath(this.getNewName());
        return this.getResourcePath().removeLastSegments(iPath.segmentCount()).append(iPath2);
    }

    protected IPath createNewPath(IPackageFragment iPackageFragment) {
        IPath iPath = RenamePackageChange.createPath(iPackageFragment.getElementName());
        IPath iPath2 = RenamePackageChange.createPath(this.getNewName(iPackageFragment));
        return iPackageFragment.getPath().removeLastSegments(iPath.segmentCount()).append(iPath2);
    }

    protected Change createUndoChange(long l) throws CoreException {
        IPackageFragment iPackageFragment = this.getPackage();
        if (iPackageFragment == null) {
            return new NullChange();
        }
        HashMap hashMap = new HashMap();
        if (!this.fRenameSubpackages) {
            this.addStamps(hashMap, iPackageFragment.getCompilationUnits());
        } else {
            IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(iPackageFragment);
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment2 = iPackageFragmentArray[n];
                this.addStamps(hashMap, iPackageFragment2.getCompilationUnits());
                ++n;
            }
        }
        return new RenamePackageChange(this.createNewPath(), this.getNewName(), this.getOldName(), l, hashMap, this.fRenameSubpackages);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRename(IProgressMonitor iProgressMonitor) throws CoreException {
        IPackageFragment iPackageFragment = this.getPackage();
        if (iPackageFragment == null) {
            return;
        }
        if (!this.fRenameSubpackages) {
            this.renamePackage(iPackageFragment, iProgressMonitor, this.createNewPath(), this.getNewName());
            return;
        }
        IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(iPackageFragment);
        iProgressMonitor.beginTask("", iPackageFragmentArray.length);
        try {
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment2 = iPackageFragmentArray[n];
                this.renamePackage(iPackageFragment2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), this.createNewPath(iPackageFragment2), this.getNewName(iPackageFragment2));
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        iProgressMonitor.done();
    }

    public String getName() {
        String string = this.fRenameSubpackages ? RefactoringCoreMessages.RenamePackageChange_name_with_subpackages : RefactoringCoreMessages.RenamePackageChange_name;
        return Messages.format(string, new String[]{this.getOldName(), this.getNewName()});
    }

    private String getNewName(IPackageFragment iPackageFragment) {
        return String.valueOf(this.getNewName()) + iPackageFragment.getElementName().substring(this.getOldName().length());
    }

    private IPackageFragment getPackage() {
        return (IPackageFragment)this.getModifiedElement();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block8: {
            RefactoringStatus refactoringStatus2;
            block9: {
                RefactoringStatus refactoringStatus3;
                block7: {
                    iProgressMonitor.beginTask("", 2);
                    try {
                        refactoringStatus = new RefactoringStatus();
                        IJavaElement iJavaElement = (IJavaElement)this.getModifiedElement();
                        refactoringStatus.merge(this.isValid((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), 2));
                        if (refactoringStatus.hasFatalError()) {
                            refactoringStatus3 = refactoringStatus;
                            Object var8_6 = null;
                            break block7;
                        }
                        if (iJavaElement == null || !iJavaElement.exists() || !(iJavaElement instanceof IPackageFragment)) break block8;
                        IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                        if (this.fRenameSubpackages) {
                            IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(iPackageFragment);
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            subProgressMonitor.beginTask("", iPackageFragmentArray.length);
                            int n = 0;
                            while (n < iPackageFragmentArray.length) {
                                RenamePackageChange.checkIfModifiable(refactoringStatus, iPackageFragmentArray[n], 2);
                                if (refactoringStatus.hasFatalError()) {
                                    refactoringStatus2 = refactoringStatus;
                                    break block9;
                                }
                                this.isValid(refactoringStatus, iPackageFragmentArray[n], (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                                ++n;
                            }
                            break block8;
                        }
                        this.isValid(refactoringStatus, iPackageFragment, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                }
                iProgressMonitor.done();
                return refactoringStatus3;
            }
            Object var8_7 = null;
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        Object var8_9 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private void isValid(RefactoringStatus refactoringStatus, IPackageFragment iPackageFragment, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray = iPackageFragment.getCompilationUnits();
        iProgressMonitor.beginTask("", iCompilationUnitArray.length);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            iProgressMonitor.subTask(Messages.format(RefactoringCoreMessages.RenamePackageChange_checking_change, iPackageFragment.getElementName()));
            RenamePackageChange.checkIfModifiable(refactoringStatus, iCompilationUnitArray[n], 3);
            iProgressMonitor.worked(1);
            ++n;
        }
        iProgressMonitor.done();
    }

    private void renamePackage(IPackageFragment iPackageFragment, IProgressMonitor iProgressMonitor, IPath iPath, String string) throws JavaModelException, CoreException {
        IPackageFragment iPackageFragment2;
        iPackageFragment.rename(string, false, iProgressMonitor);
        if (this.fCompilationUnitStamps != null && (iPackageFragment2 = (IPackageFragment)JavaCore.create((IFolder)ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath))).exists()) {
            ICompilationUnit[] iCompilationUnitArray = iPackageFragment2.getCompilationUnits();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                Long l;
                IResource iResource = iCompilationUnitArray[n].getResource();
                if (iResource != null && (l = (Long)this.fCompilationUnitStamps.get(iResource)) != null) {
                    iResource.revertModificationStamp(l.longValue());
                }
                ++n;
            }
        }
    }
}

