/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

class NameCollector
extends GenericVisitor {
    private List names = new ArrayList();
    private Selection fSelection;

    public NameCollector(ASTNode aSTNode) {
        this.fSelection = Selection.createFromStartLength(aSTNode.getStartPosition(), aSTNode.getLength());
    }

    protected boolean visitNode(ASTNode aSTNode) {
        if (aSTNode.getStartPosition() > this.fSelection.getInclusiveEnd()) {
            return true;
        }
        return this.fSelection.coveredBy(aSTNode);
    }

    public boolean visit(SimpleName simpleName) {
        this.names.add(simpleName.getIdentifier());
        return super.visit(simpleName);
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        return true;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        boolean bl = super.visit(variableDeclarationFragment);
        if (!bl) {
            this.names.add(variableDeclarationFragment.getName().getIdentifier());
        }
        return bl;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        boolean bl = super.visit(singleVariableDeclaration);
        if (!bl) {
            this.names.add(singleVariableDeclaration.getName().getIdentifier());
        }
        return bl;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        this.names.add(typeDeclarationStatement.getDeclaration().getName().getIdentifier());
        return false;
    }

    List getNames() {
        return this.names;
    }
}

