/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;

abstract class TargetProvider {
    public static final boolean BUG_CORE_130317 = true;
    protected SourceProvider fSourceProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    TargetProvider() {
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        Assert.isNotNull((Object)sourceProvider);
        this.fSourceProvider = sourceProvider;
    }

    public abstract void initialize();

    public abstract ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus var1, IProgressMonitor var2) throws JavaModelException;

    public abstract BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit var1, IProgressMonitor var2);

    public abstract ASTNode[] getInvocations(BodyDeclaration var1, IProgressMonitor var2);

    public abstract RefactoringStatus checkActivation() throws JavaModelException;

    public abstract int getStatusSeverity();

    public boolean isSingle() {
        return false;
    }

    public static TargetProvider create(ICompilationUnit iCompilationUnit, MethodInvocation methodInvocation) {
        return new SingleCallTargetProvider(iCompilationUnit, (ASTNode)methodInvocation);
    }

    public static TargetProvider create(ICompilationUnit iCompilationUnit, SuperMethodInvocation superMethodInvocation) {
        return new SingleCallTargetProvider(iCompilationUnit, (ASTNode)superMethodInvocation);
    }

    public static TargetProvider create(ICompilationUnit iCompilationUnit, ConstructorInvocation constructorInvocation) {
        return new SingleCallTargetProvider(iCompilationUnit, (ASTNode)constructorInvocation);
    }

    public static TargetProvider create(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
        if (iMethodBinding == null) {
            return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_method_declaration_not_unique));
        }
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        if (iTypeBinding.isLocal()) {
            if (((IType)iTypeBinding.getJavaElement()).isBinary()) {
                return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_cannot_local_method_in_binary));
            }
            IType iType = (IType)iTypeBinding.getDeclaringClass().getJavaElement();
            return new LocalTypeTargetProvider(iType.getCompilationUnit(), methodDeclaration);
        }
        return new MemberTypeTargetProvider(methodDeclaration.resolveBinding());
    }

    public static TargetProvider create(IMethodBinding iMethodBinding) {
        return new MemberTypeTargetProvider(iMethodBinding);
    }

    static void fastDone(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            return;
        }
        iProgressMonitor.beginTask("", 1);
        iProgressMonitor.worked(1);
        iProgressMonitor.done();
    }

    private static class BodyData {
        public BodyDeclaration fBody;
        private List fInvocations;

        public BodyData(BodyDeclaration bodyDeclaration) {
            this.fBody = bodyDeclaration;
        }

        public void addInvocation(ASTNode aSTNode) {
            if (this.fInvocations == null) {
                this.fInvocations = new ArrayList(2);
            }
            this.fInvocations.add(aSTNode);
        }

        public ASTNode[] getInvocations() {
            return this.fInvocations.toArray(new ASTNode[this.fInvocations.size()]);
        }

        public boolean hasInvocations() {
            return this.fInvocations != null && !this.fInvocations.isEmpty();
        }

        public BodyDeclaration getDeclaration() {
            return this.fBody;
        }
    }

    static class ErrorTargetProvider
    extends TargetProvider {
        private RefactoringStatus fErrorStatus;

        public ErrorTargetProvider(RefactoringStatus refactoringStatus) {
            this.fErrorStatus = refactoringStatus;
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return this.fErrorStatus;
        }

        public void initialize() {
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) throws JavaModelException {
            return null;
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) {
            return null;
        }

        public ASTNode[] getInvocations(BodyDeclaration bodyDeclaration, IProgressMonitor iProgressMonitor) {
            return null;
        }

        public int getStatusSeverity() {
            return 0;
        }
    }

    private static class InvocationFinder
    extends ASTVisitor {
        Map result = new HashMap(2);
        Stack fBodies = new Stack();
        BodyData fCurrent;
        private IMethodBinding fBinding;

        public InvocationFinder(IMethodBinding iMethodBinding) {
            Assert.isNotNull((Object)iMethodBinding);
            this.fBinding = iMethodBinding.getMethodDeclaration();
            Assert.isNotNull((Object)this.fBinding);
        }

        public boolean visit(MethodInvocation methodInvocation) {
            if (this.matches(methodInvocation.getName().resolveBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)methodInvocation);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            if (this.matches(superMethodInvocation.getName().resolveBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)superMethodInvocation);
            }
            return true;
        }

        public boolean visit(ConstructorInvocation constructorInvocation) {
            if (this.matches((IBinding)constructorInvocation.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)constructorInvocation);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation classInstanceCreation) {
            if (this.matches((IBinding)classInstanceCreation.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)classInstanceCreation);
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            return this.visitType();
        }

        public void endVisit(TypeDeclaration typeDeclaration) {
            this.endVisitType();
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            return this.visitType();
        }

        public void endVisit(EnumDeclaration enumDeclaration) {
            this.endVisitType();
        }

        public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            return this.visitType();
        }

        public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            this.endVisitType();
        }

        private boolean visitType() {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = null;
            return true;
        }

        private void endVisitType() {
            this.fCurrent = (BodyData)this.fBodies.remove(this.fBodies.size() - 1);
        }

        public boolean visit(FieldDeclaration fieldDeclaration) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)fieldDeclaration);
            return true;
        }

        public void endVisit(FieldDeclaration fieldDeclaration) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(fieldDeclaration, this.fCurrent);
            }
            this.endVisitType();
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)methodDeclaration);
            return true;
        }

        public void endVisit(MethodDeclaration methodDeclaration) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(methodDeclaration, this.fCurrent);
            }
            this.endVisitType();
        }

        public boolean visit(Initializer initializer) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)initializer);
            return true;
        }

        public void endVisit(Initializer initializer) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(initializer, this.fCurrent);
            }
            this.endVisitType();
        }

        private boolean matches(IBinding iBinding) {
            if (!(iBinding instanceof IMethodBinding)) {
                return false;
            }
            return this.fBinding.getKey().equals(((IMethodBinding)iBinding).getMethodDeclaration().getKey());
        }
    }

    private static class LocalTypeTargetProvider
    extends TargetProvider {
        private ICompilationUnit fCUnit;
        private MethodDeclaration fDeclaration;
        private Map fBodies;

        public LocalTypeTargetProvider(ICompilationUnit iCompilationUnit, MethodDeclaration methodDeclaration) {
            Assert.isNotNull((Object)iCompilationUnit);
            Assert.isNotNull((Object)methodDeclaration);
            this.fCUnit = iCompilationUnit;
            this.fDeclaration = methodDeclaration;
        }

        public void initialize() {
            InvocationFinder invocationFinder = new InvocationFinder(this.fDeclaration.resolveBinding());
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ASTNode aSTNode = ASTNodes.getParent((ASTNode)this.fDeclaration, clazz);
            aSTNode.accept((ASTVisitor)invocationFinder);
            this.fBodies = invocationFinder.result;
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) {
            LocalTypeTargetProvider.fastDone(iProgressMonitor);
            return new ICompilationUnit[]{this.fCUnit};
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) {
            Assert.isTrue((iCompilationUnit == this.fCUnit ? 1 : 0) != 0);
            Set set = this.fBodies.keySet();
            LocalTypeTargetProvider.fastDone(iProgressMonitor);
            return set.toArray(new BodyDeclaration[set.size()]);
        }

        public ASTNode[] getInvocations(BodyDeclaration bodyDeclaration, IProgressMonitor iProgressMonitor) {
            BodyData bodyData = (BodyData)this.fBodies.get(bodyDeclaration);
            Assert.isNotNull((Object)bodyData);
            LocalTypeTargetProvider.fastDone(iProgressMonitor);
            return bodyData.getInvocations();
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 3;
        }
    }

    private static class MemberTypeTargetProvider
    extends TargetProvider {
        private final IMethodBinding fMethodBinding;
        private Map fCurrentBodies;

        public MemberTypeTargetProvider(IMethodBinding iMethodBinding) {
            Assert.isNotNull((Object)iMethodBinding);
            this.fMethodBinding = iMethodBinding;
        }

        public void initialize() {
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) throws JavaModelException {
            IMethod iMethod = (IMethod)this.fMethodBinding.getJavaElement();
            Assert.isTrue((iMethod != null ? 1 : 0) != 0);
            RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)iMethod, (int)2, (int)24));
            refactoringSearchEngine2.setGranularity(2);
            refactoringSearchEngine2.setFiltering(true, true);
            refactoringSearchEngine2.setScope(RefactoringScopeFactory.create((IJavaElement)iMethod));
            refactoringSearchEngine2.setRequestor(new IRefactoringSearchRequestor(this, refactoringStatus){
                final /* synthetic */ MemberTypeTargetProvider this$1;
                private final /* synthetic */ RefactoringStatus val$status;
                {
                    this.this$1 = memberTypeTargetProvider;
                    this.val$status = refactoringStatus;
                }

                public SearchMatch acceptSearchMatch(SearchMatch searchMatch) {
                    if (searchMatch.isInsideDocComment()) {
                        return null;
                    }
                    if (searchMatch.getAccuracy() == 1) {
                        IJavaElement iJavaElement;
                        ICompilationUnit iCompilationUnit;
                        Object object = searchMatch.getElement();
                        if (object instanceof IJavaElement && (iCompilationUnit = (ICompilationUnit)(iJavaElement = (IJavaElement)object).getAncestor(5)) != null) {
                            this.val$status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match, JavaStatusContext.create((ITypeRoot)iCompilationUnit, new SourceRange(searchMatch.getOffset(), searchMatch.getLength())));
                            return null;
                        }
                        this.val$status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match);
                        return null;
                    }
                    return searchMatch;
                }
            });
            refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            return refactoringSearchEngine2.getAffectedCompilationUnits();
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) {
            CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, true);
            InvocationFinder invocationFinder = new InvocationFinder(this.fMethodBinding);
            compilationUnit.accept((ASTVisitor)invocationFinder);
            this.fCurrentBodies = invocationFinder.result;
            Set set = this.fCurrentBodies.keySet();
            MemberTypeTargetProvider.fastDone(iProgressMonitor);
            return set.toArray(new BodyDeclaration[set.size()]);
        }

        public ASTNode[] getInvocations(BodyDeclaration bodyDeclaration, IProgressMonitor iProgressMonitor) {
            BodyData bodyData = (BodyData)this.fCurrentBodies.get(bodyDeclaration);
            Assert.isNotNull((Object)bodyData);
            MemberTypeTargetProvider.fastDone(iProgressMonitor);
            return bodyData.getInvocations();
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 3;
        }
    }

    static class SingleCallTargetProvider
    extends TargetProvider {
        private ICompilationUnit fCUnit;
        private ASTNode fInvocation;
        private boolean fIterated;

        public SingleCallTargetProvider(ICompilationUnit iCompilationUnit, ASTNode aSTNode) {
            Assert.isNotNull((Object)iCompilationUnit);
            Assert.isNotNull((Object)aSTNode);
            Assert.isTrue((boolean)Invocations.isInvocation(aSTNode));
            this.fCUnit = iCompilationUnit;
            this.fInvocation = aSTNode;
        }

        public void initialize() {
            this.fIterated = false;
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) {
            return new ICompilationUnit[]{this.fCUnit};
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) {
            Assert.isTrue((iCompilationUnit == this.fCUnit ? 1 : 0) != 0);
            if (this.fIterated) {
                return new BodyDeclaration[0];
            }
            SingleCallTargetProvider.fastDone(iProgressMonitor);
            BodyDeclaration[] bodyDeclarationArray = new BodyDeclaration[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bodyDeclarationArray[0] = (BodyDeclaration)ASTNodes.getParent(this.fInvocation, clazz);
            return bodyDeclarationArray;
        }

        public ASTNode[] getInvocations(BodyDeclaration bodyDeclaration, IProgressMonitor iProgressMonitor) {
            SingleCallTargetProvider.fastDone(iProgressMonitor);
            if (this.fIterated) {
                return null;
            }
            this.fIterated = true;
            return new ASTNode[]{this.fInvocation};
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 4;
        }

        public boolean isSingle() {
            return true;
        }
    }
}

