/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.ElementStructureEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

public class ParametricStructureComputer {
    private static final boolean DEBUG_INITIALIZATION = false;
    private final ElementStructureEnvironment fElemStructureEnv = new ElementStructureEnvironment();
    private final ConstraintVariable2[] fAllConstraintVariables;
    private InferTypeArgumentsTCModel fTCModel;
    private Stack fWorkList2 = new Stack();

    public ParametricStructureComputer(ConstraintVariable2[] constraintVariable2Array, InferTypeArgumentsTCModel inferTypeArgumentsTCModel) {
        this.fAllConstraintVariables = constraintVariable2Array;
        this.fTCModel = inferTypeArgumentsTCModel;
    }

    public ElementStructureEnvironment getElemStructureEnv() {
        return this.fElemStructureEnv;
    }

    private void dumpContainerStructure() {
        System.out.println("\n*** Container Structure: ***\n");
        int n = 0;
        while (n < this.fAllConstraintVariables.length) {
            ConstraintVariable2 constraintVariable2 = this.fAllConstraintVariables[n];
            if (this.elemStructure(constraintVariable2) != null && this.elemStructure(constraintVariable2) != ParametricStructure.NONE) {
                System.out.println("elemStructure(" + constraintVariable2.toString() + ") = " + this.elemStructure(constraintVariable2));
            }
            ++n;
        }
        System.out.println();
    }

    private void setStructureAndPush(ConstraintVariable2 constraintVariable2, ParametricStructure parametricStructure) {
        this.setElemStructure(constraintVariable2, parametricStructure);
        this.fWorkList2.push(constraintVariable2);
    }

    private void initializeContainerStructure() {
        int n = 0;
        while (n < this.fAllConstraintVariables.length) {
            ConstraintVariable2 constraintVariable2 = this.fAllConstraintVariables[n];
            TType tType = ParametricStructureComputer.declaredTypeOf(constraintVariable2);
            if (tType != null) {
                if (this.isParametricType(tType) && !this.isUnmodifiableFieldOrMethod(constraintVariable2)) {
                    this.setStructureAndPush(constraintVariable2, this.newParametricType(tType));
                } else if (tType != null && !this.mightBeParametric(tType)) {
                    this.setStructureAndPush(constraintVariable2, ParametricStructure.NONE);
                }
            }
            ++n;
        }
    }

    protected static TType declaredTypeOf(ConstraintVariable2 constraintVariable2) {
        return constraintVariable2.getType();
    }

    private boolean mightBeParametric(TType tType) {
        return this.isParametricType(tType);
    }

    private void computeContainerStructure() {
        this.initializeContainerStructure();
        while (!this.fWorkList2.isEmpty()) {
            ConstraintVariable2 constraintVariable2;
            ConstraintVariable2[] constraintVariable2Array;
            ConstraintVariable2 constraintVariable22 = (ConstraintVariable2)this.fWorkList2.pop();
            List list = this.fTCModel.getUsedIn(constraintVariable22);
            Object object = list.iterator();
            while (object.hasNext()) {
                constraintVariable2Array = (ConstraintVariable2[])object.next();
                ConstraintVariable2 constraintVariable23 = constraintVariable2Array.getLeft();
                constraintVariable2 = constraintVariable2Array.getRight();
                this.unifyContainerStructure(constraintVariable23, constraintVariable2);
            }
            object = constraintVariable22.getTypeEquivalenceSet();
            if (object == null) continue;
            constraintVariable2Array = ((TypeEquivalenceSet)object).getContributingVariables();
            int n = 0;
            while (n + 1 < constraintVariable2Array.length) {
                constraintVariable2 = constraintVariable2Array[n];
                ConstraintVariable2 constraintVariable24 = constraintVariable2Array[n + 1];
                this.unifyContainerStructure(constraintVariable2, constraintVariable24);
                ++n;
            }
        }
    }

    private void unifyContainerStructure(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        if (this.isUnmodifiableFieldOrMethod(constraintVariable2) || this.isUnmodifiableFieldOrMethod(constraintVariable22)) {
            return;
        }
        if (this.updateStructureOfVar(constraintVariable2, this.elemStructure(constraintVariable22), TypeOperator.SubType)) {
            if (constraintVariable2 instanceof CollectionElementVariable2) {
                this.updateParentContainerStructureFrom((CollectionElementVariable2)constraintVariable2, constraintVariable22);
            }
            this.updateElementVarStructureFromParent(constraintVariable2);
        }
        if (this.updateStructureOfVar(constraintVariable22, this.elemStructure(constraintVariable2), TypeOperator.SuperType)) {
            if (constraintVariable22 instanceof CollectionElementVariable2) {
                this.updateParentContainerStructureFrom((CollectionElementVariable2)constraintVariable22, constraintVariable2);
            }
            this.updateElementVarStructureFromParent(constraintVariable22);
        }
    }

    private ParametricStructure newParametricType(TType tType) {
        GenericType genericType = (GenericType)tType.getTypeDeclaration();
        return new ParametricStructure(genericType);
    }

    private boolean isUnmodifiableFieldOrMethod(ConstraintVariable2 constraintVariable2) {
        return false;
    }

    private boolean isParametricType(TType tType) {
        return tType.isParameterizedType() || tType.isGenericType() || tType.isRawType() && tType.getTypeDeclaration().isGenericType();
    }

    private boolean updateStructureOfIthParamFrom(ParametricStructure parametricStructure, int n, ParametricStructure parametricStructure2) {
        boolean bl;
        boolean bl2;
        if (parametricStructure2 == null) {
            return false;
        }
        Assert.isTrue((parametricStructure != parametricStructure2 ? 1 : 0) != 0, (String)"updateStructureOfIthParamFrom(): attempt to unify ith param of a parametric type with itself!");
        ParametricStructure parametricStructure3 = parametricStructure.getParameters()[n];
        boolean bl3 = bl2 = parametricStructure3 == null;
        if (bl2) {
            parametricStructure.getParameters()[n] = parametricStructure2;
            return true;
        }
        boolean bl4 = parametricStructure3 != ParametricStructure.NONE;
        boolean bl5 = bl = parametricStructure2 != ParametricStructure.NONE;
        if (bl4 && bl) {
            if (parametricStructure3.getBase().equals(parametricStructure2.getBase())) {
                return this.updateStructureOfType(parametricStructure3, parametricStructure2);
            }
            parametricStructure.getParameters()[n] = ParametricStructure.NONE;
            return true;
        }
        return false;
    }

    private void updateElementVarStructureFromParent(ConstraintVariable2 constraintVariable2) {
        if (this.elemStructure(constraintVariable2) != ParametricStructure.NONE && this.fTCModel.getElementVariables(constraintVariable2).size() > 0) {
            ParametricStructure parametricStructure = this.elemStructure(constraintVariable2);
            Iterator iterator = this.fTCModel.getElementVariables(constraintVariable2).values().iterator();
            while (iterator.hasNext()) {
                CollectionElementVariable2 collectionElementVariable2 = (CollectionElementVariable2)iterator.next();
                int n = collectionElementVariable2.getDeclarationTypeVariableIndex();
                if (n == -1) continue;
                this.updateStructureOfVar(collectionElementVariable2, parametricStructure.getParameters()[n], TypeOperator.Equals);
            }
        }
    }

    private void updateParentContainerStructureFrom(CollectionElementVariable2 collectionElementVariable2, ConstraintVariable2 constraintVariable2) {
        ConstraintVariable2 constraintVariable22 = collectionElementVariable2.getParentConstraintVariable();
        ParametricStructure parametricStructure = this.elemStructure(constraintVariable22);
        if (parametricStructure == ParametricStructure.NONE) {
            return;
        }
        if (parametricStructure == null) {
            parametricStructure = this.newParametricType(constraintVariable22.getType());
            this.setStructureAndPush(constraintVariable22, parametricStructure);
        }
        ParametricStructure parametricStructure2 = this.elemStructure(constraintVariable2);
        int n = collectionElementVariable2.getDeclarationTypeVariableIndex();
        if (n == -1) {
            return;
        }
        if (parametricStructure == parametricStructure2 || this.containsSubStructure(parametricStructure2, parametricStructure)) {
            if (this.elemStructure(collectionElementVariable2) != ParametricStructure.NONE) {
                this.setStructureAndPush(collectionElementVariable2, ParametricStructure.NONE);
            }
            if (parametricStructure.getParameters()[n] == null) {
                parametricStructure.getParameters()[n] = ParametricStructure.NONE;
                this.fWorkList2.push(constraintVariable22);
            }
        } else if (this.updateStructureOfIthParamFrom(parametricStructure, n, parametricStructure2)) {
            this.setStructureAndPush(collectionElementVariable2, parametricStructure.getParameters()[n]);
            this.fWorkList2.push(constraintVariable22);
        }
    }

    private boolean containsSubStructure(ParametricStructure parametricStructure, ParametricStructure parametricStructure2) {
        if (parametricStructure == null) {
            return false;
        }
        ParametricStructure[] parametricStructureArray = parametricStructure.getParameters();
        int n = 0;
        while (n < parametricStructureArray.length) {
            ParametricStructure parametricStructure3 = parametricStructureArray[n];
            if (parametricStructure3 == parametricStructure2) {
                return true;
            }
            if (this.containsSubStructure(parametricStructure3, parametricStructure2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean updateStructureOfType(ParametricStructure parametricStructure, ParametricStructure parametricStructure2) {
        if (parametricStructure == null || parametricStructure2 == null) {
            return false;
        }
        ParametricStructure[] parametricStructureArray = parametricStructure.getParameters();
        ParametricStructure[] parametricStructureArray2 = parametricStructure2.getParameters();
        boolean bl = false;
        Assert.isTrue((parametricStructureArray.length == parametricStructureArray2.length ? 1 : 0) != 0);
        int n = 0;
        while (n < parametricStructureArray.length) {
            if (parametricStructure == parametricStructureArray2[n]) {
                if (parametricStructureArray[n] != ParametricStructure.NONE) {
                    parametricStructureArray[n] = ParametricStructure.NONE;
                    bl = true;
                }
            } else if (this.updateStructureOfIthParamFrom(parametricStructure, n, parametricStructureArray2[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean updateStructureOfVar(ConstraintVariable2 constraintVariable2, ParametricStructure parametricStructure, TypeOperator typeOperator) {
        boolean bl;
        boolean bl2;
        if (parametricStructure == null) {
            return false;
        }
        ParametricStructure parametricStructure2 = this.elemStructure(constraintVariable2);
        boolean bl3 = parametricStructure2 == null;
        boolean bl4 = bl2 = parametricStructure != ParametricStructure.NONE;
        if (bl3) {
            this.setStructureAndPush(constraintVariable2, parametricStructure);
            return true;
        }
        boolean bl5 = bl = parametricStructure2 != ParametricStructure.NONE;
        if (bl && !bl2) {
            if (typeOperator == TypeOperator.Equals || typeOperator == TypeOperator.SuperType) {
                this.setStructureAndPush(constraintVariable2, parametricStructure);
                return true;
            }
        } else if (bl && bl2) {
            if (!parametricStructure2.getBase().equals(parametricStructure.getBase())) {
                if (typeOperator == TypeOperator.SuperType) {
                    this.setStructureAndPush(constraintVariable2, ParametricStructure.NONE);
                    return true;
                }
            } else if (this.updateStructureOfType(parametricStructure2, parametricStructure)) {
                this.fWorkList2.push(constraintVariable2);
                return true;
            }
        }
        return false;
    }

    private void setElemStructure(ConstraintVariable2 constraintVariable2, ParametricStructure parametricStructure) {
        this.fElemStructureEnv.setElemStructure(constraintVariable2, parametricStructure);
    }

    private ParametricStructure elemStructure(ConstraintVariable2 constraintVariable2) {
        return this.fElemStructureEnv.elemStructure(constraintVariable2);
    }

    public Collection createElemConstraintVariables() {
        HashSet hashSet = new HashSet();
        this.computeContainerStructure();
        int n = 0;
        while (n < this.fAllConstraintVariables.length) {
            hashSet.addAll(this.createVariablesFor(this.fAllConstraintVariables[n]));
            ++n;
        }
        return hashSet;
    }

    private Collection createVariablesFor(ConstraintVariable2 constraintVariable2) {
        ParametricStructure parametricStructure = this.elemStructure(constraintVariable2);
        if (parametricStructure == null || parametricStructure == ParametricStructure.NONE) {
            return Collections.EMPTY_LIST;
        }
        ParametricStructure parametricStructure2 = parametricStructure;
        GenericType genericType = parametricStructure2.getBase();
        if (this.isParametricType(genericType)) {
            return this.createAndInitVars(constraintVariable2, parametricStructure2);
        }
        throw new IllegalStateException("Attempt to create element variables for parametric variable of unknown type: " + parametricStructure2);
    }

    private Collection getElementVariables(GenericType genericType, ConstraintVariable2 constraintVariable2) {
        this.fTCModel.makeElementVariables(constraintVariable2, genericType);
        return this.fTCModel.getElementVariables(constraintVariable2).values();
    }

    private Collection createAndInitVars(ConstraintVariable2 constraintVariable2, ParametricStructure parametricStructure) {
        Collection collection = this.getElementVariables(parametricStructure.getBase(), constraintVariable2);
        Collection collection2 = this.createVars(collection, parametricStructure.getParameters());
        return collection2;
    }

    private Collection createVars(Collection collection, ParametricStructure[] parametricStructureArray) {
        int n;
        Object object;
        Object object2;
        if (parametricStructureArray.length > 0) {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (CollectionElementVariable2)object2.next();
                n = ((CollectionElementVariable2)object).getDeclarationTypeVariableIndex();
                if (n == -1) continue;
                this.setElemStructure((ConstraintVariable2)object, parametricStructureArray[n]);
            }
        } else {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (CollectionElementVariable2)object2.next();
                n = ((CollectionElementVariable2)object).getDeclarationTypeVariableIndex();
                if (n == -1) continue;
                this.setElemStructure((ConstraintVariable2)object, ParametricStructure.NONE);
            }
        }
        object2 = new ArrayList(collection.size() * 2);
        object = collection.iterator();
        while (object.hasNext()) {
            CollectionElementVariable2 collectionElementVariable2 = (CollectionElementVariable2)object.next();
            int n2 = collectionElementVariable2.getDeclarationTypeVariableIndex();
            if (n2 == -1) continue;
            object2.add(collectionElementVariable2);
            object2.addAll(this.createVariablesFor(collectionElementVariable2));
        }
        return object2;
    }

    public static class ParametricStructure {
        public static final ParametricStructure NONE = new ParametricStructure();
        private final GenericType fBase;
        private final ParametricStructure[] fParameters;

        public ParametricStructure(GenericType genericType) {
            if (genericType == null) {
                throw new NullPointerException();
            }
            this.fBase = genericType;
            this.fParameters = new ParametricStructure[genericType.getTypeParameters().length];
        }

        private ParametricStructure() {
            this.fBase = null;
            this.fParameters = new ParametricStructure[0];
        }

        public ParametricStructure[] getParameters() {
            return this.fParameters;
        }

        public GenericType getBase() {
            return this.fBase;
        }

        public String toString() {
            if (this == NONE) {
                return "NONE";
            }
            return "ParamStructure " + this.fBase.toString() + '<' + Arrays.asList(this.fParameters) + '>';
        }
    }

    static class TypeOperator {
        private final String fOp;
        public static TypeOperator Equals = new TypeOperator("=^=");
        public static TypeOperator SubType = new TypeOperator("<=");
        public static TypeOperator SuperType = new TypeOperator("=>");

        private TypeOperator(String string) {
            this.fOp = string;
        }

        public String toString() {
            return this.fOp;
        }
    }
}

