/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;

public class NLSElement {
    public static final String TAG_PREFIX = "//$NON-NLS-";
    public static final int TAG_PREFIX_LENGTH = "//$NON-NLS-".length();
    public static final String TAG_POSTFIX = "$";
    public static final int TAG_POSTFIX_LENGTH = "$".length();
    private String fValue;
    private Region fPosition;
    private Region fTagPosition;
    private int fIndex;
    private boolean fIsEclipseNLS;
    private AccessorClassReference fAccessorClassReference;

    public NLSElement(String string, int n, int n2, int n3, boolean bl) {
        this.fValue = string;
        this.fIndex = n3;
        Assert.isNotNull((Object)this.fValue);
        this.fPosition = new Region(n, n2);
        this.fIsEclipseNLS = bl;
    }

    public Region getPosition() {
        return this.fPosition;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String string) {
        this.fValue = string;
    }

    public void setTagPosition(int n, int n2) {
        this.fTagPosition = new Region(n, n2);
    }

    public Region getTagPosition() {
        return this.fTagPosition;
    }

    public boolean hasTag() {
        return this.fTagPosition != null && this.fTagPosition.getLength() > 0;
    }

    public static String createTagText(int n) {
        return TAG_PREFIX + n + TAG_POSTFIX;
    }

    public String getTagText() {
        return TAG_PREFIX + (this.fIndex + 1) + TAG_POSTFIX;
    }

    public String toString() {
        return this.fPosition + ": " + this.fValue + "    Tag position: " + (this.hasTag() ? this.fTagPosition.toString() : "no tag found");
    }

    public boolean isEclipseNLS() {
        return this.fIsEclipseNLS;
    }

    public void setAccessorClassReference(AccessorClassReference accessorClassReference) {
        Assert.isTrue((boolean)this.fIsEclipseNLS);
        this.fAccessorClassReference = accessorClassReference;
    }

    public AccessorClassReference getAccessorClassReference() {
        Assert.isTrue((boolean)this.fIsEclipseNLS);
        return this.fAccessorClassReference;
    }
}

