/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class NLSHintHelper {
    private NLSHintHelper() {
    }

    public static AccessorClassReference getAccessorClassReference(CompilationUnit compilationUnit, NLSElement nLSElement) {
        Region region = nLSElement.getPosition();
        return NLSHintHelper.getAccessorClassReference(compilationUnit, (IRegion)region);
    }

    public static AccessorClassReference getAccessorClassReference(CompilationUnit compilationUnit, IRegion iRegion) {
        Object object;
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iRegion.getOffset(), iRegion.getLength());
        if (aSTNode == null) {
            return null;
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        ITypeBinding iTypeBinding = null;
        if (aSTNode2 instanceof MethodInvocation) {
            object = (MethodInvocation)aSTNode2;
            List list = object.arguments();
            if (list.indexOf(aSTNode) != 0) {
                return null;
            }
            Expression expression = (Expression)list.get(0);
            ITypeBinding iTypeBinding2 = expression.resolveTypeBinding();
            if (iTypeBinding2 == null || !iTypeBinding2.getQualifiedName().equals("java.lang.String")) {
                return null;
            }
            ITypeBinding iTypeBinding3 = object.resolveTypeBinding();
            if (iTypeBinding3 == null || !iTypeBinding3.getQualifiedName().equals("java.lang.String")) {
                return null;
            }
            IMethodBinding iMethodBinding = object.resolveMethodBinding();
            if (iMethodBinding == null || !Modifier.isStatic((int)iMethodBinding.getModifiers())) {
                return null;
            }
            iTypeBinding = iMethodBinding.getDeclaringClass();
        } else if (aSTNode2 instanceof QualifiedName) {
            object = (QualifiedName)aSTNode2;
            IBinding iBinding = object.resolveBinding();
            if (!(iBinding instanceof IVariableBinding)) {
                return null;
            }
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            if (!Modifier.isStatic((int)iVariableBinding.getModifiers())) {
                return null;
            }
            iTypeBinding = iVariableBinding.getDeclaringClass();
        } else if (aSTNode2 instanceof VariableDeclarationFragment) {
            object = (VariableDeclarationFragment)aSTNode2;
            if (object.getInitializer() != null) {
                return null;
            }
            IVariableBinding iVariableBinding = object.resolveBinding();
            if (!(iVariableBinding instanceof IVariableBinding)) {
                return null;
            }
            IVariableBinding iVariableBinding2 = iVariableBinding;
            if (!Modifier.isStatic((int)iVariableBinding2.getModifiers())) {
                return null;
            }
            if (!Modifier.isPublic((int)iVariableBinding2.getModifiers())) {
                return null;
            }
            iTypeBinding = iVariableBinding2.getDeclaringClass();
        }
        if (iTypeBinding == null) {
            return null;
        }
        try {
            object = NLSHintHelper.getResourceBundleName(iTypeBinding);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (object != null) {
            return new AccessorClassReference(iTypeBinding, (String)object, new Region(aSTNode2.getStartPosition(), aSTNode2.getLength()));
        }
        return null;
    }

    public static IPackageFragment getPackageOfAccessorClass(IJavaProject iJavaProject, ITypeBinding iTypeBinding) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        if (iTypeBinding != null && (iCompilationUnit = Bindings.findCompilationUnit(iTypeBinding, iJavaProject)) != null) {
            return (IPackageFragment)iCompilationUnit.getParent();
        }
        return null;
    }

    public static String getResourceBundleName(ITypeBinding iTypeBinding) throws JavaModelException {
        IJavaElement iJavaElement = iTypeBinding.getJavaElement();
        if (iJavaElement == null) {
            return null;
        }
        IOpenable iOpenable = iJavaElement.getOpenable();
        ICompilationUnit iCompilationUnit = null;
        if (iOpenable instanceof ICompilationUnit) {
            iCompilationUnit = (ICompilationUnit)iOpenable;
        } else if (iOpenable instanceof IClassFile) {
            iCompilationUnit = (IClassFile)iOpenable;
        } else {
            Assert.isLegal((boolean)false);
        }
        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_YES, null);
        return NLSHintHelper.getResourceBundleName(compilationUnit);
    }

    public static String getResourceBundleName(ICompilationUnit iCompilationUnit) throws JavaModelException {
        return NLSHintHelper.getResourceBundleName(JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_YES, null));
    }

    public static String getResourceBundleName(IClassFile iClassFile) throws JavaModelException {
        return NLSHintHelper.getResourceBundleName(JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iClassFile, ASTProvider.WAIT_YES, null));
    }

    public static String getResourceBundleName(CompilationUnit compilationUnit) throws JavaModelException {
        String string;
        Object object;
        if (compilationUnit == null) {
            return null;
        }
        final HashMap hashMap = new HashMap(5);
        final Object object2 = new Object();
        final Object object3 = new Object();
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation methodInvocation) {
                IBinding iBinding;
                IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
                if (iMethodBinding == null) {
                    return true;
                }
                String string = iMethodBinding.getDeclaringClass().getQualifiedName();
                if (!("java.util.ResourceBundle".equals(string) && "getBundle".equals(iMethodBinding.getName()) && methodInvocation.arguments().size() > 0 || "org.eclipse.osgi.util.NLS".equals(string) && "initializeMessages".equals(iMethodBinding.getName()) && methodInvocation.arguments().size() == 2)) {
                    return true;
                }
                Expression expression = (Expression)methodInvocation.arguments().get(0);
                String string2 = this.getBundleName(expression);
                if (string2 != null) {
                    hashMap.put(object2, string2);
                }
                if (expression instanceof Name && (iBinding = ((Name)expression).resolveBinding()) != null) {
                    hashMap.put(object3, iBinding);
                }
                return false;
            }

            public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                Expression expression = variableDeclarationFragment.getInitializer();
                String string = this.getBundleName(expression);
                if (string != null) {
                    IBinding iBinding = variableDeclarationFragment.getName().resolveBinding();
                    if (iBinding != null) {
                        hashMap.put(iBinding, string);
                    }
                    return false;
                }
                return true;
            }

            public boolean visit(Assignment assignment) {
                IBinding iBinding;
                String string;
                if (assignment.getLeftHandSide() instanceof Name && (string = this.getBundleName(assignment.getRightHandSide())) != null && (iBinding = ((Name)assignment.getLeftHandSide()).resolveBinding()) != null) {
                    hashMap.put(iBinding, string);
                    return false;
                }
                return true;
            }

            private String getBundleName(Expression expression) {
                SimpleType simpleType;
                ITypeBinding iTypeBinding;
                MethodInvocation methodInvocation;
                Expression expression2;
                if (expression instanceof StringLiteral) {
                    return ((StringLiteral)expression).getLiteralValue();
                }
                if (expression instanceof MethodInvocation && (expression2 = (methodInvocation = (MethodInvocation)expression).getExpression()) != null && expression2 instanceof TypeLiteral && (iTypeBinding = (simpleType = (SimpleType)((TypeLiteral)expression2).getType()).resolveBinding()) != null) {
                    return iTypeBinding.getQualifiedName();
                }
                return null;
            }
        });
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            IBinding iBinding;
            Object k = iterator.next();
            if (!(k instanceof IBinding) || !(object = (iBinding = (IBinding)k).getName()).equals("BUNDLE_NAME") && !object.equals("RESOURCE_BUNDLE") && !object.equals("bundleName") || (string = (String)hashMap.get(iBinding)) == null) continue;
            return string;
        }
        string = (String)hashMap.get(object2);
        if (string != null) {
            return string;
        }
        object = hashMap.get(object3);
        if (object != null) {
            return (String)hashMap.get(object);
        }
        return null;
    }

    public static IPackageFragment getResourceBundlePackage(IJavaProject iJavaProject, String string, String string2) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getAllPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragment iPackageFragment;
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            if (iPackageFragmentRoot.getKind() == 1 && (iPackageFragment = iPackageFragmentRoot.getPackageFragment(string)).exists()) {
                Object[] objectArray = iPackageFragment.isDefaultPackage() ? iPackageFragmentRoot.getNonJavaResources() : iPackageFragment.getNonJavaResources();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    IFile iFile;
                    Object object = objectArray[n2];
                    if (object instanceof IFile && (iFile = (IFile)object).getName().equals(string2)) {
                        return iPackageFragment;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public static IStorage getResourceBundle(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        if (iJavaProject == null) {
            return null;
        }
        String string = NLSHintHelper.getResourceBundleName(iCompilationUnit);
        if (string == null) {
            return null;
        }
        String string2 = Signature.getQualifier((String)string);
        String string3 = String.valueOf(Signature.getSimpleName((String)string)) + ".properties";
        return NLSHintHelper.getResourceBundle(iJavaProject, string2, string3);
    }

    public static IStorage getResourceBundle(IJavaProject iJavaProject, String string, String string2) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getAllPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IStorage iStorage;
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            if (iPackageFragmentRoot.getKind() == 1 && (iStorage = NLSHintHelper.getResourceBundle(iPackageFragmentRoot, string, string2)) != null) {
                return iStorage;
            }
            ++n;
        }
        return null;
    }

    public static IStorage getResourceBundle(IPackageFragmentRoot iPackageFragmentRoot, String string, String string2) throws JavaModelException {
        IPackageFragment iPackageFragment = iPackageFragmentRoot.getPackageFragment(string);
        if (iPackageFragment.exists()) {
            Object[] objectArray = iPackageFragment.isDefaultPackage() ? iPackageFragmentRoot.getNonJavaResources() : iPackageFragment.getNonJavaResources();
            int n = 0;
            while (n < objectArray.length) {
                IStorage iStorage;
                Object object = objectArray[n];
                if (JavaModelUtil.isOpenableStorage(object) && (iStorage = (IStorage)object).getName().equals(string2)) {
                    return iStorage;
                }
                ++n;
            }
        }
        return null;
    }

    public static IStorage getResourceBundle(IJavaProject iJavaProject, AccessorClassReference accessorClassReference) throws JavaModelException {
        String string = accessorClassReference.getResourceBundleName();
        if (string == null) {
            return null;
        }
        String string2 = String.valueOf(Signature.getSimpleName((String)string)) + ".properties";
        String string3 = Signature.getQualifier((String)string);
        ITypeBinding iTypeBinding = accessorClassReference.getBinding();
        if (iTypeBinding.isFromSource()) {
            return NLSHintHelper.getResourceBundle(iJavaProject, string3, string2);
        }
        if (iTypeBinding.getJavaElement() != null) {
            return NLSHintHelper.getResourceBundle((IPackageFragmentRoot)iTypeBinding.getJavaElement().getAncestor(3), string3, string2);
        }
        return null;
    }

    public static Properties getProperties(IJavaProject iJavaProject, AccessorClassReference accessorClassReference) {
        try {
            IStorage iStorage = NLSHintHelper.getResourceBundle(iJavaProject, accessorClassReference);
            return NLSHintHelper.getProperties(iStorage);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static Properties getProperties(IStorage var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 132->135)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

