/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.SimpleLineReader;

public class PropertyFileDocumentModel {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private List fKeyValuePairs;
    private String fLineDelimiter;

    public PropertyFileDocumentModel(IDocument iDocument) {
        this.parsePropertyDocument(iDocument);
        this.fLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
    }

    public int getIndex(String string) {
        int n = 0;
        while (n < this.fKeyValuePairs.size()) {
            KeyValuePairModell keyValuePairModell = (KeyValuePairModell)this.fKeyValuePairs.get(n);
            if (keyValuePairModell.getKey().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public InsertEdit insert(String string, String string2) {
        return this.insert(new KeyValuePair(string, string2));
    }

    public InsertEdit insert(KeyValuePair keyValuePair) {
        KeyValuePairModell keyValuePairModell = new KeyValuePairModell(keyValuePair);
        int n = this.findInsertPosition(keyValuePairModell);
        KeyValuePairModell keyValuePairModell2 = (KeyValuePairModell)this.fKeyValuePairs.get(n);
        int n2 = keyValuePairModell2.fOffset - keyValuePairModell2.fLeadingWhiteSpaces;
        String string = "";
        if (keyValuePairModell2 instanceof LastKeyValuePair && ((LastKeyValuePair)keyValuePairModell2).needsNewLine()) {
            string = this.fLineDelimiter;
            ((LastKeyValuePair)keyValuePairModell2).resetNeedsNewLine();
        }
        return new InsertEdit(n2, String.valueOf(string) + keyValuePairModell.getEncodedText(this.fLineDelimiter));
    }

    public InsertEdit[] insert(KeyValuePair[] keyValuePairArray) {
        InsertEdit[] insertEditArray = new InsertEdit[keyValuePairArray.length];
        int n = 0;
        while (n < keyValuePairArray.length) {
            insertEditArray[n] = this.insert(keyValuePairArray[n]);
            ++n;
        }
        return insertEditArray;
    }

    public DeleteEdit remove(String string) {
        Iterator iterator = this.fKeyValuePairs.iterator();
        while (iterator.hasNext()) {
            KeyValuePairModell keyValuePairModell = (KeyValuePairModell)iterator.next();
            if (!keyValuePairModell.fKey.equals(string)) continue;
            KeyValuePairModell keyValuePairModell2 = (KeyValuePairModell)iterator.next();
            return new DeleteEdit(keyValuePairModell.fOffset, keyValuePairModell2.fOffset - keyValuePairModell.fOffset);
        }
        return null;
    }

    public ReplaceEdit replace(KeyValuePair keyValuePair, KeyValuePair keyValuePair2) {
        Iterator iterator = this.fKeyValuePairs.iterator();
        while (iterator.hasNext()) {
            KeyValuePairModell keyValuePairModell = (KeyValuePairModell)iterator.next();
            if (!keyValuePairModell.fKey.equals(keyValuePair.getKey())) continue;
            String string = new KeyValuePairModell(keyValuePair2).getEncodedText(this.fLineDelimiter);
            KeyValuePairModell keyValuePairModell2 = (KeyValuePairModell)iterator.next();
            int n = keyValuePairModell2.fOffset - keyValuePairModell.fOffset;
            return new ReplaceEdit(keyValuePairModell.fOffset, n, string);
        }
        return null;
    }

    private int findInsertPosition(KeyValuePairModell keyValuePairModell) {
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        while (n3 < this.fKeyValuePairs.size()) {
            KeyValuePairModell keyValuePairModell2 = (KeyValuePairModell)this.fKeyValuePairs.get(n3);
            int n4 = keyValuePairModell2.compareTo(keyValuePairModell);
            if (n4 >= n2) {
                n = n3;
                n2 = n4;
            }
            ++n3;
        }
        if (n < this.fKeyValuePairs.size() - 1) {
            ++n;
        }
        return n;
    }

    private void parsePropertyDocument(IDocument iDocument) {
        Object object;
        int n;
        this.fKeyValuePairs = new ArrayList();
        SimpleLineReader simpleLineReader = new SimpleLineReader(iDocument);
        int n2 = 0;
        String string = simpleLineReader.readLine();
        int n3 = 0;
        while (string != null) {
            if (!SimpleLineReader.isCommentOrWhiteSpace(string)) {
                n = this.getIndexOfSeparationCharacter(string);
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    object = string.substring(n + 1);
                    this.fKeyValuePairs.add(new KeyValuePairModell(string2, (String)object, n2, n3));
                    n3 = 0;
                }
            } else {
                n3 += string.length();
            }
            n2 += string.length();
            string = simpleLineReader.readLine();
        }
        n = iDocument.getNumberOfLines() - 1;
        boolean bl = false;
        try {
            bl = iDocument.getLineLength(n) != 0;
        }
        catch (BadLocationException badLocationException) {}
        object = new LastKeyValuePair(n2, bl);
        this.fKeyValuePairs.add(object);
    }

    private int getIndexOfSeparationCharacter(String string) {
        int n = -1;
        int n2 = string.indexOf(61);
        int n3 = string.indexOf(58);
        int n4 = string.indexOf(32);
        n = n2 != -1 && n3 != -1 ? Math.min(n2, n3) : Math.max(n2, n3);
        n = n != -1 && n4 != -1 ? Math.min(n, n4) : Math.max(n, n4);
        return n;
    }

    public static String unwindEscapeChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuffer.append(PropertyFileDocumentModel.getUnwoundString(c));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String unwindValue(String string) {
        return PropertyFileDocumentModel.escapeLeadingWhiteSpaces(PropertyFileDocumentModel.escapeCommentChars(PropertyFileDocumentModel.unwindEscapeChars(string)));
    }

    private static String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ' || c > '~') {
            return "" + '\\' + 'u' + PropertyFileDocumentModel.toHex(c >> 12 & 0xF) + PropertyFileDocumentModel.toHex(c >> 8 & 0xF) + PropertyFileDocumentModel.toHex(c >> 4 & 0xF) + PropertyFileDocumentModel.toHex(c & 0xF);
        }
        return String.valueOf(c);
    }

    private static char toHex(int n) {
        return HEX_DIGITS[n & 0xF];
    }

    private static String escapeCommentChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '!': {
                    stringBuffer.append("\\!");
                    break;
                }
                case '#': {
                    stringBuffer.append("\\#");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String escapeLeadingWhiteSpaces(String string) {
        int n = PropertyFileDocumentModel.findFirstNonWhiteSpace(string);
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append('\\');
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private static int findFirstNonWhiteSpace(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isWhitespace(string.charAt(n))) {
                return n;
            }
            ++n;
        }
        return string.length();
    }

    private static class KeyValuePairModell
    extends KeyValuePair
    implements Comparable {
        int fOffset;
        int fLeadingWhiteSpaces;

        public KeyValuePairModell(String string, String string2, int n, int n2) {
            super(string, string2);
            this.fOffset = n;
            this.fLeadingWhiteSpaces = n2;
        }

        public KeyValuePairModell(KeyValuePair keyValuePair) {
            super(keyValuePair.fKey, keyValuePair.fValue);
        }

        public String getEncodedText(String string) {
            return String.valueOf(PropertyFileDocumentModel.unwindEscapeChars(this.fKey)) + '=' + PropertyFileDocumentModel.unwindValue(this.fValue) + string;
        }

        public int compareTo(Object object) {
            int n = 0;
            String string = ((KeyValuePair)object).fKey;
            int n2 = Math.min(string.length(), this.fKey.length());
            int n3 = Math.abs(string.length() - this.fKey.length());
            int n4 = 0;
            while (n4 < n2) {
                if (string.charAt(n4) != this.fKey.charAt(n4)) break;
                ++n;
                ++n4;
            }
            return n - n3;
        }
    }

    private static class LastKeyValuePair
    extends KeyValuePairModell {
        private boolean fNeedsNewLine;

        public LastKeyValuePair(int n, boolean bl) {
            super("last", "key", n, 0);
            this.fNeedsNewLine = bl;
        }

        public int compareTo(Object object) {
            return 1;
        }

        public boolean needsNewLine() {
            return this.fNeedsNewLine;
        }

        public void resetNeedsNewLine() {
            this.fNeedsNewLine = false;
        }
    }
}

