/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class CreateFileChange
extends JDTChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private long fStampToRestore;

    public CreateFileChange(IPath iPath, String string, String string2) {
        this(iPath, string, string2, -1L);
    }

    public CreateFileChange(IPath iPath, String string, String string2, long l) {
        Assert.isNotNull((Object)iPath, (String)"path");
        Assert.isNotNull((Object)string, (String)"source");
        this.fPath = iPath;
        this.fSource = string;
        this.fEncoding = string2;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = l;
    }

    protected void setEncoding(String string, boolean bl) {
        Assert.isNotNull((Object)string, (String)"encoding");
        this.fEncoding = string;
        this.fExplicitEncoding = bl;
    }

    public String getName() {
        if (this.fChangeName == null) {
            return Messages.format(NLSChangesMessages.createFile_Create_file, this.fPath.toOSString());
        }
        return this.fChangeName;
    }

    public void setName(String string) {
        this.fChangeName = string;
    }

    protected void setSource(String string) {
        this.fSource = string;
    }

    protected String getSource() {
        return this.fSource;
    }

    protected void setPath(IPath iPath) {
        this.fPath = iPath;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI uRI = iFile.getLocationURI();
        if (uRI == null) {
            refactoringStatus.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_unknownLocation, iFile.getFullPath().toString()));
            return refactoringStatus;
        }
        IFileInfo iFileInfo = EFS.getStore((URI)uRI).fetchInfo();
        if (iFileInfo.exists()) {
            refactoringStatus.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_exists, iFile.getFullPath().toString()));
            return refactoringStatus;
        }
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Change perform(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        InputStream inputStream = null;
        try {
            DeleteFileChange deleteFileChange;
            iProgressMonitor.beginTask(NLSChangesMessages.createFile_creating_resource, 3);
            this.initializeEncoding();
            IFile iFile = this.getOldFile((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            try {
                inputStream = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                iFile.create(inputStream, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (this.fStampToRestore != -1L) {
                    iFile.revertModificationStamp(this.fStampToRestore);
                }
                if (this.fExplicitEncoding) {
                    iFile.setCharset(this.fEncoding, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                } else {
                    iProgressMonitor.worked(1);
                }
                deleteFileChange = new DeleteFileChange(iFile);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JavaModelException((Throwable)unsupportedEncodingException, 985);
            }
            Object var5_5 = null;
            try {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    throw new JavaModelException((Throwable)iOException, 985);
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return deleteFileChange;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                iProgressMonitor.done();
                throw throwable2;
            }
            try {}
            catch (IOException iOException) {
                throw new JavaModelException((Throwable)iOException, 985);
            }
            if (inputStream != null) {
                inputStream.close();
            }
            Object var9_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
    }

    protected IFile getOldFile(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        IFile iFile;
        iProgressMonitor.beginTask("", 1);
        try {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return iFile;
    }

    private void initializeEncoding() {
        if (this.fEncoding == null) {
            this.fExplicitEncoding = false;
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            if (iFile != null) {
                try {
                    if (iFile.exists()) {
                        this.fEncoding = iFile.getCharset(false);
                        if (this.fEncoding == null) {
                            this.fEncoding = iFile.getCharset(true);
                        } else {
                            this.fExplicitEncoding = true;
                        }
                    } else {
                        IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(iFile.getName());
                        if (iContentType != null) {
                            this.fEncoding = iContentType.getDefaultCharset();
                        }
                        if (this.fEncoding == null) {
                            this.fEncoding = iFile.getCharset(true);
                        }
                    }
                }
                catch (CoreException coreException) {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            } else {
                this.fEncoding = ResourcesPlugin.getEncoding();
                this.fExplicitEncoding = true;
            }
        }
        Assert.isNotNull((Object)this.fEncoding);
    }
}

