/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.CreateArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class ResourceModifications {
    private List fCreate;
    private List fDelete;
    private List fMove;
    private List fMoveArguments;
    private List fRename;
    private List fRenameArguments;
    private List fCopy;
    private List fCopyArguments;
    private int fIgnoreCount;
    private List fDeltaDescriptions;

    public void addChanged(IFile iFile) {
        if (this.fIgnoreCount == 0) {
            this.internalAdd(new ChangedDescription(iFile));
        }
    }

    public void addCreate(IResource iResource) {
        if (this.fCreate == null) {
            this.fCreate = new ArrayList(2);
        }
        this.fCreate.add(iResource);
        if (this.fIgnoreCount == 0) {
            this.internalAdd(new CreateDescription(iResource));
        }
    }

    public void addDelete(IResource iResource) {
        if (this.fDelete == null) {
            this.fDelete = new ArrayList(2);
        }
        this.fDelete.add(iResource);
        if (this.fIgnoreCount == 0) {
            this.internalAdd(new DeleteDescription(iResource));
        }
    }

    public void addMove(IResource iResource, MoveArguments moveArguments) {
        if (this.fMove == null) {
            this.fMove = new ArrayList(2);
            this.fMoveArguments = new ArrayList(2);
        }
        this.fMove.add(iResource);
        this.fMoveArguments.add(moveArguments);
        if (this.fIgnoreCount == 0) {
            IPath iPath = ((IResource)moveArguments.getDestination()).getFullPath().append(iResource.getName());
            this.internalAdd(new MoveDescription(iResource, iPath));
        }
    }

    public void addCopy(IResource iResource, CopyArguments copyArguments) {
        if (this.fCopy == null) {
            this.fCopy = new ArrayList(2);
            this.fCopyArguments = new ArrayList(2);
        }
        this.fCopy.add(iResource);
        this.fCopyArguments.add(copyArguments);
        this.addCopyDelta(iResource, copyArguments);
    }

    public void addRename(IResource iResource, RenameArguments renameArguments) {
        Assert.isNotNull((Object)iResource);
        Assert.isNotNull((Object)renameArguments);
        if (this.fRename == null) {
            this.fRename = new ArrayList(2);
            this.fRenameArguments = new ArrayList(2);
        }
        this.fRename.add(iResource);
        this.fRenameArguments.add(renameArguments);
        if (this.fIgnoreCount == 0) {
            IPath iPath = iResource.getFullPath().removeLastSegments(1).append(renameArguments.getNewName());
            this.internalAdd(new MoveDescription(iResource, iPath));
        }
    }

    public RefactoringParticipant[] getParticipants(RefactoringStatus refactoringStatus, RefactoringProcessor refactoringProcessor, String[] stringArray, SharableParticipants sharableParticipants) {
        MoveParticipant[] moveParticipantArray;
        MoveArguments moveArguments;
        Iterator iterator;
        DeleteArguments deleteArguments;
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        if (this.fDelete != null) {
            deleteArguments = new DeleteArguments();
            iterator = this.fDelete.iterator();
            while (iterator.hasNext()) {
                moveArguments = ParticipantManager.loadDeleteParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, iterator.next(), (DeleteArguments)deleteArguments, (String[])stringArray, (SharableParticipants)sharableParticipants);
                arrayList.addAll(Arrays.asList(moveArguments));
            }
        }
        if (this.fCreate != null) {
            deleteArguments = new CreateArguments();
            iterator = this.fCreate.iterator();
            while (iterator.hasNext()) {
                moveArguments = ParticipantManager.loadCreateParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, iterator.next(), (CreateArguments)deleteArguments, (String[])stringArray, (SharableParticipants)sharableParticipants);
                arrayList.addAll(Arrays.asList(moveArguments));
            }
        }
        if (this.fMove != null) {
            int n = 0;
            while (n < this.fMove.size()) {
                iterator = this.fMove.get(n);
                moveArguments = (MoveArguments)this.fMoveArguments.get(n);
                moveParticipantArray = ParticipantManager.loadMoveParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, iterator, (MoveArguments)moveArguments, (String[])stringArray, (SharableParticipants)sharableParticipants);
                arrayList.addAll(Arrays.asList(moveParticipantArray));
                ++n;
            }
        }
        if (this.fCopy != null) {
            int n = 0;
            while (n < this.fCopy.size()) {
                iterator = this.fCopy.get(n);
                moveArguments = (CopyArguments)this.fCopyArguments.get(n);
                moveParticipantArray = ParticipantManager.loadCopyParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, iterator, (CopyArguments)moveArguments, (String[])stringArray, (SharableParticipants)sharableParticipants);
                arrayList.addAll(Arrays.asList(moveParticipantArray));
                ++n;
            }
        }
        if (this.fRename != null) {
            int n = 0;
            while (n < this.fRename.size()) {
                iterator = this.fRename.get(n);
                moveArguments = (RenameArguments)this.fRenameArguments.get(n);
                moveParticipantArray = ParticipantManager.loadRenameParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, iterator, (RenameArguments)moveArguments, (String[])stringArray, (SharableParticipants)sharableParticipants);
                arrayList.addAll(Arrays.asList(moveParticipantArray));
                ++n;
            }
        }
        return arrayList.toArray(new RefactoringParticipant[arrayList.size()]);
    }

    public void ignoreForDelta() {
        ++this.fIgnoreCount;
    }

    public void trackForDelta() {
        --this.fIgnoreCount;
    }

    public void addDelta(DeltaDescription deltaDescription) {
        if (this.fIgnoreCount > 0) {
            return;
        }
        this.internalAdd(deltaDescription);
    }

    public void addCopyDelta(IResource iResource, CopyArguments copyArguments) {
        if (this.fIgnoreCount == 0) {
            IPath iPath = ((IResource)copyArguments.getDestination()).getFullPath().append(iResource.getName());
            this.internalAdd(new CopyDescription(iResource, iPath));
        }
    }

    public boolean willExist(IResource iResource) {
        if (this.fDeltaDescriptions == null) {
            return false;
        }
        IPath iPath = iResource.getFullPath();
        Iterator iterator = this.fDeltaDescriptions.iterator();
        while (iterator.hasNext()) {
            DeltaDescription deltaDescription = (DeltaDescription)iterator.next();
            if (!iPath.equals((Object)deltaDescription.getDestinationPath())) continue;
            return true;
        }
        return false;
    }

    public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
        if (this.fDeltaDescriptions == null) {
            return;
        }
        Iterator iterator = this.fDeltaDescriptions.iterator();
        while (iterator.hasNext()) {
            ((DeltaDescription)iterator.next()).buildDelta(iResourceChangeDescriptionFactory);
        }
    }

    public static void buildMoveDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, IResource iResource, RenameArguments renameArguments) {
        IPath iPath = iResource.getFullPath().removeLastSegments(1).append(renameArguments.getNewName());
        iResourceChangeDescriptionFactory.move(iResource, iPath);
    }

    public static void buildMoveDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, IResource iResource, MoveArguments moveArguments) {
        IPath iPath = ((IResource)moveArguments.getDestination()).getFullPath().append(iResource.getName());
        iResourceChangeDescriptionFactory.move(iResource, iPath);
    }

    public static void buildCopyDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, IResource iResource, CopyArguments copyArguments) {
        IPath iPath = ((IResource)copyArguments.getDestination()).getFullPath().append(iResource.getName());
        iResourceChangeDescriptionFactory.copy(iResource, iPath);
    }

    private void internalAdd(DeltaDescription deltaDescription) {
        if (this.fDeltaDescriptions == null) {
            this.fDeltaDescriptions = new ArrayList();
        }
        this.fDeltaDescriptions.add(deltaDescription);
    }

    public static class ChangedDescription
    extends DeltaDescription {
        public ChangedDescription(IFile iFile) {
            super((IResource)iFile);
        }

        public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
            iResourceChangeDescriptionFactory.change((IFile)this.fResource);
        }

        public IPath getDestinationPath() {
            return null;
        }
    }

    public static class CopyDescription
    extends DeltaDescription {
        private IPath fDestination;

        public CopyDescription(IResource iResource, IPath iPath) {
            super(iResource);
            this.fDestination = iPath;
        }

        public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
            iResourceChangeDescriptionFactory.copy(this.fResource, this.fDestination);
        }

        public IPath getDestinationPath() {
            return this.fDestination;
        }
    }

    public static class CreateDescription
    extends DeltaDescription {
        public CreateDescription(IResource iResource) {
            super(iResource);
        }

        public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
            iResourceChangeDescriptionFactory.create(this.fResource);
        }

        public IPath getDestinationPath() {
            return this.fResource.getFullPath();
        }
    }

    public static class DeleteDescription
    extends DeltaDescription {
        public DeleteDescription(IResource iResource) {
            super(iResource);
        }

        public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
            iResourceChangeDescriptionFactory.delete(this.fResource);
        }

        public IPath getDestinationPath() {
            return null;
        }
    }

    public static abstract class DeltaDescription {
        protected IResource fResource;

        public DeltaDescription(IResource iResource) {
            this.fResource = iResource;
        }

        public abstract void buildDelta(IResourceChangeDescriptionFactory var1);

        public abstract IPath getDestinationPath();
    }

    public static class MoveDescription
    extends DeltaDescription {
        private IPath fDestination;

        public MoveDescription(IResource iResource, IPath iPath) {
            super(iResource);
            this.fDestination = iPath;
        }

        public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
            iResourceChangeDescriptionFactory.move(this.fResource, this.fDestination);
        }

        public IPath getDestinationPath() {
            return this.fDestination;
        }
    }
}

