/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class RefactoringAnalyzeUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private RefactoringAnalyzeUtil() {
    }

    public static IRegion[] getNewRanges(TextEdit[] textEditArray, TextChange textChange) {
        IRegion[] iRegionArray = new IRegion[textEditArray.length];
        int n = 0;
        while (n < textEditArray.length) {
            iRegionArray[n] = RefactoringAnalyzeUtil.getNewTextRange(textEditArray[n], textChange);
            ++n;
        }
        return iRegionArray;
    }

    public static RefactoringStatus reportProblemNodes(String string, SimpleName[] simpleNameArray) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < simpleNameArray.length) {
            JavaStringStatusContext javaStringStatusContext = new JavaStringStatusContext(string, new SourceRange((ASTNode)simpleNameArray[n]));
            refactoringStatus.addError(Messages.format(RefactoringCoreMessages.RefactoringAnalyzeUtil_name_collision, simpleNameArray[n].getIdentifier()), (RefactoringStatusContext)javaStringStatusContext);
            ++n;
        }
        return refactoringStatus;
    }

    public static MethodDeclaration getMethodDeclaration(TextEdit textEdit, TextChange textChange, CompilationUnit compilationUnit) {
        SimpleName simpleName = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(textEdit, textChange), compilationUnit);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)simpleName, clazz);
    }

    public static Block getBlock(TextEdit textEdit, TextChange textChange, CompilationUnit compilationUnit) {
        SimpleName simpleName = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(textEdit, textChange), compilationUnit);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Block");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Block)ASTNodes.getParent((ASTNode)simpleName, clazz);
    }

    public static IProblem[] getIntroducedCompileProblems(CompilationUnit compilationUnit, CompilationUnit compilationUnit2) {
        HashSet<IProblem> hashSet = new HashSet<IProblem>();
        Set set = RefactoringAnalyzeUtil.getOldProblems(compilationUnit2);
        IProblem[] iProblemArray = ASTNodes.getProblems((ASTNode)compilationUnit, 2, 3);
        int n = 0;
        while (n < iProblemArray.length) {
            IProblem iProblem = RefactoringAnalyzeUtil.findCorrespondingProblem(set, iProblemArray[n]);
            if (iProblem == null) {
                hashSet.add(iProblemArray[n]);
            }
            ++n;
        }
        return hashSet.toArray(new IProblem[hashSet.size()]);
    }

    public static IRegion getNewTextRange(TextEdit textEdit, TextChange textChange) {
        return textChange.getPreviewEdit(textEdit).getRegion();
    }

    private static IProblem findCorrespondingProblem(Set set, IProblem iProblem) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IProblem iProblem2 = (IProblem)iterator.next();
            if (!RefactoringAnalyzeUtil.isCorresponding(iProblem2, iProblem)) continue;
            return iProblem2;
        }
        return null;
    }

    private static boolean isCorresponding(IProblem iProblem, IProblem iProblem2) {
        if (iProblem.getID() != iProblem2.getID()) {
            return false;
        }
        return iProblem.getMessage().equals(iProblem2.getMessage());
    }

    private static SimpleName getSimpleName(ASTNode aSTNode) {
        if (aSTNode instanceof SimpleName) {
            return (SimpleName)aSTNode;
        }
        if (aSTNode instanceof VariableDeclaration) {
            return ((VariableDeclaration)aSTNode).getName();
        }
        return null;
    }

    private static SimpleName findSimpleNameNode(IRegion iRegion, CompilationUnit compilationUnit) {
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iRegion.getOffset(), iRegion.getLength());
        return RefactoringAnalyzeUtil.getSimpleName(aSTNode);
    }

    private static Set getOldProblems(CompilationUnit compilationUnit) {
        return new HashSet<IProblem>(Arrays.asList(ASTNodes.getProblems((ASTNode)compilationUnit, 2, 3)));
    }
}

