/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class RenameEnumConstProcessor
extends RenameFieldProcessor {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameEnumConstProcessor";

    public RenameEnumConstProcessor(IField iField) {
        super(iField);
    }

    public String canEnableGetterRenaming() throws CoreException {
        return "";
    }

    public String canEnableSetterRenaming() throws CoreException {
        return "";
    }

    public RefactoringStatus checkNewElementName(String string) throws CoreException {
        RefactoringStatus refactoringStatus = Checks.checkEnumConstantName(string);
        if (Checks.isAlreadyNamed((IJavaElement)this.getField(), string)) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_another_name);
        }
        if (this.getField().getDeclaringType().getField(string).exists()) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_const_already_defined);
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        Change change = super.createChange(iProgressMonitor);
        if (change != null) {
            IField iField = this.getField();
            String string = null;
            IJavaProject iJavaProject = iField.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 589826;
            IType iType = iField.getDeclaringType();
            try {
                if (!Flags.isPrivate((int)iType.getFlags())) {
                    n |= 4;
                }
                if (iType.isAnonymous() || iType.isLocal()) {
                    n |= 0x40000;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            String string2 = Messages.format(RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description_short, this.fField.getElementName());
            String string3 = Messages.format(RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description, new String[]{iField.getElementName(), JavaElementLabels.getElementLabel(iField.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            String string4 = new JDTRefactoringDescriptorComment(string, this, string3).asString();
            RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.enum.constant");
            renameJavaElementDescriptor.setProject(string);
            renameJavaElementDescriptor.setDescription(string2);
            renameJavaElementDescriptor.setComment(string4);
            renameJavaElementDescriptor.setFlags(n);
            renameJavaElementDescriptor.setJavaElement((IJavaElement)iField);
            renameJavaElementDescriptor.setNewName(this.getNewElementName());
            renameJavaElementDescriptor.setUpdateReferences(this.fUpdateReferences);
            renameJavaElementDescriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
            RefactoringDescriptorChange refactoringDescriptorChange = new RefactoringDescriptorChange((RefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameEnumConstProcessor_change_name, new Change[]{change});
            refactoringDescriptorChange.markAsSynthetic();
            return refactoringDescriptorChange;
        }
        return change;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameEnumConstRefactoring_name;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object == null || !object.exists() || object.getElementType() != 8) {
                    return ScriptableRefactoring.createInputFatalStatus(object, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.enum.constant");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fField = (IField)object;
            object = javaRefactoringArguments.getAttribute("name");
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName((String)object);
            String string3 = javaRefactoringArguments.getAttribute("references");
            if (string3 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.setUpdateReferences(Boolean.valueOf(string3));
            string = javaRefactoringArguments.getAttribute("textual");
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "textual"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setUpdateTextualMatches(Boolean.valueOf(string));
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameEnumConstAvailable(this.getField());
    }
}

