/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class RippleMethodFinder2 {
    private final IMethod fMethod;
    private List fDeclarations;
    private ITypeHierarchy fHierarchy;
    private Map fTypeToMethod;
    private Set fRootTypes;
    private MultiMap fRootReps;
    private Map fRootHierarchies;
    private UnionFind fUnionFind;
    private boolean fExcludeBinaries;

    private RippleMethodFinder2(IMethod iMethod, boolean bl) {
        this.fMethod = iMethod;
        this.fExcludeBinaries = bl;
    }

    public static IMethod[] getRelatedMethods(IMethod iMethod, boolean bl, IProgressMonitor iProgressMonitor, WorkingCopyOwner workingCopyOwner) throws CoreException {
        block3: {
            IMethod[] iMethodArray;
            try {
                if (MethodChecks.isVirtual(iMethod)) break block3;
                iMethodArray = new IMethod[]{iMethod};
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return iMethodArray;
        }
        IMethod[] iMethodArray = new RippleMethodFinder2(iMethod, bl).getAllRippleMethods(iProgressMonitor, workingCopyOwner);
        Object var4_7 = null;
        iProgressMonitor.done();
        return iMethodArray;
    }

    public static IMethod[] getRelatedMethods(IMethod iMethod, IProgressMonitor iProgressMonitor, WorkingCopyOwner workingCopyOwner) throws CoreException {
        return RippleMethodFinder2.getRelatedMethods(iMethod, true, iProgressMonitor, workingCopyOwner);
    }

    private IMethod[] getAllRippleMethods(IProgressMonitor iProgressMonitor, WorkingCopyOwner workingCopyOwner) throws CoreException {
        Object object;
        Object object2;
        Object object3;
        ArrayList<IType> arrayList;
        Object object4;
        iProgressMonitor.beginTask("", 4);
        this.findAllDeclarations((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), workingCopyOwner);
        Assert.isTrue((boolean)this.fDeclarations.contains(this.fMethod), (String)"Search for method declaration did not find original element");
        this.createHierarchyOfDeclarations((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), workingCopyOwner);
        this.createTypeToMethod();
        this.createUnionFind();
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fHierarchy = null;
        this.fRootTypes = null;
        HashMap<IType, ArrayList<IType>> hashMap = new HashMap<IType, ArrayList<IType>>();
        IType iType = this.fTypeToMethod.keySet().iterator();
        while (iType.hasNext()) {
            object4 = (IType)iType.next();
            IType iType2 = this.fUnionFind.find((IType)object4);
            arrayList = (ArrayList<IType>)hashMap.get(iType2);
            if (arrayList == null) {
                arrayList = new ArrayList<IType>();
            }
            arrayList.add((IType)object4);
            hashMap.put(iType2, arrayList);
        }
        Assert.isTrue((hashMap.size() > 0 ? 1 : 0) != 0);
        if (hashMap.size() == 1) {
            return this.fDeclarations.toArray(new IMethod[this.fDeclarations.size()]);
        }
        iType = this.fUnionFind.find(this.fMethod.getDeclaringType());
        object4 = (List)hashMap.get(iType);
        boolean bl = false;
        arrayList = new ArrayList();
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object3 = (IType)object5.next();
            arrayList.add((IType)this.fTypeToMethod.get(object3));
            if (!object3.isInterface()) continue;
            bl = true;
        }
        object5 = new ArrayList(this.fDeclarations);
        this.fDeclarations = null;
        object5.removeAll(arrayList);
        object3 = new ArrayList();
        boolean bl2 = false;
        Object object6 = object5.iterator();
        while (object6.hasNext()) {
            object2 = (IMethod)object6.next();
            object = object2.getDeclaringType();
            object3.add(object);
            if (!object.isInterface()) continue;
            bl2 = true;
        }
        if (object3.size() == 0) {
            return arrayList.toArray(new IMethod[arrayList.size()]);
        }
        if (!bl && !bl2) {
            return arrayList.toArray(new IMethod[arrayList.size()]);
        }
        object6 = new HashSet();
        object2 = new ArrayList(object4);
        while (object2.size() > 0) {
            IType iType3;
            Object object7;
            ITypeHierarchy iTypeHierarchy;
            Object object8;
            object = object2.iterator();
            while (object.hasNext()) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                object8 = (IType)object.next();
                iTypeHierarchy = this.getCachedHierarchy((IType)object8, workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (iTypeHierarchy == null) {
                    iTypeHierarchy = object8.newTypeHierarchy(workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                object7 = iTypeHierarchy.getAllSubtypes((IType)object8);
                int n = 0;
                while (n < ((IMethod)object7).length) {
                    ((HashSet)object6).add(object7[n]);
                    ++n;
                }
            }
            object2.clear();
            object = new HashSet();
            object8 = object3.iterator();
            while (object8.hasNext()) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iTypeHierarchy = (IType)object8.next();
                object7 = (IMethod)this.fTypeToMethod.get(iTypeHierarchy);
                ITypeHierarchy iTypeHierarchy2 = this.getCachedHierarchy((IType)iTypeHierarchy, workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (iTypeHierarchy2 == null) {
                    iTypeHierarchy2 = iTypeHierarchy.newTypeHierarchy(workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                iType3 = iTypeHierarchy2.getAllSubtypes((IType)iTypeHierarchy);
                int n = 0;
                while (n < ((IType)iType3).length) {
                    IType iType4 = iType3[n];
                    if (((HashSet)object6).contains(iType4) && JavaModelUtil.isVisibleInHierarchy((IMember)object7, iType4.getPackageFragment())) {
                        ((HashSet)object).add(this.fUnionFind.find((IType)iTypeHierarchy));
                    }
                    ++n;
                }
            }
            if (((HashSet)object).size() == 0) {
                return arrayList.toArray(new IMethod[arrayList.size()]);
            }
            object8 = ((HashSet)object).iterator();
            while (object8.hasNext()) {
                iTypeHierarchy = (IType)object8.next();
                object7 = (List)hashMap.get(iTypeHierarchy);
                Iterator iterator = object7.iterator();
                while (iterator.hasNext()) {
                    iType3 = (IType)iterator.next();
                    arrayList.add((IType)this.fTypeToMethod.get(iType3));
                }
                object3.removeAll((Collection<?>)object7);
                object2.addAll(object7);
            }
        }
        this.fRootReps = null;
        this.fRootHierarchies = null;
        this.fTypeToMethod = null;
        this.fUnionFind = null;
        return arrayList.toArray(new IMethod[arrayList.size()]);
    }

    private ITypeHierarchy getCachedHierarchy(IType iType, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType iType2 = this.fUnionFind.find(iType);
        if (iType2 != null) {
            Collection collection = this.fRootReps.get(iType2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IType iType3 = (IType)iterator.next();
                ITypeHierarchy iTypeHierarchy = (ITypeHierarchy)this.fRootHierarchies.get(iType3);
                if (iTypeHierarchy == null) {
                    iTypeHierarchy = iType3.newTypeHierarchy(workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    this.fRootHierarchies.put(iType3, iTypeHierarchy);
                }
                if (!iTypeHierarchy.contains(iType)) continue;
                return iTypeHierarchy;
            }
        }
        return null;
    }

    private void findAllDeclarations(IProgressMonitor iProgressMonitor, WorkingCopyOwner workingCopyOwner) throws CoreException {
        this.fDeclarations = new ArrayList();
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fMethod, (int)48, (int)24));
        if (workingCopyOwner != null) {
            refactoringSearchEngine2.setOwner(workingCopyOwner);
        }
        refactoringSearchEngine2.setScope(RefactoringScopeFactory.createRelatedProjectsScope(this.fMethod.getJavaProject(), 7));
        refactoringSearchEngine2.setFiltering(false, this.fExcludeBinaries);
        refactoringSearchEngine2.setGrouping(false);
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        SearchMatch[] searchMatchArray = (SearchMatch[])refactoringSearchEngine2.getResults();
        IMethod iMethod = null;
        int n = 0;
        while (n < searchMatchArray.length) {
            iMethod = (IMethod)searchMatchArray[n].getElement();
            if (iMethod != null) {
                this.fDeclarations.add(iMethod);
            }
            ++n;
        }
    }

    private void createHierarchyOfDeclarations(IProgressMonitor iProgressMonitor, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        IRegion iRegion = JavaCore.newRegion();
        Iterator iterator = this.fDeclarations.iterator();
        while (iterator.hasNext()) {
            IType iType = ((IMethod)iterator.next()).getDeclaringType();
            iRegion.add((IJavaElement)iType);
        }
        this.fHierarchy = JavaCore.newTypeHierarchy((IRegion)iRegion, (WorkingCopyOwner)workingCopyOwner, (IProgressMonitor)iProgressMonitor);
    }

    private void createTypeToMethod() {
        this.fTypeToMethod = new HashMap();
        Iterator iterator = this.fDeclarations.iterator();
        while (iterator.hasNext()) {
            IMethod iMethod = (IMethod)iterator.next();
            this.fTypeToMethod.put(iMethod.getDeclaringType(), iMethod);
        }
    }

    private void createUnionFind() throws JavaModelException {
        IType iType;
        this.fRootTypes = new HashSet(this.fTypeToMethod.keySet());
        this.fUnionFind = new UnionFind();
        Iterator<Object> iterator = this.fTypeToMethod.keySet().iterator();
        while (iterator.hasNext()) {
            iType = (IType)iterator.next();
            this.fUnionFind.init(iType);
        }
        iterator = this.fTypeToMethod.keySet().iterator();
        while (iterator.hasNext()) {
            iType = (IType)iterator.next();
            this.uniteWithSupertypes(iType, iType);
        }
        this.fRootReps = new MultiMap();
        iterator = this.fRootTypes.iterator();
        while (iterator.hasNext()) {
            iType = (IType)iterator.next();
            IType iType2 = this.fUnionFind.find(iType);
            if (iType2 == null) continue;
            this.fRootReps.put(iType2, iType);
        }
        this.fRootHierarchies = new HashMap();
    }

    private void uniteWithSupertypes(IType iType, IType iType2) throws JavaModelException {
        IType[] iTypeArray = this.fHierarchy.getSupertypes(iType2);
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType3 = iTypeArray[n];
            IType iType4 = this.fUnionFind.find(iType3);
            if (iType4 == null) {
                this.uniteWithSupertypes(iType, iType3);
            } else {
                IMember iMember = (IMember)this.fTypeToMethod.get(iType3);
                if (JavaModelUtil.isVisibleInHierarchy(iMember, iType.getPackageFragment())) {
                    IType iType5 = this.fUnionFind.find(iType);
                    this.fUnionFind.union(iType5, iType4);
                    this.fRootTypes.remove(iType);
                    this.uniteWithSupertypes(iType3, iType3);
                }
            }
            ++n;
        }
    }

    private static class MultiMap {
        HashMap fImplementation = new HashMap();

        private MultiMap() {
        }

        public void put(IType iType, IType iType2) {
            HashSet<IType> hashSet = (HashSet<IType>)this.fImplementation.get(iType);
            if (hashSet == null) {
                hashSet = new HashSet<IType>();
                this.fImplementation.put(iType, hashSet);
            }
            hashSet.add(iType2);
        }

        public Collection get(IType iType) {
            return (Collection)this.fImplementation.get(iType);
        }
    }

    private static class UnionFind {
        HashMap fElementToRepresentative = new HashMap();

        private UnionFind() {
        }

        public void init(IType iType) {
            this.fElementToRepresentative.put(iType, iType);
        }

        public IType find(IType iType) {
            IType iType2 = iType;
            IType iType3 = (IType)this.fElementToRepresentative.get(iType2);
            while (iType3 != null && !iType3.equals(iType2)) {
                iType2 = iType3;
                iType3 = (IType)this.fElementToRepresentative.get(iType2);
            }
            if (iType3 == null) {
                return null;
            }
            iType3 = (IType)this.fElementToRepresentative.get(iType);
            while (!iType3.equals(iType2)) {
                IType iType4 = iType;
                iType = iType3;
                this.fElementToRepresentative.put(iType4, iType2);
                iType3 = (IType)this.fElementToRepresentative.get(iType);
            }
            return iType2;
        }

        public void union(IType iType, IType iType2) {
            this.fElementToRepresentative.put(iType, iType2);
        }
    }
}

