/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;

class TextMatchUpdater {
    private static final String TEXT_EDIT_LABEL = RefactoringCoreMessages.TextMatchUpdater_update;
    private static final GroupCategorySet TEXTUAL_MATCHES = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.textualMatches", RefactoringCoreMessages.TextMatchUpdater_textualMatches_name, RefactoringCoreMessages.TextMatchUpdater_textualMatches_description));
    private final IJavaSearchScope fScope;
    private final TextChangeManager fManager;
    private final SearchResultGroup[] fReferences;
    private final boolean fOnlyQualified;
    private final RefactoringScanner fScanner;
    private final String fNewName;
    private final int fCurrentNameLength;

    private TextMatchUpdater(TextChangeManager textChangeManager, IJavaSearchScope iJavaSearchScope, String string, String string2, String string3, SearchResultGroup[] searchResultGroupArray, boolean bl) {
        Assert.isNotNull((Object)textChangeManager);
        Assert.isNotNull((Object)iJavaSearchScope);
        Assert.isNotNull((Object)searchResultGroupArray);
        this.fManager = textChangeManager;
        this.fScope = iJavaSearchScope;
        this.fReferences = searchResultGroupArray;
        this.fOnlyQualified = bl;
        this.fNewName = string3;
        this.fCurrentNameLength = string.length();
        this.fScanner = new RefactoringScanner(string, string2);
    }

    static void perform(IProgressMonitor iProgressMonitor, IJavaSearchScope iJavaSearchScope, String string, String string2, String string3, TextChangeManager textChangeManager, SearchResultGroup[] searchResultGroupArray, boolean bl) throws JavaModelException {
        new TextMatchUpdater(textChangeManager, iJavaSearchScope, string, string2, string3, searchResultGroupArray, bl).updateTextMatches(iProgressMonitor);
    }

    static void perform(IProgressMonitor iProgressMonitor, IJavaSearchScope iJavaSearchScope, ITextUpdating iTextUpdating, TextChangeManager textChangeManager, SearchResultGroup[] searchResultGroupArray) throws JavaModelException {
        new TextMatchUpdater(textChangeManager, iJavaSearchScope, iTextUpdating.getCurrentElementName(), iTextUpdating.getCurrentElementQualifier(), iTextUpdating.getNewElementName(), searchResultGroupArray, false).updateTextMatches(iProgressMonitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTextMatches(IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            IProject[] iProjectArray = this.getProjectsInScope();
            iProgressMonitor.beginTask("", iProjectArray.length);
            int n = 0;
            while (n < iProjectArray.length) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.addTextMatches((IResource)iProjectArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iProgressMonitor.done();
    }

    private IProject[] getProjectsInScope() {
        IPath[] iPathArray = this.fScope.enclosingProjectsAndJars();
        HashSet<IPath> hashSet = new HashSet<IPath>();
        hashSet.addAll(Arrays.asList(iPathArray));
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (hashSet.contains(iProjectArray[n].getFullPath())) {
                arrayList.add(iProjectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTextMatches(IResource iResource, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            block13: {
                try {
                    String string;
                    block14: {
                        IJavaElement iJavaElement;
                        block17: {
                            block16: {
                                block15: {
                                    string = String.valueOf(RefactoringCoreMessages.TextMatchUpdater_searching) + iResource.getFullPath();
                                    if (!(iResource instanceof IFile)) break block14;
                                    iJavaElement = JavaCore.create((IResource)iResource);
                                    if (iJavaElement instanceof ICompilationUnit) break block15;
                                    break block16;
                                }
                                if (iJavaElement.exists() && this.fScope.encloses(iJavaElement)) break block17;
                            }
                            Object var6_8 = null;
                            iProgressMonitor.done();
                            return;
                        }
                        this.addCuTextMatches((ICompilationUnit)iJavaElement);
                        break block13;
                    }
                    if (iResource instanceof IContainer) {
                        IResource[] iResourceArray = ((IContainer)iResource).members();
                        iProgressMonitor.beginTask(string, iResourceArray.length);
                        iProgressMonitor.subTask(string);
                        int n = 0;
                        while (n < iResourceArray.length) {
                            if (iProgressMonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            this.addTextMatches(iResourceArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            ++n;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    throw javaModelException;
                }
                catch (CoreException coreException) {
                    throw new JavaModelException(coreException);
                }
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    private void addCuTextMatches(ICompilationUnit iCompilationUnit) throws JavaModelException {
        this.fScanner.scan(iCompilationUnit);
        Set set = this.fScanner.getMatches();
        if (set.size() == 0) {
            return;
        }
        this.removeReferences(iCompilationUnit, set);
        if (set.size() != 0) {
            this.addTextUpdates(iCompilationUnit, set);
        }
    }

    private void removeReferences(ICompilationUnit iCompilationUnit, Set set) {
        int n = 0;
        while (n < this.fReferences.length) {
            SearchResultGroup searchResultGroup = this.fReferences[n];
            if (iCompilationUnit.equals(searchResultGroup.getCompilationUnit())) {
                this.removeReferences(set, searchResultGroup);
            }
            ++n;
        }
    }

    private void removeReferences(Set set, SearchResultGroup searchResultGroup) {
        SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
        int n = 0;
        while (n < searchMatchArray.length) {
            int n2 = searchMatchArray[n].getOffset() + searchMatchArray[n].getLength() - this.fCurrentNameLength;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                RefactoringScanner.TextMatch textMatch = (RefactoringScanner.TextMatch)iterator.next();
                if (textMatch.getStartPosition() != n2) continue;
                iterator.remove();
            }
            ++n;
        }
    }

    private void addTextUpdates(ICompilationUnit iCompilationUnit, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RefactoringScanner.TextMatch textMatch = (RefactoringScanner.TextMatch)iterator.next();
            if (!textMatch.isQualified() && this.fOnlyQualified) continue;
            int n = textMatch.getStartPosition();
            ReplaceEdit replaceEdit = new ReplaceEdit(n, this.fCurrentNameLength, this.fNewName);
            try {
                TextChangeCompatibility.addTextEdit(this.fManager.get(iCompilationUnit), TEXT_EDIT_LABEL, (TextEdit)replaceEdit, TEXTUAL_MATCHES);
            }
            catch (MalformedTreeException malformedTreeException) {}
        }
    }
}

