/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

class OverwriteHelper {
    private Object fDestination;
    private IFile[] fFiles = new IFile[0];
    private IFolder[] fFolders = new IFolder[0];
    private ICompilationUnit[] fCus = new ICompilationUnit[0];
    private IPackageFragmentRoot[] fRoots = new IPackageFragmentRoot[0];
    private IPackageFragment[] fPackageFragments = new IPackageFragment[0];

    OverwriteHelper() {
    }

    public void setFiles(IFile[] iFileArray) {
        Assert.isNotNull((Object)iFileArray);
        this.fFiles = iFileArray;
    }

    public void setFolders(IFolder[] iFolderArray) {
        Assert.isNotNull((Object)iFolderArray);
        this.fFolders = iFolderArray;
    }

    public void setCus(ICompilationUnit[] iCompilationUnitArray) {
        Assert.isNotNull((Object)iCompilationUnitArray);
        this.fCus = iCompilationUnitArray;
    }

    public void setPackageFragmentRoots(IPackageFragmentRoot[] iPackageFragmentRootArray) {
        Assert.isNotNull((Object)iPackageFragmentRootArray);
        this.fRoots = iPackageFragmentRootArray;
    }

    public void setPackages(IPackageFragment[] iPackageFragmentArray) {
        Assert.isNotNull((Object)iPackageFragmentArray);
        this.fPackageFragments = iPackageFragmentArray;
    }

    public IFile[] getFilesWithoutUnconfirmedOnes() {
        return this.fFiles;
    }

    public IFolder[] getFoldersWithoutUnconfirmedOnes() {
        return this.fFolders;
    }

    public ICompilationUnit[] getCusWithoutUnconfirmedOnes() {
        return this.fCus;
    }

    public IPackageFragmentRoot[] getPackageFragmentRootsWithoutUnconfirmedOnes() {
        return this.fRoots;
    }

    public IPackageFragment[] getPackagesWithoutUnconfirmedOnes() {
        return this.fPackageFragments;
    }

    public void confirmOverwriting(IReorgQueries iReorgQueries, IJavaElement iJavaElement) {
        Assert.isNotNull((Object)iJavaElement);
        this.fDestination = iJavaElement;
        this.confirmOverwritting(iReorgQueries);
    }

    public void confirmOverwriting(IReorgQueries iReorgQueries, IResource iResource) {
        Assert.isNotNull((Object)iResource);
        Assert.isNotNull((Object)iReorgQueries);
        this.fDestination = iResource;
        this.confirmOverwritting(iReorgQueries);
    }

    private void confirmOverwritting(IReorgQueries iReorgQueries) {
        IConfirmQuery iConfirmQuery = iReorgQueries.createYesYesToAllNoNoToAllQuery(RefactoringCoreMessages.OverwriteHelper_0, true, 6);
        IConfirmQuery iConfirmQuery2 = iReorgQueries.createSkipQuery(RefactoringCoreMessages.OverwriteHelper_2, 7);
        this.confirmFileOverwritting(iConfirmQuery);
        this.confirmFolderOverwritting(iConfirmQuery2);
        this.confirmCuOverwritting(iConfirmQuery);
        this.confirmPackageFragmentRootOverwritting(iConfirmQuery2);
        this.confirmPackageOverwritting(iConfirmQuery);
    }

    private void confirmPackageFragmentRootOverwritting(IConfirmQuery iConfirmQuery) {
        ArrayList<IPackageFragmentRoot> arrayList = new ArrayList<IPackageFragmentRoot>(1);
        int n = 0;
        while (n < this.fRoots.length) {
            IPackageFragmentRoot iPackageFragmentRoot = this.fRoots[n];
            if (this.canOverwrite(iPackageFragmentRoot) && !OverwriteHelper.skip(iPackageFragmentRoot.getElementName(), iConfirmQuery)) {
                arrayList.add(iPackageFragmentRoot);
            }
            ++n;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = arrayList.toArray(new IPackageFragmentRoot[arrayList.size()]);
        this.fRoots = ArrayTypeConverter.toPackageFragmentRootArray(ReorgUtils.setMinus((IJavaElement[])this.fRoots, (IJavaElement[])iPackageFragmentRootArray));
    }

    private void confirmCuOverwritting(IConfirmQuery iConfirmQuery) {
        ArrayList<ICompilationUnit> arrayList = new ArrayList<ICompilationUnit>(1);
        int n = 0;
        while (n < this.fCus.length) {
            ICompilationUnit iCompilationUnit = this.fCus[n];
            if (this.canOverwrite(iCompilationUnit) && !OverwriteHelper.overwrite((IJavaElement)iCompilationUnit, iConfirmQuery)) {
                arrayList.add(iCompilationUnit);
            }
            ++n;
        }
        ICompilationUnit[] iCompilationUnitArray = arrayList.toArray(new ICompilationUnit[arrayList.size()]);
        this.fCus = ArrayTypeConverter.toCuArray(ReorgUtils.setMinus((IJavaElement[])this.fCus, (IJavaElement[])iCompilationUnitArray));
    }

    private void confirmFolderOverwritting(IConfirmQuery iConfirmQuery) {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>(1);
        int n = 0;
        while (n < this.fFolders.length) {
            IFolder iFolder = this.fFolders[n];
            if (this.canOverwrite((IResource)iFolder) && !OverwriteHelper.skip(iFolder.getName(), iConfirmQuery)) {
                arrayList.add(iFolder);
            }
            ++n;
        }
        IFolder[] iFolderArray = arrayList.toArray(new IFolder[arrayList.size()]);
        this.fFolders = ArrayTypeConverter.toFolderArray(ReorgUtils.setMinus((IResource[])this.fFolders, (IResource[])iFolderArray));
    }

    private void confirmFileOverwritting(IConfirmQuery iConfirmQuery) {
        ArrayList<IFile> arrayList = new ArrayList<IFile>(1);
        int n = 0;
        while (n < this.fFiles.length) {
            IFile iFile = this.fFiles[n];
            if (this.canOverwrite((IResource)iFile) && !OverwriteHelper.overwrite((IResource)iFile, iConfirmQuery)) {
                arrayList.add(iFile);
            }
            ++n;
        }
        IFile[] iFileArray = arrayList.toArray(new IFile[arrayList.size()]);
        this.fFiles = ArrayTypeConverter.toFileArray(ReorgUtils.setMinus((IResource[])this.fFiles, (IResource[])iFileArray));
    }

    private void confirmPackageOverwritting(IConfirmQuery iConfirmQuery) {
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>(1);
        int n = 0;
        while (n < this.fPackageFragments.length) {
            IPackageFragment iPackageFragment = this.fPackageFragments[n];
            if (this.canOverwrite(iPackageFragment) && !OverwriteHelper.overwrite((IJavaElement)iPackageFragment, iConfirmQuery)) {
                arrayList.add(iPackageFragment);
            }
            ++n;
        }
        IPackageFragment[] iPackageFragmentArray = arrayList.toArray(new IPackageFragment[arrayList.size()]);
        this.fPackageFragments = ArrayTypeConverter.toPackageArray(ReorgUtils.setMinus((IJavaElement[])this.fPackageFragments, (IJavaElement[])iPackageFragmentArray));
    }

    private boolean canOverwrite(IPackageFragment iPackageFragment) {
        Assert.isTrue((boolean)(this.fDestination instanceof IPackageFragmentRoot));
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)this.fDestination;
        return !iPackageFragmentRoot.equals(iPackageFragment.getParent()) && iPackageFragmentRoot.getPackageFragment(iPackageFragment.getElementName()).exists();
    }

    private boolean canOverwrite(IResource iResource) {
        if (iResource == null) {
            return false;
        }
        IResource iResource2 = ResourceUtil.getResource(this.fDestination);
        if (iResource2.equals((Object)iResource.getParent())) {
            return false;
        }
        if (iResource2 instanceof IContainer) {
            IContainer iContainer = (IContainer)iResource2;
            IResource iResource3 = iContainer.findMember(iResource.getName());
            if (iResource3 == null || !iResource3.exists()) {
                return false;
            }
            if (iResource3 instanceof IContainer) {
                try {
                    if (((IContainer)iResource3).members().length == 0) {
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private boolean canOverwrite(IPackageFragmentRoot iPackageFragmentRoot) {
        Assert.isTrue((boolean)(this.fDestination instanceof IJavaProject));
        IJavaProject iJavaProject = (IJavaProject)this.fDestination;
        IFolder iFolder = iJavaProject.getProject().getFolder(iPackageFragmentRoot.getElementName());
        try {
            return !iJavaProject.equals(iPackageFragmentRoot.getParent()) && iFolder.exists() && iFolder.members().length > 0;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    private boolean canOverwrite(ICompilationUnit iCompilationUnit) {
        if (this.fDestination instanceof IPackageFragment) {
            IPackageFragment iPackageFragment = (IPackageFragment)this.fDestination;
            return !iPackageFragment.equals(iCompilationUnit.getParent()) && iPackageFragment.getCompilationUnit(iCompilationUnit.getElementName()).exists();
        }
        return this.canOverwrite(ReorgUtils.getResource((IJavaElement)iCompilationUnit));
    }

    private static boolean overwrite(IResource iResource, IConfirmQuery iConfirmQuery) {
        return OverwriteHelper.overwrite(iResource.getName(), iConfirmQuery);
    }

    private static boolean overwrite(IJavaElement iJavaElement, IConfirmQuery iConfirmQuery) {
        return OverwriteHelper.overwrite(iJavaElement.getElementName(), iConfirmQuery);
    }

    private static boolean overwrite(String string, IConfirmQuery iConfirmQuery) {
        String string2 = Messages.format(RefactoringCoreMessages.OverwriteHelper_1, string);
        return iConfirmQuery.confirm(string2);
    }

    private static boolean skip(String string, IConfirmQuery iConfirmQuery) {
        String string2 = Messages.format(RefactoringCoreMessages.OverwriteHelper_3, string);
        return iConfirmQuery.confirm(string2);
    }
}

