/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyPackageChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyPackageFragmentRootChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MovePackageChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MovePackageFragmentRootChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MoveResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CopyModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateCopyOfCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JDTCopyRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JDTMoveRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MoveCuUpdateCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.OverwriteHelper;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.Changes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class ReorgPolicyFactory {
    private static final String ATTRIBUTE_FILES = "files";
    private static final String ATTRIBUTE_FOLDERS = "folders";
    private static final String ATTRIBUTE_FRAGMENTS = "fragments";
    private static final String ATTRIBUTE_LOG = "log";
    private static final String ATTRIBUTE_MEMBERS = "members";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_POLICY = "policy";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_ROOTS = "roots";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String DELIMITER_ELEMENT = "\t";
    private static final String DELIMITER_RECORD = "\n";
    private static final String NO_ID = "no_id";
    private static final String NO_POLICY = "no_policy";
    private static final String UNUSED_STRING = "unused";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static boolean containsNull(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws JavaModelException {
        return (IReorgPolicy.ICopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, iResourceArray, iJavaElementArray);
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(RefactoringStatus refactoringStatus, RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_POLICY);
            if (string != null && !"".equals(string)) {
                if ("org.eclipse.wst.jsdt.ui.copyResources".equals(string)) {
                    return new CopyFilesFoldersAndCusPolicy(null, null, null);
                }
                if ("org.eclipse.wst.jsdt.ui.copyRoots".equals(string)) {
                    return new CopyPackageFragmentRootsPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.copyPackages".equals(string)) {
                    return new CopyPackagesPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.copyMembers".equals(string)) {
                    return new CopySubCuElementsPolicy(null);
                }
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{string, ATTRIBUTE_POLICY})));
            } else {
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
            }
        } else {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
        }
        return null;
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws JavaModelException {
        return (IReorgPolicy.IMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, iResourceArray, iJavaElementArray);
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(RefactoringStatus refactoringStatus, RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_POLICY);
            if (string != null && !"".equals(string)) {
                if ("org.eclipse.wst.jsdt.ui.moveResources".equals(string)) {
                    return new MoveFilesFoldersAndCusPolicy(null, null, null);
                }
                if ("org.eclipse.wst.jsdt.ui.moveRoots".equals(string)) {
                    return new MovePackageFragmentRootsPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.movePackages".equals(string)) {
                    return new MovePackagesPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.moveMembers".equals(string)) {
                    return new MoveSubCuElementsPolicy(null);
                }
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{string, ATTRIBUTE_POLICY})));
            } else {
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
            }
        } else {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
        }
        return null;
    }

    private static IReorgPolicy createReorgPolicy(boolean bl, IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws JavaModelException {
        Object[] objectArray;
        ReorgPolicy reorgPolicy = bl ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer actualSelectionComputer = new ActualSelectionComputer(iJavaElementArray, iResourceArray);
        Object[] objectArray2 = actualSelectionComputer.getActualResourcesToReorg();
        if (objectArray2.length + (objectArray = actualSelectionComputer.getActualJavaElementsToReorg()).length == 0 || ReorgPolicyFactory.containsNull(objectArray2) || ReorgPolicyFactory.containsNull(objectArray) || ReorgUtils.isArchiveMember((IJavaElement[])objectArray) || ReorgUtils.hasElementsOfType((IJavaElement[])objectArray, 2) || ReorgUtils.hasElementsOfType((IJavaElement[])objectArray, 1) || ReorgUtils.hasElementsOfType((IResource[])objectArray2, 12) || !new ParentChecker((IResource[])objectArray2, (IJavaElement[])objectArray).haveCommonParent()) {
            return reorgPolicy;
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])objectArray, 4)) {
            if (objectArray2.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])objectArray, 4)) {
                return reorgPolicy;
            }
            if (bl) {
                return new CopyPackagesPolicy(ArrayTypeConverter.toPackageArray(objectArray));
            }
            return new MovePackagesPolicy(ArrayTypeConverter.toPackageArray(objectArray));
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])objectArray, 3)) {
            if (objectArray2.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])objectArray, 3)) {
                return reorgPolicy;
            }
            if (bl) {
                return new CopyPackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(objectArray));
            }
            return new MovePackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(objectArray));
        }
        if (ReorgUtils.hasElementsOfType((IResource[])objectArray2, 3) || ReorgUtils.hasElementsOfType((IJavaElement[])objectArray, 5)) {
            if (ReorgUtils.hasElementsNotOfType((IJavaElement[])objectArray, 5)) {
                return reorgPolicy;
            }
            if (ReorgUtils.hasElementsNotOfType((IResource[])objectArray2, 3)) {
                return reorgPolicy;
            }
            if (bl) {
                return new CopyFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])objectArray2), ReorgUtils.getFolders((IResource[])objectArray2), ArrayTypeConverter.toCuArray(objectArray));
            }
            return new MoveFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])objectArray2), ReorgUtils.getFolders((IResource[])objectArray2), ArrayTypeConverter.toCuArray(objectArray));
        }
        if (ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IJavaElement[])objectArray)) {
            Assert.isTrue((objectArray2.length == 0 ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IJavaElement[])objectArray, 5) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IJavaElement[])objectArray, 6) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgPolicyFactory.hasElementsLargerThanCuOrClassFile((IJavaElement[])objectArray) ? 1 : 0) != 0);
            if (bl) {
                return new CopySubCuElementsPolicy((IJavaElement[])objectArray);
            }
            return new MoveSubCuElementsPolicy((IJavaElement[])objectArray);
        }
        return reorgPolicy;
    }

    private static boolean hasElementsLargerThanCuOrClassFile(IJavaElement[] iJavaElementArray) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (!ReorgUtils.isInsideCompilationUnit(iJavaElementArray[n]) && !ReorgUtils.isInsideClassFile(iJavaElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IJavaElement[] iJavaElementArray) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (ReorgUtils.isInsideCompilationUnit(iJavaElementArray[n])) {
                return true;
            }
            if (ReorgUtils.isInsideClassFile(iJavaElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static CreateTargetExecutionLog loadCreateTargetExecutionLog(RefactoringStatus refactoringStatus, JavaRefactoringArguments javaRefactoringArguments) {
        CreateTargetExecutionLog createTargetExecutionLog = new CreateTargetExecutionLog();
        String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_LOG);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_RECORD, false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                ReorgPolicyFactory.processCreateTargetExecutionRecord(createTargetExecutionLog, javaRefactoringArguments, string2);
            }
        }
        return createTargetExecutionLog;
    }

    public static ReorgExecutionLog loadReorgExecutionLog(RefactoringStatus refactoringStatus, JavaRefactoringArguments javaRefactoringArguments) {
        ReorgExecutionLog reorgExecutionLog = new ReorgExecutionLog();
        String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_LOG);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_RECORD, false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                ReorgPolicyFactory.processReorgExecutionRecord(reorgExecutionLog, javaRefactoringArguments, string2);
            }
        }
        return reorgExecutionLog;
    }

    private static void processCreateTargetExecutionRecord(CreateTargetExecutionLog createTargetExecutionLog, JavaRefactoringArguments javaRefactoringArguments, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_ELEMENT, false);
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
            if (iJavaElement == null) {
                iJavaElement = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string2);
            }
            if (iJavaElement != null && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                IJavaElement iJavaElement2 = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (iJavaElement2 == null) {
                    iJavaElement2 = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string2);
                }
                if (iJavaElement2 != null) {
                    createTargetExecutionLog.markAsCreated(iJavaElement, iJavaElement2);
                }
            }
        }
    }

    private static void processReorgExecutionRecord(ReorgExecutionLog reorgExecutionLog, JavaRefactoringArguments javaRefactoringArguments, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_ELEMENT, false);
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2);
            if (iJavaElement == null) {
                iJavaElement = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string2);
            }
            if (stringTokenizer.hasMoreTokens()) {
                boolean bl;
                boolean bl2 = Boolean.valueOf(stringTokenizer.nextToken());
                if (bl2) {
                    reorgExecutionLog.markAsProcessed((Object)iJavaElement);
                    if (iJavaElement instanceof IJavaElement) {
                        reorgExecutionLog.markAsProcessed((Object)JavaElementResourceMapping.create(iJavaElement));
                    }
                }
                if (stringTokenizer.hasMoreTokens() && (bl = Boolean.valueOf(stringTokenizer.nextToken()).booleanValue()) && stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    reorgExecutionLog.setNewName((Object)iJavaElement, string3);
                    if (iJavaElement instanceof IJavaElement) {
                        reorgExecutionLog.setNewName((Object)JavaElementResourceMapping.create(iJavaElement), string3);
                    }
                }
            }
        }
    }

    public static void storeCreateTargetExecutionLog(String string, Map map, CreateTargetExecutionLog createTargetExecutionLog) {
        if (createTargetExecutionLog != null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            Object[] objectArray = createTargetExecutionLog.getSelectedElements();
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                Object object2 = objectArray[n];
                if (object2 != null && (object = createTargetExecutionLog.getCreatedElement(object2)) != null) {
                    ReorgPolicyFactory.storeLogElement(stringBuffer, string, object2);
                    stringBuffer.append(DELIMITER_ELEMENT);
                    ReorgPolicyFactory.storeLogElement(stringBuffer, string, object);
                    stringBuffer.append(DELIMITER_RECORD);
                }
                ++n;
            }
            String string2 = new String(stringBuffer.toString().trim());
            if (!"".equals(string2)) {
                map.put(ATTRIBUTE_LOG, string2);
            }
        }
    }

    private static boolean storeLogElement(StringBuffer stringBuffer, String string, Object object) {
        if (object instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)object;
            stringBuffer.append(JDTRefactoringDescriptor.elementToHandle(string, iJavaElement));
            return true;
        }
        if (object instanceof IResource) {
            IResource iResource = (IResource)object;
            stringBuffer.append(JDTRefactoringDescriptor.resourceToHandle(string, iResource));
            return true;
        }
        return false;
    }

    public static void storeReorgExecutionLog(String string, Map map, ReorgExecutionLog reorgExecutionLog) {
        if (reorgExecutionLog != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.addAll(Arrays.asList(reorgExecutionLog.getProcessedElements()));
            hashSet.addAll(Arrays.asList(reorgExecutionLog.getRenamedElements()));
            StringBuffer stringBuffer = new StringBuffer(64);
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (!ReorgPolicyFactory.storeLogElement(stringBuffer, string, e)) continue;
                stringBuffer.append(DELIMITER_ELEMENT);
                stringBuffer.append(reorgExecutionLog.isProcessed(e));
                stringBuffer.append(DELIMITER_ELEMENT);
                boolean bl = reorgExecutionLog.isRenamed(e);
                stringBuffer.append(bl);
                if (bl) {
                    stringBuffer.append(DELIMITER_ELEMENT);
                    stringBuffer.append(reorgExecutionLog.getNewName(e));
                }
                stringBuffer.append(DELIMITER_RECORD);
            }
            object = new String(stringBuffer.toString().trim());
            if (!"".equals(object)) {
                map.put(ATTRIBUTE_LOG, object);
            }
        }
    }

    private ReorgPolicyFactory() {
    }

    private static final class ActualSelectionComputer {
        private final IJavaElement[] fJavaElements;
        private final IResource[] fResources;

        public ActualSelectionComputer(IJavaElement[] iJavaElementArray, IResource[] iResourceArray) {
            this.fJavaElements = iJavaElementArray;
            this.fResources = iResourceArray;
        }

        public IJavaElement[] getActualJavaElementsToReorg() throws JavaModelException {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < this.fJavaElements.length) {
                IJavaElement iJavaElement = this.fJavaElements[n];
                if (iJavaElement != null) {
                    if (iJavaElement instanceof IType) {
                        IType iType = (IType)iJavaElement;
                        ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
                        if (iCompilationUnit != null && iType.getDeclaringType() == null && iCompilationUnit.exists() && iCompilationUnit.getTypes().length == 1 && !arrayList.contains(iCompilationUnit)) {
                            arrayList.add(iCompilationUnit);
                        } else if (!arrayList.contains(iType)) {
                            arrayList.add(iType);
                        }
                    } else if (!arrayList.contains(iJavaElement)) {
                        arrayList.add(iJavaElement);
                    }
                }
                ++n;
            }
            return arrayList.toArray(new IJavaElement[arrayList.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            int n = 0;
            while (n < this.fResources.length) {
                IJavaElement iJavaElement;
                if (!(this.fResources[n] == null || (iJavaElement = JavaCore.create((IResource)this.fResources[n])) != null && iJavaElement.exists() && hashSet.contains(iJavaElement) || arrayList.contains(this.fResources[n]))) {
                    arrayList.add(this.fResources[n]);
                }
                ++n;
            }
            return arrayList.toArray(new IResource[arrayList.size()]);
        }
    }

    private static final class CopyFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_RESOURCE = "org.eclipse.wst.jsdt.ui.copyResources";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        private static Change copyCuToPackage(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment, NewNameProposer newNameProposer, INewNameQueries iNewNameQueries) {
            IResource iResource = ReorgUtils.getResource((IJavaElement)iCompilationUnit);
            if (iResource != null && iResource.isLinked() && ResourceUtil.getResource(iPackageFragment) instanceof IContainer) {
                return CopyFilesFoldersAndCusPolicy.copyFileToContainer(iCompilationUnit, (IContainer)ResourceUtil.getResource(iPackageFragment), newNameProposer, iNewNameQueries);
            }
            String string = newNameProposer.createNewName(iCompilationUnit, iPackageFragment);
            CopyCompilationUnitChange copyCompilationUnitChange = new CopyCompilationUnitChange(iCompilationUnit, iPackageFragment, iNewNameQueries.createStaticQuery(string));
            if (string == null || string.equals(iCompilationUnit.getElementName())) {
                return copyCompilationUnitChange;
            }
            try {
                IPath iPath = iCompilationUnit.getResource().getParent().getFullPath().append(JavaModelUtil.getRenamedCUName(iCompilationUnit, string));
                INewNameQuery iNewNameQuery = iNewNameQueries.createNewCompilationUnitNameQuery(iCompilationUnit, string);
                return new CreateCopyOfCompilationUnitChange(iPath, iCompilationUnit.getSource(), iCompilationUnit, iNewNameQuery);
            }
            catch (CoreException coreException) {
                return copyCompilationUnitChange;
            }
        }

        private static Change copyFileToContainer(ICompilationUnit iCompilationUnit, IContainer iContainer, NewNameProposer newNameProposer, INewNameQueries iNewNameQueries) {
            IResource iResource = ReorgUtils.getResource((IJavaElement)iCompilationUnit);
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(iResource, newNameProposer, iNewNameQueries, iContainer);
        }

        private static Change createCopyResourceChange(IResource iResource, NewNameProposer newNameProposer, INewNameQueries iNewNameQueries, IContainer iContainer) {
            if (iResource == null || iContainer == null) {
                return new NullChange();
            }
            String string = newNameProposer.createNewName(iResource, iContainer);
            INewNameQuery iNewNameQuery = string == null ? iNewNameQueries.createNullQuery() : iNewNameQueries.createNewResourceNameQuery(iResource, string);
            return new CopyResourceChange(iResource, iContainer, iNewNameQuery);
        }

        CopyFilesFoldersAndCusPolicy(IFile[] iFileArray, IFolder[] iFolderArray, ICompilationUnit[] iCompilationUnitArray) {
            super(iFileArray, iFolderArray, iCompilationUnitArray);
        }

        private Change createChange(ICompilationUnit iCompilationUnit, NewNameProposer newNameProposer, INewNameQueries iNewNameQueries) {
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            if (iPackageFragment != null) {
                return CopyFilesFoldersAndCusPolicy.copyCuToPackage(iCompilationUnit, iPackageFragment, newNameProposer, iNewNameQueries);
            }
            IContainer iContainer = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.copyFileToContainer(iCompilationUnit, iContainer, newNameProposer, iNewNameQueries);
        }

        public Change createChange(IProgressMonitor iProgressMonitor, INewNameQueries iNewNameQueries) {
            IFile[] iFileArray = this.getFiles();
            IFolder[] iFolderArray = this.getFolders();
            ICompilationUnit[] iCompilationUnitArray = this.getCus();
            iProgressMonitor.beginTask("", iCompilationUnitArray.length + iFileArray.length + iFolderArray.length);
            NewNameProposer newNameProposer = new NewNameProposer();
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy);
            dynamicValidationStateChange.markAsSynthetic();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                dynamicValidationStateChange.add(this.createChange(iCompilationUnitArray[n], newNameProposer, iNewNameQueries));
                iProgressMonitor.worked(1);
                ++n;
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            n = 0;
            while (n < iFileArray.length) {
                dynamicValidationStateChange.add(this.createChange((IResource)iFileArray[n], newNameProposer, iNewNameQueries));
                iProgressMonitor.worked(1);
                ++n;
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            n = 0;
            while (n < iFolderArray.length) {
                dynamicValidationStateChange.add(this.createChange((IResource)iFolderArray[n], newNameProposer, iNewNameQueries));
                iProgressMonitor.worked(1);
                ++n;
            }
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        private Change createChange(IResource iResource, NewNameProposer newNameProposer, INewNameQueries iNewNameQueries) {
            IContainer iContainer = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(iResource, newNameProposer, iNewNameQueries, iContainer);
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        protected String getDescriptionPlural() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_plural;
        }

        protected String getDescriptionSingular() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_singular;
        }

        private Object getDestination() {
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            if (iPackageFragment != null) {
                return iPackageFragment;
            }
            return this.getDestinationAsContainer();
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments copyArguments = new CopyArguments(this.getDestination(), this.fReorgExecutionLog);
            CopyArguments copyArguments2 = new CopyArguments((Object)this.getDestinationAsContainer(), this.fReorgExecutionLog);
            ICompilationUnit[] iCompilationUnitArray = this.getCus();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                this.fModifications.copy(iCompilationUnitArray[n], copyArguments, copyArguments2);
                ++n;
            }
            IResource[] iResourceArray = ReorgUtils.union((IResource[])this.getFiles(), (IResource[])this.getFolders());
            int n2 = 0;
            while (n2 < iResourceArray.length) {
                this.fModifications.copy(iResourceArray[n2], copyArguments2);
                ++n2;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_RESOURCE;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_ROOTS = "org.eclipse.wst.jsdt.ui.copyRoots";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackageFragmentRootsPolicy(IPackageFragmentRoot[] iPackageFragmentRootArray) {
            super(iPackageFragmentRootArray);
        }

        private Change createChange(IPackageFragmentRoot iPackageFragmentRoot, IJavaProject iJavaProject, NewNameProposer newNameProposer, INewNameQueries iNewNameQueries) {
            IProject iProject;
            IResource iResource = iPackageFragmentRoot.getResource();
            String string = newNameProposer.createNewName(iResource, (IContainer)(iProject = iJavaProject.getProject()));
            INewNameQuery iNewNameQuery = string == null ? iNewNameQueries.createNullQuery() : iNewNameQueries.createNewPackageFragmentRootNameQuery(iPackageFragmentRoot, string);
            return new CopyPackageFragmentRootChange(iPackageFragmentRoot, iProject, iNewNameQuery, null);
        }

        public Change createChange(IProgressMonitor iProgressMonitor, INewNameQueries iNewNameQueries) {
            NewNameProposer newNameProposer = new NewNameProposer();
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots();
            iProgressMonitor.beginTask("", iPackageFragmentRootArray.length);
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_source_folder);
            dynamicValidationStateChange.markAsSynthetic();
            IJavaProject iJavaProject = this.getDestinationJavaProject();
            Assert.isNotNull((Object)iJavaProject);
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                dynamicValidationStateChange.add(this.createChange(iPackageFragmentRootArray[n], iJavaProject, newNameProposer, iNewNameQueries));
                iProgressMonitor.worked(1);
                ++n;
            }
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments copyArguments = new CopyArguments((Object)this.getDestinationJavaProject(), this.fReorgExecutionLog);
            CopyArguments copyArguments2 = new CopyArguments((Object)this.getDestinationJavaProject().getProject(), this.fReorgExecutionLog);
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                this.fModifications.copy(iPackageFragmentRootArray[n], copyArguments, copyArguments2);
                ++n;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_ROOTS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_PACKAGES = "org.eclipse.wst.jsdt.ui.copyPackages";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackagesPolicy(IPackageFragment[] iPackageFragmentArray) {
            super(iPackageFragmentArray);
        }

        private Change createChange(IPackageFragment iPackageFragment, IPackageFragmentRoot iPackageFragmentRoot, NewNameProposer newNameProposer, INewNameQueries iNewNameQueries) {
            String string = newNameProposer.createNewName(iPackageFragment, iPackageFragmentRoot);
            if (string == null || JavaConventions.validatePackageName((String)string).getSeverity() < 4) {
                INewNameQuery iNewNameQuery = string == null ? iNewNameQueries.createNullQuery() : iNewNameQueries.createNewPackageNameQuery(iPackageFragment, string);
                return new CopyPackageChange(iPackageFragment, iPackageFragmentRoot, iNewNameQuery);
            }
            if (iPackageFragmentRoot.getResource() instanceof IContainer) {
                IContainer iContainer = (IContainer)iPackageFragmentRoot.getResource();
                IResource iResource = iPackageFragment.getResource();
                INewNameQuery iNewNameQuery = iNewNameQueries.createNewResourceNameQuery(iResource, string);
                return new CopyResourceChange(iResource, iContainer, iNewNameQuery);
            }
            return new NullChange();
        }

        public Change createChange(IProgressMonitor iProgressMonitor, INewNameQueries iNewNameQueries) throws JavaModelException {
            NewNameProposer newNameProposer = new NewNameProposer();
            IPackageFragment[] iPackageFragmentArray = this.getPackages();
            iProgressMonitor.beginTask("", iPackageFragmentArray.length);
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_package);
            dynamicValidationStateChange.markAsSynthetic();
            IPackageFragmentRoot iPackageFragmentRoot = this.getDestinationAsPackageFragmentRoot();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                dynamicValidationStateChange.add(this.createChange(iPackageFragmentArray[n], iPackageFragmentRoot, newNameProposer, iNewNameQueries));
                iProgressMonitor.worked(1);
                ++n;
            }
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IPackageFragmentRoot iPackageFragmentRoot = this.getDestinationAsPackageFragmentRoot();
            CopyArguments copyArguments = new CopyArguments((Object)iPackageFragmentRoot, this.fReorgExecutionLog);
            CopyArguments copyArguments2 = new CopyArguments((Object)iPackageFragmentRoot.getResource(), this.fReorgExecutionLog);
            IPackageFragment[] iPackageFragmentArray = this.getPackages();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                this.fModifications.copy(iPackageFragmentArray[n], copyArguments, copyArguments2);
                ++n;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_PACKAGES;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopySubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_MEMBERS = "org.eclipse.wst.jsdt.ui.copyMembers";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopySubCuElementsPolicy(IJavaElement[] iJavaElementArray) {
            super(iJavaElementArray);
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && (this.getSourceCu() != null || this.getSourceClassFile() != null);
        }

        public Change createChange(IProgressMonitor iProgressMonitor, INewNameQueries iNewNameQueries) throws JavaModelException {
            try {
                CompilationUnit compilationUnit = this.createSourceCuNode();
                ICompilationUnit iCompilationUnit = this.getDestinationCu();
                CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit);
                IJavaElement[] iJavaElementArray = this.getJavaElements();
                int n = 0;
                while (n < iJavaElementArray.length) {
                    this.copyToDestination(iJavaElementArray[n], compilationUnitRewrite, compilationUnit, compilationUnitRewrite.getRoot());
                    ++n;
                }
                return CopySubCuElementsPolicy.createCompilationUnitChange(iCompilationUnit, compilationUnitRewrite);
            }
            catch (JavaModelException javaModelException) {
                throw javaModelException;
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        private CompilationUnit createSourceCuNode() {
            Assert.isTrue((this.getSourceCu() != null || this.getSourceClassFile() != null ? 1 : 0) != 0);
            Assert.isTrue((this.getSourceCu() == null || this.getSourceClassFile() == null ? 1 : 0) != 0);
            ASTParser aSTParser = ASTParser.newParser((int)3);
            if (this.getSourceCu() != null) {
                aSTParser.setSource(this.getSourceCu());
            } else {
                aSTParser.setSource(this.getSourceClassFile());
            }
            return (CompilationUnit)aSTParser.createAST(null);
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }

        protected String getDescriptionPlural() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_types;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_fields;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_methods;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializers;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_declarations;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_containers;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_imports;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_plural;
        }

        protected String getDescriptionSingular() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_type;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_field;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_method;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializer;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_package;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_section;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_import;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments copyArguments = new CopyArguments((Object)this.getJavaElementDestination(), this.fReorgExecutionLog);
            IJavaElement[] iJavaElementArray = this.getJavaElements();
            int n = 0;
            while (n < iJavaElementArray.length) {
                this.fModifications.copy(iJavaElementArray[n], copyArguments, null);
                ++n;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_MEMBERS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        private IClassFile getSourceClassFile() {
            return (IClassFile)this.getJavaElements()[0].getAncestor(6);
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        protected static final int ONLY_CUS = 2;
        protected static final int ONLY_FILES = 1;
        protected static final int ONLY_FOLDERS = 0;
        private ICompilationUnit[] fCus;
        private IFile[] fFiles;
        private IFolder[] fFolders;

        private static IContainer getAsContainer(IResource iResource) {
            if (iResource instanceof IContainer) {
                return (IContainer)iResource;
            }
            if (iResource instanceof IFile) {
                return ((IFile)iResource).getParent();
            }
            return null;
        }

        public FilesFoldersAndCusReorgPolicy(IFile[] iFileArray, IFolder[] iFolderArray, ICompilationUnit[] iCompilationUnitArray) {
            this.fFiles = iFileArray;
            this.fFolders = iFolderArray;
            this.fCus = iCompilationUnitArray;
        }

        public boolean canChildrenBeDestinations(IJavaElement iJavaElement) {
            switch (iJavaElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource iResource) {
            return iResource instanceof IContainer;
        }

        public boolean canElementBeDestination(IJavaElement iJavaElement) {
            switch (iJavaElement.getElementType()) {
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource iResource) {
            return iResource instanceof IProject || iResource instanceof IFolder;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext, IReorgQueries iReorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus = super.checkFinalConditions(iProgressMonitor, checkConditionsContext, iReorgQueries);
            this.confirmOverwriting(iReorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwriting(IReorgQueries iReorgQueries) {
            OverwriteHelper overwriteHelper = new OverwriteHelper();
            overwriteHelper.setFiles(this.fFiles);
            overwriteHelper.setFolders(this.fFolders);
            overwriteHelper.setCus(this.fCus);
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            if (iPackageFragment != null) {
                overwriteHelper.confirmOverwriting(iReorgQueries, (IJavaElement)iPackageFragment);
            } else {
                IContainer iContainer = this.getDestinationAsContainer();
                if (iContainer != null) {
                    overwriteHelper.confirmOverwriting(iReorgQueries, (IResource)iContainer);
                }
            }
            this.fFiles = overwriteHelper.getFilesWithoutUnconfirmedOnes();
            this.fFolders = overwriteHelper.getFoldersWithoutUnconfirmedOnes();
            this.fCus = overwriteHelper.getCusWithoutUnconfirmedOnes();
        }

        protected boolean containsLinkedResources() {
            return ReorgUtils.containsLinkedResources((IResource[])this.fFiles) || ReorgUtils.containsLinkedResources((IResource[])this.fFolders) || ReorgUtils.containsLinkedResources((IJavaElement[])this.fCus);
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        protected final int getContentKind() {
            int n = this.fCus.length + this.fFiles.length + this.fFolders.length;
            if (n == this.fCus.length) {
                return 2;
            }
            if (n == this.fFiles.length) {
                return 1;
            }
            if (n == this.fFolders.length) {
                return 0;
            }
            return -1;
        }

        protected final ICompilationUnit[] getCus() {
            return this.fCus;
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = this.fFiles.length + this.fFolders.length + this.fCus.length;
            String string = n == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject iProject = this.getSingleProject();
            String string2 = iProject != null ? iProject.getName() : null;
            String string3 = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(n), this.getDestinationLabel()});
            int n2 = 589830;
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string2, this, string3);
            JDTRefactoringDescriptor jDTRefactoringDescriptor = this.createRefactoringDescriptor(jDTRefactoringDescriptorComment, hashMap, string, string2, n2);
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_FILES, new Integer(this.fFiles.length).toString());
            int n3 = 0;
            while (n3 < this.fFiles.length) {
                hashMap.put("element" + (n3 + 1), jDTRefactoringDescriptor.resourceToHandle((IResource)this.fFiles[n3]));
                ++n3;
            }
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_FOLDERS, new Integer(this.fFolders.length).toString());
            n3 = 0;
            while (n3 < this.fFolders.length) {
                hashMap.put("element" + (n3 + this.fFiles.length + 1), jDTRefactoringDescriptor.resourceToHandle((IResource)this.fFolders[n3]));
                ++n3;
            }
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_UNITS, new Integer(this.fCus.length).toString());
            n3 = 0;
            while (n3 < this.fCus.length) {
                hashMap.put("element" + (n3 + this.fFolders.length + this.fFiles.length + 1), jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCus[n3]));
                ++n3;
            }
            hashMap.putAll(this.getRefactoringArguments(string2));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor);
        }

        protected final IContainer getDestinationAsContainer() {
            IResource iResource = this.getResourceDestination();
            if (iResource != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(iResource);
            }
            IJavaElement iJavaElement = this.getJavaElementDestination();
            Assert.isNotNull((Object)iJavaElement);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtils.getResource(iJavaElement));
        }

        protected final IPackageFragment getDestinationAsPackageFragment() {
            IPackageFragment iPackageFragment = this.getJavaDestinationAsPackageFragment(this.getJavaElementDestination());
            if (iPackageFragment != null) {
                return iPackageFragment;
            }
            return this.getResourceDestinationAsPackageFragment(this.getResourceDestination());
        }

        protected final IJavaElement getDestinationContainerAsJavaElement() {
            if (this.getJavaElementDestination() != null) {
                return this.getJavaElementDestination();
            }
            IContainer iContainer = this.getDestinationAsContainer();
            if (iContainer == null) {
                return null;
            }
            IJavaElement iJavaElement = JavaCore.create((IResource)iContainer);
            if (iJavaElement != null && iJavaElement.exists()) {
                return iJavaElement;
            }
            return null;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        private IPackageFragment getJavaDestinationAsPackageFragment(IJavaElement iJavaElement) {
            if (iJavaElement == null || this.fCheckDestination && !iJavaElement.exists()) {
                return null;
            }
            if (iJavaElement instanceof IPackageFragment) {
                return (IPackageFragment)iJavaElement;
            }
            if (iJavaElement instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)iJavaElement).getPackageFragment("");
            }
            if (iJavaElement instanceof IJavaProject) {
                try {
                    IPackageFragmentRoot iPackageFragmentRoot = ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)iJavaElement);
                    if (iPackageFragmentRoot != null) {
                        return iPackageFragmentRoot.getPackageFragment("");
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return (IPackageFragment)iJavaElement.getAncestor(4);
        }

        public final IJavaElement[] getJavaElements() {
            return this.fCus;
        }

        private IPackageFragment getResourceDestinationAsPackageFragment(IResource iResource) {
            if (iResource instanceof IFile) {
                return this.getJavaDestinationAsPackageFragment(JavaCore.create((IResource)iResource.getParent()));
            }
            return null;
        }

        public final IResource[] getResources() {
            return ReorgUtils.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        private IProject getSingleProject() {
            IProject iProject = null;
            int n = 0;
            while (n < this.fFiles.length) {
                if (iProject == null) {
                    iProject = this.fFiles[n].getProject();
                } else if (!iProject.equals((Object)this.fFiles[n].getProject())) {
                    return null;
                }
                ++n;
            }
            n = 0;
            while (n < this.fFolders.length) {
                if (iProject == null) {
                    iProject = this.fFolders[n].getProject();
                } else if (!iProject.equals((Object)this.fFolders[n].getProject())) {
                    return null;
                }
                ++n;
            }
            n = 0;
            while (n < this.fCus.length) {
                if (iProject == null) {
                    iProject = this.fCus[n].getJavaProject().getProject();
                } else if (!iProject.equals((Object)this.fCus[n].getJavaProject().getProject())) {
                    return null;
                }
                ++n;
            }
            return iProject;
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            ArrayList<IResource> arrayList;
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            if (refactoringArguments instanceof JavaRefactoringArguments) {
                IResource iResource;
                String string;
                JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                String string2 = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FILES);
                if (string2 != null && !"".equals(string2)) {
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
                }
                string2 = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FOLDERS);
                if (string2 != null && !"".equals(string2)) {
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
                }
                string2 = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_UNITS);
                if (string2 != null && !"".equals(string2)) {
                    try {
                        n3 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
                }
                String string3 = null;
                arrayList = new ArrayList<IResource>();
                int n4 = 0;
                while (n4 < n) {
                    string = "element" + (n4 + 1);
                    string3 = javaRefactoringArguments.getAttribute(string);
                    if (string3 != null && !"".equals(string3)) {
                        iResource = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string3);
                        if (iResource == null || !iResource.exists()) {
                            refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iResource, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            arrayList.add(iResource);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string));
                    }
                    ++n4;
                }
                this.fFiles = arrayList.toArray(new IFile[arrayList.size()]);
                arrayList = new ArrayList();
                n4 = 0;
                while (n4 < n2) {
                    string = "element" + (n + n4 + 1);
                    string3 = javaRefactoringArguments.getAttribute(string);
                    if (string3 != null && !"".equals(string3)) {
                        iResource = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string3);
                        if (iResource == null || !iResource.exists()) {
                            refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iResource, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            arrayList.add(iResource);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string));
                    }
                    ++n4;
                }
                this.fFolders = arrayList.toArray(new IFolder[arrayList.size()]);
                arrayList = new ArrayList();
                n4 = 0;
                while (n4 < n3) {
                    string = "element" + (n2 + n + n4 + 1);
                    string3 = javaRefactoringArguments.getAttribute(string);
                    if (string3 != null && !"".equals(string3)) {
                        iResource = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string3, false);
                        if (iResource == null || !iResource.exists() || iResource.getElementType() != 5) {
                            refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iResource, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            arrayList.add(iResource);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string));
                    }
                    ++n4;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fCus = arrayList.toArray(new ICompilationUnit[arrayList.size()]);
            refactoringStatus.merge(super.initialize(refactoringArguments));
            return refactoringStatus;
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource iResource) {
            int n = 0;
            while (n < this.fFolders.length) {
                IFolder iFolder = this.fFolders[n];
                if (iFolder.equals((Object)iResource) || ParentChecker.isDescendantOf(iResource, (IResource)iFolder)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            IOpenable iOpenable;
            Assert.isNotNull((Object)iJavaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!iJavaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist0);
            }
            if (iJavaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (iJavaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_readonly);
            }
            if (!iJavaElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_structure);
            }
            if (iJavaElement instanceof IOpenable && !(iOpenable = (IOpenable)iJavaElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inconsistent);
            }
            if (iJavaElement instanceof IPackageFragmentRoot) {
                iOpenable = (IPackageFragmentRoot)iJavaElement;
                if (iOpenable.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_archive);
                }
                if (iOpenable.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_external);
                }
            }
            if (ReorgUtils.isInsideCompilationUnit(iJavaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            iOpenable = this.getDestinationAsContainer();
            if (iOpenable == null || this.isChildOfOrEqualToAnyFolder((IResource)iOpenable)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(iJavaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource iResource) throws JavaModelException {
            Assert.isNotNull((Object)iResource);
            if (!iResource.exists() || iResource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!iResource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (iResource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(iResource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(iResource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }
    }

    private static final class MoveFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_RESOURCES = "org.eclipse.wst.jsdt.ui.moveResources";
        private TextChangeManager fChangeManager;
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private String fFilePatterns;
        private MoveModifications fModifications;
        private QualifiedNameSearchResult fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        private boolean fUpdateQualifiedNames = false;
        private boolean fUpdateReferences = true;

        private static Change moveCuToPackage(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment) {
            IResource iResource = iCompilationUnit.getResource();
            if (iResource != null && iResource.isLinked() && ResourceUtil.getResource(iPackageFragment) instanceof IContainer) {
                return MoveFilesFoldersAndCusPolicy.moveFileToContainer(iCompilationUnit, (IContainer)ResourceUtil.getResource(iPackageFragment));
            }
            return new MoveCompilationUnitChange(iCompilationUnit, iPackageFragment);
        }

        private static Change moveFileToContainer(ICompilationUnit iCompilationUnit, IContainer iContainer) {
            return new MoveResourceChange(iCompilationUnit.getResource(), iContainer);
        }

        MoveFilesFoldersAndCusPolicy(IFile[] iFileArray, IFolder[] iFolderArray, ICompilationUnit[] iCompilationUnitArray) {
            super(iFileArray, iFolderArray, iCompilationUnitArray);
        }

        public boolean canEnableQualifiedNameUpdating() {
            return this.getCus().length > 0 && !JavaElementUtil.isDefaultPackage(this.getCommonParent());
        }

        public boolean canEnableUpdateReferences() {
            return this.getCus().length > 0;
        }

        public boolean canUpdateQualifiedNames() {
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            return this.canEnableQualifiedNameUpdating() && iPackageFragment != null && !iPackageFragment.isDefaultPackage();
        }

        public boolean canUpdateReferences() {
            if (this.getCus().length == 0) {
                return false;
            }
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            if (iPackageFragment != null && iPackageFragment.isDefaultPackage()) {
                return false;
            }
            Object object = this.getCommonParent();
            return !JavaElementUtil.isDefaultPackage(object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext, IReorgQueries iReorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus;
            try {
                try {
                    iProgressMonitor.beginTask("", this.fUpdateQualifiedNames ? 7 : 3);
                    RefactoringStatus refactoringStatus2 = new RefactoringStatus();
                    this.confirmMovingReadOnly(iReorgQueries);
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2), refactoringStatus2);
                    if (this.fUpdateQualifiedNames) {
                        this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
                    }
                    refactoringStatus2.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), checkConditionsContext, iReorgQueries));
                    refactoringStatus = refactoringStatus2;
                    Object var5_8 = null;
                }
                catch (JavaModelException javaModelException) {
                    throw javaModelException;
                }
                catch (CoreException coreException) {
                    throw new JavaModelException(coreException);
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus;
        }

        private void computeQualifiedNameMatches(IProgressMonitor iProgressMonitor) throws JavaModelException {
            if (!this.fUpdateQualifiedNames) {
                return;
            }
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            if (iPackageFragment != null) {
                ICompilationUnit[] iCompilationUnitArray = this.getCus();
                iProgressMonitor.beginTask("", iCompilationUnitArray.length);
                iProgressMonitor.subTask(RefactoringCoreMessages.MoveRefactoring_scanning_qualified_names);
                int n = 0;
                while (n < iCompilationUnitArray.length) {
                    ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
                    IType[] iTypeArray = iCompilationUnit.getTypes();
                    SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                    subProgressMonitor.beginTask("", iTypeArray.length);
                    int n2 = 0;
                    while (n2 < iTypeArray.length) {
                        this.handleType(iTypeArray[n2], iPackageFragment, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        if (subProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++n2;
                    }
                    subProgressMonitor.done();
                    ++n;
                }
            }
            iProgressMonitor.done();
        }

        private void confirmMovingReadOnly(IReorgQueries iReorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), iReorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(ICompilationUnit iCompilationUnit) {
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            if (iPackageFragment != null) {
                return MoveFilesFoldersAndCusPolicy.moveCuToPackage(iCompilationUnit, iPackageFragment);
            }
            IContainer iContainer = this.getDestinationAsContainer();
            if (iContainer == null) {
                return new NullChange();
            }
            return MoveFilesFoldersAndCusPolicy.moveFileToContainer(iCompilationUnit, iContainer);
        }

        public Change createChange(IProgressMonitor iProgressMonitor) throws JavaModelException {
            if (!this.fUpdateReferences) {
                return this.createSimpleMoveChange(iProgressMonitor);
            }
            return this.createReferenceUpdatingMoveChange(iProgressMonitor);
        }

        private Change createChange(IResource iResource) {
            IContainer iContainer = this.getDestinationAsContainer();
            if (iContainer == null) {
                return new NullChange();
            }
            return new MoveResourceChange(iResource, iContainer);
        }

        private TextChangeManager createChangeManager(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
            block5: {
                block4: {
                    TextChangeManager textChangeManager;
                    iProgressMonitor.beginTask("", 1);
                    try {
                        if (this.fUpdateReferences) break block4;
                        textChangeManager = new TextChangeManager();
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    iProgressMonitor.done();
                    return textChangeManager;
                }
                IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
                if (iPackageFragment == null) break block5;
                MoveCuUpdateCreator moveCuUpdateCreator = new MoveCuUpdateCreator(this.getCus(), iPackageFragment);
                TextChangeManager textChangeManager = moveCuUpdateCreator.createChangeManager((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
                Object var5_7 = null;
                iProgressMonitor.done();
                return textChangeManager;
            }
            TextChangeManager textChangeManager = new TextChangeManager();
            Object var5_8 = null;
            iProgressMonitor.done();
            return textChangeManager;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        private Change createReferenceUpdatingMoveChange(IProgressMonitor iProgressMonitor) throws JavaModelException {
            DynamicValidationStateChange dynamicValidationStateChange;
            iProgressMonitor.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
            try {
                RefactoringStatus refactoringStatus;
                DynamicValidationStateChange dynamicValidationStateChange2 = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
                dynamicValidationStateChange2.markAsSynthetic();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), new RefactoringStatus());
                    refactoringStatus = Checks.validateModifiesFiles(this.getAllModifiedFiles(), null);
                    if (refactoringStatus.hasFatalError()) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                dynamicValidationStateChange2.merge(new CompositeChange(RefactoringCoreMessages.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                refactoringStatus = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (refactoringStatus instanceof CompositeChange) {
                    dynamicValidationStateChange2.merge((CompositeChange)refactoringStatus);
                } else {
                    dynamicValidationStateChange2.add((Change)refactoringStatus);
                }
                dynamicValidationStateChange = dynamicValidationStateChange2;
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        private Change createSimpleMoveChange(IProgressMonitor iProgressMonitor) {
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
            dynamicValidationStateChange.markAsSynthetic();
            IFile[] iFileArray = this.getFiles();
            IFolder[] iFolderArray = this.getFolders();
            ICompilationUnit[] iCompilationUnitArray = this.getCus();
            iProgressMonitor.beginTask("", iFileArray.length + iFolderArray.length + iCompilationUnitArray.length);
            int n = 0;
            while (n < iFileArray.length) {
                dynamicValidationStateChange.add(this.createChange((IResource)iFileArray[n]));
                iProgressMonitor.worked(1);
                ++n;
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            n = 0;
            while (n < iFolderArray.length) {
                dynamicValidationStateChange.add(this.createChange((IResource)iFolderArray[n]));
                iProgressMonitor.worked(1);
                ++n;
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            n = 0;
            while (n < iCompilationUnitArray.length) {
                dynamicValidationStateChange.add(this.createChange(iCompilationUnitArray[n]));
                iProgressMonitor.worked(1);
                ++n;
            }
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        public IFile[] getAllModifiedFiles() {
            HashSet<IFile> hashSet = new HashSet<IFile>();
            hashSet.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
            hashSet.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
            if (this.getDestinationAsPackageFragment() != null && this.getUpdateReferences()) {
                hashSet.addAll(Arrays.asList(ResourceUtil.getFiles(this.getCus())));
            }
            return hashSet.toArray(new IFile[hashSet.size()]);
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries iCreateTargetQueries) {
            return iCreateTargetQueries.createNewPackageQuery();
        }

        protected String getDescriptionPlural() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_plural;
        }

        protected String getDescriptionSingular() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_singular;
        }

        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            int n;
            ICompilationUnit[] iCompilationUnitArray;
            boolean bl;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            IContainer iContainer = this.getDestinationAsContainer();
            Object object = null;
            object = iPackageFragment != null ? iPackageFragment : iContainer;
            boolean bl2 = bl = this.canUpdateReferences() && this.getUpdateReferences();
            if (object != null) {
                iCompilationUnitArray = this.getCus();
                n = 0;
                while (n < iCompilationUnitArray.length) {
                    this.fModifications.move(iCompilationUnitArray[n], new MoveArguments(object, bl));
                    ++n;
                }
            }
            if (iContainer != null) {
                iCompilationUnitArray = this.getFiles();
                n = 0;
                while (n < iCompilationUnitArray.length) {
                    this.fModifications.move((IResource)iCompilationUnitArray[n], new MoveArguments((Object)iContainer, bl));
                    ++n;
                }
                IFolder[] iFolderArray = this.getFolders();
                int n2 = 0;
                while (n2 < iFolderArray.length) {
                    this.fModifications.move((IResource)iFolderArray[n2], new MoveArguments((Object)iContainer, bl));
                    ++n2;
                }
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_MOVE_RESOURCES;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected Map getRefactoringArguments(String string) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.putAll(super.getRefactoringArguments(string));
            if (this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                hashMap.put(ReorgPolicyFactory.ATTRIBUTE_PATTERNS, this.fFilePatterns);
            }
            hashMap.put("references", Boolean.valueOf(this.fUpdateReferences).toString());
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED, Boolean.valueOf(this.fUpdateQualifiedNames).toString());
            return hashMap;
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean getUpdateQualifiedNames() {
            return this.fUpdateQualifiedNames;
        }

        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        private void handleType(IType iType, IPackageFragment iPackageFragment, IProgressMonitor iProgressMonitor) {
            QualifiedNameFinder.process(this.fQualifiedNameSearchResult, iType.getFullyQualifiedName(), String.valueOf(iPackageFragment.getElementName()) + "." + iType.getTypeQualifiedName(), this.fFilePatterns, iType.getJavaProject().getProject(), iProgressMonitor);
        }

        public boolean hasAllInputSet() {
            return super.hasAllInputSet() && !this.canUpdateReferences() && !this.canUpdateQualifiedNames();
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            String string;
            if (refactoringArguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
                String string2 = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_PATTERNS);
                this.fFilePatterns = string2 != null && !"".equals(string2) ? string2 : "";
                String string3 = javaRefactoringArguments.getAttribute("references");
                if (string3 == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
                }
                this.fUpdateReferences = Boolean.valueOf(string3);
                string = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED);
                if (string == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_QUALIFIED));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fUpdateQualifiedNames = Boolean.valueOf(string);
            return super.initialize(refactoringArguments);
        }

        public boolean isTextualMove() {
            return false;
        }

        public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
            if (this.fQualifiedNameSearchResult != null) {
                return this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(changeArray));
            }
            return null;
        }

        public void setDestinationCheck(boolean bl) {
            this.fCheckDestination = bl;
        }

        public void setFilePatterns(String string) {
            Assert.isNotNull((Object)string);
            this.fFilePatterns = string;
        }

        public void setUpdateQualifiedNames(boolean bl) {
            this.fUpdateQualifiedNames = bl;
        }

        public void setUpdateReferences(boolean bl) {
            this.fUpdateReferences = bl;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            RefactoringStatus refactoringStatus = super.verifyDestination(iJavaElement);
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            Object object = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (iJavaElement.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer iContainer = this.getDestinationAsContainer();
            if (iContainer != null && iContainer.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IPackageFragment iPackageFragment = this.getDestinationAsPackageFragment();
            if (iPackageFragment != null && iPackageFragment.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return refactoringStatus;
        }

        protected RefactoringStatus verifyDestination(IResource iResource) throws JavaModelException {
            RefactoringStatus refactoringStatus = super.verifyDestination(iResource);
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            Object object = this.getCommonParent();
            if (iResource.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer iContainer = this.getDestinationAsContainer();
            if (iContainer != null && iContainer.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IJavaElement iJavaElement = this.getDestinationContainerAsJavaElement();
            if (iJavaElement != null && iJavaElement.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return refactoringStatus;
        }
    }

    private static final class MovePackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_ROOTS = "org.eclipse.wst.jsdt.ui.moveRoots";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;

        private static boolean isParentOfAny(IJavaProject iJavaProject, IPackageFragmentRoot[] iPackageFragmentRootArray) {
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(iPackageFragmentRootArray[n], iJavaProject)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        MovePackageFragmentRootsPolicy(IPackageFragmentRoot[] iPackageFragmentRootArray) {
            super(iPackageFragmentRootArray);
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                ResourceAttributes resourceAttributes;
                if (iPackageFragmentRootArray[n].isReadOnly() && !iPackageFragmentRootArray[n].isArchive() && ((resourceAttributes = iPackageFragmentRootArray[n].getResource().getResourceAttributes()) == null || resourceAttributes.isReadOnly())) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext, IReorgQueries iReorgQueries) throws CoreException {
            try {
                RefactoringStatus refactoringStatus = super.checkFinalConditions(iProgressMonitor, checkConditionsContext, iReorgQueries);
                this.confirmMovingReadOnly(iReorgQueries);
                return refactoringStatus;
            }
            catch (JavaModelException javaModelException) {
                throw javaModelException;
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries iReorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), iReorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragmentRoot iPackageFragmentRoot, IJavaProject iJavaProject) {
            return new MovePackageFragmentRootChange(iPackageFragmentRoot, iJavaProject.getProject(), null);
        }

        public Change createChange(IProgressMonitor iProgressMonitor) throws JavaModelException {
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots();
            iProgressMonitor.beginTask("", iPackageFragmentRootArray.length);
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_source_folder);
            dynamicValidationStateChange.markAsSynthetic();
            IJavaProject iJavaProject = this.getDestinationJavaProject();
            Assert.isNotNull((Object)iJavaProject);
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                dynamicValidationStateChange.add(this.createChange(iPackageFragmentRootArray[n], iJavaProject));
                iProgressMonitor.worked(1);
                ++n;
            }
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries iCreateTargetQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            boolean bl;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IJavaProject iJavaProject = this.getDestinationJavaProject();
            boolean bl2 = bl = this.canUpdateReferences() && this.getUpdateReferences();
            if (iJavaProject != null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots();
                int n = 0;
                while (n < iPackageFragmentRootArray.length) {
                    this.fModifications.move(iPackageFragmentRootArray[n], new MoveArguments((Object)iJavaProject, bl));
                    ++n;
                }
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_MOVE_ROOTS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean isTextualMove() {
            return false;
        }

        public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean bl) {
            this.fCheckDestination = bl;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            RefactoringStatus refactoringStatus = super.verifyDestination(iJavaElement);
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            IJavaProject iJavaProject = this.getDestinationJavaProject();
            if (MovePackageFragmentRootsPolicy.isParentOfAny(iJavaProject, this.getPackageFragmentRoots())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return refactoringStatus;
        }
    }

    private static final class MovePackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_PACKAGES = "org.eclipse.wst.jsdt.ui.movePackages";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;

        private static boolean isParentOfAny(IPackageFragmentRoot iPackageFragmentRoot, IPackageFragment[] iPackageFragmentArray) {
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment = iPackageFragmentArray[n];
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(iPackageFragment, iPackageFragmentRoot)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        MovePackagesPolicy(IPackageFragment[] iPackageFragmentArray) {
            super(iPackageFragmentArray);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext, IReorgQueries iReorgQueries) throws CoreException {
            try {
                RefactoringStatus refactoringStatus = super.checkFinalConditions(iProgressMonitor, checkConditionsContext, iReorgQueries);
                this.confirmMovingReadOnly(iReorgQueries);
                return refactoringStatus;
            }
            catch (JavaModelException javaModelException) {
                throw javaModelException;
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries iReorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), iReorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragment iPackageFragment, IPackageFragmentRoot iPackageFragmentRoot) {
            return new MovePackageChange(iPackageFragment, iPackageFragmentRoot);
        }

        public Change createChange(IProgressMonitor iProgressMonitor) throws JavaModelException {
            IPackageFragment[] iPackageFragmentArray = this.getPackages();
            iProgressMonitor.beginTask("", iPackageFragmentArray.length);
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_package);
            dynamicValidationStateChange.markAsSynthetic();
            IPackageFragmentRoot iPackageFragmentRoot = this.getDestinationAsPackageFragmentRoot();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                dynamicValidationStateChange.add(this.createChange(iPackageFragmentArray[n], iPackageFragmentRoot));
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n;
            }
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries iCreateTargetQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            boolean bl = this.canUpdateReferences() && this.getUpdateReferences();
            IPackageFragment[] iPackageFragmentArray = this.getPackages();
            IPackageFragmentRoot iPackageFragmentRoot = this.getDestinationAsPackageFragmentRoot();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                this.fModifications.move(iPackageFragmentArray[n], new MoveArguments((Object)iPackageFragmentRoot, bl));
                ++n;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_MOVE_PACKAGES;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean isTextualMove() {
            return false;
        }

        public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean bl) {
            this.fCheckDestination = bl;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            RefactoringStatus refactoringStatus = super.verifyDestination(iJavaElement);
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            IPackageFragmentRoot iPackageFragmentRoot = this.getDestinationAsPackageFragmentRoot();
            if (MovePackagesPolicy.isParentOfAny(iPackageFragmentRoot, this.getPackages())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package2parent);
            }
            return refactoringStatus;
        }
    }

    private static final class MoveSubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_MEMBERS = "org.eclipse.wst.jsdt.ui.moveMembers";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();

        MoveSubCuElementsPolicy(IJavaElement[] iJavaElementArray) {
            super(iJavaElementArray);
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Change createChange(IProgressMonitor iProgressMonitor) throws JavaModelException {
            DynamicValidationStateChange dynamicValidationStateChange;
            block13: {
                CompilationUnitChange compilationUnitChange;
                block12: {
                    iProgressMonitor.beginTask("", 3);
                    try {
                        try {
                            CompilationUnitChange compilationUnitChange2;
                            CompilationUnit compilationUnit;
                            CompilationUnitRewrite compilationUnitRewrite;
                            ICompilationUnit iCompilationUnit = this.getSourceCu();
                            CompilationUnit compilationUnit2 = RefactoringASTParser.parseWithASTProvider((ITypeRoot)iCompilationUnit, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            CompilationUnitRewrite compilationUnitRewrite2 = new CompilationUnitRewrite(iCompilationUnit, compilationUnit2);
                            ICompilationUnit iCompilationUnit2 = this.getDestinationCu();
                            if (iCompilationUnit.equals(iCompilationUnit2)) {
                                compilationUnitRewrite = compilationUnitRewrite2;
                                iProgressMonitor.worked(1);
                            } else {
                                compilationUnit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)iCompilationUnit2, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit2, compilationUnit);
                            }
                            compilationUnit = this.getJavaElements();
                            int n = 0;
                            while (true) {
                                if (n >= ((CompilationUnit)compilationUnit).length) {
                                    ASTNodeDeleteUtil.markAsDeleted((IJavaElement[])compilationUnit, compilationUnitRewrite2, null);
                                    compilationUnitChange2 = MoveSubCuElementsPolicy.createCompilationUnitChange(iCompilationUnit2, compilationUnitRewrite);
                                    if (!iCompilationUnit.equals(iCompilationUnit2)) break;
                                    compilationUnitChange = compilationUnitChange2;
                                    Object var10_14 = null;
                                    break block12;
                                }
                                this.copyToDestination((IJavaElement)compilationUnit[n], compilationUnitRewrite, compilationUnitRewrite2.getRoot(), compilationUnitRewrite.getRoot());
                                ++n;
                            }
                            DynamicValidationStateChange dynamicValidationStateChange2 = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_members);
                            dynamicValidationStateChange2.markAsSynthetic();
                            dynamicValidationStateChange2.add((Change)compilationUnitChange2);
                            if (Arrays.asList(this.getJavaElements()).containsAll(Arrays.asList(iCompilationUnit.getTypes()))) {
                                dynamicValidationStateChange2.add(DeleteChangeCreator.createDeleteChange(null, new IResource[0], (IJavaElement[])new ICompilationUnit[]{iCompilationUnit}, RefactoringCoreMessages.ReorgPolicy_move, null));
                            } else {
                                dynamicValidationStateChange2.add((Change)MoveSubCuElementsPolicy.createCompilationUnitChange(iCompilationUnit, compilationUnitRewrite2));
                            }
                            dynamicValidationStateChange = dynamicValidationStateChange2;
                            break block13;
                        }
                        catch (JavaModelException javaModelException) {
                            throw javaModelException;
                        }
                        catch (CoreException coreException) {
                            throw new JavaModelException(coreException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                }
                iProgressMonitor.done();
                return compilationUnitChange;
            }
            Object var10_15 = null;
            iProgressMonitor.done();
            return dynamicValidationStateChange;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getSourceCu()), ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries iCreateTargetQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_types;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_fields;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_methods;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_initializers;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declarations;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_containers;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declarations;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_plural;
        }

        protected String getDescriptionSingular() {
            int n = this.getContentKind();
            switch (n) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_type;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_field;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_method;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_initializer;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declaration;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_section;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declaration;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_header;
        }

        public String getPolicyId() {
            return POLICY_MOVE_MEMBERS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean isTextualMove() {
            return true;
        }

        public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean bl) {
            this.fCheckDestination = bl;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            Object object;
            IJavaElement[] iJavaElementArray = this.getJavaElements();
            int n = 0;
            while (n < iJavaElementArray.length) {
                object = iJavaElement.getParent();
                while (object != null) {
                    if (object.equals(iJavaElementArray[n])) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    object = object.getParent();
                }
                ++n;
            }
            RefactoringStatus refactoringStatus = super.verifyDestination(iJavaElement);
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            object = new ParentChecker(new IResource[0], this.getJavaElements()).getCommonParent();
            if (iJavaElement.equals(object) || Arrays.asList(this.getJavaElements()).contains(iJavaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return refactoringStatus;
        }
    }

    private static final class NewNameProposer {
        private final Set fAutoGeneratedNewNames = new HashSet(2);

        private NewNameProposer() {
        }

        private static boolean isNewNameOk(IContainer iContainer, String string) {
            return iContainer.findMember(string) == null;
        }

        private static boolean isNewNameOk(IPackageFragment iPackageFragment, String string) {
            return !iPackageFragment.getCompilationUnit(string).exists();
        }

        private static boolean isNewNameOk(IPackageFragmentRoot iPackageFragmentRoot, String string) {
            return !iPackageFragmentRoot.getPackageFragment(string).exists();
        }

        public String createNewName(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment) {
            if (NewNameProposer.isNewNameOk(iPackageFragment, iCompilationUnit.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(iCompilationUnit, iPackageFragment)) {
                return null;
            }
            int n = 1;
            while (true) {
                String string;
                if (NewNameProposer.isNewNameOk(iPackageFragment, string = n == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOf1, iCompilationUnit.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOfMore, new String[]{String.valueOf(n), iCompilationUnit.getElementName()})) && !this.fAutoGeneratedNewNames.contains(string)) {
                    this.fAutoGeneratedNewNames.add(string);
                    return JavaCore.removeJavaLikeExtension((String)string);
                }
                ++n;
            }
        }

        public String createNewName(IPackageFragment iPackageFragment, IPackageFragmentRoot iPackageFragmentRoot) {
            if (NewNameProposer.isNewNameOk(iPackageFragmentRoot, iPackageFragment.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(iPackageFragment, iPackageFragmentRoot)) {
                return null;
            }
            int n = 1;
            while (true) {
                String string;
                if (NewNameProposer.isNewNameOk(iPackageFragmentRoot, string = n == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOf1, iPackageFragment.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOfMore, new String[]{String.valueOf(n), iPackageFragment.getElementName()})) && !this.fAutoGeneratedNewNames.contains(string)) {
                    this.fAutoGeneratedNewNames.add(string);
                    return string;
                }
                ++n;
            }
        }

        public String createNewName(IResource iResource, IContainer iContainer) {
            if (NewNameProposer.isNewNameOk(iContainer, iResource.getName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(iResource, (IResource)iContainer)) {
                return null;
            }
            int n = 1;
            while (true) {
                String string;
                if (NewNameProposer.isNewNameOk(iContainer, string = n == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOf1, iResource.getName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOfMore, new String[]{String.valueOf(n), iResource.getName()})) && !this.fAutoGeneratedNewNames.contains(string)) {
                    this.fAutoGeneratedNewNames.add(string);
                    return string;
                }
                ++n;
            }
        }
    }

    private static final class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private NoCopyPolicy() {
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        public Change createChange(IProgressMonitor iProgressMonitor, INewNameQueries iNewNameQueries) {
            return new NullChange();
        }

        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public ChangeDescriptor getDescriptor() {
            return null;
        }

        protected String getHeaderPattern() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return null;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        protected RefactoringStatus verifyDestination(IResource iResource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }
    }

    private static final class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private NoMovePolicy() {
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        public Change createChange(IProgressMonitor iProgressMonitor) {
            return new NullChange();
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return new CreateTargetExecutionLog();
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries iCreateTargetQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public ChangeDescriptor getDescriptor() {
            return null;
        }

        protected String getHeaderPattern() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            return new RefactoringStatus();
        }

        public boolean isTextualMove() {
            return true;
        }

        public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean bl) {
            this.fCheckDestination = bl;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        protected RefactoringStatus verifyDestination(IResource iResource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }
    }

    private static abstract class PackageFragmentRootsReorgPolicy
    extends ReorgPolicy {
        private IPackageFragmentRoot[] fPackageFragmentRoots;

        public PackageFragmentRootsReorgPolicy(IPackageFragmentRoot[] iPackageFragmentRootArray) {
            this.fPackageFragmentRoots = iPackageFragmentRootArray;
        }

        public boolean canChildrenBeDestinations(IJavaElement iJavaElement) {
            switch (iJavaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource iResource) {
            return false;
        }

        public boolean canElementBeDestination(IJavaElement iJavaElement) {
            return iJavaElement.getElementType() == 2;
        }

        public boolean canElementBeDestination(IResource iResource) {
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int n = 0;
            while (n < this.fPackageFragmentRoots.length) {
                if (!(ReorgUtils.isSourceFolder((IJavaElement)this.fPackageFragmentRoots[n]) || this.fPackageFragmentRoots[n].isArchive() && !this.fPackageFragmentRoots[n].isExternal())) {
                    return false;
                }
                ++n;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragmentRoots);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext, IReorgQueries iReorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus = super.checkFinalConditions(iProgressMonitor, checkConditionsContext, iReorgQueries);
            this.confirmOverwriting(iReorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwriting(IReorgQueries iReorgQueries) {
            OverwriteHelper overwriteHelper = new OverwriteHelper();
            overwriteHelper.setPackageFragmentRoots(this.fPackageFragmentRoots);
            IJavaProject iJavaProject = this.getDestinationJavaProject();
            overwriteHelper.confirmOverwriting(iReorgQueries, (IJavaElement)iJavaProject);
            this.fPackageFragmentRoots = overwriteHelper.getPackageFragmentRootsWithoutUnconfirmedOnes();
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = this.fPackageFragmentRoots.length;
            String string = n == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject iProject = this.getSingleProject();
            String string2 = iProject != null ? iProject.getName() : null;
            String string3 = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(n), this.getDestinationLabel()});
            int n2 = 6;
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string2, this, string3);
            JDTRefactoringDescriptor jDTRefactoringDescriptor = this.createRefactoringDescriptor(jDTRefactoringDescriptorComment, hashMap, string, string2, n2);
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_ROOTS, new Integer(this.fPackageFragmentRoots.length).toString());
            int n3 = 0;
            while (n3 < this.fPackageFragmentRoots.length) {
                hashMap.put("element" + (n3 + 1), jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fPackageFragmentRoots[n3]));
                ++n3;
            }
            hashMap.putAll(this.getRefactoringArguments(string2));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor);
        }

        private IJavaProject getDestinationAsJavaProject(IJavaElement iJavaElement) {
            if (iJavaElement == null) {
                return null;
            }
            return iJavaElement.getJavaProject();
        }

        protected IJavaProject getDestinationJavaProject() {
            return this.getDestinationAsJavaProject(this.getJavaElementDestination());
        }

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragmentRoots;
        }

        protected IPackageFragmentRoot[] getPackageFragmentRoots() {
            return this.fPackageFragmentRoots;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IPackageFragmentRoot[] getRoots() {
            return this.fPackageFragmentRoots;
        }

        private IProject getSingleProject() {
            IProject iProject = null;
            int n = 0;
            while (n < this.fPackageFragmentRoots.length) {
                if (iProject == null) {
                    iProject = this.fPackageFragmentRoots[n].getJavaProject().getProject();
                } else if (!iProject.equals((Object)this.fPackageFragmentRoots[n].getJavaProject().getProject())) {
                    return null;
                }
                ++n;
            }
            return iProject;
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            ArrayList<IJavaElement> arrayList;
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            if (refactoringArguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
                int n = 0;
                String string = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_ROOTS);
                if (string != null && !"".equals(string)) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
                }
                String string2 = null;
                arrayList = new ArrayList<IJavaElement>();
                int n2 = 0;
                while (n2 < n) {
                    String string3 = "element" + (n2 + 1);
                    string2 = javaRefactoringArguments.getAttribute(string3);
                    if (string2 != null && !"".equals(string2)) {
                        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                        if (iJavaElement == null || !iJavaElement.exists() || iJavaElement.getElementType() != 3) {
                            refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iJavaElement, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            arrayList.add(iJavaElement);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string3));
                    }
                    ++n2;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fPackageFragmentRoots = arrayList.toArray(new IPackageFragmentRoot[arrayList.size()]);
            refactoringStatus.merge(super.initialize(refactoringArguments));
            return refactoringStatus;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            Assert.isNotNull((Object)iJavaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!iJavaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (iJavaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(iJavaElement instanceof IJavaProject) && !(iJavaElement instanceof IPackageFragmentRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
            }
            if (iJavaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2writable);
            }
            if (ReorgUtils.isPackageFragmentRoot(iJavaElement.getJavaProject())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2nosrc);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource iResource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
        }
    }

    private static abstract class PackagesReorgPolicy
    extends ReorgPolicy {
        private IPackageFragment[] fPackageFragments;

        public PackagesReorgPolicy(IPackageFragment[] iPackageFragmentArray) {
            this.fPackageFragments = iPackageFragmentArray;
        }

        public boolean canChildrenBeDestinations(IJavaElement iJavaElement) {
            switch (iJavaElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource iResource) {
            return false;
        }

        public boolean canElementBeDestination(IJavaElement iJavaElement) {
            switch (iJavaElement.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource iResource) {
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            int n = 0;
            while (n < this.fPackageFragments.length) {
                if (JavaElementUtil.isDefaultPackage(this.fPackageFragments[n]) || this.fPackageFragments[n].isReadOnly()) {
                    return false;
                }
                ++n;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragments);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext, IReorgQueries iReorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus = super.checkFinalConditions(iProgressMonitor, checkConditionsContext, iReorgQueries);
            this.confirmOverwriting(iReorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwriting(IReorgQueries iReorgQueries) throws JavaModelException {
            OverwriteHelper overwriteHelper = new OverwriteHelper();
            overwriteHelper.setPackages(this.fPackageFragments);
            IPackageFragmentRoot iPackageFragmentRoot = this.getDestinationAsPackageFragmentRoot();
            overwriteHelper.confirmOverwriting(iReorgQueries, (IJavaElement)iPackageFragmentRoot);
            this.fPackageFragments = overwriteHelper.getPackagesWithoutUnconfirmedOnes();
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = this.fPackageFragments.length;
            String string = n == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject iProject = this.getSingleProject();
            String string2 = iProject != null ? iProject.getName() : null;
            String string3 = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(n), this.getDestinationLabel()});
            int n2 = 589830;
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string2, this, string3);
            JDTRefactoringDescriptor jDTRefactoringDescriptor = this.createRefactoringDescriptor(jDTRefactoringDescriptorComment, hashMap, string, string2, n2);
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS, new Integer(this.fPackageFragments.length).toString());
            int n3 = 0;
            while (n3 < this.fPackageFragments.length) {
                hashMap.put("element" + (n3 + 1), jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fPackageFragments[n3]));
                ++n3;
            }
            hashMap.putAll(this.getRefactoringArguments(string2));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor);
        }

        protected IPackageFragmentRoot getDestinationAsPackageFragmentRoot() throws JavaModelException {
            return this.getDestinationAsPackageFragmentRoot(this.getJavaElementDestination());
        }

        private IPackageFragmentRoot getDestinationAsPackageFragmentRoot(IJavaElement iJavaElement) throws JavaModelException {
            IPackageFragment iPackageFragment;
            if (iJavaElement == null) {
                return null;
            }
            if (iJavaElement instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)iJavaElement;
            }
            if (iJavaElement instanceof IPackageFragment && (iPackageFragment = (IPackageFragment)iJavaElement).getParent() instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)iPackageFragment.getParent();
            }
            if (iJavaElement instanceof IJavaProject) {
                return ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)iJavaElement);
            }
            return null;
        }

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragments;
        }

        protected IPackageFragment[] getPackages() {
            return this.fPackageFragments;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject iProject = null;
            int n = 0;
            while (n < this.fPackageFragments.length) {
                if (iProject == null) {
                    iProject = this.fPackageFragments[n].getJavaProject().getProject();
                } else if (!iProject.equals((Object)this.fPackageFragments[n].getJavaProject().getProject())) {
                    return null;
                }
                ++n;
            }
            return iProject;
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            ArrayList<IJavaElement> arrayList;
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            if (refactoringArguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
                int n = 0;
                String string = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS);
                if (string != null && !"".equals(string)) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
                }
                String string2 = null;
                arrayList = new ArrayList<IJavaElement>();
                int n2 = 0;
                while (n2 < n) {
                    String string3 = "element" + (n2 + 1);
                    string2 = javaRefactoringArguments.getAttribute(string3);
                    if (string2 != null && !"".equals(string2)) {
                        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                        if (iJavaElement == null || !iJavaElement.exists() || iJavaElement.getElementType() != 4) {
                            refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iJavaElement, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            arrayList.add(iJavaElement);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string3));
                    }
                    ++n2;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fPackageFragments = arrayList.toArray(new IPackageFragment[arrayList.size()]);
            refactoringStatus.merge(super.initialize(refactoringArguments));
            return refactoringStatus;
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            Assert.isNotNull((Object)iJavaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!iJavaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (iJavaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            IPackageFragmentRoot iPackageFragmentRoot = this.getDestinationAsPackageFragmentRoot(iJavaElement);
            if (!ReorgUtils.isSourceFolder((IJavaElement)iPackageFragmentRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource iResource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
        }
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private static final String ATTRIBUTE_DESTINATION = "destination";
        private static final String ATTRIBUTE_TARGET = "target";
        protected boolean fCheckDestination = true;
        private IJavaElement fJavaElementDestination;
        private IResource fResourceDestination;

        private ReorgPolicy() {
        }

        public boolean canChildrenBeDestinations(IJavaElement iJavaElement) {
            return true;
        }

        public boolean canChildrenBeDestinations(IResource iResource) {
            return true;
        }

        public boolean canElementBeDestination(IJavaElement iJavaElement) {
            return true;
        }

        public boolean canElementBeDestination(IResource iResource) {
            return true;
        }

        public boolean canEnable() throws JavaModelException {
            IResource[] iResourceArray = this.getResources();
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                if (!iResource.exists() || iResource.isPhantom() || !iResource.isAccessible()) {
                    return false;
                }
                ++n;
            }
            IJavaElement[] iJavaElementArray = this.getJavaElements();
            int n2 = 0;
            while (n2 < iJavaElementArray.length) {
                IJavaElement iJavaElement = iJavaElementArray[n2];
                if (!iJavaElement.exists()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        public boolean canEnableUpdateReferences() {
            return false;
        }

        public boolean canUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public boolean canUpdateReferences() {
            return false;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext, IReorgQueries iReorgQueries) throws CoreException {
            Assert.isNotNull((Object)iReorgQueries);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker resourceChangeChecker = (ResourceChangeChecker)checkConditionsContext.getChecker((Class)clazz);
            IFile[] iFileArray = this.getAllModifiedFiles();
            RefactoringModifications refactoringModifications = this.getModifications();
            IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = resourceChangeChecker.getDeltaFactory();
            int n = 0;
            while (n < iFileArray.length) {
                iResourceChangeDescriptionFactory.change(iFileArray[n]);
                ++n;
            }
            if (refactoringModifications != null) {
                refactoringModifications.buildDelta(iResourceChangeDescriptionFactory);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                refactoringModifications.buildValidateEdits((ValidateEditChecker)checkConditionsContext.getChecker((Class)clazz2));
            }
            return new RefactoringStatus();
        }

        public IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        protected abstract String getDescriptionPlural();

        protected abstract String getDescriptionSingular();

        protected String getDestinationLabel() {
            IJavaElement iJavaElement = this.getJavaElementDestination();
            if (iJavaElement == null) {
                iJavaElement = this.getResourceDestination();
            }
            return JavaElementLabels.getTextLabel(iJavaElement, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }

        public String getFilePatterns() {
            Assert.isTrue((boolean)false);
            return null;
        }

        protected abstract String getHeaderPattern();

        public final IJavaElement getJavaElementDestination() {
            return this.fJavaElementDestination;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            return null;
        }

        protected abstract String getProcessorId();

        protected Map getRefactoringArguments(String string) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IJavaElement iJavaElement = this.getJavaElementDestination();
            if (iJavaElement != null) {
                hashMap.put(ATTRIBUTE_DESTINATION, JDTRefactoringDescriptor.elementToHandle(string, iJavaElement));
            } else {
                IResource iResource = this.getResourceDestination();
                if (iResource != null) {
                    hashMap.put(ATTRIBUTE_TARGET, JDTRefactoringDescriptor.resourceToHandle(null, iResource));
                }
            }
            return hashMap;
        }

        protected abstract String getRefactoringId();

        public final IResource getResourceDestination() {
            return this.fResourceDestination;
        }

        public boolean getUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public boolean getUpdateReferences() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public boolean hasAllInputSet() {
            return this.fJavaElementDestination != null || this.fResourceDestination != null;
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            if (refactoringArguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
                String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_DESTINATION);
                if (string != null) {
                    IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                    if (iJavaElement != null) {
                        if (this.fCheckDestination && !iJavaElement.exists()) {
                            return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getProcessorId(), this.getRefactoringId());
                        }
                        try {
                            return this.setDestination(iJavaElement);
                        }
                        catch (JavaModelException javaModelException) {
                            JavaPlugin.log(javaModelException);
                            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{string, "input"}));
                        }
                    }
                    IResource iResource = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string);
                    if (iResource == null || this.fCheckDestination && !iResource.exists()) {
                        return ScriptableRefactoring.createInputFatalStatus(iResource, this.getProcessorId(), this.getRefactoringId());
                    }
                    try {
                        return this.setDestination(iResource);
                    }
                    catch (JavaModelException javaModelException) {
                        JavaPlugin.log(javaModelException);
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{string, "input"}));
                    }
                }
                string = javaRefactoringArguments.getAttribute(ATTRIBUTE_TARGET);
                if (string != null) {
                    IResource iResource = JDTRefactoringDescriptor.handleToResource(null, string);
                    if (iResource == null || this.fCheckDestination && !iResource.exists()) {
                        return ScriptableRefactoring.createInputFatalStatus(iResource, this.getProcessorId(), this.getRefactoringId());
                    }
                    try {
                        return this.setDestination(iResource);
                    }
                    catch (JavaModelException javaModelException) {
                        JavaPlugin.log(javaModelException);
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{string, "input"}));
                    }
                }
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }

        public final RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, RefactoringProcessor refactoringProcessor, String[] stringArray, SharableParticipants sharableParticipants) throws CoreException {
            RefactoringModifications refactoringModifications = this.getModifications();
            if (refactoringModifications != null) {
                return refactoringModifications.loadParticipants(refactoringStatus, refactoringProcessor, stringArray, sharableParticipants);
            }
            return new RefactoringParticipant[0];
        }

        public final RefactoringStatus setDestination(IJavaElement iJavaElement) throws JavaModelException {
            Assert.isNotNull((Object)iJavaElement);
            this.fJavaElementDestination = null;
            this.fResourceDestination = null;
            this.fJavaElementDestination = iJavaElement;
            return this.verifyDestination(iJavaElement);
        }

        public final RefactoringStatus setDestination(IResource iResource) throws JavaModelException {
            Assert.isNotNull((Object)iResource);
            this.fJavaElementDestination = null;
            this.fResourceDestination = null;
            this.fResourceDestination = iResource;
            return this.verifyDestination(iResource);
        }

        public void setFilePatterns(String string) {
            Assert.isTrue((boolean)false);
        }

        public void setUpdateQualifiedNames(boolean bl) {
            Assert.isTrue((boolean)false);
        }

        public void setUpdateReferences(boolean bl) {
            Assert.isTrue((boolean)false);
        }

        protected abstract RefactoringStatus verifyDestination(IJavaElement var1) throws JavaModelException;

        protected abstract RefactoringStatus verifyDestination(IResource var1) throws JavaModelException;
    }

    private static abstract class SubCuElementReorgPolicy
    extends ReorgPolicy {
        protected static final int ONLY_FIELDS = 1;
        protected static final int ONLY_IMPORT_CONTAINERS = 5;
        protected static final int ONLY_IMPORT_DECLARATIONS = 6;
        protected static final int ONLY_INITIALIZERS = 3;
        protected static final int ONLY_METHODS = 2;
        protected static final int ONLY_PACKAGE_DECLARATIONS = 4;
        protected static final int ONLY_TYPES = 0;
        private IJavaElement[] fJavaElements;

        protected static CompilationUnitChange createCompilationUnitChange(ICompilationUnit iCompilationUnit, CompilationUnitRewrite compilationUnitRewrite) throws CoreException {
            CompilationUnitChange compilationUnitChange = compilationUnitRewrite.createChange();
            if (compilationUnitChange != null && iCompilationUnit.isWorkingCopy()) {
                compilationUnitChange.setSaveMode(4);
            }
            return compilationUnitChange;
        }

        protected static final ICompilationUnit getDestinationCu(IJavaElement iJavaElement) {
            if (iJavaElement instanceof ICompilationUnit) {
                return (ICompilationUnit)iJavaElement;
            }
            return (ICompilationUnit)iJavaElement.getAncestor(5);
        }

        private static ICompilationUnit getEnclosingCu(IJavaElement iJavaElement) {
            if (iJavaElement instanceof ICompilationUnit) {
                return (ICompilationUnit)iJavaElement;
            }
            return (ICompilationUnit)iJavaElement.getAncestor(5);
        }

        private static IType getEnclosingType(IJavaElement iJavaElement) {
            if (iJavaElement instanceof IType) {
                return (IType)iJavaElement;
            }
            return (IType)iJavaElement.getAncestor(7);
        }

        private static String getUnindentedSource(ISourceReference iSourceReference) throws JavaModelException {
            Assert.isTrue((boolean)(iSourceReference instanceof IJavaElement));
            String[] stringArray = Strings.convertIntoLines(iSourceReference.getSource());
            IJavaProject iJavaProject = ((IJavaElement)iSourceReference).getJavaProject();
            Strings.trimIndentation(stringArray, iJavaProject, false);
            return Strings.concatenate(stringArray, StubUtility.getLineDelimiterUsed((IJavaElement)iSourceReference));
        }

        SubCuElementReorgPolicy(IJavaElement[] iJavaElementArray) {
            this.fJavaElements = iJavaElementArray;
        }

        public boolean canChildrenBeDestinations(IResource iResource) {
            return false;
        }

        public boolean canElementBeDestination(IResource iResource) {
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int n = 0;
            while (n < this.fJavaElements.length) {
                IMember iMember;
                if (this.fJavaElements[n] instanceof IMember && (iMember = (IMember)this.fJavaElements[n]).isBinary() && iMember.getSourceRange() == null) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private void copyImportsToDestination(IImportContainer iImportContainer, ASTRewrite aSTRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) throws JavaModelException {
            IJavaElement[] iJavaElementArray = iImportContainer.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                Assert.isTrue((boolean)(iJavaElementArray[n] instanceof IImportDeclaration));
                IImportDeclaration iImportDeclaration = (IImportDeclaration)iJavaElementArray[n];
                this.copyImportToDestination(iImportDeclaration, aSTRewrite, compilationUnit, compilationUnit2);
                ++n;
            }
        }

        private void copyImportToDestination(IImportDeclaration iImportDeclaration, ASTRewrite aSTRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) throws JavaModelException {
            ImportDeclaration importDeclaration = ASTNodeSearchUtil.getImportDeclarationNode(iImportDeclaration, compilationUnit);
            ImportDeclaration importDeclaration2 = (ImportDeclaration)ASTNode.copySubtree((AST)aSTRewrite.getAST(), (ASTNode)importDeclaration);
            aSTRewrite.getListRewrite((ASTNode)compilationUnit2, CompilationUnit.IMPORTS_PROPERTY).insertLast((ASTNode)importDeclaration2, null);
        }

        private void copyInitializerToDestination(IInitializer iInitializer, CompilationUnitRewrite compilationUnitRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) throws JavaModelException {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)compilationUnitRewrite.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)iInitializer), 28);
            this.copyMemberToDestination((IMember)iInitializer, compilationUnitRewrite, compilationUnit, compilationUnit2, bodyDeclaration);
        }

        private void copyMemberToDestination(IMember iMember, CompilationUnitRewrite compilationUnitRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2, BodyDeclaration bodyDeclaration) throws JavaModelException {
            IType iType;
            ASTNode aSTNode;
            Initializer initializer;
            IJavaElement iJavaElement = this.getJavaElementDestination();
            switch (iJavaElement.getElementType()) {
                case 10: {
                    initializer = ASTNodeSearchUtil.getInitializerNode((IInitializer)iJavaElement, compilationUnit2);
                    aSTNode = initializer.getParent();
                    break;
                }
                case 8: {
                    initializer = ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)iJavaElement, compilationUnit2);
                    aSTNode = initializer.getParent();
                    break;
                }
                case 9: {
                    initializer = ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)iJavaElement, compilationUnit2);
                    aSTNode = initializer.getParent();
                    break;
                }
                case 7: {
                    initializer = null;
                    iType = (IType)iJavaElement;
                    if (iType.isAnonymous()) {
                        aSTNode = ASTNodeSearchUtil.getClassInstanceCreationNode(iType, compilationUnit2).getAnonymousClassDeclaration();
                        break;
                    }
                    aSTNode = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, compilationUnit2);
                    break;
                }
                default: {
                    initializer = null;
                    aSTNode = null;
                }
            }
            if (!(iMember instanceof IInitializer) && (iType = ASTNodeSearchUtil.getBodyDeclarationNode(iMember, compilationUnit)) != null) {
                ImportRewriteUtil.addImports(compilationUnitRewrite, (ASTNode)iType, new HashMap(), new HashMap(), false);
            }
            if (aSTNode != null) {
                iType = aSTNode instanceof AbstractTypeDeclaration ? (bodyDeclaration instanceof EnumConstantDeclaration && aSTNode instanceof EnumDeclaration ? compilationUnitRewrite.getASTRewrite().getListRewrite(aSTNode, EnumDeclaration.ENUM_CONSTANTS_PROPERTY) : compilationUnitRewrite.getASTRewrite().getListRewrite(aSTNode, ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty())) : compilationUnitRewrite.getASTRewrite().getListRewrite(aSTNode, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                if (initializer != null) {
                    List list = iType.getOriginalList();
                    int n = list.indexOf(initializer);
                    if (n > 0 && n < list.size() - 1) {
                        iType.insertBefore((ASTNode)bodyDeclaration, (ASTNode)list.get(n), null);
                    } else {
                        iType.insertLast((ASTNode)bodyDeclaration, null);
                    }
                } else {
                    iType.insertAt((ASTNode)bodyDeclaration, ASTNodes.getInsertionIndex(bodyDeclaration, iType.getRewrittenList()), null);
                }
                return;
            }
            iType = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDestinationAsType(), compilationUnit2);
            compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)iType, iType.getBodyDeclarationsProperty()).insertLast((ASTNode)bodyDeclaration, null);
        }

        private void copyMethodToDestination(IMethod iMethod, CompilationUnitRewrite compilationUnitRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) throws JavaModelException {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)compilationUnitRewrite.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)iMethod), 31);
            this.copyMemberToDestination((IMember)iMethod, compilationUnitRewrite, compilationUnit, compilationUnit2, bodyDeclaration);
        }

        private void copyPackageDeclarationToDestination(IPackageDeclaration iPackageDeclaration, ASTRewrite aSTRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) throws JavaModelException {
            if (compilationUnit2.getPackage() != null) {
                return;
            }
            PackageDeclaration packageDeclaration = ASTNodeSearchUtil.getPackageDeclarationNode(iPackageDeclaration, compilationUnit);
            PackageDeclaration packageDeclaration2 = (PackageDeclaration)ASTNode.copySubtree((AST)aSTRewrite.getAST(), (ASTNode)packageDeclaration);
            aSTRewrite.set((ASTNode)compilationUnit2, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)packageDeclaration2, null);
        }

        protected void copyToDestination(IJavaElement iJavaElement, CompilationUnitRewrite compilationUnitRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) throws CoreException {
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            switch (iJavaElement.getElementType()) {
                case 8: {
                    this.copyMemberToDestination((IMember)iJavaElement, compilationUnitRewrite, compilationUnit, compilationUnit2, this.createNewFieldDeclarationNode((IField)iJavaElement, aSTRewrite, compilationUnit));
                    break;
                }
                case 12: {
                    this.copyImportsToDestination((IImportContainer)iJavaElement, aSTRewrite, compilationUnit, compilationUnit2);
                    break;
                }
                case 13: {
                    this.copyImportToDestination((IImportDeclaration)iJavaElement, aSTRewrite, compilationUnit, compilationUnit2);
                    break;
                }
                case 10: {
                    this.copyInitializerToDestination((IInitializer)iJavaElement, compilationUnitRewrite, compilationUnit, compilationUnit2);
                    break;
                }
                case 9: {
                    this.copyMethodToDestination((IMethod)iJavaElement, compilationUnitRewrite, compilationUnit, compilationUnit2);
                    break;
                }
                case 11: {
                    this.copyPackageDeclarationToDestination((IPackageDeclaration)iJavaElement, aSTRewrite, compilationUnit, compilationUnit2);
                    break;
                }
                case 7: {
                    this.copyTypeToDestination((IType)iJavaElement, compilationUnitRewrite, compilationUnit, compilationUnit2);
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                }
            }
        }

        private void copyTypeToDestination(IType iType, CompilationUnitRewrite compilationUnitRewrite, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) throws JavaModelException {
            AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)compilationUnitRewrite.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)iType), 55);
            IType iType2 = SubCuElementReorgPolicy.getEnclosingType(this.getJavaElementDestination());
            if (iType2 != null) {
                this.copyMemberToDestination((IMember)iType, compilationUnitRewrite, compilationUnit, compilationUnit2, (BodyDeclaration)abstractTypeDeclaration);
            } else {
                compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)compilationUnit2, CompilationUnit.TYPES_PROPERTY).insertLast((ASTNode)abstractTypeDeclaration, null);
            }
        }

        /*
         * Exception decompiling
         */
        private BodyDeclaration createNewFieldDeclarationNode(IField var1_1, ASTRewrite var2_2, CompilationUnit var3_3) throws CoreException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 340->343)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment, Map map, String string, String string2, int n) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), string2, string, jDTRefactoringDescriptorComment.asString(), map, n);
        }

        protected final int getContentKind() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = ReorgUtils.getElementsOfType(this.fJavaElements, 7).size();
            int n8 = n7 + (n6 = ReorgUtils.getElementsOfType(this.fJavaElements, 8).size()) + (n5 = ReorgUtils.getElementsOfType(this.fJavaElements, 9).size()) + (n4 = ReorgUtils.getElementsOfType(this.fJavaElements, 10).size()) + (n3 = ReorgUtils.getElementsOfType(this.fJavaElements, 11).size()) + (n2 = ReorgUtils.getElementsOfType(this.fJavaElements, 12).size()) + (n = ReorgUtils.getElementsOfType(this.fJavaElements, 13).size());
            if (n8 == n7) {
                return 0;
            }
            if (n8 == n6) {
                return 1;
            }
            if (n8 == n5) {
                return 2;
            }
            if (n8 == n4) {
                return 3;
            }
            if (n8 == n3) {
                return 4;
            }
            if (n8 == n2) {
                return 5;
            }
            if (n8 == n) {
                return 6;
            }
            return -1;
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = this.fJavaElements.length;
            String string = n == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject iProject = this.getSingleProject();
            String string2 = iProject != null ? iProject.getName() : null;
            String string3 = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(n), this.getDestinationLabel()});
            int n2 = 589830;
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string2, this, string3);
            JDTRefactoringDescriptor jDTRefactoringDescriptor = this.createRefactoringDescriptor(jDTRefactoringDescriptorComment, hashMap, string, string2, n2);
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            hashMap.put(ReorgPolicyFactory.ATTRIBUTE_MEMBERS, new Integer(this.fJavaElements.length).toString());
            int n3 = 0;
            while (n3 < this.fJavaElements.length) {
                hashMap.put("element" + (n3 + 1), jDTRefactoringDescriptor.elementToHandle(this.fJavaElements[n3]));
                ++n3;
            }
            hashMap.putAll(this.getRefactoringArguments(string2));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor);
        }

        private IType getDestinationAsType() throws JavaModelException {
            IJavaElement iJavaElement = this.getJavaElementDestination();
            IType iType = SubCuElementReorgPolicy.getEnclosingType(iJavaElement);
            if (iType != null) {
                return iType;
            }
            ICompilationUnit iCompilationUnit = SubCuElementReorgPolicy.getEnclosingCu(iJavaElement);
            Assert.isNotNull((Object)iCompilationUnit);
            IType iType2 = JavaElementUtil.getMainType(iCompilationUnit);
            Assert.isNotNull((Object)iType2);
            return iType2;
        }

        protected final ICompilationUnit getDestinationCu() {
            return SubCuElementReorgPolicy.getDestinationCu(this.getJavaElementDestination());
        }

        public final IJavaElement[] getJavaElements() {
            return this.fJavaElements;
        }

        public final IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject iProject = null;
            int n = 0;
            while (n < this.fJavaElements.length) {
                if (iProject == null) {
                    iProject = this.fJavaElements[n].getJavaProject().getProject();
                } else if (!iProject.equals((Object)this.fJavaElements[n].getJavaProject().getProject())) {
                    return null;
                }
                ++n;
            }
            return iProject;
        }

        protected final ICompilationUnit getSourceCu() {
            return (ICompilationUnit)this.fJavaElements[0].getAncestor(5);
        }

        public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
            ArrayList<IJavaElement> arrayList;
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            if (refactoringArguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
                int n = 0;
                String string = javaRefactoringArguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_MEMBERS);
                if (string != null && !"".equals(string)) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
                }
                String string2 = null;
                arrayList = new ArrayList<IJavaElement>();
                int n2 = 0;
                while (n2 < n) {
                    String string3 = "element" + (n2 + 1);
                    string2 = javaRefactoringArguments.getAttribute(string3);
                    if (string2 != null && !"".equals(string2)) {
                        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                        if (iJavaElement == null || !iJavaElement.exists()) {
                            refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iJavaElement, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            arrayList.add(iJavaElement);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string3));
                    }
                    ++n2;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fJavaElements = arrayList.toArray(new IJavaElement[arrayList.size()]);
            refactoringStatus.merge(super.initialize(refactoringArguments));
            return refactoringStatus;
        }

        private RefactoringStatus recursiveVerifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            Assert.isNotNull((Object)iJavaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!iJavaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist1);
            }
            if (iJavaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(iJavaElement instanceof ICompilationUnit) && !ReorgUtils.isInsideCompilationUnit(iJavaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            ICompilationUnit iCompilationUnit = SubCuElementReorgPolicy.getDestinationCu(iJavaElement);
            Assert.isNotNull((Object)iCompilationUnit);
            if (iCompilationUnit.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_modify);
            }
            switch (iJavaElement.getElementType()) {
                case 5: {
                    int[] nArray = new int[]{8, 10, 9};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), nArray)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 11: {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package_decl);
                }
                case 12: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 13: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 8: 
                case 9: 
                case 10: {
                    return this.recursiveVerifyDestination(iJavaElement.getParent());
                }
                case 7: {
                    int[] nArray = new int[]{13, 12, 11};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), nArray)) break;
                    return this.recursiveVerifyDestination(iJavaElement.getParent());
                }
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IJavaElement iJavaElement) throws JavaModelException {
            return this.recursiveVerifyDestination(iJavaElement);
        }

        protected final RefactoringStatus verifyDestination(IResource iResource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_resource);
        }
    }
}

