/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;

class AccessAnalyzer
extends ASTVisitor {
    private ICompilationUnit fCUnit;
    private IVariableBinding fFieldBinding;
    private ITypeBinding fDeclaringClassBinding;
    private String fGetter;
    private String fSetter;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewriter;
    private List fGroupDescriptions;
    private RefactoringStatus fStatus;
    private boolean fSetterMustReturnValue;
    private boolean fEncapsulateDeclaringClass;
    private boolean fIsFieldFinal;
    private boolean fRemoveStaticImport;
    private boolean fReferencingGetter;
    private boolean fReferencingSetter;
    private static final String READ_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_read_access;
    private static final String WRITE_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_write_access;
    private static final String PREFIX_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_prefix_access;
    private static final String POSTFIX_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_postfix_access;
    static /* synthetic */ Class class$0;

    public AccessAnalyzer(SelfEncapsulateFieldRefactoring selfEncapsulateFieldRefactoring, ICompilationUnit iCompilationUnit, IVariableBinding iVariableBinding, ITypeBinding iTypeBinding, ASTRewrite aSTRewrite, ImportRewrite importRewrite) {
        Assert.isNotNull((Object)selfEncapsulateFieldRefactoring);
        Assert.isNotNull((Object)iCompilationUnit);
        Assert.isNotNull((Object)iVariableBinding);
        Assert.isNotNull((Object)iTypeBinding);
        Assert.isNotNull((Object)aSTRewrite);
        Assert.isNotNull((Object)importRewrite);
        this.fCUnit = iCompilationUnit;
        this.fFieldBinding = iVariableBinding.getVariableDeclaration();
        this.fDeclaringClassBinding = iTypeBinding;
        this.fRewriter = aSTRewrite;
        this.fImportRewriter = importRewrite;
        this.fGroupDescriptions = new ArrayList();
        this.fGetter = selfEncapsulateFieldRefactoring.getGetterName();
        this.fSetter = selfEncapsulateFieldRefactoring.getSetterName();
        this.fEncapsulateDeclaringClass = selfEncapsulateFieldRefactoring.getEncapsulateDeclaringClass();
        try {
            this.fIsFieldFinal = Flags.isFinal((int)selfEncapsulateFieldRefactoring.getField().getFlags());
        }
        catch (JavaModelException javaModelException) {}
        this.fStatus = new RefactoringStatus();
    }

    public boolean getSetterMustReturnValue() {
        return this.fSetterMustReturnValue;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public List getGroupDescriptions() {
        return this.fGroupDescriptions;
    }

    public boolean visit(Assignment assignment) {
        Expression expression = assignment.getLeftHandSide();
        if (!this.considerBinding(this.resolveBinding(expression), (ASTNode)expression)) {
            return true;
        }
        this.checkParent((ASTNode)assignment);
        if (!this.fIsFieldFinal) {
            AST aST = assignment.getAST();
            MethodInvocation methodInvocation = aST.newMethodInvocation();
            methodInvocation.setName(aST.newSimpleName(this.fSetter));
            this.fReferencingSetter = true;
            Expression expression2 = this.getReceiver(expression);
            if (expression2 != null) {
                methodInvocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)expression2));
            }
            List list = methodInvocation.arguments();
            if (assignment.getOperator() == Assignment.Operator.ASSIGN) {
                list.add(this.fRewriter.createCopyTarget((ASTNode)assignment.getRightHandSide()));
            } else {
                boolean bl = ASTNodes.needsParentheses(assignment.getRightHandSide());
                InfixExpression infixExpression = aST.newInfixExpression();
                infixExpression.setOperator(ASTNodes.convertToInfixOperator(assignment.getOperator()));
                MethodInvocation methodInvocation2 = aST.newMethodInvocation();
                methodInvocation2.setName(aST.newSimpleName(this.fGetter));
                this.fReferencingGetter = true;
                if (expression2 != null) {
                    methodInvocation2.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)expression2));
                }
                infixExpression.setLeftOperand((Expression)methodInvocation2);
                Expression expression3 = (Expression)this.fRewriter.createCopyTarget((ASTNode)assignment.getRightHandSide());
                if (bl) {
                    ParenthesizedExpression parenthesizedExpression = aST.newParenthesizedExpression();
                    parenthesizedExpression.setExpression(expression3);
                    expression3 = parenthesizedExpression;
                }
                infixExpression.setRightOperand(expression3);
                list.add(infixExpression);
            }
            this.fRewriter.replace((ASTNode)assignment, (ASTNode)methodInvocation, this.createGroupDescription(WRITE_ACCESS));
        }
        assignment.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        if (!simpleName.isDeclaration() && this.considerBinding(simpleName.resolveBinding(), (ASTNode)simpleName)) {
            this.fReferencingGetter = true;
            this.fRewriter.replace((ASTNode)simpleName, this.fRewriter.createStringPlaceholder(String.valueOf(this.fGetter) + "()", 32), this.createGroupDescription(READ_ACCESS));
        }
        return true;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        if (this.considerBinding(importDeclaration.resolveBinding(), (ASTNode)importDeclaration)) {
            this.fRemoveStaticImport = true;
        }
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        Expression expression = prefixExpression.getOperand();
        if (!this.considerBinding(this.resolveBinding(expression), (ASTNode)expression)) {
            return true;
        }
        PrefixExpression.Operator operator = prefixExpression.getOperator();
        if (operator != PrefixExpression.Operator.INCREMENT && operator != PrefixExpression.Operator.DECREMENT) {
            return true;
        }
        this.checkParent((ASTNode)prefixExpression);
        this.fRewriter.replace((ASTNode)prefixExpression, (ASTNode)this.createInvocation(prefixExpression.getAST(), prefixExpression.getOperand(), prefixExpression.getOperator().toString()), this.createGroupDescription(PREFIX_ACCESS));
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        Expression expression = postfixExpression.getOperand();
        if (!this.considerBinding(this.resolveBinding(expression), (ASTNode)expression)) {
            return true;
        }
        ASTNode aSTNode = postfixExpression.getParent();
        if (!(aSTNode instanceof ExpressionStatement)) {
            this.fStatus.addError(RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_cannot_convert_postfix_expression, JavaStatusContext.create((ITypeRoot)this.fCUnit, new SourceRange((ASTNode)postfixExpression)));
            return false;
        }
        this.fRewriter.replace((ASTNode)postfixExpression, (ASTNode)this.createInvocation(postfixExpression.getAST(), postfixExpression.getOperand(), postfixExpression.getOperator().toString()), this.createGroupDescription(POSTFIX_ACCESS));
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        String string = methodDeclaration.getName().getIdentifier();
        return !string.equals(this.fGetter) && !string.equals(this.fSetter);
    }

    public void endVisit(CompilationUnit compilationUnit) {
        if (!this.fRemoveStaticImport) {
            return;
        }
        ITypeBinding iTypeBinding = this.fFieldBinding.getDeclaringClass();
        String string = this.fFieldBinding.getName();
        String string2 = iTypeBinding.getQualifiedName();
        if (this.fRemoveStaticImport) {
            this.fImportRewriter.removeStaticImport(String.valueOf(string2) + "." + string);
        }
        if (this.fReferencingGetter) {
            this.fImportRewriter.addStaticImport(string2, this.fGetter, false);
        }
        if (this.fReferencingSetter) {
            this.fImportRewriter.addStaticImport(string2, this.fSetter, false);
        }
    }

    private boolean considerBinding(IBinding iBinding, ASTNode aSTNode) {
        if (!(iBinding instanceof IVariableBinding)) {
            return false;
        }
        boolean bl = Bindings.equals((IBinding)this.fFieldBinding, (IBinding)((IVariableBinding)iBinding).getVariableDeclaration());
        if (!bl || this.fEncapsulateDeclaringClass) {
            return bl;
        }
        if (iBinding instanceof IVariableBinding) {
            AbstractTypeDeclaration abstractTypeDeclaration;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
                ITypeBinding iTypeBinding = abstractTypeDeclaration.resolveBinding();
                return !Bindings.equals((IBinding)this.fDeclaringClassBinding, (IBinding)iTypeBinding);
            }
        }
        return true;
    }

    private void checkParent(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        if (!(aSTNode2 instanceof ExpressionStatement)) {
            this.fSetterMustReturnValue = true;
        }
    }

    private IBinding resolveBinding(Expression expression) {
        if (expression instanceof SimpleName) {
            return ((SimpleName)expression).resolveBinding();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).resolveBinding();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName().resolveBinding();
        }
        return null;
    }

    private Expression getReceiver(Expression expression) {
        int n = expression.getNodeType();
        switch (n) {
            case 42: {
                return null;
            }
            case 40: {
                return ((QualifiedName)expression).getQualifier();
            }
            case 22: {
                return ((FieldAccess)expression).getExpression();
            }
        }
        return null;
    }

    private MethodInvocation createInvocation(AST aST, Expression expression, String string) {
        Expression expression2 = this.getReceiver(expression);
        MethodInvocation methodInvocation = aST.newMethodInvocation();
        methodInvocation.setName(aST.newSimpleName(this.fSetter));
        if (expression2 != null) {
            methodInvocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)expression2));
        }
        InfixExpression infixExpression = aST.newInfixExpression();
        methodInvocation.arguments().add(infixExpression);
        if ("++".equals(string)) {
            infixExpression.setOperator(InfixExpression.Operator.PLUS);
        } else if ("--".equals(string)) {
            infixExpression.setOperator(InfixExpression.Operator.MINUS);
        } else {
            Assert.isTrue((boolean)false, (String)"Should not happen");
        }
        MethodInvocation methodInvocation2 = aST.newMethodInvocation();
        methodInvocation2.setName(aST.newSimpleName(this.fGetter));
        if (expression2 != null) {
            methodInvocation2.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)expression2));
        }
        infixExpression.setLeftOperand((Expression)methodInvocation2);
        infixExpression.setRightOperand((Expression)aST.newNumberLiteral("1"));
        this.fReferencingGetter = true;
        this.fReferencingSetter = true;
        return methodInvocation;
    }

    private TextEditGroup createGroupDescription(String string) {
        TextEditGroup textEditGroup = new TextEditGroup(string);
        this.fGroupDescriptions.add(textEditGroup);
        return textEditGroup;
    }
}

