/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.MethodRefParameter;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ReturnTypeInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.IDefaultValueAdvisor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ChangeSignatureRefactoring
extends ScriptableRefactoring
implements IDelegateUpdating {
    private static final String ATTRIBUTE_RETURN = "return";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTE_KIND = "kind";
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private List fParameterInfos;
    private CompilationUnitRewrite fBaseCuRewrite;
    private List fExceptionInfos;
    protected TextChangeManager fChangeManager;
    protected List fOtherChanges;
    private IMethod fMethod;
    private IMethod fTopMethod;
    private IMethod[] fRippleMethods;
    private SearchResultGroup[] fOccurrences;
    private ReturnTypeInfo fReturnTypeInfo;
    private String fMethodName;
    private int fVisibility;
    private static final String CONST_CLASS_DECL = "class A{";
    private static final String CONST_ASSIGN = " i=";
    private static final String CONST_CLOSE = ";}";
    private StubTypeContext fContextCuStartEnd;
    private int fOldVarargIndex;
    private BodyUpdater fBodyUpdater;
    private IDefaultValueAdvisor fDefaultValueAdvisor;
    private ITypeHierarchy fCachedTypeHierarchy = null;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    private static final boolean BUG_89686 = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ChangeSignatureRefactoring(IMethod iMethod) throws JavaModelException {
        this.fMethod = iMethod;
        this.fOldVarargIndex = -1;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        if (this.fMethod != null) {
            this.fParameterInfos = ChangeSignatureRefactoring.createParameterInfoList(iMethod);
            this.fReturnTypeInfo = new ReturnTypeInfo(Signature.toString((String)Signature.getReturnType((String)this.fMethod.getSignature())));
            this.fMethodName = this.fMethod.getElementName();
            this.fVisibility = JdtFlags.getVisibilityCode((IMember)this.fMethod);
        }
    }

    private static List createParameterInfoList(IMethod iMethod) {
        try {
            String[] stringArray = iMethod.getParameterTypes();
            String[] stringArray2 = iMethod.getParameterNames();
            ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>(stringArray.length);
            int n = 0;
            while (n < stringArray2.length) {
                ParameterInfo parameterInfo;
                if (n == stringArray2.length - 1 && Flags.isVarargs((int)iMethod.getFlags())) {
                    String string = stringArray[n];
                    int n2 = Signature.getArrayCount((String)string);
                    String string2 = Signature.getElementType((String)string);
                    if (n2 > 1) {
                        string2 = Signature.createArraySignature((String)string2, (int)(n2 - 1));
                    }
                    parameterInfo = new ParameterInfo(String.valueOf(Signature.toString((String)string2)) + "...", stringArray2[n], n);
                } else {
                    parameterInfo = new ParameterInfo(Signature.toString((String)stringArray[n]), stringArray2[n], n);
                }
                arrayList.add(parameterInfo);
                ++n;
            }
            return arrayList;
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return new ArrayList(0);
        }
    }

    public String getName() {
        return RefactoringCoreMessages.ChangeSignatureRefactoring_modify_Parameters;
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public String getReturnTypeString() {
        return this.fReturnTypeInfo.getNewTypeName();
    }

    public void setNewMethodName(String string) {
        Assert.isNotNull((Object)string);
        this.fMethodName = string;
    }

    public void setNewReturnTypeName(String string) {
        Assert.isNotNull((Object)string);
        this.fReturnTypeInfo.setNewTypeName(string);
    }

    public boolean canChangeNameAndReturnType() {
        try {
            return !this.fMethod.isConstructor();
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return false;
        }
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int n) {
        Assert.isTrue((n == 1 || n == 4 || n == 0 || n == 2 ? 1 : 0) != 0);
        this.fVisibility = n;
    }

    public int[] getAvailableVisibilities() throws JavaModelException {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public List getExceptionInfos() {
        return this.fExceptionInfos;
    }

    public void setBodyUpdater(BodyUpdater bodyUpdater) {
        this.fBodyUpdater = bodyUpdater;
    }

    public CompilationUnitRewrite getBaseCuRewrite() {
        return this.fBaseCuRewrite;
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean bl) {
        this.fDelegateUpdating = bl;
    }

    public void setDeprecateDelegates(boolean bl) {
        this.fDelegateDeprecation = bl;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public RefactoringStatus checkSignature() {
        return this.checkSignature(false, this.doGetProblemVerifier());
    }

    private RefactoringStatus checkSignature(boolean bl, TypeContextChecker.IProblemVerifier iProblemVerifier) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.checkMethodName(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.checkParameterNamesAndValues(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.checkForDuplicateParameterNames(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        try {
            RefactoringStatus[] refactoringStatusArray = bl ? TypeContextChecker.checkAndResolveMethodTypes(this.fMethod, this.getStubTypeContext(), this.getNotDeletedInfos(), this.fReturnTypeInfo, iProblemVerifier) : TypeContextChecker.checkMethodTypesSyntax(this.fMethod, this.getNotDeletedInfos(), this.fReturnTypeInfo);
            int n = 0;
            while (n < refactoringStatusArray.length) {
                refactoringStatus.merge(refactoringStatusArray[n]);
                ++n;
            }
            refactoringStatus.merge(this.checkVarargs());
        }
        catch (CoreException coreException) {
            throw new RuntimeException(coreException);
        }
        return refactoringStatus;
    }

    public boolean isSignatureSameAsInitial() throws JavaModelException {
        if (!this.isVisibilitySameAsInitial()) {
            return false;
        }
        if (!this.isMethodNameSameAsInitial()) {
            return false;
        }
        if (!this.isReturnTypeSameAsInitial()) {
            return false;
        }
        if (!this.areExceptionsSameAsInitial()) {
            return false;
        }
        if (this.fMethod.getNumberOfParameters() == 0 && this.fParameterInfos.isEmpty()) {
            return true;
        }
        return this.areNamesSameAsInitial() && this.isOrderSameAsInitial() && this.areParameterTypesSameAsInitial();
    }

    public boolean isSignatureClashWithInitial() throws JavaModelException {
        if (!this.isMethodNameSameAsInitial()) {
            return false;
        }
        if (this.fMethod.getNumberOfParameters() == 0 && this.fParameterInfos.isEmpty()) {
            return true;
        }
        int n = this.getNotDeletedInfos().size();
        if (this.fMethod.getNumberOfParameters() != n) {
            return false;
        }
        if (this.isOrderSameAsInitial()) {
            return this.areParameterTypesSameAsInitial();
        }
        return false;
    }

    private boolean areParameterTypesSameAsInitial() {
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (parameterInfo.isAdded() || parameterInfo.isDeleted() || !parameterInfo.isTypeNameChanged()) continue;
            return false;
        }
        return true;
    }

    private boolean isReturnTypeSameAsInitial() throws JavaModelException {
        return !this.fReturnTypeInfo.isTypeNameChanged();
    }

    private boolean isMethodNameSameAsInitial() {
        return this.fMethodName.equals(this.fMethod.getElementName());
    }

    private boolean areExceptionsSameAsInitial() {
        Iterator iterator = this.fExceptionInfos.iterator();
        while (iterator.hasNext()) {
            ExceptionInfo exceptionInfo = (ExceptionInfo)iterator.next();
            if (exceptionInfo.isOld()) continue;
            return false;
        }
        return true;
    }

    private void checkParameterNamesAndValues(RefactoringStatus refactoringStatus) {
        int n = 1;
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (!parameterInfo.isDeleted()) {
                this.checkParameterName(refactoringStatus, parameterInfo, n);
                if (refactoringStatus.hasFatalError()) {
                    return;
                }
                if (parameterInfo.isAdded()) {
                    this.checkParameterDefaultValue(refactoringStatus, parameterInfo);
                    if (refactoringStatus.hasFatalError()) {
                        return;
                    }
                }
            }
            ++n;
        }
    }

    private void checkParameterName(RefactoringStatus refactoringStatus, ParameterInfo parameterInfo, int n) {
        if (parameterInfo.getNewName().trim().length() == 0) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_param_name_not_empty, Integer.toString(n)));
        } else {
            refactoringStatus.merge(Checks.checkTempName(parameterInfo.getNewName()));
        }
    }

    private void checkMethodName(RefactoringStatus refactoringStatus) {
        if (this.isMethodNameSameAsInitial() || !this.canChangeNameAndReturnType()) {
            return;
        }
        if ("".equals(this.fMethodName.trim())) {
            String string = RefactoringCoreMessages.ChangeSignatureRefactoring_method_name_not_empty;
            refactoringStatus.addFatalError(string);
            return;
        }
        if (this.fMethodName.equals(this.fMethod.getDeclaringType().getElementName())) {
            String string = RefactoringCoreMessages.ChangeSignatureRefactoring_constructor_name;
            refactoringStatus.addWarning(string);
        }
        refactoringStatus.merge(Checks.checkMethodName(this.fMethodName));
    }

    private void checkParameterDefaultValue(RefactoringStatus refactoringStatus, ParameterInfo parameterInfo) {
        if (this.fDefaultValueAdvisor != null) {
            return;
        }
        if (parameterInfo.isNewVarargs()) {
            if (!ChangeSignatureRefactoring.isValidVarargsExpression(parameterInfo.getDefaultValue())) {
                String string = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_invalid_expression, new String[]{parameterInfo.getDefaultValue()});
                refactoringStatus.addFatalError(string);
            }
            return;
        }
        if (parameterInfo.getDefaultValue().trim().equals("")) {
            String string = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_default_value, new String[]{parameterInfo.getNewName()});
            refactoringStatus.addFatalError(string);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidExpression(parameterInfo.getDefaultValue())) {
            String string = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_invalid_expression, new String[]{parameterInfo.getDefaultValue()});
            refactoringStatus.addFatalError(string);
        }
    }

    private RefactoringStatus checkVarargs() throws JavaModelException {
        RefactoringStatus refactoringStatus = this.checkOriginalVarargs();
        if (refactoringStatus != null) {
            return refactoringStatus;
        }
        if (this.fRippleMethods != null) {
            int n = 0;
            while (n < this.fRippleMethods.length) {
                IMethod iMethod = this.fRippleMethods[n];
                if (JdtFlags.isVarargs(iMethod)) {
                    this.fOldVarargIndex = iMethod.getNumberOfParameters() - 1;
                    List list = this.getNotDeletedInfos();
                    int n2 = 0;
                    while (n2 < list.size()) {
                        ParameterInfo parameterInfo = (ParameterInfo)list.get(n2);
                        if (this.fOldVarargIndex != -1 && parameterInfo.getOldIndex() == this.fOldVarargIndex && !parameterInfo.isNewVarargs()) {
                            String string = JavaModelUtil.getFullyQualifiedName(iMethod.getDeclaringType());
                            String string2 = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_ripple_cannot_convert_vararg, new Object[]{parameterInfo.getNewName(), string});
                            return RefactoringStatus.createFatalErrorStatus((String)string2, (RefactoringStatusContext)JavaStatusContext.create((IMember)iMethod));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private RefactoringStatus checkOriginalVarargs() throws JavaModelException {
        if (JdtFlags.isVarargs(this.fMethod)) {
            this.fOldVarargIndex = this.fMethod.getNumberOfParameters() - 1;
        }
        List list = this.getNotDeletedInfos();
        int n = 0;
        while (n < list.size()) {
            ParameterInfo parameterInfo = (ParameterInfo)list.get(n);
            if (parameterInfo.isOldVarargs() && !parameterInfo.isNewVarargs()) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_cannot_convert_vararg, parameterInfo.getNewName()));
            }
            if (n != list.size() - 1 && parameterInfo.isNewVarargs()) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_vararg_must_be_last, parameterInfo.getNewName()));
            }
            ++n;
        }
        return null;
    }

    private RefactoringStatus checkTypeVariables() throws JavaModelException {
        Object object;
        ParameterInfo parameterInfo;
        Object object2;
        if (this.fRippleMethods.length == 1) {
            return null;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fReturnTypeInfo.isTypeNameChanged() && this.fReturnTypeInfo.getNewTypeBinding() != null) {
            object2 = new HashSet();
            this.collectTypeVariables(this.fReturnTypeInfo.getNewTypeBinding(), (Set)object2);
            if (((HashSet)object2).size() != 0) {
                parameterInfo = (ITypeBinding)((HashSet)object2).iterator().next();
                object = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_return_type_contains_type_variable, new String[]{this.fReturnTypeInfo.getNewTypeName(), parameterInfo.getName()});
                refactoringStatus.addError((String)object);
            }
        }
        object2 = this.getNotDeletedInfos().iterator();
        while (object2.hasNext()) {
            parameterInfo = (ParameterInfo)object2.next();
            if (!parameterInfo.isTypeNameChanged() || parameterInfo.getNewTypeBinding() == null) continue;
            object = new HashSet();
            this.collectTypeVariables(parameterInfo.getNewTypeBinding(), (Set)object);
            if (((HashSet)object).size() == 0) continue;
            ITypeBinding iTypeBinding = (ITypeBinding)((HashSet)object).iterator().next();
            String string = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_parameter_type_contains_type_variable, new String[]{parameterInfo.getNewTypeName(), parameterInfo.getNewName(), iTypeBinding.getName()});
            refactoringStatus.addError(string);
        }
        return refactoringStatus;
    }

    private void collectTypeVariables(ITypeBinding iTypeBinding, Set set) {
        ITypeBinding iTypeBinding2;
        if (iTypeBinding.isTypeVariable()) {
            set.add(iTypeBinding);
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeBounds();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                this.collectTypeVariables(iTypeBindingArray[n], set);
                ++n;
            }
        } else if (iTypeBinding.isArray()) {
            this.collectTypeVariables(iTypeBinding.getElementType(), set);
        } else if (iTypeBinding.isParameterizedType()) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                this.collectTypeVariables(iTypeBindingArray[n], set);
                ++n;
            }
        } else if (iTypeBinding.isWildcardType() && (iTypeBinding2 = iTypeBinding.getBound()) != null) {
            this.collectTypeVariables(iTypeBinding2, set);
        }
    }

    public static boolean isValidExpression(String string) {
        String string2 = string.trim();
        if ("".equals(string2)) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CONST_CLASS_DECL).append("Object").append(CONST_ASSIGN);
        int n = stringBuffer.length();
        stringBuffer.append(string2).append(CONST_CLOSE);
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        Selection selection = Selection.createFromStartLength(n, string2.length());
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(selection, false);
        compilationUnit.accept((ASTVisitor)selectionAnalyzer);
        ASTNode aSTNode = selectionAnalyzer.getFirstSelectedNode();
        return aSTNode instanceof Expression && string2.equals(stringBuffer.substring(compilationUnit.getExtendedStartPosition(aSTNode), compilationUnit.getExtendedStartPosition(aSTNode) + compilationUnit.getExtendedLength(aSTNode)));
    }

    public static boolean isValidVarargsExpression(String string) {
        String string2 = string.trim();
        if ("".equals(string2)) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A{ {m(");
        int n = stringBuffer.length();
        stringBuffer.append(string2).append(");}}");
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        Selection selection = Selection.createFromStartLength(n, string2.length());
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(selection, false);
        compilationUnit.accept((ASTVisitor)selectionAnalyzer);
        ASTNode[] aSTNodeArray = selectionAnalyzer.getSelectedNodes();
        if (aSTNodeArray.length == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < aSTNodeArray.length) {
            if (!(aSTNodeArray[n2] instanceof Expression)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public StubTypeContext getStubTypeContext() {
        try {
            if (this.fContextCuStartEnd == null) {
                this.fContextCuStartEnd = TypeContextChecker.createStubTypeContext(this.getCu(), this.fBaseCuRewrite.getRoot(), this.fMethod.getSourceRange().getOffset());
            }
        }
        catch (CoreException coreException) {
            throw new RuntimeException(coreException);
        }
        return this.fContextCuStartEnd;
    }

    private ITypeHierarchy getCachedTypeHierarchy(IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (this.fCachedTypeHierarchy == null) {
            this.fCachedTypeHierarchy = this.fMethod.getDeclaringType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        return this.fCachedTypeHierarchy;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block13: {
            ITypeHierarchy iTypeHierarchy;
            block14: {
                block12: {
                    block11: {
                        RefactoringStatus refactoringStatus2;
                        try {
                            iProgressMonitor.beginTask("", 5);
                            refactoringStatus = Checks.checkIfCuBroken((IMember)this.fMethod);
                            if (!refactoringStatus.hasFatalError()) break block11;
                            refactoringStatus2 = refactoringStatus;
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_13 = null;
                            iProgressMonitor.done();
                            throw throwable;
                        }
                        iProgressMonitor.done();
                        return refactoringStatus2;
                    }
                    if (this.fMethod != null && this.fMethod.exists()) break block12;
                    String string = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_method_deleted, this.getCu().getElementName());
                    RefactoringStatus refactoringStatus3 = RefactoringStatus.createFatalErrorStatus((String)string);
                    Object var5_9 = null;
                    iProgressMonitor.done();
                    return refactoringStatus3;
                }
                if (MethodChecks.isVirtual(this.fMethod)) {
                    iTypeHierarchy = this.getCachedTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    this.fTopMethod = MethodChecks.isDeclaredInInterface(this.fMethod, iTypeHierarchy, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    if (this.fTopMethod == null) {
                        this.fTopMethod = MethodChecks.overridesAnotherMethod(this.fMethod, iTypeHierarchy);
                    }
                }
                if (this.fTopMethod == null) {
                    this.fTopMethod = this.fMethod;
                }
                if (this.fTopMethod.equals(this.fMethod)) break block13;
                if (!this.fTopMethod.getDeclaringType().isInterface()) break block14;
                iTypeHierarchy = JavaStatusContext.create((IMember)this.fTopMethod);
                String string = Messages.format(RefactoringCoreMessages.MethodChecks_implements, new String[]{JavaElementUtil.createMethodSignature(this.fTopMethod), JavaModelUtil.getFullyQualifiedName(this.fTopMethod.getDeclaringType())});
                RefactoringStatus refactoringStatus4 = RefactoringStatus.createStatus((int)4, (String)string, (RefactoringStatusContext)iTypeHierarchy, (String)Corext.getPluginId(), (int)2, (Object)this.fTopMethod);
                Object var5_10 = null;
                iProgressMonitor.done();
                return refactoringStatus4;
            }
            iTypeHierarchy = JavaStatusContext.create((IMember)this.fTopMethod);
            String string = Messages.format(RefactoringCoreMessages.MethodChecks_overrides, new String[]{JavaElementUtil.createMethodSignature(this.fTopMethod), JavaModelUtil.getFullyQualifiedName(this.fTopMethod.getDeclaringType())});
            RefactoringStatus refactoringStatus5 = RefactoringStatus.createStatus((int)4, (String)string, (RefactoringStatusContext)iTypeHierarchy, (String)Corext.getPluginId(), (int)1, (Object)this.fTopMethod);
            Object var5_11 = null;
            iProgressMonitor.done();
            return refactoringStatus5;
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fBaseCuRewrite == null || !this.fBaseCuRewrite.getCu().equals(this.getCu())) {
            this.fBaseCuRewrite = new CompilationUnitRewrite(this.getCu());
            this.fBaseCuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new TightSourceRangeComputer());
        }
        iProgressMonitor.worked(1);
        refactoringStatus.merge(this.createExceptionInfoList());
        iProgressMonitor.worked(1);
        RefactoringStatus refactoringStatus6 = refactoringStatus;
        Object var5_12 = null;
        iProgressMonitor.done();
        return refactoringStatus6;
    }

    private RefactoringStatus createExceptionInfoList() {
        if (this.fExceptionInfos == null || this.fExceptionInfos.isEmpty()) {
            ASTNode aSTNode;
            block6: {
                this.fExceptionInfos = new ArrayList(0);
                aSTNode = NodeFinder.perform((ASTNode)this.fBaseCuRewrite.getRoot(), this.fMethod.getNameRange());
                if (aSTNode != null && aSTNode instanceof Name && aSTNode.getParent() instanceof MethodDeclaration) break block6;
                return null;
            }
            try {
                MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode.getParent();
                List list = methodDeclaration.thrownExceptions();
                ArrayList<ExceptionInfo> arrayList = new ArrayList<ExceptionInfo>(list.size());
                int n = 0;
                while (n < list.size()) {
                    Name name = (Name)list.get(n);
                    ITypeBinding iTypeBinding = name.resolveTypeBinding();
                    if (iTypeBinding == null) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_no_exception_binding);
                    }
                    IType iType = (IType)iTypeBinding.getJavaElement();
                    arrayList.add(ExceptionInfo.createInfoForOldException(iType, iTypeBinding));
                    ++n;
                }
                this.fExceptionInfos = arrayList;
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            RefactoringStatus refactoringStatus2;
                            try {
                                iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_checking_preconditions, 8);
                                refactoringStatus = new RefactoringStatus();
                                this.clearManagers();
                                this.fBaseCuRewrite.clearASTAndImportRewrites();
                                this.fBaseCuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new TightSourceRangeComputer());
                                if (!this.isSignatureSameAsInitial()) break block13;
                                refactoringStatus2 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_unchanged);
                                Object var3_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_15 = null;
                                iProgressMonitor.done();
                                throw throwable;
                            }
                            iProgressMonitor.done();
                            return refactoringStatus2;
                        }
                        refactoringStatus.merge(this.checkSignature(true, this.doGetProblemVerifier()));
                        if (!refactoringStatus.hasFatalError()) break block14;
                        RefactoringStatus refactoringStatus3 = refactoringStatus;
                        Object var3_10 = null;
                        iProgressMonitor.done();
                        return refactoringStatus3;
                    }
                    if (this.fDelegateUpdating && this.isSignatureClashWithInitial()) {
                        refactoringStatus.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_old_and_new_signatures_not_sufficiently_different));
                    }
                    this.fRippleMethods = RippleMethodFinder2.getRelatedMethods(this.fMethod, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), null);
                    refactoringStatus.merge(this.checkVarargs());
                    if (!refactoringStatus.hasFatalError()) break block15;
                    RefactoringStatus refactoringStatus4 = refactoringStatus;
                    Object var3_11 = null;
                    iProgressMonitor.done();
                    return refactoringStatus4;
                }
                this.fOccurrences = this.findOccurrences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
                refactoringStatus.merge(this.checkVisibilityChanges());
                refactoringStatus.merge(this.checkTypeVariables());
                if (!this.isOrderSameAsInitial()) {
                    refactoringStatus.merge(this.checkReorderings((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                } else {
                    iProgressMonitor.worked(1);
                }
                if (!this.areNamesSameAsInitial()) {
                    refactoringStatus.merge(this.checkRenamings((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                } else {
                    iProgressMonitor.worked(1);
                }
                if (!refactoringStatus.hasFatalError()) break block16;
                RefactoringStatus refactoringStatus5 = refactoringStatus;
                Object var3_12 = null;
                iProgressMonitor.done();
                return refactoringStatus5;
            }
            this.createChangeManager((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
            this.fCachedTypeHierarchy = null;
            if (this.mustAnalyzeAstOfDeclaringCu()) {
                refactoringStatus.merge(this.checkCompilationofDeclaringCu());
            }
            if (!refactoringStatus.hasFatalError()) break block17;
            RefactoringStatus refactoringStatus6 = refactoringStatus;
            Object var3_13 = null;
            iProgressMonitor.done();
            return refactoringStatus6;
        }
        refactoringStatus.merge(this.validateModifiesFiles());
        RefactoringStatus refactoringStatus7 = refactoringStatus;
        Object var3_14 = null;
        iProgressMonitor.done();
        return refactoringStatus7;
    }

    protected TypeContextChecker.IProblemVerifier doGetProblemVerifier() {
        return null;
    }

    private void clearManagers() {
        this.fChangeManager = null;
        this.fOtherChanges = new ArrayList();
    }

    private RefactoringStatus checkVisibilityChanges() throws JavaModelException {
        if (this.isVisibilitySameAsInitial()) {
            return null;
        }
        if (this.fRippleMethods.length == 1) {
            return null;
        }
        Assert.isTrue((JdtFlags.getVisibilityCode((IMember)this.fMethod) != 2 ? 1 : 0) != 0);
        if (this.fVisibility == 2) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_non_virtual);
        }
        return null;
    }

    public String getOldMethodSignature() throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getMethod().getFlags();
        stringBuffer.append(this.getVisibilityString(n));
        if (Flags.isStatic((int)n)) {
            stringBuffer.append("static ");
        }
        if (!this.getMethod().isConstructor()) {
            stringBuffer.append(this.fReturnTypeInfo.getOldTypeName()).append(' ');
        }
        stringBuffer.append(JavaElementLabels.getElementLabel(this.fMethod.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED));
        stringBuffer.append('.');
        stringBuffer.append(this.fMethod.getElementName()).append('(').append(this.getOldMethodParameters()).append(')');
        stringBuffer.append(this.getOldMethodThrows());
        return stringBuffer.toString();
    }

    public String getNewMethodSignature() throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getVisibilityString(this.fVisibility));
        if (Flags.isStatic((int)this.getMethod().getFlags())) {
            stringBuffer.append("static ");
        }
        if (!this.getMethod().isConstructor()) {
            stringBuffer.append(this.getReturnTypeString()).append(' ');
        }
        stringBuffer.append(this.getMethodName()).append('(').append(this.getMethodParameters()).append(')');
        stringBuffer.append(this.getMethodThrows());
        return stringBuffer.toString();
    }

    private String getVisibilityString(int n) {
        String string = JdtFlags.getVisibilityString(n);
        if ("".equals(string)) {
            return string;
        }
        return String.valueOf(string) + ' ';
    }

    private String getMethodThrows() {
        StringBuffer stringBuffer = new StringBuffer(" throws ");
        Iterator iterator = this.fExceptionInfos.iterator();
        while (iterator.hasNext()) {
            ExceptionInfo exceptionInfo = (ExceptionInfo)iterator.next();
            if (exceptionInfo.isDeleted()) continue;
            stringBuffer.append(exceptionInfo.getType().getElementName());
            stringBuffer.append(", ");
        }
        if (stringBuffer.length() == " throws ".length()) {
            return "";
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        return stringBuffer.toString();
    }

    private String getOldMethodThrows() {
        StringBuffer stringBuffer = new StringBuffer(" throws ");
        Iterator iterator = this.fExceptionInfos.iterator();
        while (iterator.hasNext()) {
            ExceptionInfo exceptionInfo = (ExceptionInfo)iterator.next();
            if (exceptionInfo.isAdded()) continue;
            stringBuffer.append(exceptionInfo.getType().getElementName());
            stringBuffer.append(", ");
        }
        if (stringBuffer.length() == " throws ".length()) {
            return "";
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        return stringBuffer.toString();
    }

    private void checkForDuplicateParameterNames(RefactoringStatus refactoringStatus) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = this.getNotDeletedInfos().iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            String string = parameterInfo.getNewName();
            if (hashSet.contains(string) && !hashSet2.contains(string)) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_duplicate_name, string));
                hashSet2.add(string);
                continue;
            }
            hashSet.add(string);
        }
    }

    private ICompilationUnit getCu() {
        return this.fMethod.getCompilationUnit();
    }

    private boolean mustAnalyzeAstOfDeclaringCu() throws JavaModelException {
        if (JdtFlags.isAbstract((IMember)this.getMethod())) {
            return false;
        }
        if (JdtFlags.isNative((IMember)this.getMethod())) {
            return false;
        }
        return !this.getMethod().getDeclaringType().isInterface();
    }

    private RefactoringStatus checkCompilationofDeclaringCu() throws CoreException {
        ICompilationUnit iCompilationUnit = this.getCu();
        TextChange textChange = this.fChangeManager.get(iCompilationUnit);
        String string = textChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse(string, iCompilationUnit, true, false, null);
        IProblem[] iProblemArray = RefactoringAnalyzeUtil.getIntroducedCompileProblems(compilationUnit, this.fBaseCuRewrite.getRoot());
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n];
            if (this.shouldReport(iProblem, compilationUnit)) {
                refactoringStatus.addEntry(new RefactoringStatusEntry(iProblem.isError() ? 3 : 2, iProblem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(string, new SourceRange(iProblem))));
            }
            ++n;
        }
        return refactoringStatus;
    }

    private boolean shouldReport(IProblem iProblem, CompilationUnit compilationUnit) {
        if (!iProblem.isError()) {
            return false;
        }
        if (iProblem.getID() == 0x1000002) {
            return false;
        }
        ASTNode aSTNode = ASTNodeSearchUtil.getAstNode(compilationUnit, iProblem.getSourceStart(), iProblem.getSourceEnd() - iProblem.getSourceStart());
        TypeContextChecker.IProblemVerifier iProblemVerifier = this.doGetProblemVerifier();
        if (iProblemVerifier != null) {
            return iProblemVerifier.isError(iProblem, aSTNode);
        }
        return true;
    }

    private String getOldMethodParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = this.getNotAddedInfos().iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ChangeSignatureRefactoring.createDeclarationString(parameterInfo));
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getMethodParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = this.getNotDeletedInfos().iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ChangeSignatureRefactoring.createDeclarationString(parameterInfo));
            ++n;
        }
        return stringBuffer.toString();
    }

    private List getAddedInfos() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>(1);
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (!parameterInfo.isAdded()) continue;
            arrayList.add(parameterInfo);
        }
        return arrayList;
    }

    private List getDeletedInfos() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>(1);
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (!parameterInfo.isDeleted()) continue;
            arrayList.add(parameterInfo);
        }
        return arrayList;
    }

    private List getNotAddedInfos() {
        ArrayList arrayList = new ArrayList(this.fParameterInfos);
        arrayList.removeAll(this.getAddedInfos());
        return arrayList;
    }

    private List getNotDeletedInfos() {
        ArrayList arrayList = new ArrayList(this.fParameterInfos);
        arrayList.removeAll(this.getDeletedInfos());
        return arrayList;
    }

    private boolean areNamesSameAsInitial() {
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (!parameterInfo.isRenamed()) continue;
            return false;
        }
        return true;
    }

    private boolean isOrderSameAsInitial() {
        int n = 0;
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (parameterInfo.getOldIndex() != n) {
                return false;
            }
            if (parameterInfo.isDeleted()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private RefactoringStatus checkReorderings(IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_checking_preconditions, 1);
            refactoringStatus = this.checkNativeMethods();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkRenamings(IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_checking_preconditions, 1);
            refactoringStatus = this.checkParameterNamesInRippleMethods();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkParameterNamesInRippleMethods() throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Set set = this.getNewParameterNamesList();
        int n = 0;
        while (n < this.fRippleMethods.length) {
            String[] stringArray = this.fRippleMethods[n].getParameterNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (set.contains(stringArray[n2])) {
                    Object[] objectArray = new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[n]), stringArray[n2]};
                    String string = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_already_has, objectArray);
                    RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)this.fRippleMethods[n].getCompilationUnit(), this.fRippleMethods[n].getNameRange());
                    refactoringStatus.addError(string, refactoringStatusContext);
                }
                ++n2;
            }
            ++n;
        }
        return refactoringStatus;
    }

    private Set getNewParameterNamesList() {
        Set set = this.getOriginalParameterNames();
        Set set2 = this.getNamesOfNotDeletedParameters();
        set2.removeAll(set);
        return set2;
    }

    private Set getNamesOfNotDeletedParameters() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.getNotDeletedInfos().iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            hashSet.add(parameterInfo.getNewName());
        }
        return hashSet;
    }

    private Set getOriginalParameterNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (parameterInfo.isAdded()) continue;
            hashSet.add(parameterInfo.getOldName());
        }
        return hashSet;
    }

    private RefactoringStatus checkNativeMethods() throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < this.fRippleMethods.length) {
            if (JdtFlags.isNative((IMember)this.fRippleMethods[n])) {
                String string = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_native, new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[n]), JavaModelUtil.getFullyQualifiedName(this.fRippleMethods[n].getDeclaringType())});
                refactoringStatus.addError(string, JavaStatusContext.create((IMember)this.fRippleMethods[n]));
            }
            ++n;
        }
        return refactoringStatus;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    public Change createChange(IProgressMonitor iProgressMonitor) {
        Object object;
        ArrayList<TextChange> arrayList;
        iProgressMonitor.beginTask("", 1);
        try {
            TextChange[] textChangeArray = this.fChangeManager.getAllChanges();
            arrayList = new ArrayList<TextChange>(textChangeArray.length);
            arrayList.addAll(this.fOtherChanges);
            arrayList.addAll(Arrays.asList(textChangeArray));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            IJavaProject iJavaProject = this.fMethod.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 589826;
            try {
                if (!Flags.isPrivate((int)this.fMethod.getFlags())) {
                    n |= 4;
                }
                if ((object = this.fMethod.getDeclaringType()).isAnonymous() || object.isLocal()) {
                    n |= 0x40000;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            object = null;
            try {
                Object object2;
                Object object3;
                Object object4;
                String string2 = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_descriptor_description_short, this.fMethod.getElementName());
                String string3 = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_descriptor_description, new String[]{this.getOldMethodSignature(), this.getNewMethodSignature()});
                JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
                if (!this.fMethod.getElementName().equals(this.fMethodName)) {
                    jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_new_name_pattern, this.fMethodName));
                }
                if (!this.isVisibilitySameAsInitial()) {
                    object4 = JdtFlags.getVisibilityString(this.fVisibility);
                    if ("".equals(object4)) {
                        object4 = RefactoringCoreMessages.ChangeSignatureRefactoring_default_visibility;
                    }
                    jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_new_visibility_pattern, object4));
                }
                if (this.fReturnTypeInfo.isTypeNameChanged()) {
                    jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_new_return_type_pattern, this.fReturnTypeInfo.getNewTypeName()));
                }
                object4 = new ArrayList();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                Iterator iterator = this.fParameterInfos.iterator();
                while (iterator.hasNext()) {
                    object3 = (ParameterInfo)iterator.next();
                    if (((ParameterInfo)object3).isDeleted()) {
                        object4.add(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_deleted_parameter_pattern, new String[]{((ParameterInfo)object3).getOldTypeName(), ((ParameterInfo)object3).getOldName()}));
                        continue;
                    }
                    if (((ParameterInfo)object3).isAdded()) {
                        arrayList2.add(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_added_parameter_pattern, new String[]{((ParameterInfo)object3).getNewTypeName(), ((ParameterInfo)object3).getNewName()}));
                        continue;
                    }
                    if (!((ParameterInfo)object3).isRenamed() && !((ParameterInfo)object3).isTypeNameChanged() && !((ParameterInfo)object3).isVarargChanged()) continue;
                    arrayList3.add(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_changed_parameter_pattern, new String[]{((ParameterInfo)object3).getOldTypeName(), ((ParameterInfo)object3).getOldName()}));
                }
                if (!arrayList2.isEmpty()) {
                    jDTRefactoringDescriptorComment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_added_parameters, arrayList2.toArray(new String[arrayList2.size()])));
                }
                if (!object4.isEmpty()) {
                    jDTRefactoringDescriptorComment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_removed_parameters, object4.toArray(new String[object4.size()])));
                }
                if (!arrayList3.isEmpty()) {
                    jDTRefactoringDescriptorComment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_changed_parameters, arrayList3.toArray(new String[arrayList3.size()])));
                }
                arrayList2.clear();
                object4.clear();
                arrayList3.clear();
                iterator = this.fExceptionInfos.iterator();
                while (iterator.hasNext()) {
                    object3 = (ExceptionInfo)iterator.next();
                    if (((ExceptionInfo)object3).isAdded()) {
                        arrayList2.add(((ExceptionInfo)object3).getType().getElementName());
                        continue;
                    }
                    if (!((ExceptionInfo)object3).isDeleted()) continue;
                    object4.add(((ExceptionInfo)object3).getType().getElementName());
                }
                if (!arrayList2.isEmpty()) {
                    jDTRefactoringDescriptorComment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_added_exceptions, arrayList2.toArray(new String[arrayList2.size()])));
                }
                if (!object4.isEmpty()) {
                    jDTRefactoringDescriptorComment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ChangeSignatureRefactoring_removed_exceptions, object4.toArray(new String[object4.size()])));
                }
                object = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.change.method.signature", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, n);
                hashMap.put("input", ((JDTRefactoringDescriptor)((Object)object)).elementToHandle((IJavaElement)this.fMethod));
                hashMap.put("name", this.fMethodName);
                hashMap.put(ATTRIBUTE_DELEGATE, Boolean.valueOf(this.fDelegateUpdating).toString());
                hashMap.put(ATTRIBUTE_DEPRECATE, Boolean.valueOf(this.fDelegateDeprecation).toString());
                if (this.fReturnTypeInfo.isTypeNameChanged()) {
                    hashMap.put(ATTRIBUTE_RETURN, this.fReturnTypeInfo.getNewTypeName());
                }
                try {
                    if (!this.isVisibilitySameAsInitial()) {
                        hashMap.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                }
                int n2 = 1;
                object3 = this.fParameterInfos.iterator();
                while (object3.hasNext()) {
                    object2 = (ParameterInfo)object3.next();
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append(((ParameterInfo)object2).getOldTypeName());
                    stringBuffer.append(" ");
                    stringBuffer.append(((ParameterInfo)object2).getOldName());
                    stringBuffer.append(" ");
                    stringBuffer.append(((ParameterInfo)object2).getOldIndex());
                    stringBuffer.append(" ");
                    stringBuffer.append(((ParameterInfo)object2).getNewTypeName());
                    stringBuffer.append(" ");
                    stringBuffer.append(((ParameterInfo)object2).getNewName());
                    stringBuffer.append(" ");
                    stringBuffer.append(((ParameterInfo)object2).isDeleted());
                    hashMap.put(ATTRIBUTE_PARAMETER + n2, stringBuffer.toString());
                    String string4 = ((ParameterInfo)object2).getDefaultValue();
                    if (string4 != null && !"".equals(string4)) {
                        hashMap.put(ATTRIBUTE_DEFAULT + n2, string4);
                    }
                    ++n2;
                }
                n2 = 1;
                object3 = this.fExceptionInfos.iterator();
                while (object3.hasNext()) {
                    object2 = (ExceptionInfo)object3.next();
                    hashMap.put("element" + n2, ((JDTRefactoringDescriptor)((Object)object)).elementToHandle((IJavaElement)((ExceptionInfo)object2).getType()));
                    hashMap.put(ATTRIBUTE_KIND + n2, new Integer(((ExceptionInfo)object2).getKind()).toString());
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                Object var20_24 = null;
                iProgressMonitor.done();
                this.clearManagers();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            iProgressMonitor.done();
            this.clearManagers();
            throw throwable;
        }
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)object, this.doGetRefactoringChangeName(), arrayList.toArray(new Change[arrayList.size()]));
        Object var20_25 = null;
        iProgressMonitor.done();
        this.clearManagers();
        return dynamicValidationRefactoringChange;
    }

    protected String doGetRefactoringChangeName() {
        return RefactoringCoreMessages.ChangeSignatureRefactoring_restructure_parameters;
    }

    private TextChangeManager createChangeManager(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_preview, 2);
        this.fChangeManager = new TextChangeManager();
        boolean bl = this.isNoArgConstructor();
        Map map = null;
        if (bl) {
            map = this.createNamedSubclassMapping((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        } else {
            iProgressMonitor.worked(1);
        }
        int n = 0;
        while (n < this.fOccurrences.length) {
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SearchResultGroup searchResultGroup = this.fOccurrences[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                Object object;
                CompilationUnitRewrite compilationUnitRewrite;
                if (iCompilationUnit.equals(this.getCu())) {
                    compilationUnitRewrite = this.fBaseCuRewrite;
                } else {
                    compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit);
                    compilationUnitRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new TightSourceRangeComputer());
                }
                ASTNode[] aSTNodeArray = ASTNodeSearchUtil.findNodes(searchResultGroup.getSearchResults(), compilationUnitRewrite.getRoot());
                ArrayList<OccurrenceUpdate> arrayList = new ArrayList<OccurrenceUpdate>();
                int n2 = 0;
                while (n2 < aSTNodeArray.length) {
                    object = this.createOccurrenceUpdate(aSTNodeArray[n2], compilationUnitRewrite, refactoringStatus);
                    if (object instanceof DeclarationUpdate) {
                        ((OccurrenceUpdate)object).updateNode();
                    } else {
                        arrayList.add((OccurrenceUpdate)object);
                    }
                    ++n2;
                }
                Object object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    ((OccurrenceUpdate)object2.next()).updateNode();
                }
                if (bl && map.containsKey(iCompilationUnit)) {
                    object2 = (Set)map.get(iCompilationUnit);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        IType iType = (IType)object.next();
                        AbstractTypeDeclaration abstractTypeDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, compilationUnitRewrite.getRoot());
                        if (abstractTypeDeclaration == null) continue;
                        this.modifyImplicitCallsToNoArgConstructor(abstractTypeDeclaration, compilationUnitRewrite);
                    }
                }
                if ((object2 = compilationUnitRewrite.createChange()) != null) {
                    this.fChangeManager.manage(iCompilationUnit, (TextChange)object2);
                }
            }
            ++n;
        }
        iProgressMonitor.done();
        return this.fChangeManager;
    }

    private Map createNamedSubclassMapping(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType[] iTypeArray = this.getCachedTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)).getSubclasses(this.fMethod.getDeclaringType());
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            if (!iType.isAnonymous()) {
                ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
                if (!hashMap.containsKey(iCompilationUnit)) {
                    hashMap.put(iCompilationUnit, new HashSet());
                }
                ((Set)hashMap.get(iCompilationUnit)).add(iType);
            }
            ++n;
        }
        return hashMap;
    }

    private void modifyImplicitCallsToNoArgConstructor(AbstractTypeDeclaration abstractTypeDeclaration, CompilationUnitRewrite compilationUnitRewrite) {
        MethodDeclaration[] methodDeclarationArray = this.getAllConstructors(abstractTypeDeclaration);
        if (methodDeclarationArray.length == 0) {
            this.addNewConstructorToSubclass(abstractTypeDeclaration, compilationUnitRewrite);
        } else {
            int n = 0;
            while (n < methodDeclarationArray.length) {
                if (ChangeSignatureRefactoring.containsImplicitCallToSuperConstructor(methodDeclarationArray[n])) {
                    this.addExplicitSuperConstructorCall(methodDeclarationArray[n], compilationUnitRewrite);
                }
                ++n;
            }
        }
    }

    private void addExplicitSuperConstructorCall(MethodDeclaration methodDeclaration, CompilationUnitRewrite compilationUnitRewrite) {
        SuperConstructorInvocation superConstructorInvocation = methodDeclaration.getAST().newSuperConstructorInvocation();
        this.addArgumentsToNewSuperConstructorCall(superConstructorInvocation, compilationUnitRewrite);
        String string = RefactoringCoreMessages.ChangeSignatureRefactoring_add_super_call;
        TextEditGroup textEditGroup = compilationUnitRewrite.createGroupDescription(string);
        compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)methodDeclaration.getBody(), Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)superConstructorInvocation, textEditGroup);
    }

    private void addArgumentsToNewSuperConstructorCall(SuperConstructorInvocation superConstructorInvocation, CompilationUnitRewrite compilationUnitRewrite) {
        int n = 0;
        Iterator iterator = this.getNotDeletedInfos().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            List list = this.getParameterInfos();
            List list2 = superConstructorInvocation.arguments();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((expression = this.createNewExpression(parameterInfo, list, list2, compilationUnitRewrite, (MethodDeclaration)ASTNodes.getParent((ASTNode)superConstructorInvocation, clazz))) != null) {
                superConstructorInvocation.arguments().add(expression);
            }
            ++n;
        }
    }

    private static boolean containsImplicitCallToSuperConstructor(MethodDeclaration methodDeclaration) {
        Assert.isTrue((boolean)methodDeclaration.isConstructor());
        Block block = methodDeclaration.getBody();
        if (block == null) {
            return false;
        }
        if (block.statements().size() == 0) {
            return true;
        }
        if (block.statements().get(0) instanceof ConstructorInvocation) {
            return false;
        }
        return !(block.statements().get(0) instanceof SuperConstructorInvocation);
    }

    private void addNewConstructorToSubclass(AbstractTypeDeclaration abstractTypeDeclaration, CompilationUnitRewrite compilationUnitRewrite) {
        AST aST = abstractTypeDeclaration.getAST();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setName(aST.newSimpleName(abstractTypeDeclaration.getName().getIdentifier()));
        methodDeclaration.setConstructor(true);
        methodDeclaration.setExtraDimensions(0);
        methodDeclaration.setJavadoc(null);
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, ChangeSignatureRefactoring.getAccessModifier(abstractTypeDeclaration)));
        methodDeclaration.setReturnType2((Type)aST.newPrimitiveType(PrimitiveType.VOID));
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        SuperConstructorInvocation superConstructorInvocation = aST.newSuperConstructorInvocation();
        this.addArgumentsToNewSuperConstructorCall(superConstructorInvocation, compilationUnitRewrite);
        block.statements().add(superConstructorInvocation);
        String string = RefactoringCoreMessages.ChangeSignatureRefactoring_add_constructor;
        TextEditGroup textEditGroup = compilationUnitRewrite.createGroupDescription(string);
        compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)methodDeclaration, textEditGroup);
    }

    private static int getAccessModifier(AbstractTypeDeclaration abstractTypeDeclaration) {
        int n = abstractTypeDeclaration.getModifiers();
        if (Modifier.isPublic((int)n)) {
            return 1;
        }
        if (Modifier.isProtected((int)n)) {
            return 4;
        }
        if (Modifier.isPrivate((int)n)) {
            return 2;
        }
        return 0;
    }

    private MethodDeclaration[] getAllConstructors(AbstractTypeDeclaration abstractTypeDeclaration) {
        ArrayList<BodyDeclaration> arrayList = new ArrayList<BodyDeclaration>(1);
        ListIterator listIterator = abstractTypeDeclaration.bodyDeclarations().listIterator();
        while (listIterator.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)listIterator.next();
            if (!(bodyDeclaration instanceof MethodDeclaration) || !((MethodDeclaration)bodyDeclaration).isConstructor()) continue;
            arrayList.add(bodyDeclaration);
        }
        return arrayList.toArray(new MethodDeclaration[arrayList.size()]);
    }

    private boolean isNoArgConstructor() throws JavaModelException {
        return this.fMethod.isConstructor() && this.fMethod.getNumberOfParameters() == 0;
    }

    private Expression createNewExpression(ParameterInfo parameterInfo, List list, List list2, CompilationUnitRewrite compilationUnitRewrite, MethodDeclaration methodDeclaration) {
        if (parameterInfo.isNewVarargs() && parameterInfo.getDefaultValue().trim().length() == 0) {
            return null;
        }
        if (this.fDefaultValueAdvisor == null) {
            return (Expression)compilationUnitRewrite.getASTRewrite().createStringPlaceholder(parameterInfo.getDefaultValue(), 32);
        }
        return this.fDefaultValueAdvisor.createDefaultExpression(list2, parameterInfo, list, methodDeclaration, false, compilationUnitRewrite);
    }

    private boolean isVisibilitySameAsInitial() throws JavaModelException {
        return this.fVisibility == JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fMethod);
    }

    private SearchResultGroup[] findOccurrences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        if (this.fMethod.isConstructor()) {
            return ConstructorReferenceFinder.getConstructorOccurrences(this.fMethod, iProgressMonitor, refactoringStatus);
        }
        SearchPattern searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])this.fRippleMethods, 3);
        return RefactoringSearchEngine.search(searchPattern, this.createRefactoringScope(), iProgressMonitor, refactoringStatus);
    }

    private static String createDeclarationString(ParameterInfo parameterInfo) {
        String string = parameterInfo.getNewTypeName();
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return String.valueOf(string) + " " + parameterInfo.getNewName();
    }

    private OccurrenceUpdate createOccurrenceUpdate(ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite, RefactoringStatus refactoringStatus) {
        if (aSTNode instanceof SimpleName && aSTNode.getParent() instanceof EnumConstantDeclaration) {
            aSTNode = aSTNode.getParent();
        }
        if (ChangeSignatureRefactoring.isReferenceNode(aSTNode)) {
            return new ReferenceUpdate(aSTNode, compilationUnitRewrite, refactoringStatus);
        }
        if (aSTNode instanceof SimpleName && aSTNode.getParent() instanceof MethodDeclaration) {
            return new DeclarationUpdate((MethodDeclaration)aSTNode.getParent(), compilationUnitRewrite, refactoringStatus);
        }
        if (aSTNode instanceof MemberRef || aSTNode instanceof MethodRef) {
            return new DocReferenceUpdate(aSTNode, compilationUnitRewrite, refactoringStatus);
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ASTNodes.getParent(aSTNode, clazz) != null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ImportDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new StaticImportUpdate((ImportDeclaration)ASTNodes.getParent(aSTNode, clazz2), compilationUnitRewrite, refactoringStatus);
        }
        return new NullOccurrenceUpdate(aSTNode, compilationUnitRewrite, refactoringStatus);
    }

    private static boolean isReferenceNode(ASTNode aSTNode) {
        switch (aSTNode.getNodeType()) {
            case 14: 
            case 17: 
            case 32: 
            case 46: 
            case 48: 
            case 72: {
                return true;
            }
        }
        return false;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            String string2;
            Object object;
            int n;
            String string3;
            Object object2;
            Object object3;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string4 = javaRefactoringArguments.getAttribute("input");
            if (string4 != null) {
                object3 = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string4, false);
                if (object3 == null || !object3.exists() || object3.getElementType() != 9) {
                    return this.createInputFatalStatus(object3, "org.eclipse.wst.jsdt.ui.change.method.signature");
                }
                this.fMethod = (IMethod)object3;
                this.fMethodName = this.fMethod.getElementName();
                try {
                    this.fVisibility = JdtFlags.getVisibilityCode((IMember)this.fMethod);
                    this.fReturnTypeInfo = new ReturnTypeInfo(Signature.toString((String)Signature.getReturnType((String)this.fMethod.getSignature())));
                }
                catch (JavaModelException javaModelException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_VISIBILITY));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            object3 = javaRefactoringArguments.getAttribute("name");
            if (object3 != null) {
                this.fMethodName = object3;
                object2 = Checks.checkMethodName(this.fMethodName);
                if (object2.hasError()) {
                    return object2;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            object2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_RETURN);
            if (object2 != null && !"".equals(object2)) {
                this.fReturnTypeInfo = new ReturnTypeInfo((String)object2);
            }
            if ((string3 = javaRefactoringArguments.getAttribute(ATTRIBUTE_VISIBILITY)) != null && !"".equals(string3)) {
                n = 0;
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = n;
            }
            n = 1;
            String string5 = ATTRIBUTE_PARAMETER + n;
            String string6 = null;
            this.fParameterInfos = new ArrayList(3);
            while ((string6 = javaRefactoringArguments.getAttribute(string5)) != null) {
                object = new StringTokenizer(string6);
                if (((StringTokenizer)object).countTokens() < 6) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_PARAMETER));
                }
                string = ((StringTokenizer)object).nextToken();
                string2 = ((StringTokenizer)object).nextToken();
                String string7 = ((StringTokenizer)object).nextToken();
                String string8 = ((StringTokenizer)object).nextToken();
                String string9 = ((StringTokenizer)object).nextToken();
                String string10 = ((StringTokenizer)object).nextToken();
                ParameterInfo parameterInfo = null;
                try {
                    parameterInfo = new ParameterInfo(string, string2, Integer.valueOf(string7));
                    parameterInfo.setNewTypeName(string8);
                    parameterInfo.setNewName(string9);
                    if (Boolean.valueOf(string10).booleanValue()) {
                        parameterInfo.markAsDeleted();
                    }
                    this.fParameterInfos.add(parameterInfo);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_PARAMETER));
                }
                String string11 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DEFAULT + n);
                if (string11 != null && !"".equals(string11)) {
                    parameterInfo.setDefaultValue(string11);
                }
                string5 = ATTRIBUTE_PARAMETER + ++n;
            }
            n = 1;
            this.fExceptionInfos = new ArrayList(2);
            string5 = "element" + n;
            while ((string6 = javaRefactoringArguments.getAttribute(string5)) != null) {
                object = null;
                string = javaRefactoringArguments.getAttribute(ATTRIBUTE_KIND + n);
                if (string != null) {
                    string2 = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string6, false);
                    if (string2 == null || !string2.exists()) {
                        return this.createInputFatalStatus(string2, "org.eclipse.wst.jsdt.ui.change.method.signature");
                    }
                    try {
                        object = new ExceptionInfo((IType)string2, Integer.valueOf(string), null);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_KIND));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, ATTRIBUTE_KIND));
                }
                this.fExceptionInfos.add(object);
                string5 = "element" + ++n;
            }
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_DEPRECATE);
            if (object == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
            }
            this.fDelegateDeprecation = Boolean.valueOf((String)object);
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_DELEGATE);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELEGATE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDelegateUpdating = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    protected ASTNode moveNode(ASTNode aSTNode, ASTRewrite aSTRewrite) {
        ASTNode aSTNode2 = ASTNodes.isExistingNode(aSTNode) ? aSTRewrite.createMoveTarget(aSTNode) : ASTNode.copySubtree((AST)aSTRewrite.getAST(), (ASTNode)aSTNode);
        return aSTNode2;
    }

    public String getDelegateUpdatingTitle(boolean bl) {
        if (bl) {
            return RefactoringCoreMessages.DelegateCreator_keep_original_changed_plural;
        }
        return RefactoringCoreMessages.DelegateCreator_keep_original_changed_singular;
    }

    public IDefaultValueAdvisor getDefaultValueAdvisor() {
        return this.fDefaultValueAdvisor;
    }

    public void setDefaultValueAdvisor(IDefaultValueAdvisor iDefaultValueAdvisor) {
        this.fDefaultValueAdvisor = iDefaultValueAdvisor;
    }

    class DeclarationUpdate
    extends OccurrenceUpdate {
        private MethodDeclaration fMethDecl;

        protected DeclarationUpdate(MethodDeclaration methodDeclaration, CompilationUnitRewrite compilationUnitRewrite, RefactoringStatus refactoringStatus) {
            super(compilationUnitRewrite, compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.ChangeSignatureRefactoring_change_signature), refactoringStatus);
            this.fMethDecl = methodDeclaration;
        }

        protected void registerImportRemoveNode(ASTNode aSTNode) {
            if (!ChangeSignatureRefactoring.this.fDelegateUpdating) {
                super.registerImportRemoveNode(aSTNode);
            }
        }

        public void updateNode() throws CoreException {
            this.changeParamguments();
            if (ChangeSignatureRefactoring.this.canChangeNameAndReturnType()) {
                this.changeMethodName();
                this.changeReturnType();
            }
            if (this.needsVisibilityUpdate()) {
                this.changeVisibility();
            }
            this.reshuffleElements();
            this.changeExceptions();
            this.changeJavadocTags();
            if (ChangeSignatureRefactoring.this.fBodyUpdater == null || ChangeSignatureRefactoring.this.fBodyUpdater.needsParameterUsedCheck()) {
                this.checkIfDeletedParametersUsed();
            }
            if (ChangeSignatureRefactoring.this.fBodyUpdater != null) {
                ChangeSignatureRefactoring.this.fBodyUpdater.updateBody(this.fMethDecl, this.fCuRewrite, this.fResult);
            }
            if (ChangeSignatureRefactoring.this.fDelegateUpdating) {
                this.addDelegate();
            }
        }

        private void addDelegate() throws JavaModelException {
            DelegateMethodCreator delegateMethodCreator = new DelegateMethodCreator();
            delegateMethodCreator.setDeclaration((BodyDeclaration)this.fMethDecl);
            delegateMethodCreator.setDeclareDeprecated(ChangeSignatureRefactoring.this.fDelegateDeprecation);
            delegateMethodCreator.setSourceRewrite(this.fCuRewrite);
            delegateMethodCreator.prepareDelegate();
            ASTNode aSTNode = delegateMethodCreator.getDelegateInvocation();
            if (aSTNode != null) {
                new ReferenceUpdate(aSTNode, delegateMethodCreator.getDelegateRewrite(), this.fResult).updateNode();
            }
            new DocReferenceUpdate((ASTNode)delegateMethodCreator.getJavadocReference(), delegateMethodCreator.getDelegateRewrite(), this.fResult).updateNode();
            delegateMethodCreator.createEdit();
        }

        protected ListRewrite getParamgumentsRewrite() {
            return this.getASTRewrite().getListRewrite((ASTNode)this.fMethDecl, MethodDeclaration.PARAMETERS_PROPERTY);
        }

        protected void changeParamgumentName(ParameterInfo parameterInfo) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this.fMethDecl.parameters().get(parameterInfo.getOldIndex());
            if (!parameterInfo.getOldName().equals(singleVariableDeclaration.getName().getIdentifier())) {
                return;
            }
            String string = RefactoringCoreMessages.ChangeSignatureRefactoring_update_parameter_references;
            TextEditGroup textEditGroup = this.fCuRewrite.createGroupDescription(string);
            TempOccurrenceAnalyzer tempOccurrenceAnalyzer = new TempOccurrenceAnalyzer((VariableDeclaration)singleVariableDeclaration, false);
            tempOccurrenceAnalyzer.perform();
            SimpleName[] simpleNameArray = tempOccurrenceAnalyzer.getReferenceAndDeclarationNodes();
            int n = 0;
            while (n < simpleNameArray.length) {
                SimpleName simpleName = simpleNameArray[n];
                this.getASTRewrite().set((ASTNode)simpleName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)parameterInfo.getNewName(), textEditGroup);
                ++n;
            }
        }

        protected void changeParamgumentType(ParameterInfo parameterInfo) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this.fMethDecl.parameters().get(parameterInfo.getOldIndex());
            this.getASTRewrite().set((ASTNode)singleVariableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.VARARGS_PROPERTY, (Object)parameterInfo.isNewVarargs(), this.fDescription);
            this.replaceTypeNode(singleVariableDeclaration.getType(), ParameterInfo.stripEllipsis(parameterInfo.getNewTypeName()), parameterInfo.getNewTypeBinding());
            this.removeExtraDimensions(singleVariableDeclaration);
        }

        private void removeExtraDimensions(SingleVariableDeclaration singleVariableDeclaration) {
            if (singleVariableDeclaration.getExtraDimensions() != 0) {
                this.getASTRewrite().set((ASTNode)singleVariableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), this.fDescription);
            }
        }

        private void changeReturnType() throws JavaModelException {
            if (ChangeSignatureRefactoring.this.isReturnTypeSameAsInitial()) {
                return;
            }
            this.replaceTypeNode(this.fMethDecl.getReturnType2(), ChangeSignatureRefactoring.this.fReturnTypeInfo.getNewTypeName(), ChangeSignatureRefactoring.this.fReturnTypeInfo.getNewTypeBinding());
            this.removeExtraDimensions(this.fMethDecl);
        }

        private void removeExtraDimensions(MethodDeclaration methodDeclaration) {
            if (methodDeclaration.getExtraDimensions() != 0) {
                this.getASTRewrite().set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), this.fDescription);
            }
        }

        private boolean needsVisibilityUpdate() throws JavaModelException {
            if (ChangeSignatureRefactoring.this.isVisibilitySameAsInitial()) {
                return false;
            }
            if (this.isIncreasingVisibility()) {
                return JdtFlags.isHigherVisibility(ChangeSignatureRefactoring.this.fVisibility, JdtFlags.getVisibilityCode((BodyDeclaration)this.fMethDecl));
            }
            return JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((BodyDeclaration)this.fMethDecl), ChangeSignatureRefactoring.this.fVisibility);
        }

        private boolean isIncreasingVisibility() throws JavaModelException {
            return JdtFlags.isHigherVisibility(ChangeSignatureRefactoring.this.fVisibility, JdtFlags.getVisibilityCode((IMember)ChangeSignatureRefactoring.this.fMethod));
        }

        private void changeVisibility() {
            ModifierRewrite.create(this.getASTRewrite(), (ASTNode)this.fMethDecl).setVisibility(ChangeSignatureRefactoring.this.fVisibility, this.fDescription);
        }

        private void changeExceptions() {
            Iterator iterator = ChangeSignatureRefactoring.this.fExceptionInfos.iterator();
            while (iterator.hasNext()) {
                ExceptionInfo exceptionInfo = (ExceptionInfo)iterator.next();
                if (exceptionInfo.isOld()) continue;
                if (exceptionInfo.isDeleted()) {
                    this.removeExceptionFromNodeList(exceptionInfo, this.fMethDecl.thrownExceptions());
                    continue;
                }
                this.addExceptionToNodeList(exceptionInfo, this.getASTRewrite().getListRewrite((ASTNode)this.fMethDecl, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY));
            }
        }

        private void removeExceptionFromNodeList(ExceptionInfo exceptionInfo, List list) {
            ITypeBinding iTypeBinding = exceptionInfo.getTypeBinding();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Name name = (Name)iterator.next();
                ITypeBinding iTypeBinding2 = name.resolveTypeBinding();
                if (iTypeBinding2 == null || !Bindings.equals((IBinding)iTypeBinding2, (IBinding)iTypeBinding) && !exceptionInfo.getType().getElementName().equals(iTypeBinding2.getName())) continue;
                this.getASTRewrite().remove((ASTNode)name, this.fDescription);
                this.registerImportRemoveNode((ASTNode)name);
            }
        }

        private void addExceptionToNodeList(ExceptionInfo exceptionInfo, ListRewrite listRewrite) {
            Name name;
            String string = JavaModelUtil.getFullyQualifiedName(exceptionInfo.getType());
            Object object = listRewrite.getOriginalList().iterator();
            while (object.hasNext()) {
                name = (Name)object.next();
                ITypeBinding iTypeBinding = name.resolveTypeBinding();
                if (iTypeBinding == null || !iTypeBinding.getQualifiedName().equals(string)) continue;
                return;
            }
            object = this.getImportRewrite().addImport(JavaModelUtil.getFullyQualifiedName(exceptionInfo.getType()));
            this.getImportRemover().registerAddedImport((String)object);
            name = this.getASTRewrite().createStringPlaceholder((String)object, 42);
            listRewrite.insertLast((ASTNode)name, this.fDescription);
        }

        private void changeJavadocTags() throws JavaModelException {
            SimpleName simpleName;
            ParameterInfo parameterInfo;
            Object object;
            Name name;
            Object object2;
            TagElement tagElement;
            Javadoc javadoc = this.fMethDecl.getJavadoc();
            if (javadoc == null) {
                return;
            }
            ITypeBinding iTypeBinding = Bindings.getBindingOfParentType((ASTNode)this.fMethDecl);
            if (iTypeBinding == null) {
                return;
            }
            IMethodBinding iMethodBinding = this.fMethDecl.resolveBinding();
            if (iMethodBinding == null) {
                return;
            }
            boolean bl = Bindings.findOverriddenMethod(iMethodBinding, false) == null;
            List list = javadoc.tags();
            ListRewrite listRewrite = this.getASTRewrite().getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            if (!ChangeSignatureRefactoring.this.isReturnTypeSameAsInitial()) {
                if (PrimitiveType.VOID.toString().equals(ChangeSignatureRefactoring.this.fReturnTypeInfo.getNewTypeName())) {
                    int n = 0;
                    while (n < list.size()) {
                        tagElement = (TagElement)list.get(n);
                        if ("@return".equals(tagElement.getTagName())) {
                            this.getASTRewrite().remove((ASTNode)tagElement, this.fDescription);
                            this.registerImportRemoveNode((ASTNode)tagElement);
                        }
                        ++n;
                    }
                } else if (bl && "V".equals(ChangeSignatureRefactoring.this.fMethod.getReturnType())) {
                    TagElement tagElement2 = this.createReturnTag();
                    tagElement = this.findTagElementToInsertAfter(list, "@return");
                    this.insertTag(tagElement2, tagElement, listRewrite);
                    list = listRewrite.getRewrittenList();
                }
            }
            if (!ChangeSignatureRefactoring.this.areNamesSameAsInitial() || !ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                Object object3;
                Iterator iterator;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                tagElement = list.iterator();
                while (tagElement.hasNext()) {
                    object2 = (TagElement)tagElement.next();
                    iterator = object2.getTagName();
                    name = object2.fragments();
                    if (!"@param".equals(iterator) || name.size() <= 0 || !(name.get(0) instanceof SimpleName)) continue;
                    object3 = (SimpleName)name.get(0);
                    object = object3.getIdentifier();
                    boolean bl2 = false;
                    int n = 0;
                    while (n < ChangeSignatureRefactoring.this.fParameterInfos.size()) {
                        parameterInfo = (ParameterInfo)ChangeSignatureRefactoring.this.fParameterInfos.get(n);
                        if (((String)object).equals(parameterInfo.getOldName())) {
                            if (parameterInfo.isDeleted()) {
                                this.getASTRewrite().remove((ASTNode)object2, this.fDescription);
                                this.registerImportRemoveNode((ASTNode)object2);
                                bl2 = true;
                                break;
                            }
                            if (!parameterInfo.isRenamed()) break;
                            simpleName = object3.getAST().newSimpleName(parameterInfo.getNewName());
                            this.getASTRewrite().replace((ASTNode)object3, (ASTNode)simpleName, this.fDescription);
                            this.registerImportRemoveNode((ASTNode)object2);
                            break;
                        }
                        ++n;
                    }
                    if (bl2) continue;
                    arrayList.add(object2);
                }
                list = listRewrite.getRewrittenList();
                if (!ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                    tagElement = this.findTagElementToInsertAfter(list, "@param");
                    boolean bl3 = true;
                    iterator = ChangeSignatureRefactoring.this.fParameterInfos.iterator();
                    while (iterator.hasNext()) {
                        name = (ParameterInfo)iterator.next();
                        object3 = name.getOldName();
                        object = name.getNewName();
                        if (name.isAdded()) {
                            bl3 = false;
                            if (!bl) continue;
                            TagElement tagElement3 = JavadocUtil.createParamTag((String)object, this.fCuRewrite.getRoot().getAST(), this.fCuRewrite.getCu().getJavaProject());
                            this.insertTag(tagElement3, tagElement, listRewrite);
                            tagElement = tagElement3;
                            continue;
                        }
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            TagElement tagElement4 = (TagElement)iterator2.next();
                            parameterInfo = (SimpleName)tagElement4.fragments().get(0);
                            if (((String)object3).equals(parameterInfo.getIdentifier())) {
                                iterator2.remove();
                                if (bl3) {
                                    tagElement = tagElement4;
                                } else {
                                    simpleName = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tagElement4);
                                    this.getASTRewrite().remove((ASTNode)tagElement4, this.fDescription);
                                    this.insertTag((TagElement)simpleName, tagElement, listRewrite);
                                    tagElement = simpleName;
                                }
                            }
                            bl3 = false;
                        }
                    }
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        name = (TagElement)iterator.next();
                        object3 = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)name);
                        this.getASTRewrite().remove((ASTNode)name, this.fDescription);
                        this.insertTag((TagElement)object3, tagElement, listRewrite);
                        tagElement = object3;
                    }
                }
                list = listRewrite.getRewrittenList();
            }
            if (!ChangeSignatureRefactoring.this.areExceptionsSameAsInitial()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n = 0;
                while (n < list.size()) {
                    object2 = (TagElement)list.get(n);
                    if (("@throws".equals(object2.getTagName()) || "@exception".equals(object2.getTagName())) && object2.fragments().size() > 0 && object2.fragments().get(0) instanceof Name) {
                        boolean bl4 = false;
                        name = (Name)object2.fragments().get(0);
                        int n2 = 0;
                        while (n2 < ChangeSignatureRefactoring.this.fExceptionInfos.size()) {
                            object = (ExceptionInfo)ChangeSignatureRefactoring.this.fExceptionInfos.get(n2);
                            if (((ExceptionInfo)object).isDeleted()) {
                                boolean bl5 = false;
                                ITypeBinding iTypeBinding2 = name.resolveTypeBinding();
                                if (iTypeBinding2 != null) {
                                    parameterInfo = ((ExceptionInfo)object).getTypeBinding();
                                    if (parameterInfo != null && Bindings.equals((IBinding)parameterInfo, (IBinding)iTypeBinding2)) {
                                        bl5 = true;
                                    } else if (((ExceptionInfo)object).getType().getElementName().equals(iTypeBinding2.getName())) {
                                        bl5 = true;
                                    }
                                    if (bl5) {
                                        this.getASTRewrite().remove((ASTNode)object2, this.fDescription);
                                        this.registerImportRemoveNode((ASTNode)object2);
                                        bl4 = true;
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (!bl4) {
                            arrayList.add(object2);
                        }
                    }
                    ++n;
                }
                list = listRewrite.getRewrittenList();
                TagElement tagElement5 = this.findTagElementToInsertAfter(list, "@throws");
                object2 = ChangeSignatureRefactoring.this.fExceptionInfos.iterator();
                while (object2.hasNext()) {
                    ExceptionInfo exceptionInfo = (ExceptionInfo)object2.next();
                    if (exceptionInfo.isAdded()) {
                        if (!bl) continue;
                        name = this.createExceptionTag(exceptionInfo.getType().getElementName());
                        this.insertTag((TagElement)name, tagElement5, listRewrite);
                        tagElement5 = name;
                        continue;
                    }
                    name = arrayList.iterator();
                    while (name.hasNext()) {
                        TagElement tagElement6 = (TagElement)name.next();
                        object = (Name)tagElement6.fragments().get(0);
                        ITypeBinding iTypeBinding3 = object.resolveTypeBinding();
                        if (iTypeBinding3 == null) continue;
                        boolean bl6 = false;
                        parameterInfo = exceptionInfo.getTypeBinding();
                        if (parameterInfo != null && Bindings.equals((IBinding)parameterInfo, (IBinding)iTypeBinding3)) {
                            bl6 = true;
                        } else if (exceptionInfo.getType().getElementName().equals(iTypeBinding3.getName())) {
                            bl6 = true;
                        }
                        if (!bl6) continue;
                        name.remove();
                        simpleName = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tagElement6);
                        this.getASTRewrite().remove((ASTNode)tagElement6, this.fDescription);
                        this.insertTag((TagElement)simpleName, tagElement5, listRewrite);
                        tagElement5 = simpleName;
                    }
                }
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    TagElement tagElement7 = (TagElement)object2.next();
                    name = (TagElement)this.getASTRewrite().createMoveTarget((ASTNode)tagElement7);
                    this.getASTRewrite().remove((ASTNode)tagElement7, this.fDescription);
                    this.insertTag((TagElement)name, tagElement5, listRewrite);
                    tagElement5 = name;
                }
            }
        }

        private TagElement createReturnTag() {
            TagElement tagElement = this.getASTRewrite().getAST().newTagElement();
            tagElement.setTagName("@return");
            TextElement textElement = this.getASTRewrite().getAST().newTextElement();
            String string = StubUtility.getTodoTaskTag(this.fCuRewrite.getCu().getJavaProject());
            if (string != null) {
                textElement.setText(string);
            }
            tagElement.fragments().add(textElement);
            return tagElement;
        }

        private TagElement createExceptionTag(String string) {
            TagElement tagElement = this.getASTRewrite().getAST().newTagElement();
            tagElement.setTagName("@throws");
            SimpleName simpleName = this.getASTRewrite().getAST().newSimpleName(string);
            tagElement.fragments().add(simpleName);
            TextElement textElement = this.getASTRewrite().getAST().newTextElement();
            String string2 = StubUtility.getTodoTaskTag(this.fCuRewrite.getCu().getJavaProject());
            if (string2 != null) {
                textElement.setText(string2);
            }
            tagElement.fragments().add(textElement);
            return tagElement;
        }

        private void insertTag(TagElement tagElement, TagElement tagElement2, ListRewrite listRewrite) {
            if (tagElement2 == null) {
                listRewrite.insertFirst((ASTNode)tagElement, this.fDescription);
            } else {
                listRewrite.insertAfter((ASTNode)tagElement, (ASTNode)tagElement2, this.fDescription);
            }
        }

        private TagElement findTagElementToInsertAfter(List list, String string) {
            List<String> list2 = Arrays.asList("@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated", "@value");
            int n = list2.indexOf(string);
            if (n == -1) {
                return list.size() == 0 ? null : (TagElement)list.get(list.size());
            }
            int n2 = 0;
            while (n2 < list.size()) {
                int n3 = list2.indexOf(((TagElement)list.get(n2)).getTagName());
                if (n3 >= n) {
                    return n2 == 0 ? null : (TagElement)list.get(n2 - 1);
                }
                ++n2;
            }
            return list.size() == 0 ? null : (TagElement)list.get(list.size() - 1);
        }

        private void checkIfDeletedParametersUsed() {
            Iterator iterator = ChangeSignatureRefactoring.this.getDeletedInfos().iterator();
            while (iterator.hasNext()) {
                ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this.fMethDecl.parameters().get(parameterInfo.getOldIndex());
                TempOccurrenceAnalyzer tempOccurrenceAnalyzer = new TempOccurrenceAnalyzer((VariableDeclaration)singleVariableDeclaration, false);
                tempOccurrenceAnalyzer.perform();
                SimpleName[] simpleNameArray = tempOccurrenceAnalyzer.getReferenceNodes();
                if (simpleNameArray.length <= 0) continue;
                RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)this.fCuRewrite.getCu(), (ASTNode)simpleNameArray[0]);
                String string = this.getFullTypeName(this.fMethDecl);
                Object[] objectArray = new String[]{singleVariableDeclaration.getName().getIdentifier(), this.fMethDecl.getName().getIdentifier(), string};
                String string2 = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_parameter_used, objectArray);
                this.fResult.addError(string2, refactoringStatusContext);
            }
        }

        private String getFullTypeName(MethodDeclaration methodDeclaration) {
            MethodDeclaration methodDeclaration2 = methodDeclaration;
            do {
                if ((methodDeclaration2 = methodDeclaration2.getParent()) instanceof AbstractTypeDeclaration) {
                    return ((AbstractTypeDeclaration)methodDeclaration2).getName().getIdentifier();
                }
                if (!(methodDeclaration2 instanceof ClassInstanceCreation)) continue;
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)methodDeclaration2;
                return Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_anonymous_subclass, new String[]{ASTNodes.asString((ASTNode)classInstanceCreation.getType())});
            } while (!(methodDeclaration2 instanceof EnumConstantDeclaration));
            EnumDeclaration enumDeclaration = (EnumDeclaration)methodDeclaration2.getParent();
            return Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_anonymous_subclass, new String[]{ASTNodes.asString((ASTNode)enumDeclaration.getName())});
        }

        protected ASTNode createNewParamgument(ParameterInfo parameterInfo, List list, List list2) {
            return this.createNewSingleVariableDeclaration(parameterInfo);
        }

        private SingleVariableDeclaration createNewSingleVariableDeclaration(ParameterInfo parameterInfo) {
            SingleVariableDeclaration singleVariableDeclaration = this.getASTRewrite().getAST().newSingleVariableDeclaration();
            singleVariableDeclaration.setName(this.getASTRewrite().getAST().newSimpleName(parameterInfo.getNewName()));
            singleVariableDeclaration.setType(this.createNewTypeNode(ParameterInfo.stripEllipsis(parameterInfo.getNewTypeName()), parameterInfo.getNewTypeBinding()));
            singleVariableDeclaration.setVarargs(parameterInfo.isNewVarargs());
            return singleVariableDeclaration;
        }

        protected SimpleName getMethodNameNode() {
            return this.fMethDecl.getName();
        }
    }

    class DocReferenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected DocReferenceUpdate(ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite, RefactoringStatus refactoringStatus) {
            super(compilationUnitRewrite, compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.ChangeSignatureRefactoring_update_javadoc_reference), refactoringStatus);
            this.fNode = aSTNode;
        }

        public void updateNode() {
            if (this.fNode instanceof MethodRef) {
                this.changeParamguments();
                this.reshuffleElements();
            }
            if (ChangeSignatureRefactoring.this.canChangeNameAndReturnType()) {
                this.changeMethodName();
            }
        }

        protected ASTNode createNewParamgument(ParameterInfo parameterInfo, List list, List list2) {
            return this.createNewMethodRefParameter(parameterInfo);
        }

        private MethodRefParameter createNewMethodRefParameter(ParameterInfo parameterInfo) {
            MethodRefParameter methodRefParameter = this.getASTRewrite().getAST().newMethodRefParameter();
            List list = this.getParamgumentsRewrite().getOriginalList();
            if (list.size() > 0 && ((MethodRefParameter)list.get(0)).getName() != null) {
                methodRefParameter.setName(this.getASTRewrite().getAST().newSimpleName(parameterInfo.getNewName()));
            }
            methodRefParameter.setType(this.createNewDocRefType(parameterInfo));
            methodRefParameter.setVarargs(parameterInfo.isNewVarargs());
            return methodRefParameter;
        }

        private Type createNewDocRefType(ParameterInfo parameterInfo) {
            String string = ParameterInfo.stripEllipsis(parameterInfo.getNewTypeName());
            ITypeBinding iTypeBinding = parameterInfo.getNewTypeBinding();
            if (iTypeBinding != null) {
                iTypeBinding = iTypeBinding.getErasure();
            }
            return this.createNewTypeNode(string, iTypeBinding);
        }

        protected SimpleName getMethodNameNode() {
            if (this.fNode instanceof MemberRef) {
                return ((MemberRef)this.fNode).getName();
            }
            if (this.fNode instanceof MethodRef) {
                return ((MethodRef)this.fNode).getName();
            }
            return null;
        }

        protected ListRewrite getParamgumentsRewrite() {
            return this.getASTRewrite().getListRewrite(this.fNode, MethodRef.PARAMETERS_PROPERTY);
        }

        protected void changeParamgumentName(ParameterInfo parameterInfo) {
            if (!(this.fNode instanceof MethodRef)) {
                return;
            }
            MethodRefParameter methodRefParameter = (MethodRefParameter)((MethodRef)this.fNode).parameters().get(parameterInfo.getOldIndex());
            SimpleName simpleName = methodRefParameter.getName();
            if (simpleName != null) {
                this.getASTRewrite().set((ASTNode)simpleName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)parameterInfo.getNewName(), this.fDescription);
            }
        }

        protected void changeParamgumentType(ParameterInfo parameterInfo) {
            if (!(this.fNode instanceof MethodRef)) {
                return;
            }
            MethodRefParameter methodRefParameter = (MethodRefParameter)((MethodRef)this.fNode).parameters().get(parameterInfo.getOldIndex());
            Type type = methodRefParameter.getType();
            Type type2 = this.createNewDocRefType(parameterInfo);
            if (parameterInfo.isNewVarargs()) {
                if (parameterInfo.isOldVarargs() && !methodRefParameter.isVarargs()) {
                    type2 = this.getASTRewrite().getAST().newArrayType(type2);
                } else {
                    this.getASTRewrite().set((ASTNode)methodRefParameter, (StructuralPropertyDescriptor)MethodRefParameter.VARARGS_PROPERTY, (Object)Boolean.TRUE, this.fDescription);
                }
            } else if (methodRefParameter.isVarargs()) {
                this.getASTRewrite().set((ASTNode)methodRefParameter, (StructuralPropertyDescriptor)MethodRefParameter.VARARGS_PROPERTY, (Object)Boolean.FALSE, this.fDescription);
            }
            this.getASTRewrite().replace((ASTNode)type, (ASTNode)type2, this.fDescription);
            this.registerImportRemoveNode((ASTNode)type);
        }
    }

    class NullOccurrenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected NullOccurrenceUpdate(ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite, RefactoringStatus refactoringStatus) {
            super(compilationUnitRewrite, null, refactoringStatus);
            this.fNode = aSTNode;
        }

        public void updateNode() throws JavaModelException {
            int n = this.fNode.getStartPosition();
            int n2 = this.fNode.getLength();
            String string = "Cannot update found node: nodeType=" + this.fNode.getNodeType() + "; " + this.fNode.toString() + "[" + n + ", " + n2 + "]";
            JavaPlugin.log(new Exception(String.valueOf(string) + ":\n" + this.fCuRewrite.getCu().getSource().substring(n, n + n2)));
            this.fResult.addError(string, JavaStatusContext.create((ITypeRoot)this.fCuRewrite.getCu(), this.fNode));
        }

        protected ListRewrite getParamgumentsRewrite() {
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo parameterInfo, List list, List list2) {
            return null;
        }

        protected SimpleName getMethodNameNode() {
            return null;
        }
    }

    abstract class OccurrenceUpdate {
        protected final CompilationUnitRewrite fCuRewrite;
        protected final TextEditGroup fDescription;
        protected RefactoringStatus fResult;

        protected OccurrenceUpdate(CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup, RefactoringStatus refactoringStatus) {
            this.fCuRewrite = compilationUnitRewrite;
            this.fDescription = textEditGroup;
            this.fResult = refactoringStatus;
        }

        protected final ASTRewrite getASTRewrite() {
            return this.fCuRewrite.getASTRewrite();
        }

        protected final ImportRewrite getImportRewrite() {
            return this.fCuRewrite.getImportRewrite();
        }

        protected final ImportRemover getImportRemover() {
            return this.fCuRewrite.getImportRemover();
        }

        protected final CompilationUnitRewrite getCompilationUnitRewrite() {
            return this.fCuRewrite;
        }

        public abstract void updateNode() throws CoreException;

        protected void registerImportRemoveNode(ASTNode aSTNode) {
            this.getImportRemover().registerRemovedNode(aSTNode);
        }

        protected final void reshuffleElements() {
            Object object;
            if (ChangeSignatureRefactoring.this.isOrderSameAsInitial()) {
                return;
            }
            ListRewrite listRewrite = this.getParamgumentsRewrite();
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            List list = listRewrite.getRewrittenList();
            Iterator iterator = list.iterator();
            List list2 = listRewrite.getOriginalList();
            Object object2 = list2.iterator();
            while (object2.hasNext()) {
                linkedHashMap.put(iterator.next(), object2.next());
            }
            object2 = new ArrayList();
            int n = 0;
            while (n < ChangeSignatureRefactoring.this.fParameterInfos.size()) {
                ASTNode aSTNode;
                object = (ParameterInfo)ChangeSignatureRefactoring.this.fParameterInfos.get(n);
                int n2 = ((ParameterInfo)object).getOldIndex();
                if (((ParameterInfo)object).isDeleted()) {
                    if (n2 != ChangeSignatureRefactoring.this.fOldVarargIndex) {
                        this.registerImportRemoveNode((ASTNode)list.get(n2));
                    } else {
                        int n3 = n2;
                        while (n3 < list.size()) {
                            this.registerImportRemoveNode((ASTNode)list.get(n3));
                            ++n3;
                        }
                    }
                } else if (((ParameterInfo)object).isAdded()) {
                    ASTNode aSTNode2 = this.createNewParamgument((ParameterInfo)object, ChangeSignatureRefactoring.this.fParameterInfos, list);
                    if (aSTNode2 != null) {
                        object2.add(aSTNode2);
                    }
                } else if (n2 != ChangeSignatureRefactoring.this.fOldVarargIndex) {
                    ASTNode aSTNode3 = (ASTNode)list.get(n2);
                    aSTNode = ChangeSignatureRefactoring.this.moveNode(aSTNode3, this.getASTRewrite());
                    object2.add(aSTNode);
                } else {
                    int n4 = n2;
                    while (n4 < list.size()) {
                        aSTNode = (ASTNode)list.get(n4);
                        ASTNode aSTNode4 = ChangeSignatureRefactoring.this.moveNode(aSTNode, this.getASTRewrite());
                        object2.add(aSTNode4);
                        ++n4;
                    }
                }
                ++n;
            }
            Iterator iterator2 = list.iterator();
            object = object2.iterator();
            while (iterator2.hasNext() && object.hasNext()) {
                ASTNode aSTNode = (ASTNode)iterator2.next();
                ASTNode aSTNode5 = (ASTNode)object.next();
                if (!ASTNodes.isExistingNode(aSTNode)) {
                    listRewrite.replace((ASTNode)linkedHashMap.get(aSTNode), aSTNode5, this.fDescription);
                    continue;
                }
                listRewrite.replace(aSTNode, aSTNode5, this.fDescription);
            }
            while (iterator2.hasNext()) {
                ASTNode aSTNode = (ASTNode)iterator2.next();
                if (!ASTNodes.isExistingNode(aSTNode)) {
                    listRewrite.remove((ASTNode)linkedHashMap.get(aSTNode), this.fDescription);
                    continue;
                }
                listRewrite.remove(aSTNode, this.fDescription);
            }
            while (object.hasNext()) {
                ASTNode aSTNode = (ASTNode)object.next();
                listRewrite.insertLast(aSTNode, this.fDescription);
            }
        }

        protected abstract ListRewrite getParamgumentsRewrite();

        protected final void changeParamguments() {
            Iterator iterator = ChangeSignatureRefactoring.this.getParameterInfos().iterator();
            while (iterator.hasNext()) {
                ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
                if (parameterInfo.isAdded() || parameterInfo.isDeleted()) continue;
                if (parameterInfo.isRenamed()) {
                    this.changeParamgumentName(parameterInfo);
                }
                if (!parameterInfo.isTypeNameChanged()) continue;
                this.changeParamgumentType(parameterInfo);
            }
        }

        protected void changeParamgumentName(ParameterInfo parameterInfo) {
        }

        protected void changeParamgumentType(ParameterInfo parameterInfo) {
        }

        protected final void replaceTypeNode(Type type, String string, ITypeBinding iTypeBinding) {
            Type type2 = this.createNewTypeNode(string, iTypeBinding);
            this.getASTRewrite().replace((ASTNode)type, (ASTNode)type2, this.fDescription);
            this.registerImportRemoveNode((ASTNode)type);
            this.getTightSourceRangeComputer().addTightSourceNode((ASTNode)type);
        }

        protected abstract ASTNode createNewParamgument(ParameterInfo var1, List var2, List var3);

        protected abstract SimpleName getMethodNameNode();

        protected final void changeMethodName() {
            if (!ChangeSignatureRefactoring.this.isMethodNameSameAsInitial()) {
                SimpleName simpleName = this.getMethodNameNode();
                SimpleName simpleName2 = simpleName.getAST().newSimpleName(ChangeSignatureRefactoring.this.fMethodName);
                this.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)simpleName2, this.fDescription);
                this.registerImportRemoveNode((ASTNode)simpleName);
                this.getTightSourceRangeComputer().addTightSourceNode((ASTNode)simpleName);
            }
        }

        protected final Type createNewTypeNode(String string, ITypeBinding iTypeBinding) {
            Type type;
            if (iTypeBinding == null) {
                type = ChangeSignatureRefactoring.this.fDefaultValueAdvisor != null ? ChangeSignatureRefactoring.this.fDefaultValueAdvisor.createType(string, this.getMethodNameNode().getStartPosition(), this.getCompilationUnitRewrite()) : (Type)this.getASTRewrite().createStringPlaceholder(string, 43);
            } else {
                type = this.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST());
                this.getImportRemover().registerAddedImports(type);
            }
            return type;
        }

        protected final TightSourceRangeComputer getTightSourceRangeComputer() {
            return (TightSourceRangeComputer)this.fCuRewrite.getASTRewrite().getExtendedSourceRangeComputer();
        }
    }

    class ReferenceUpdate
    extends OccurrenceUpdate {
        private ASTNode fNode;

        protected ReferenceUpdate(ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite, RefactoringStatus refactoringStatus) {
            super(compilationUnitRewrite, compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.ChangeSignatureRefactoring_update_reference), refactoringStatus);
            this.fNode = aSTNode;
        }

        public void updateNode() {
            this.reshuffleElements();
            this.changeMethodName();
        }

        protected ListRewrite getParamgumentsRewrite() {
            if (this.fNode instanceof MethodInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, MethodInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, SuperMethodInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof ClassInstanceCreation) {
                return this.getASTRewrite().getListRewrite(this.fNode, ClassInstanceCreation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof ConstructorInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, ConstructorInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof SuperConstructorInvocation) {
                return this.getASTRewrite().getListRewrite(this.fNode, SuperConstructorInvocation.ARGUMENTS_PROPERTY);
            }
            if (this.fNode instanceof EnumConstantDeclaration) {
                return this.getASTRewrite().getListRewrite(this.fNode, EnumConstantDeclaration.ARGUMENTS_PROPERTY);
            }
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo parameterInfo, List list, List list2) {
            CompilationUnitRewrite compilationUnitRewrite = this.getCompilationUnitRewrite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)ASTNodes.getParent(this.fNode, clazz);
            if (this.isRecursiveReference()) {
                return this.createNewExpressionRecursive(parameterInfo, list, list2, compilationUnitRewrite, methodDeclaration);
            }
            return ChangeSignatureRefactoring.this.createNewExpression(parameterInfo, list, list2, compilationUnitRewrite, methodDeclaration);
        }

        private Expression createNewExpressionRecursive(ParameterInfo parameterInfo, List list, List list2, CompilationUnitRewrite compilationUnitRewrite, MethodDeclaration methodDeclaration) {
            if (ChangeSignatureRefactoring.this.fDefaultValueAdvisor != null && parameterInfo.isAdded()) {
                return ChangeSignatureRefactoring.this.fDefaultValueAdvisor.createDefaultExpression(list2, parameterInfo, list, methodDeclaration, true, compilationUnitRewrite);
            }
            return (Expression)this.getASTRewrite().createStringPlaceholder(parameterInfo.getNewName(), 32);
        }

        protected SimpleName getMethodNameNode() {
            if (this.fNode instanceof MethodInvocation) {
                return ((MethodInvocation)this.fNode).getName();
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                return ((SuperMethodInvocation)this.fNode).getName();
            }
            return null;
        }

        private boolean isRecursiveReference() {
            MethodDeclaration methodDeclaration;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((methodDeclaration = (MethodDeclaration)ASTNodes.getParent(this.fNode, clazz)) == null) {
                return false;
            }
            IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
            if (iMethodBinding == null) {
                return false;
            }
            if (this.fNode instanceof MethodInvocation) {
                return iMethodBinding == ((MethodInvocation)this.fNode).resolveMethodBinding();
            }
            if (this.fNode instanceof SuperMethodInvocation) {
                IMethodBinding iMethodBinding2 = ((SuperMethodInvocation)this.fNode).resolveMethodBinding();
                return this.isSameMethod(iMethodBinding2, iMethodBinding);
            }
            if (this.fNode instanceof ClassInstanceCreation) {
                return iMethodBinding == ((ClassInstanceCreation)this.fNode).resolveConstructorBinding();
            }
            if (this.fNode instanceof ConstructorInvocation) {
                return iMethodBinding == ((ConstructorInvocation)this.fNode).resolveConstructorBinding();
            }
            if (this.fNode instanceof SuperConstructorInvocation) {
                return false;
            }
            if (this.fNode instanceof EnumConstantDeclaration) {
                return false;
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        private boolean isSameMethod(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
            ITypeBinding[] iTypeBindingArray;
            if (iMethodBinding.isConstructor() ? !iMethodBinding2.isConstructor() : !iMethodBinding.getName().equals(iMethodBinding2.getName())) {
                return false;
            }
            ITypeBinding[] iTypeBindingArray2 = iMethodBinding.getParameterTypes();
            if (iTypeBindingArray2.length != (iTypeBindingArray = iMethodBinding2.getParameterTypes()).length) {
                return false;
            }
            int n = 0;
            while (n < iTypeBindingArray2.length) {
                if (iTypeBindingArray2[n].getErasure() != iTypeBindingArray[n].getErasure()) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    class StaticImportUpdate
    extends OccurrenceUpdate {
        private final ImportDeclaration fImportDecl;

        public StaticImportUpdate(ImportDeclaration importDeclaration, CompilationUnitRewrite compilationUnitRewrite, RefactoringStatus refactoringStatus) {
            super(compilationUnitRewrite, null, refactoringStatus);
            this.fImportDecl = importDeclaration;
        }

        public void updateNode() throws JavaModelException {
            ImportRewrite importRewrite = this.fCuRewrite.getImportRewrite();
            QualifiedName qualifiedName = (QualifiedName)this.fImportDecl.getName();
            importRewrite.addStaticImport(qualifiedName.getQualifier().getFullyQualifiedName(), ChangeSignatureRefactoring.this.fMethodName, false);
        }

        protected ListRewrite getParamgumentsRewrite() {
            return null;
        }

        protected ASTNode createNewParamgument(ParameterInfo parameterInfo, List list, List list2) {
            return null;
        }

        protected SimpleName getMethodNameNode() {
            return null;
        }
    }
}

