/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.TypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ChangeTypeRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_TYPE = "type";
    private final Map fConstraintCache;
    private int fSelectionStart;
    private int fSelectionLength;
    private int fEffectiveSelectionStart;
    private int fEffectiveSelectionLength;
    private ICompilationUnit fCu;
    private IMethodBinding fMethodBinding;
    private int fParamIndex;
    private String fParamName;
    private IVariableBinding fFieldBinding;
    private ICompilationUnit[] fAffectedUnits;
    private Collection fRelevantVars;
    private final Collection fValidTypes;
    private Collection fRelevantConstraints;
    private Collection fAllConstraints;
    private String fSelectedTypeName;
    private ITypeBinding fSelectedType;
    private Map fCuToSearchResultGroup = new HashMap();
    private ITypeBinding fObject;
    private static final boolean DEBUG = false;
    private ConstraintVariable fCv;
    private IBinding fSelectionBinding;
    private ITypeBinding fSelectionTypeBinding;
    private ConstraintCollector fCollector;

    public ITypeBinding getObject() {
        return this.fObject;
    }

    public ChangeTypeRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        this(iCompilationUnit, n, n2, null);
    }

    public ChangeTypeRefactoring(ICompilationUnit iCompilationUnit, int n, int n2, String string) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fEffectiveSelectionStart = n;
        this.fEffectiveSelectionLength = n2;
        this.fCu = iCompilationUnit;
        if (string != null) {
            this.fSelectedTypeName = string;
        }
        this.fConstraintCache = new HashMap();
        this.fValidTypes = new HashSet();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fCu == null || !this.fCu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection);
        }
        return this.checkSelection((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
    }

    private void setSelectionRanges(Expression expression) {
        this.fEffectiveSelectionStart = expression.getStartPosition();
        this.fEffectiveSelectionLength = expression.getLength();
        this.fSelectionBinding = ExpressionVariable.resolveBinding(expression);
        this.setOriginalType(expression.resolveTypeBinding());
    }

    private RefactoringStatus checkSelection(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IMethod iMethod;
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            RefactoringStatus refactoringStatus;
                                            try {
                                                iProgressMonitor.beginTask("", 5);
                                                ASTNode aSTNode = this.getTargetNode(this.fCu, this.fSelectionStart, this.fSelectionLength);
                                                TypeConstraintFactory typeConstraintFactory = new TypeConstraintFactory(){

                                                    public boolean filter(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2, ConstraintOperator constraintOperator) {
                                                        if (constraintOperator.isStrictSubtypeOperator()) {
                                                            return true;
                                                        }
                                                        if (constraintVariable.getBinding() != null && constraintVariable2.getBinding() != null && !Bindings.equals((IBinding)constraintVariable.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding) && !Bindings.equals((IBinding)constraintVariable2.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding)) {
                                                            return true;
                                                        }
                                                        return super.filter(constraintVariable, constraintVariable2, constraintOperator);
                                                    }
                                                };
                                                this.fCollector = new ConstraintCollector(new FullConstraintCreator(new ConstraintVariableFactory(), typeConstraintFactory));
                                                String string = this.determineSelection(aSTNode);
                                                if (string == null) break block12;
                                                refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)string);
                                                Object var6_15 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var6_25 = null;
                                                iProgressMonitor.done();
                                                throw throwable;
                                            }
                                            iProgressMonitor.done();
                                            return refactoringStatus;
                                        }
                                        if (this.fMethodBinding == null || (iMethod = (IMethod)this.fMethodBinding.getJavaElement()) != null) break block13;
                                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                                        Object var6_16 = null;
                                        iProgressMonitor.done();
                                        return refactoringStatus;
                                    }
                                    iProgressMonitor.worked(1);
                                    iMethod = new RefactoringStatus();
                                    if (!this.fSelectionTypeBinding.isArray()) break block14;
                                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported);
                                    Object var6_17 = null;
                                    iProgressMonitor.done();
                                    return refactoringStatus;
                                }
                                if (!this.fSelectionTypeBinding.isPrimitive()) break block15;
                                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_primitivesNotSupported);
                                Object var6_18 = null;
                                iProgressMonitor.done();
                                return refactoringStatus;
                            }
                            if (!this.checkOverriddenBinaryMethods()) break block16;
                            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnBinary);
                            Object var6_19 = null;
                            iProgressMonitor.done();
                            return refactoringStatus;
                        }
                        if (!this.fSelectionTypeBinding.isLocal()) break block17;
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_localTypesNotSupported);
                        Object var6_20 = null;
                        iProgressMonitor.done();
                        return refactoringStatus;
                    }
                    if (this.fFieldBinding == null || !this.fFieldBinding.getDeclaringClass().isLocal()) break block18;
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                    Object var6_21 = null;
                    iProgressMonitor.done();
                    return refactoringStatus;
                }
                if (!this.fSelectionTypeBinding.isTypeVariable()) break block19;
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_typeParametersNotSupported);
                Object var6_22 = null;
                iProgressMonitor.done();
                return refactoringStatus;
            }
            if (!this.fSelectionTypeBinding.isEnum()) break block20;
            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_enumsNotSupported);
            Object var6_23 = null;
            iProgressMonitor.done();
            return refactoringStatus;
        }
        iProgressMonitor.worked(1);
        if (this.fSelectedType != null) {
            this.computeValidTypes((IProgressMonitor)new NullProgressMonitor());
        }
        IMethod iMethod2 = iMethod;
        Object var6_24 = null;
        iProgressMonitor.done();
        return iMethod2;
    }

    private boolean checkOverriddenBinaryMethods() throws JavaModelException {
        if (this.fMethodBinding != null) {
            Set set = ChangeTypeRefactoring.getDeclaringSuperTypes(this.fMethodBinding);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ITypeBinding iTypeBinding = (ITypeBinding)iterator.next();
                IMethodBinding iMethodBinding = ChangeTypeRefactoring.findMethod(this.fMethodBinding, iTypeBinding);
                Assert.isNotNull((Object)iMethodBinding);
                IMethod iMethod = (IMethod)iMethodBinding.getJavaElement();
                if (!iMethod.isBinary()) continue;
                return true;
            }
        }
        return false;
    }

    private static IMethodBinding findMethod(IMethodBinding iMethodBinding, ITypeBinding iTypeBinding) {
        if (iMethodBinding.getDeclaringClass().equals((Object)iTypeBinding)) {
            return iMethodBinding;
        }
        return Bindings.findOverriddenMethodInType(iTypeBinding, iMethodBinding);
    }

    private static Set getDeclaringSuperTypes(IMethodBinding iMethodBinding) {
        ITypeBinding[] iTypeBindingArray = Bindings.getAllSuperTypes(iMethodBinding.getDeclaringClass());
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            if (ChangeTypeRefactoring.findMethod(iMethodBinding, iTypeBinding) != null) {
                hashSet.add(iTypeBinding);
            }
            ++n;
        }
        return hashSet;
    }

    public Collection computeValidTypes(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 100);
        try {
            this.fCv = this.findConstraintVariableForSelectedNode((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantVars = this.findRelevantConstraintVars(this.fCv, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantConstraints = this.findRelevantConstraints(this.fRelevantVars, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 30));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fValidTypes.addAll(this.computeValidTypes(this.fSelectionTypeBinding, this.fRelevantVars, this.fRelevantConstraints, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20)));
        }
        catch (CoreException coreException) {
            JavaPlugin.logErrorMessage("Error occurred during computation of valid types: " + coreException.toString());
            this.fValidTypes.clear();
        }
        iProgressMonitor.done();
        return this.fValidTypes;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 1);
        RefactoringStatus refactoringStatus = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fAffectedUnits), this.getValidationContext());
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeMessages_CreateChangesForChangeType, 1);
        try {
            HashMap hashMap = new HashMap();
            this.groupChangesByCompilationUnit(hashMap);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            String string = null;
            IJavaProject iJavaProject = this.fCu.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            String string2 = RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description_short;
            String string3 = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel(this.fSelectionBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)this.fSelectedType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_element_pattern, BindingLabelProvider.getBindingLabel(this.fSelectionBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_type_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.getOriginalType(), JavaElementLabels.ALL_FULLY_QUALIFIED)));
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_refactored_type_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.fSelectedType, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.change.type", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap2, 786434);
            hashMap2.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCu));
            hashMap2.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            hashMap2.put(ATTRIBUTE_TYPE, this.fSelectedType.getQualifiedName());
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange2 = new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.ChangeTypeRefactoring_allChanges);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iterator.next();
                Set set = (Set)hashMap.get(iCompilationUnit);
                CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.getName(), iCompilationUnit);
                this.addAllChangesFor(iCompilationUnit, set, compilationUnitChange);
                dynamicValidationRefactoringChange2.add((Change)compilationUnitChange);
                iProgressMonitor.worked(1);
                if (!iProgressMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            dynamicValidationRefactoringChange = dynamicValidationRefactoringChange2;
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    private void addAllChangesFor(ICompilationUnit iCompilationUnit, Set set, CompilationUnitChange compilationUnitChange) throws CoreException {
        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, false);
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
        String string = this.updateImports(compilationUnit, multiTextEdit);
        this.updateCu(compilationUnit, set, compilationUnitChange, aSTRewrite, string);
        multiTextEdit.addChild(aSTRewrite.rewriteAST());
    }

    private void updateCu(CompilationUnit compilationUnit, Set set, CompilationUnitChange compilationUnitChange, ASTRewrite aSTRewrite, String string) throws JavaModelException {
        aSTRewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SourceRangeComputer());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ConstraintVariable constraintVariable = (ConstraintVariable)iterator.next();
            ASTNode aSTNode = this.findDeclaration(compilationUnit, constraintVariable);
            if ((aSTNode instanceof SimpleName || aSTNode instanceof QualifiedName) && constraintVariable instanceof ExpressionVariable) {
                ASTNode aSTNode2 = aSTNode.getParent().getParent();
                this.updateType(compilationUnit, ChangeTypeRefactoring.getType(aSTNode2), compilationUnitChange, aSTRewrite, string);
                continue;
            }
            if (aSTNode instanceof MethodDeclaration || aSTNode instanceof FieldDeclaration) {
                this.updateType(compilationUnit, ChangeTypeRefactoring.getType(aSTNode), compilationUnitChange, aSTRewrite, string);
                continue;
            }
            if (!(aSTNode instanceof ParameterizedType)) continue;
            this.updateType(compilationUnit, ChangeTypeRefactoring.getType(aSTNode), compilationUnitChange, aSTRewrite, string);
        }
    }

    private void updateType(CompilationUnit compilationUnit, Type type, CompilationUnitChange compilationUnitChange, ASTRewrite aSTRewrite, String string) {
        String string2 = this.fSelectionTypeBinding.getName();
        String string3 = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_typeChange, new String[]{string2, string});
        TextEditGroup textEditGroup = new TextEditGroup(string3);
        AST aST = compilationUnit.getAST();
        Type type2 = type;
        if (this.fSelectionTypeBinding.isParameterizedType() && !this.fSelectionTypeBinding.isRawType() && type.isSimpleType()) {
            type2 = type.getParent();
        }
        Assert.isTrue((this.fSelectedType.isClass() || this.fSelectedType.isInterface() ? 1 : 0) != 0);
        Object object = null;
        object = !this.fSelectedType.isParameterizedType() ? aST.newSimpleType(ASTNodeFactory.newName(aST, string)) : this.createParameterizedType(aST, this.fSelectedType);
        aSTRewrite.replace((ASTNode)type2, (ASTNode)object, textEditGroup);
        compilationUnitChange.addTextEditGroup(textEditGroup);
    }

    private Type createParameterizedType(AST aST, ITypeBinding iTypeBinding) {
        if (iTypeBinding.isParameterizedType() && !iTypeBinding.isRawType()) {
            SimpleType simpleType = aST.newSimpleType(ASTNodeFactory.newName(aST, iTypeBinding.getErasure().getName()));
            ParameterizedType parameterizedType = aST.newParameterizedType((Type)simpleType);
            int n = 0;
            while (n < iTypeBinding.getTypeArguments().length) {
                ITypeBinding iTypeBinding2 = iTypeBinding.getTypeArguments()[n];
                Type type = this.createParameterizedType(aST, iTypeBinding2);
                parameterizedType.typeArguments().add(type);
                ++n;
            }
            return parameterizedType;
        }
        if (!iTypeBinding.isTypeVariable()) {
            return aST.newSimpleType(ASTNodeFactory.newName(aST, iTypeBinding.getErasure().getName()));
        }
        return aST.newSimpleType((Name)aST.newSimpleName(iTypeBinding.getName()));
    }

    private void groupChangesByCompilationUnit(Map map) throws JavaModelException {
        Iterator iterator = this.fRelevantVars.iterator();
        while (iterator.hasNext()) {
            ConstraintVariable constraintVariable;
            ConstraintVariable constraintVariable2 = (ConstraintVariable)iterator.next();
            if (!(constraintVariable2 instanceof ExpressionVariable) && !(constraintVariable2 instanceof ReturnTypeVariable)) continue;
            ICompilationUnit iCompilationUnit = null;
            if (constraintVariable2 instanceof ExpressionVariable) {
                constraintVariable = (ExpressionVariable)constraintVariable2;
                iCompilationUnit = ((ExpressionVariable)constraintVariable).getCompilationUnitRange().getCompilationUnit();
            } else if (constraintVariable2 instanceof ReturnTypeVariable) {
                constraintVariable = (ReturnTypeVariable)constraintVariable2;
                IMethodBinding iMethodBinding = ((ReturnTypeVariable)constraintVariable).getMethodBinding();
                iCompilationUnit = ((IMethod)iMethodBinding.getJavaElement()).getCompilationUnit();
            }
            if (!map.containsKey(iCompilationUnit)) {
                map.put(iCompilationUnit, new HashSet());
            }
            ((Set)map.get(iCompilationUnit)).add(constraintVariable2);
        }
    }

    private ASTNode findDeclaration(CompilationUnit compilationUnit, ConstraintVariable constraintVariable) throws JavaModelException {
        if (this.fFieldBinding != null) {
            IField iField = (IField)this.fFieldBinding.getJavaElement();
            return ASTNodeSearchUtil.getFieldDeclarationNode(iField, compilationUnit);
        }
        if (constraintVariable instanceof ExpressionVariable) {
            Iterator iterator = this.fAllConstraints.iterator();
            while (iterator.hasNext()) {
                ConstraintVariable constraintVariable2;
                SimpleTypeConstraint simpleTypeConstraint;
                ITypeConstraint iTypeConstraint = (ITypeConstraint)iterator.next();
                if (!iTypeConstraint.isSimpleTypeConstraint() || !(simpleTypeConstraint = (SimpleTypeConstraint)iTypeConstraint).isDefinesConstraint() || !simpleTypeConstraint.getLeft().equals(constraintVariable) || !((constraintVariable2 = simpleTypeConstraint.getRight()) instanceof TypeVariable)) continue;
                TypeVariable typeVariable = (TypeVariable)constraintVariable2;
                return NodeFinder.perform((ASTNode)compilationUnit, typeVariable.getCompilationUnitRange().getSourceRange());
            }
        } else if (constraintVariable instanceof ReturnTypeVariable) {
            ReturnTypeVariable returnTypeVariable = (ReturnTypeVariable)constraintVariable;
            IMethodBinding iMethodBinding = returnTypeVariable.getMethodBinding();
            IMethod iMethod = (IMethod)iMethodBinding.getJavaElement();
            return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, compilationUnit);
        }
        return null;
    }

    private static Type getType(ASTNode aSTNode) {
        switch (aSTNode.getNodeType()) {
            case 44: {
                return ((SingleVariableDeclaration)aSTNode).getType();
            }
            case 23: {
                return ((FieldDeclaration)aSTNode).getType();
            }
            case 60: {
                return ((VariableDeclarationStatement)aSTNode).getType();
            }
            case 31: {
                return ((MethodDeclaration)aSTNode).getReturnType2();
            }
            case 74: {
                return ((ParameterizedType)aSTNode).getType();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_name;
    }

    private String determineSelection(ASTNode aSTNode) {
        if (aSTNode == null) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection;
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        ASTNode aSTNode3 = aSTNode2.getParent();
        if (aSTNode3 == null) {
            return ChangeTypeRefactoring.nodeTypeNotSupported();
        }
        if (aSTNode3.getNodeType() == 74) {
            aSTNode = aSTNode3;
        }
        ASTNode aSTNode4 = null;
        if (aSTNode.getNodeType() == 40) {
            aSTNode4 = aSTNode;
            while (aSTNode4.getNodeType() == 40) {
                aSTNode4 = aSTNode4.getParent();
            }
            if (aSTNode4.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            aSTNode = aSTNode4.getParent();
        } else if (aSTNode2.getNodeType() == 40) {
            aSTNode4 = aSTNode2;
            while (aSTNode4.getNodeType() == 40) {
                aSTNode4 = aSTNode4.getParent();
            }
            if (aSTNode4.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            aSTNode = aSTNode4.getParent();
        }
        this.fObject = aSTNode.getAST().resolveWellKnownType("java.lang.Object");
        switch (aSTNode.getNodeType()) {
            case 42: {
                return this.simpleNameSelected((SimpleName)aSTNode);
            }
            case 60: {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)aSTNode);
            }
            case 23: {
                return this.fieldDeclarationSelected((FieldDeclaration)aSTNode);
            }
            case 44: {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)aSTNode);
            }
            case 74: {
                return this.parameterizedTypeSelected((ParameterizedType)aSTNode);
            }
        }
        return ChangeTypeRefactoring.nodeTypeNotSupported();
    }

    private static String nodeTypeNotSupported() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
    }

    private String singleVariableDeclarationSelected(SingleVariableDeclaration singleVariableDeclaration) {
        SimpleName simpleName = singleVariableDeclaration.getName();
        this.setSelectionRanges((Expression)simpleName);
        return this.simpleNameSelected(simpleName);
    }

    private String parameterizedTypeSelected(ParameterizedType parameterizedType) {
        ASTNode aSTNode = parameterizedType.getParent();
        if (aSTNode.getNodeType() != 31) {
            if (aSTNode.getNodeType() == 44) {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)aSTNode);
            }
            if (aSTNode.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)aSTNode);
            }
            if (aSTNode.getNodeType() == 23) {
                return this.fieldDeclarationSelected((FieldDeclaration)aSTNode);
            }
            return ChangeTypeRefactoring.nodeTypeNotSupported();
        }
        this.fMethodBinding = ((MethodDeclaration)aSTNode).resolveBinding();
        this.fParamIndex = -1;
        this.fEffectiveSelectionStart = parameterizedType.getStartPosition();
        this.fEffectiveSelectionLength = parameterizedType.getLength();
        this.setOriginalType(parameterizedType.resolveBinding());
        return null;
    }

    private String variableDeclarationStatementSelected(VariableDeclarationStatement variableDeclarationStatement) {
        if (variableDeclarationStatement.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)variableDeclarationStatement.fragments().iterator().next();
        SimpleName simpleName = variableDeclarationFragment.getName();
        this.setSelectionRanges((Expression)simpleName);
        return this.simpleNameSelected(simpleName);
    }

    private String fieldDeclarationSelected(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().iterator().next();
        this.fFieldBinding = variableDeclarationFragment.resolveBinding();
        SimpleName simpleName = variableDeclarationFragment.getName();
        this.setSelectionRanges((Expression)simpleName);
        return this.simpleNameSelected(simpleName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String simpleNameSelected(SimpleName simpleName) {
        ASTNode aSTNode = simpleName.getParent();
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode.getNodeType() == 60) {
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode;
            if (variableDeclarationStatement.fragments().size() <= 1) return null;
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        if (aSTNode.getNodeType() == 59) {
            if (aSTNode2.getNodeType() == 60) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode2;
                if (variableDeclarationStatement.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else if (aSTNode2.getNodeType() == 58) {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)aSTNode2;
                if (variableDeclarationExpression.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                if (aSTNode2.getNodeType() != 23) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
                FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode2;
                if (fieldDeclaration.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode;
                this.fFieldBinding = variableDeclarationFragment.resolveBinding();
                this.setSelectionRanges((Expression)variableDeclarationFragment.getName());
            }
            return null;
        } else if (aSTNode.getNodeType() == 44) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)aSTNode;
            if (aSTNode2.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)aSTNode2).resolveBinding();
                this.setOriginalType(simpleName.resolveTypeBinding());
                this.fParamIndex = ((MethodDeclaration)aSTNode2).parameters().indexOf(aSTNode);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (aSTNode.getNodeType() == 43 && aSTNode2.getNodeType() == 44) {
            ASTNode aSTNode3 = aSTNode2.getParent();
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)aSTNode2;
            if (singleVariableDeclaration.getExtraDimensions() > 0) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
            }
            if (aSTNode3 != null && aSTNode3.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)aSTNode3).resolveBinding();
                this.fParamIndex = ((MethodDeclaration)aSTNode3).parameters().indexOf(aSTNode2);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (aSTNode.getNodeType() == 43 && aSTNode2.getNodeType() == 31) {
            this.fMethodBinding = ((MethodDeclaration)aSTNode2).resolveBinding();
            this.setOriginalType(this.fMethodBinding.getReturnType());
            this.fParamIndex = -1;
            return null;
        } else if (aSTNode.getNodeType() == 31 && aSTNode2.getNodeType() == 55) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
            if (methodDeclaration.getName().equals((Object)simpleName) || methodDeclaration.thrownExceptions().contains(simpleName)) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
            }
            this.fMethodBinding = ((MethodDeclaration)aSTNode).resolveBinding();
            this.fParamIndex = -1;
            return null;
        } else {
            if (aSTNode.getNodeType() == 43 && aSTNode2.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)aSTNode2);
            }
            if (aSTNode.getNodeType() == 11) {
                ASTNode aSTNode4 = ChangeTypeRefactoring.findDeclaration(aSTNode.getRoot(), this.fSelectionStart, this.fSelectionLength + 1);
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode4;
                SimpleName simpleName2 = variableDeclarationFragment.getName();
                this.setSelectionRanges((Expression)simpleName2);
                return null;
            } else {
                if (aSTNode.getNodeType() == 43 && aSTNode2.getNodeType() == 23) {
                    return this.fieldDeclarationSelected((FieldDeclaration)aSTNode2);
                }
                if (aSTNode.getNodeType() == 43 && aSTNode2.getNodeType() == 5) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
                }
                if (aSTNode.getNodeType() != 40) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
                this.setSelectionRanges((Expression)simpleName);
            }
        }
        return null;
    }

    private ConstraintVariable findConstraintVariableForSelectedNode(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[]{this.fCu};
        Collection collection = this.getConstraints(iCompilationUnitArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 50);
        subProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            subProgressMonitor.worked(1);
            ITypeConstraint iTypeConstraint = (ITypeConstraint)iterator.next();
            if (!(iTypeConstraint instanceof SimpleTypeConstraint)) continue;
            SimpleTypeConstraint simpleTypeConstraint = (SimpleTypeConstraint)iTypeConstraint;
            if (this.matchesSelection(simpleTypeConstraint.getLeft())) {
                return simpleTypeConstraint.getLeft();
            }
            if (!this.matchesSelection(simpleTypeConstraint.getRight())) continue;
            return simpleTypeConstraint.getRight();
        }
        subProgressMonitor.done();
        iProgressMonitor.done();
        Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_noMatchingConstraintVariable);
        return null;
    }

    private boolean matchesSelection(ConstraintVariable constraintVariable) {
        if (constraintVariable instanceof ExpressionVariable) {
            ExpressionVariable expressionVariable = (ExpressionVariable)constraintVariable;
            return this.fSelectionBinding != null && Bindings.equals(this.fSelectionBinding, expressionVariable.getExpressionBinding());
        }
        if (constraintVariable instanceof ParameterTypeVariable) {
            ParameterTypeVariable parameterTypeVariable = (ParameterTypeVariable)constraintVariable;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)parameterTypeVariable.getMethodBinding(), (IBinding)this.fMethodBinding) && parameterTypeVariable.getParameterIndex() == this.fParamIndex) {
                return true;
            }
        } else if (constraintVariable instanceof ReturnTypeVariable) {
            ReturnTypeVariable returnTypeVariable = (ReturnTypeVariable)constraintVariable;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)returnTypeVariable.getMethodBinding(), (IBinding)this.fMethodBinding) && this.fParamIndex == -1) {
                return true;
            }
        }
        return false;
    }

    private Collection findRelevantConstraintVars(ConstraintVariable constraintVariable, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 150);
        HashSet<ConstraintVariable> hashSet = new HashSet<ConstraintVariable>();
        hashSet.add(constraintVariable);
        ICompilationUnit[] iCompilationUnitArray = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
        Collection collection = this.getConstraints(iCompilationUnitArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
        ArrayList<ConstraintVariable> arrayList = new ArrayList<ConstraintVariable>(hashSet);
        while (!arrayList.isEmpty()) {
            iProgressMonitor.worked(10);
            ConstraintVariable constraintVariable2 = (ConstraintVariable)arrayList.remove(0);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ConstraintVariable constraintVariable3;
                SimpleTypeConstraint simpleTypeConstraint;
                iProgressMonitor.worked(1);
                ITypeConstraint iTypeConstraint = (ITypeConstraint)iterator.next();
                if (!iTypeConstraint.isSimpleTypeConstraint() || !(simpleTypeConstraint = (SimpleTypeConstraint)iTypeConstraint).isDefinesConstraint() && !simpleTypeConstraint.isEqualsConstraint() || !((constraintVariable3 = ChangeTypeRefactoring.match(constraintVariable2, simpleTypeConstraint.getLeft(), simpleTypeConstraint.getRight())) instanceof ExpressionVariable) && !(constraintVariable3 instanceof ParameterTypeVariable) && !(constraintVariable3 instanceof ReturnTypeVariable) || hashSet.contains(constraintVariable3)) continue;
                arrayList.add(constraintVariable3);
                hashSet.add(constraintVariable3);
            }
        }
        iProgressMonitor.done();
        return hashSet;
    }

    private static ConstraintVariable match(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2, ConstraintVariable constraintVariable3) {
        if (constraintVariable.equals(constraintVariable2)) {
            return constraintVariable3;
        }
        if (constraintVariable.equals(constraintVariable3)) {
            return constraintVariable2;
        }
        return null;
    }

    private Collection findRelevantConstraints(Collection collection, IProgressMonitor iProgressMonitor) throws CoreException {
        ICompilationUnit[] iCompilationUnitArray = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
        this.fAllConstraints = this.getConstraints(iCompilationUnitArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 1000 + this.fAllConstraints.size());
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        Iterator iterator = this.fAllConstraints.iterator();
        while (iterator.hasNext()) {
            ITypeConstraint iTypeConstraint;
            ITypeConstraint iTypeConstraint2 = (ITypeConstraint)iterator.next();
            if (iTypeConstraint2.isSimpleTypeConstraint()) {
                iTypeConstraint = (SimpleTypeConstraint)iTypeConstraint2;
                if (((SimpleTypeConstraint)iTypeConstraint).isDefinesConstraint() || ((SimpleTypeConstraint)iTypeConstraint).isEqualsConstraint() || ((SimpleTypeConstraint)iTypeConstraint).getLeft().equals(((SimpleTypeConstraint)iTypeConstraint).getRight()) || ChangeTypeRefactoring.isNull(((SimpleTypeConstraint)iTypeConstraint).getLeft())) continue;
                if (collection.contains(((SimpleTypeConstraint)iTypeConstraint).getLeft()) || collection.contains(((SimpleTypeConstraint)iTypeConstraint).getRight())) {
                    arrayList.add(iTypeConstraint2);
                }
            } else {
                iTypeConstraint = (CompositeOrTypeConstraint)iTypeConstraint2;
                ITypeConstraint[] iTypeConstraintArray = ((CompositeOrTypeConstraint)iTypeConstraint).getConstraints();
                int n = 0;
                while (n < iTypeConstraintArray.length) {
                    ITypeConstraint iTypeConstraint3 = iTypeConstraintArray[n];
                    SimpleTypeConstraint simpleTypeConstraint = (SimpleTypeConstraint)iTypeConstraint3;
                    if (collection.contains(simpleTypeConstraint.getLeft())) {
                        arrayList.add(iTypeConstraint2);
                    }
                    ++n;
                }
            }
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
        return arrayList;
    }

    private static ASTNode findDeclaration(ASTNode aSTNode, int n, int n2) {
        ASTNode aSTNode2 = NodeFinder.perform(aSTNode, n, n2);
        Assert.isTrue((boolean)(aSTNode2 instanceof SimpleName), (String)String.valueOf(aSTNode2.getNodeType()));
        Assert.isTrue((boolean)(aSTNode instanceof CompilationUnit), (String)String.valueOf(aSTNode.getNodeType()));
        return ((CompilationUnit)aSTNode).findDeclaringNode(((SimpleName)aSTNode2).resolveBinding());
    }

    static String print(Collection collection) {
        if (collection.isEmpty()) {
            return "{ }";
        }
        String string = "{ ";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)iterator.next();
            string = String.valueOf(string) + iTypeBinding.getQualifiedName();
            string = iterator.hasNext() ? String.valueOf(string) + ", " : String.valueOf(string) + " }";
        }
        return string;
    }

    private Collection computeValidTypes(ITypeBinding iTypeBinding, Collection collection, Collection collection2, IProgressMonitor iProgressMonitor) throws JavaModelException {
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        IJavaProject iJavaProject = this.fCu.getJavaProject();
        HashSet hashSet2 = new HashSet();
        hashSet2.addAll(this.getAllSuperTypes(iTypeBinding));
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, hashSet2.size());
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding2 = (ITypeBinding)iterator.next();
            if (!this.isValid(iJavaProject, iTypeBinding2, collection, collection2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1))) continue;
            hashSet.add(iTypeBinding2);
        }
        hashSet.remove(iTypeBinding);
        iProgressMonitor.done();
        return hashSet;
    }

    private boolean isValid(IJavaProject iJavaProject, ITypeBinding iTypeBinding, Collection collection, Collection collection2, IProgressMonitor iProgressMonitor) throws JavaModelException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, collection2.size());
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ITypeConstraint iTypeConstraint = (ITypeConstraint)iterator.next();
            if (iTypeConstraint instanceof SimpleTypeConstraint ? !this.isValidSimpleConstraint(iJavaProject, iTypeBinding, collection, (SimpleTypeConstraint)iTypeConstraint) : iTypeConstraint instanceof CompositeOrTypeConstraint && !this.isValidOrConstraint(iJavaProject, iTypeBinding, collection, (CompositeOrTypeConstraint)iTypeConstraint)) {
                return false;
            }
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
        return true;
    }

    private boolean isValidSimpleConstraint(IJavaProject iJavaProject, ITypeBinding iTypeBinding, Collection collection, SimpleTypeConstraint simpleTypeConstraint) throws JavaModelException {
        return !collection.contains(simpleTypeConstraint.getLeft()) || this.isSubTypeOf(iTypeBinding, this.findType(simpleTypeConstraint.getRight()));
    }

    private boolean isValidOrConstraint(IJavaProject iJavaProject, ITypeBinding iTypeBinding, Collection collection, CompositeOrTypeConstraint compositeOrTypeConstraint) throws JavaModelException {
        ITypeConstraint[] iTypeConstraintArray = compositeOrTypeConstraint.getConstraints();
        int n = 0;
        while (n < iTypeConstraintArray.length) {
            SimpleTypeConstraint simpleTypeConstraint;
            if (iTypeConstraintArray[n] instanceof SimpleTypeConstraint && (collection.contains((simpleTypeConstraint = (SimpleTypeConstraint)iTypeConstraintArray[n]).getLeft()) ? this.isSubTypeOf(iTypeBinding, this.findType(simpleTypeConstraint.getRight())) : collection.contains(simpleTypeConstraint.getRight()) && this.isSubTypeOf(this.findType(simpleTypeConstraint.getLeft()), iTypeBinding))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private ITypeBinding findType(ConstraintVariable constraintVariable) {
        return constraintVariable.getBinding();
    }

    private Collection getConstraints(ICompilationUnit[] iCompilationUnitArray, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, iCompilationUnitArray.length);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            arrayList.addAll(this.getConstraints(iCompilationUnitArray[n]));
            iProgressMonitor.worked(1);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    private List getConstraints(ICompilationUnit iCompilationUnit) {
        Object object;
        if (this.fConstraintCache.containsKey(iCompilationUnit)) {
            return (List)this.fConstraintCache.get(iCompilationUnit);
        }
        CompilationUnit compilationUnit = ASTCreator.createAST(iCompilationUnit, null);
        if (this.fMethodBinding != null && this.fCuToSearchResultGroup.containsKey(iCompilationUnit)) {
            object = (SearchResultGroup)this.fCuToSearchResultGroup.get(iCompilationUnit);
            ASTNode[] aSTNodeArray = ASTNodeSearchUtil.getAstNodes(((SearchResultGroup)object).getSearchResults(), compilationUnit);
            int n = 0;
            while (n < aSTNodeArray.length) {
                ASTNode aSTNode = aSTNodeArray[n];
                if (this.fMethodBinding != null) {
                    ASTNode aSTNode2 = aSTNode;
                    while (!(aSTNode2 instanceof MethodDeclaration)) {
                        aSTNode2 = aSTNode2.getParent();
                    }
                    MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode2;
                    methodDeclaration.accept((ASTVisitor)this.fCollector);
                }
                ++n;
            }
        } else {
            compilationUnit.accept((ASTVisitor)this.fCollector);
        }
        object = Arrays.asList(this.fCollector.getConstraints());
        this.fConstraintCache.put(iCompilationUnit, object);
        return object;
    }

    private String updateImports(CompilationUnit compilationUnit, MultiTextEdit multiTextEdit) throws CoreException {
        ImportRewrite importRewrite = StubUtility.createImportRewrite(compilationUnit, true);
        String string = importRewrite.addImport(this.fSelectedType.getQualifiedName());
        multiTextEdit.addChild(importRewrite.rewriteImports(null));
        return string;
    }

    public Collection getValidTypes() {
        return this.fValidTypes;
    }

    public ITypeBinding getOriginalType() {
        return this.fSelectionTypeBinding;
    }

    private void setOriginalType(ITypeBinding iTypeBinding) {
        this.fSelectionTypeBinding = iTypeBinding;
        this.fSelectedType = this.findSuperTypeByName(iTypeBinding, this.fSelectedTypeName);
    }

    public String getTarget() {
        String string;
        String string2 = string = this.fSelectionTypeBinding == null ? "" : String.valueOf(this.fSelectionTypeBinding.getName()) + " ";
        if (this.fFieldBinding != null) {
            return String.valueOf(string) + this.fFieldBinding.getName();
        }
        if (this.fMethodBinding != null) {
            if (this.fParamIndex == -1) {
                return String.valueOf(string) + this.fMethodBinding.getName() + "(...)";
            }
            return String.valueOf(string) + this.fParamName;
        }
        if (this.fSelectionBinding != null) {
            return String.valueOf(string) + this.fSelectionBinding.getName();
        }
        return string;
    }

    public Collection getValidTypeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.fValidTypes.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)iterator.next();
            arrayList.add(iTypeBinding.getQualifiedName());
        }
        return arrayList;
    }

    private ASTNode getTargetNode(ICompilationUnit iCompilationUnit, int n, int n2) {
        CompilationUnit compilationUnit = ASTCreator.createAST(iCompilationUnit, null);
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n, n2);
        return aSTNode;
    }

    private ICompilationUnit[] collectAffectedUnits(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        if (this.fAffectedUnits != null) {
            iProgressMonitor.worked(100);
            return this.fAffectedUnits;
        }
        if (this.fMethodBinding != null) {
            if (this.fMethodBinding != null) {
                SearchPattern searchPattern;
                IMethod[] iMethodArray;
                IMethod iMethod;
                IMethod iMethod2 = (IMethod)this.fMethodBinding.getJavaElement();
                if (iMethod2 == null) {
                    Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_no_method);
                }
                if (!(iMethod = iMethod2).getDeclaringType().isInterface() && MethodChecks.isVirtual(iMethod)) {
                    iMethodArray = new SubProgressMonitor(iProgressMonitor, 5);
                    searchPattern = MethodChecks.isDeclaredInInterface(iMethod, iMethod.getDeclaringType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)iMethodArray, 1)), (IProgressMonitor)iMethodArray);
                    if (searchPattern != null && !searchPattern.equals(iMethod)) {
                        iMethod = searchPattern;
                    }
                }
                iMethodArray = RippleMethodFinder2.getRelatedMethods(iMethod, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 15), null);
                searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])iMethodArray, 3);
                IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)iMethod2);
                CollectingSearchRequestor collectingSearchRequestor = new CollectingSearchRequestor();
                SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, null, iJavaSearchScope, collectingSearchRequestor, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 80), new RefactoringStatus());
                this.fAffectedUnits = this.getCus(searchResultGroupArray);
            }
        } else if (this.fFieldBinding != null) {
            IField iField = (IField)this.fFieldBinding.getJavaElement();
            if (iField == null) {
                Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_no_filed);
            }
            SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)iField, (int)3, (int)24);
            IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)iField);
            CollectingSearchRequestor collectingSearchRequestor = new CollectingSearchRequestor();
            SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, null, iJavaSearchScope, collectingSearchRequestor, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100), new RefactoringStatus());
            this.fAffectedUnits = this.getCus(searchResultGroupArray);
        } else {
            this.fAffectedUnits = new ICompilationUnit[]{this.fCu};
        }
        iProgressMonitor.done();
        return this.fAffectedUnits;
    }

    public void setSelectedType(ITypeBinding iTypeBinding) {
        this.fSelectedType = iTypeBinding;
    }

    private static boolean isNull(ConstraintVariable constraintVariable) {
        return constraintVariable instanceof ExpressionVariable && ((ExpressionVariable)constraintVariable).getExpressionType() == 33;
    }

    void printCollection(String string, Collection collection) {
        System.out.println(String.valueOf(collection.size()) + " " + string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            System.out.println("  " + iterator.next());
        }
    }

    private ICompilationUnit[] getCus(SearchResultGroup[] searchResultGroupArray) {
        ArrayList<ICompilationUnit> arrayList = new ArrayList<ICompilationUnit>(searchResultGroupArray.length);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                arrayList.add(iCompilationUnit);
                this.fCuToSearchResultGroup.put(iCompilationUnit, searchResultGroup);
            }
            ++n;
        }
        return arrayList.toArray(new ICompilationUnit[arrayList.size()]);
    }

    public Set getAllSuperTypes(ITypeBinding iTypeBinding) {
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        hashSet.add(iTypeBinding);
        if (iTypeBinding.getSuperclass() != null) {
            hashSet.addAll(this.getAllSuperTypes(iTypeBinding.getSuperclass()));
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            hashSet.addAll(this.getAllSuperTypes(iTypeBindingArray[n]));
            ++n;
        }
        if (iTypeBinding != this.fObject && !ChangeTypeRefactoring.contains(hashSet, this.fObject)) {
            hashSet.add(this.fObject);
        }
        return hashSet;
    }

    private ITypeBinding findSuperTypeByName(ITypeBinding iTypeBinding, String string) {
        Set set = this.getAllSuperTypes(iTypeBinding);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding2 = (ITypeBinding)iterator.next();
            if (!iTypeBinding2.getQualifiedName().equals(string)) continue;
            return iTypeBinding2;
        }
        return null;
    }

    public boolean isSubTypeOf(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        if (iTypeBinding.isParameterizedType() && iTypeBinding.getTypeDeclaration().isEqualTo((IBinding)iTypeBinding2.getTypeDeclaration())) {
            return true;
        }
        Set set = this.getAllSuperTypes(iTypeBinding);
        return ChangeTypeRefactoring.contains(set, iTypeBinding2);
    }

    private static boolean contains(Collection collection, ITypeBinding iTypeBinding) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding2 = (ITypeBinding)iterator.next();
            if (!Bindings.equals((IBinding)iTypeBinding2, (IBinding)iTypeBinding)) continue;
            return true;
        }
        return false;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        Object object;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            int n;
            int n2;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute("selection");
            if (string != null) {
                n2 = -1;
                n = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object == null || !object.exists() || object.getElementType() != 5) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.change.type");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)object;
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_TYPE);
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fSelectedTypeName = object;
        return new RefactoringStatus();
    }

    private class SourceRangeComputer
    extends TargetSourceRangeComputer {
        private SourceRangeComputer() {
        }

        public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode aSTNode) {
            return new TargetSourceRangeComputer.SourceRange(aSTNode.getStartPosition(), aSTNode.getLength());
        }
    }
}

