/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

public class LocalDeclarationAnalyzer
extends ASTVisitor {
    private Selection fSelection;
    private List fAffectedLocals;

    public static VariableDeclaration[] perform(BodyDeclaration bodyDeclaration, Selection selection) {
        LocalDeclarationAnalyzer localDeclarationAnalyzer = new LocalDeclarationAnalyzer(selection);
        bodyDeclaration.accept((ASTVisitor)localDeclarationAnalyzer);
        return localDeclarationAnalyzer.fAffectedLocals.toArray(new VariableDeclaration[localDeclarationAnalyzer.fAffectedLocals.size()]);
    }

    private LocalDeclarationAnalyzer(Selection selection) {
        this.fSelection = selection;
        this.fAffectedLocals = new ArrayList(1);
    }

    public boolean visit(SimpleName simpleName) {
        IVariableBinding iVariableBinding = null;
        if (simpleName.isDeclaration() || !this.considerNode((ASTNode)simpleName) || (iVariableBinding = ASTNodes.getLocalVariableBinding((Name)simpleName)) == null) {
            return false;
        }
        this.handleReferenceToLocal(simpleName, iVariableBinding);
        return true;
    }

    private boolean considerNode(ASTNode aSTNode) {
        return this.fSelection.getVisitSelectionMode(aSTNode) == 3;
    }

    private void handleReferenceToLocal(SimpleName simpleName, IVariableBinding iVariableBinding) {
        VariableDeclaration variableDeclaration = ASTNodes.findVariableDeclaration(iVariableBinding, (ASTNode)simpleName);
        if (variableDeclaration != null && this.fSelection.covers((ASTNode)variableDeclaration)) {
            this.addLocalDeclaration(variableDeclaration);
        }
    }

    private void addLocalDeclaration(VariableDeclaration variableDeclaration) {
        if (!this.fAffectedLocals.contains(variableDeclaration)) {
            this.fAffectedLocals.add(variableDeclaration);
        }
    }
}

