/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;

public final class ConstraintCollector
extends ASTVisitor {
    private final ConstraintCreator fCreator;
    private final Set fConstraints;

    public ConstraintCollector() {
        this(new FullConstraintCreator());
    }

    public ConstraintCollector(ConstraintCreator constraintCreator) {
        Assert.isNotNull((Object)constraintCreator);
        this.fCreator = constraintCreator;
        this.fConstraints = new LinkedHashSet();
    }

    private void add(ITypeConstraint[] iTypeConstraintArray) {
        this.fConstraints.addAll(Arrays.asList(iTypeConstraintArray));
    }

    public void clear() {
        this.fConstraints.clear();
    }

    public ITypeConstraint[] getConstraints() {
        return this.fConstraints.toArray(new ITypeConstraint[this.fConstraints.size()]);
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.add(this.fCreator.create(anonymousClassDeclaration));
        return true;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        this.add(this.fCreator.create(arrayAccess));
        return true;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        this.add(this.fCreator.create(arrayCreation));
        return true;
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        this.add(this.fCreator.create(arrayInitializer));
        return true;
    }

    public boolean visit(ArrayType arrayType) {
        this.add(this.fCreator.create(arrayType));
        return true;
    }

    public boolean visit(AssertStatement assertStatement) {
        this.add(this.fCreator.create(assertStatement));
        return true;
    }

    public boolean visit(Assignment assignment) {
        this.add(this.fCreator.create(assignment));
        return true;
    }

    public boolean visit(Block block) {
        this.add(this.fCreator.create(block));
        return true;
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        this.add(this.fCreator.create(booleanLiteral));
        return true;
    }

    public boolean visit(BreakStatement breakStatement) {
        this.add(this.fCreator.create(breakStatement));
        return true;
    }

    public boolean visit(CastExpression castExpression) {
        this.add(this.fCreator.create(castExpression));
        return true;
    }

    public boolean visit(CatchClause catchClause) {
        this.add(this.fCreator.create(catchClause));
        return true;
    }

    public boolean visit(RegularExpressionLiteral regularExpressionLiteral) {
        this.add(this.fCreator.create(regularExpressionLiteral));
        return true;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.add(this.fCreator.create(classInstanceCreation));
        return true;
    }

    public boolean visit(CompilationUnit compilationUnit) {
        this.add(this.fCreator.create(compilationUnit));
        return true;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        this.add(this.fCreator.create(conditionalExpression));
        return true;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        this.add(this.fCreator.create(constructorInvocation));
        return true;
    }

    public boolean visit(ContinueStatement continueStatement) {
        this.add(this.fCreator.create(continueStatement));
        return true;
    }

    public boolean visit(DoStatement doStatement) {
        this.add(this.fCreator.create(doStatement));
        return true;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.add(this.fCreator.create(emptyStatement));
        return true;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        this.add(this.fCreator.create(expressionStatement));
        return true;
    }

    public boolean visit(FieldAccess fieldAccess) {
        this.add(this.fCreator.create(fieldAccess));
        return true;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        this.add(this.fCreator.create(fieldDeclaration));
        return true;
    }

    public boolean visit(ForStatement forStatement) {
        this.add(this.fCreator.create(forStatement));
        return true;
    }

    public boolean visit(FunctionExpression functionExpression) {
        this.add(this.fCreator.create(functionExpression));
        return true;
    }

    public boolean visit(ObjectLiteral objectLiteral) {
        this.add(this.fCreator.create(objectLiteral));
        return true;
    }

    public boolean visit(ObjectLiteralField objectLiteralField) {
        this.add(this.fCreator.create(objectLiteralField));
        return true;
    }

    public boolean visit(ForInStatement forInStatement) {
        this.add(this.fCreator.create(forInStatement));
        return true;
    }

    public boolean visit(IfStatement ifStatement) {
        this.add(this.fCreator.create(ifStatement));
        return true;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        this.add(this.fCreator.create(importDeclaration));
        return true;
    }

    public boolean visit(InfixExpression infixExpression) {
        this.add(this.fCreator.create(infixExpression));
        return true;
    }

    public boolean visit(Initializer initializer) {
        this.add(this.fCreator.create(initializer));
        return true;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        this.add(this.fCreator.create(instanceofExpression));
        return true;
    }

    public boolean visit(Javadoc javadoc) {
        this.add(this.fCreator.create(javadoc));
        return true;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        this.add(this.fCreator.create(labeledStatement));
        return true;
    }

    public boolean visit(ListExpression listExpression) {
        this.add(this.fCreator.create(listExpression));
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.add(this.fCreator.create(methodDeclaration));
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        this.add(this.fCreator.create(methodInvocation));
        return true;
    }

    public boolean visit(NullLiteral nullLiteral) {
        this.add(this.fCreator.create(nullLiteral));
        return true;
    }

    public boolean visit(UndefinedLiteral undefinedLiteral) {
        this.add(this.fCreator.create(undefinedLiteral));
        return true;
    }

    public boolean visit(NumberLiteral numberLiteral) {
        this.add(this.fCreator.create(numberLiteral));
        return true;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        this.add(this.fCreator.create(packageDeclaration));
        return true;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        this.add(this.fCreator.create(parenthesizedExpression));
        return true;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        this.add(this.fCreator.create(postfixExpression));
        return true;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        this.add(this.fCreator.create(prefixExpression));
        return true;
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.add(this.fCreator.create(primitiveType));
        return true;
    }

    public boolean visit(QualifiedName qualifiedName) {
        this.add(this.fCreator.create(qualifiedName));
        return true;
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.add(this.fCreator.create(returnStatement));
        return true;
    }

    public boolean visit(SimpleName simpleName) {
        this.add(this.fCreator.create(simpleName));
        return true;
    }

    public boolean visit(SimpleType simpleType) {
        this.add(this.fCreator.create(simpleType));
        return true;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.add(this.fCreator.create(singleVariableDeclaration));
        return true;
    }

    public boolean visit(StringLiteral stringLiteral) {
        this.add(this.fCreator.create(stringLiteral));
        return true;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        this.add(this.fCreator.create(superConstructorInvocation));
        return true;
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        this.add(this.fCreator.create(superFieldAccess));
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        this.add(this.fCreator.create(superMethodInvocation));
        return true;
    }

    public boolean visit(SwitchCase switchCase) {
        this.add(this.fCreator.create(switchCase));
        return true;
    }

    public boolean visit(SwitchStatement switchStatement) {
        this.add(this.fCreator.create(switchStatement));
        return true;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        this.add(this.fCreator.create(synchronizedStatement));
        return true;
    }

    public boolean visit(ThisExpression thisExpression) {
        this.add(this.fCreator.create(thisExpression));
        return true;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.add(this.fCreator.create(throwStatement));
        return true;
    }

    public boolean visit(TryStatement tryStatement) {
        this.add(this.fCreator.create(tryStatement));
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        this.add(this.fCreator.create(typeDeclaration));
        return true;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        this.add(this.fCreator.create(typeDeclarationStatement));
        return true;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        this.add(this.fCreator.create(typeLiteral));
        return true;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        this.add(this.fCreator.create(variableDeclarationExpression));
        return true;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        this.add(this.fCreator.create(variableDeclarationFragment));
        return true;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        this.add(this.fCreator.create(variableDeclarationStatement));
        return true;
    }

    public boolean visit(WhileStatement whileStatement) {
        this.add(this.fCreator.create(whileStatement));
        return true;
    }

    public boolean visit(WithStatement withStatement) {
        this.add(this.fCreator.create(withStatement));
        return true;
    }
}

