/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.TypeRules;

public abstract class ConstraintVariable {
    private final ITypeBinding fTypeBinding;
    private Object fData;

    protected ConstraintVariable(ITypeBinding iTypeBinding) {
        this.fTypeBinding = iTypeBinding;
    }

    public boolean canBeAssignedTo(ConstraintVariable constraintVariable) {
        if (this.fTypeBinding == null || constraintVariable.fTypeBinding == null) {
            return false;
        }
        return TypeRules.canAssign(this.fTypeBinding, constraintVariable.fTypeBinding);
    }

    public String toResolvedString() {
        if (this.fTypeBinding == null) {
            return "<NULL BINDING>";
        }
        return Bindings.asString((IBinding)this.fTypeBinding);
    }

    public String toString() {
        return this.toResolvedString();
    }

    public ITypeBinding getBinding() {
        return this.fTypeBinding;
    }

    public Object getData() {
        return this.fData;
    }

    public void setData(Object object) {
        this.fData = object;
    }
}

