/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;

public final class GenericType
extends HierarchyType {
    private TypeVariable[] fTypeParameters;

    protected GenericType(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected void initialize(ITypeBinding iTypeBinding, IType iType) {
        Assert.isTrue((boolean)iTypeBinding.isGenericType());
        super.initialize(iTypeBinding, iType);
        TypeEnvironment typeEnvironment = this.getEnvironment();
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeParameters();
        this.fTypeParameters = new TypeVariable[iTypeBindingArray.length];
        int n = 0;
        while (n < iTypeBindingArray.length) {
            this.fTypeParameters[n] = (TypeVariable)typeEnvironment.create(iTypeBindingArray[n]);
            ++n;
        }
    }

    public int getKind() {
        return 6;
    }

    public TypeVariable[] getTypeParameters() {
        return (TypeVariable[])this.fTypeParameters.clone();
    }

    public boolean doEquals(TType tType) {
        return this.getJavaElementType().equals(((GenericType)tType).getJavaElementType());
    }

    public int hashCode() {
        return this.getJavaElementType().hashCode();
    }

    protected boolean doCanAssignTo(TType tType) {
        return false;
    }

    protected boolean isTypeEquivalentTo(TType tType) {
        int n = tType.getKind();
        if (n == 8 || n == 7) {
            return this.getErasure().isTypeEquivalentTo(tType.getErasure());
        }
        return super.isTypeEquivalentTo(tType);
    }

    public String getName() {
        return this.getJavaElementType().getElementName();
    }

    protected String getPlainPrettySignature() {
        StringBuffer stringBuffer = new StringBuffer(this.getJavaElementType().getFullyQualifiedName('.'));
        stringBuffer.append("<");
        stringBuffer.append(this.fTypeParameters[0].getPrettySignature());
        int n = 1;
        while (n < this.fTypeParameters.length) {
            stringBuffer.append(", ");
            stringBuffer.append(this.fTypeParameters[n].getPrettySignature());
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

