/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class TypeSetIntersection
extends TypeSet {
    private TypeSet fLHS;
    private TypeSet fRHS;
    private EnumeratedTypeSet fEnumCache = null;

    public TypeSetIntersection(TypeSet typeSet, TypeSet typeSet2) {
        super(typeSet.getTypeSetEnvironment());
        this.fLHS = typeSet;
        this.fRHS = typeSet2;
    }

    public TypeSet getLHS() {
        return this.fLHS;
    }

    public TypeSet getRHS() {
        return this.fRHS;
    }

    public boolean isUniverse() {
        return this.fLHS.isUniverse() && this.fRHS.isUniverse();
    }

    public TypeSet makeClone() {
        return this;
    }

    public boolean isEmpty() {
        if (this.fLHS.isEmpty() || this.fRHS.isEmpty()) {
            return true;
        }
        if (this.fLHS.isUniverse() || this.fRHS.isUniverse()) {
            return false;
        }
        if (this.fLHS.contains(this.getJavaLangObject()) && this.fRHS.contains(this.getJavaLangObject())) {
            return false;
        }
        return false;
    }

    public boolean contains(TType tType) {
        return this.fLHS.contains(tType) && this.fRHS.contains(tType);
    }

    public boolean containsAll(TypeSet typeSet) {
        return this.fLHS.containsAll(typeSet) && this.fRHS.containsAll(typeSet);
    }

    public TypeSet subTypes() {
        if (this.isUniverse() || this.contains(this.getJavaLangObject())) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        if ((this.fLHS instanceof SubTypesSet || this.fLHS instanceof SubTypesOfSingleton) && (this.fRHS instanceof SubTypesSet || this.fRHS instanceof SubTypesOfSingleton)) {
            return this;
        }
        return this.getTypeSetEnvironment().createSubTypesSet(this);
    }

    public TypeSet superTypes() {
        if ((this.fLHS instanceof SuperTypesSet || this.fLHS instanceof SuperTypesOfSingleton) && (this.fRHS instanceof SuperTypesSet || this.fRHS instanceof SuperTypesOfSingleton)) {
            return this;
        }
        return this.getTypeSetEnvironment().createSuperTypesSet(this);
    }

    public TypeSet upperBound() {
        if (this.fLHS.contains(this.getJavaLangObject()) && this.fRHS.contains(this.getJavaLangObject())) {
            return new SingletonTypeSet(this.getTypeSetEnvironment().getJavaLangObject(), this.getTypeSetEnvironment());
        }
        if (this.fEnumCache != null) {
            return this.fEnumCache.upperBound();
        }
        EnumeratedTypeSet enumeratedTypeSet = this.fLHS.enumerate();
        EnumeratedTypeSet enumeratedTypeSet2 = this.fRHS.enumerate();
        TypeSet typeSet = enumeratedTypeSet.intersectedWith(enumeratedTypeSet2);
        return typeSet.upperBound();
    }

    public TypeSet lowerBound() {
        Object object;
        Object object2;
        if (this.fLHS.hasUniqueLowerBound() && this.fRHS.hasUniqueLowerBound()) {
            object2 = this.fLHS.uniqueLowerBound();
            if (((TType)object2).equals(object = this.fRHS.uniqueLowerBound())) {
                return new SingletonTypeSet((TType)object2, this.getTypeSetEnvironment());
            }
            if (TTypes.canAssignTo((TType)object2, (TType)object)) {
                return new SingletonTypeSet((TType)object, this.getTypeSetEnvironment());
            }
            if (TTypes.canAssignTo((TType)object, (TType)object2)) {
                return new SingletonTypeSet((TType)object2, this.getTypeSetEnvironment());
            }
        }
        if (this.fEnumCache != null) {
            return this.fEnumCache.lowerBound();
        }
        object2 = this.fLHS.enumerate();
        object = this.fRHS.enumerate();
        TypeSet typeSet = ((TypeSet)object2).intersectedWith((TypeSet)object);
        return typeSet.lowerBound();
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        if (typeSet.equals(this.fLHS)) {
            return this;
        }
        if (typeSet.equals(this.fRHS)) {
            return this;
        }
        if (typeSet instanceof TypeSetIntersection) {
            TypeSetIntersection typeSetIntersection = (TypeSetIntersection)typeSet;
            if (this.fLHS.equals(typeSetIntersection.fLHS)) {
                return new TypeSetIntersection(this, typeSetIntersection.fRHS);
            }
            if (this.fLHS.equals(typeSetIntersection.fRHS)) {
                return new TypeSetIntersection(this, typeSetIntersection.fLHS);
            }
            if (this.fRHS.equals(typeSetIntersection.fLHS)) {
                return new TypeSetIntersection(this, typeSetIntersection.fRHS);
            }
            if (this.fRHS.equals(typeSetIntersection.fRHS)) {
                return new TypeSetIntersection(this, typeSetIntersection.fLHS);
            }
        }
        return null;
    }

    public boolean isSingleton() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.isSingleton();
        }
        int n = 0;
        Iterator iterator = this.fLHS.iterator();
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            if (this.fRHS.contains(tType)) {
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return n == 1;
    }

    public TType anyMember() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.anyMember();
        }
        Iterator iterator = this.fLHS.iterator();
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            if (!this.fRHS.contains(tType)) continue;
            return tType;
        }
        return null;
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public boolean equals(Object object) {
        if (object instanceof TypeSetIntersection) {
            TypeSetIntersection typeSetIntersection = (TypeSetIntersection)object;
            return typeSetIntersection.fLHS.equals(this.fLHS) && typeSetIntersection.fRHS.equals(this.fRHS);
        }
        return false;
    }

    public String toString() {
        return "<" + this.fID + ": intersect(" + this.fLHS + "," + this.fRHS + ")>";
    }

    public boolean hasUniqueLowerBound() {
        return false;
    }

    public boolean hasUniqueUpperBound() {
        return false;
    }

    public TType uniqueLowerBound() {
        return null;
    }

    public TType uniqueUpperBound() {
        return null;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            EnumeratedTypeSet enumeratedTypeSet = this.fLHS.enumerate();
            EnumeratedTypeSet enumeratedTypeSet2 = this.fRHS.enumerate();
            this.fEnumCache = enumeratedTypeSet.intersectedWith(enumeratedTypeSet2).enumerate();
        }
        return this.fEnumCache;
    }
}

