/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.wst.jsdt.internal.ui.util.PatternConstructor;

public class QualifiedNameFinder {
    private static final GroupCategorySet QUALIFIED_NAMES = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.qualifiedNames", RefactoringCoreMessages.QualifiedNameFinder_qualifiedNames_name, RefactoringCoreMessages.QualifiedNameFinder_qualifiedNames_description));

    public static void process(QualifiedNameSearchResult qualifiedNameSearchResult, String string, String string2, String string3, IProject iProject, IProgressMonitor iProgressMonitor) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)iProject);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (string3 == null || string3.length() == 0) {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.worked(1);
            return;
        }
        ResultCollector resultCollector = new ResultCollector(qualifiedNameSearchResult, string2);
        TextSearchEngine textSearchEngine = TextSearchEngine.create();
        Pattern pattern = PatternConstructor.createPattern(string, true, false);
        textSearchEngine.search(QualifiedNameFinder.createScope(string3, iProject), (TextSearchRequestor)resultCollector, pattern, iProgressMonitor);
    }

    private static TextSearchScope createScope(String string, IProject iProject) {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        hashSet.add(iProject);
        QualifiedNameFinder.addReferencingProjects(iProject, hashSet);
        IResource[] iResourceArray = hashSet.toArray(new IResource[hashSet.size()]);
        Pattern pattern = QualifiedNameFinder.getFilePattern(string);
        return TextSearchScope.newSearchScope((IResource[])iResourceArray, (Pattern)pattern, (boolean)false);
    }

    private static Pattern getFilePattern(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        return PatternConstructor.createPattern(stringArray, true, false);
    }

    private static void addReferencingProjects(IProject iProject, Set set) {
        IProject[] iProjectArray = iProject.getReferencingProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject2 = iProjectArray[n];
            if (set.add(iProject2)) {
                QualifiedNameFinder.addReferencingProjects(iProject2, set);
            }
            ++n;
        }
    }

    private static class ResultCollector
    extends TextSearchRequestor {
        private String fNewValue;
        private QualifiedNameSearchResult fResult;

        public ResultCollector(QualifiedNameSearchResult qualifiedNameSearchResult, String string) {
            this.fResult = qualifiedNameSearchResult;
            this.fNewValue = string;
        }

        public boolean acceptFile(IFile iFile) throws CoreException {
            IJavaElement iJavaElement = JavaCore.create((IFile)iFile);
            if (iJavaElement != null && iJavaElement.exists()) {
                return false;
            }
            if (!FileBuffers.getTextFileBufferManager().isTextFileLocation(iFile.getFullPath(), false)) {
                return false;
            }
            IPath iPath = iFile.getProjectRelativePath();
            String string = iPath.segment(0);
            return string == null || !string.startsWith(".refactorings") && !string.startsWith(".deprecations");
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess textSearchMatchAccess) throws CoreException {
            char c;
            int n;
            int n2 = textSearchMatchAccess.getMatchOffset();
            int n3 = textSearchMatchAccess.getMatchLength();
            if (n2 > 0 && ((n = (int)textSearchMatchAccess.getFileContentChar(n2 - 1)) == 46 || Character.isJavaIdentifierPart((char)n))) {
                return true;
            }
            int n4 = n2 + n3;
            n = textSearchMatchAccess.getFileContentLength();
            if (n4 < n && Character.isJavaIdentifierPart(c = textSearchMatchAccess.getFileContentChar(n4))) {
                return true;
            }
            IFile iFile = textSearchMatchAccess.getFile();
            TextChange textChange = this.fResult.getChange(iFile);
            TextChangeCompatibility.addTextEdit(textChange, RefactoringCoreMessages.QualifiedNameFinder_update_name, (TextEdit)new ReplaceEdit(n2, n3, this.fNewValue), QUALIFIED_NAMES);
            return true;
        }
    }
}

